/*
 * Decompiled with CFR 0.152.
 */
package com.ad4screen.sdk.provider;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.location.Location;
import android.net.Uri;
import com.ad4screen.sdk.Log;
import com.ad4screen.sdk.contract.A4SContract;
import com.ad4screen.sdk.plugins.model.Geofence;
import com.ad4screen.sdk.provider.c;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class e
extends c {
    public e(c.a a2, Context context) {
        super(a2, context);
    }

    private long getGeofenceId(Geofence geofence) {
        long l2 = -1L;
        String[] stringArray = new String[1];
        String[] stringArray2 = stringArray;
        stringArray[0] = "_id";
        String[] stringArray3 = new String[1];
        String[] stringArray4 = stringArray3;
        stringArray3[0] = geofence.getId();
        e e2 = e2.mAcc.a(A4SContract.Geofences.getContentUri(e2.mContext), stringArray2, "server_id=?", stringArray4, null);
        if (e2 != null) {
            int n2 = e2.getCount();
            if (n2 > 0) {
                e e3 = e2;
                e3.moveToFirst();
                l2 = e3.getLong(0);
                if (n2 > 1) {
                    Log.warn("A4SGeofenceResolver|getGeofenceId|there are " + n2 + " instances of " + geofence);
                }
            }
            e2.close();
        }
        return l2;
    }

    private String[] getWhereArgsLocationLimit(Location location, float f2) {
        Location location2 = location;
        float f3 = f2;
        double d2 = f3 / 111.0f;
        double d3 = (double)f3 / (Math.cos(Math.toRadians(location.getLatitude())) * 111.0);
        double d4 = location2.getLatitude() - d2;
        d2 = location2.getLatitude() + d2;
        double d5 = location2.getLongitude() - d3;
        d3 = location2.getLongitude() + d3;
        String[] stringArray = new String[4];
        String[] stringArray2 = stringArray;
        stringArray2[0] = String.valueOf(d4);
        stringArray2[1] = String.valueOf(d2);
        stringArray2[2] = String.valueOf(d5);
        stringArray[3] = String.valueOf(d3);
        return stringArray;
    }

    private String[] getWhereArgsLocationLimit(Location stringArray, float f2, String[] stringArray2) {
        String[] stringArray3 = stringArray3.getWhereArgsLocationLimit((Location)stringArray, f2);
        stringArray = new String[stringArray2.length + stringArray3.length];
        int n2 = 0;
        int n3 = 0;
        while (n3 < stringArray2.length) {
            stringArray[n2] = stringArray2[n3];
            ++n3;
            ++n2;
        }
        int n4 = 0;
        while (n4 < stringArray3.length) {
            stringArray[n2] = stringArray3[n4];
            ++n4;
            ++n2;
        }
        return stringArray;
    }

    private String getWhereLocationLimit() {
        return "latitude>? AND latitude<? AND longitude>? AND longitude<?";
    }

    public long hasGeofence(String string2) {
        long l2 = -1L;
        String[] stringArray = new String[1];
        String[] stringArray2 = stringArray;
        stringArray[0] = "_id";
        String[] stringArray3 = new String[1];
        String[] stringArray4 = stringArray3;
        stringArray3[0] = string2;
        e e2 = e2.mAcc.a(A4SContract.Geofences.getContentUri(e2.mContext), stringArray2, "server_id=?", stringArray4, null);
        if (e2 != null) {
            if (e2.getCount() > 0) {
                e e3 = e2;
                e3.moveToFirst();
                l2 = e3.getLong(0);
            }
            e2.close();
        }
        return l2;
    }

    public long hasGeofenceGroup(String string2) {
        long l2 = -1L;
        String[] stringArray = new String[1];
        String[] stringArray2 = stringArray;
        stringArray[0] = "_id";
        String[] stringArray3 = new String[1];
        String[] stringArray4 = stringArray3;
        stringArray3[0] = string2;
        e e2 = e2.mAcc.a(A4SContract.BeaconGeofenceGroups.getContentUri(e2.mContext), stringArray2, "server_id=?", stringArray4, null);
        if (e2 != null) {
            if (e2.getCount() > 0) {
                e e3 = e2;
                e3.moveToFirst();
                l2 = e3.getLong(0);
            }
            e2.close();
        }
        return l2;
    }

    public int getGeofencesCount() {
        int n2 = -1;
        String[] stringArray = new String[1];
        String[] stringArray2 = stringArray;
        stringArray[0] = "_id";
        e e2 = e2.mAcc.a(A4SContract.Geofences.getContentUri(e2.mContext), stringArray2, null, null, null);
        if (e2 != null) {
            e e3 = e2;
            n2 = e3.getCount();
            e3.close();
        }
        return n2;
    }

    public List<Geofence> getAllGeofences(boolean bl, boolean bl2) {
        return this.getAllGeofences(null, null, bl, bl2);
    }

    public List<Geofence> getAllGeofences(Location location, float f2, boolean bl, boolean bl2) {
        e e2 = this;
        return e2.getAllGeofences(e2.getWhereLocationLimit(), this.getWhereArgsLocationLimit(location, f2), bl, bl2);
    }

    public List<Geofence> getAllGeofences(String string2, String[] stringArray, Location location, float f2, boolean bl, boolean bl2) {
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        String[] stringArray2 = stringArray2.getWhereArgsLocationLimit(location, f2, stringArray);
        return stringArray2.getAllGeofences("(" + string2 + ") AND (" + super.getWhereLocationLimit() + ")", stringArray2, bl, bl2);
    }

    public List<Geofence> getAllGeofences(String string2, String[] object, boolean bl, boolean bl2) {
        Object var5_5 = null;
        String[] stringArray = new String[14];
        String[] stringArray2 = stringArray;
        stringArray[0] = "_id";
        stringArray[1] = "server_id";
        stringArray[2] = "external_id";
        stringArray[3] = "name";
        stringArray[4] = "latitude";
        stringArray[5] = "longitude";
        stringArray[6] = "radius";
        stringArray[7] = "detected_time";
        stringArray[8] = "notified_time";
        stringArray[9] = "detected_count";
        stringArray[10] = "device_latitude";
        stringArray[11] = "device_longitude";
        stringArray[12] = "distance";
        stringArray[13] = "transition";
        string2 = this.mAcc.a(A4SContract.Geofences.getContentUri(this.mContext), stringArray2, string2, (String[])object, null);
        if (string2 != null) {
            if (string2.moveToFirst()) {
                ArrayList arrayList;
                object = arrayList;
                arrayList = new ArrayList(string2.getCount());
                do {
                    Geofence geofence;
                    String string3 = string2;
                    long l2 = string3.getLong(0);
                    Geofence geofence2 = geofence;
                    geofence2(string2.getString(1));
                    geofence2.setRowId(l2);
                    geofence2.setExternalId(string2.getString(2));
                    geofence2.setName(string2.getString(3));
                    geofence2.setLatitude(string2.getDouble(4));
                    geofence2.setLongitude(string2.getDouble(5));
                    geofence.setRadius(string2.getInt(6));
                    if (!string3.isNull(7)) {
                        geofence2.setDetectedTime(c.convertStringToDate(string2.getString(7)));
                    }
                    if (!string2.isNull(8)) {
                        geofence2.setNotifiedTime(c.convertStringToDate(string2.getString(8)));
                    }
                    if (!string2.isNull(9)) {
                        geofence2.setDetectedCount(string2.getInt(9));
                    }
                    if (!string2.isNull(10)) {
                        geofence2.setDeviceLatitude(string2.getDouble(10));
                    }
                    if (!string2.isNull(11)) {
                        geofence2.setDeviceLongitude(string2.getDouble(11));
                    }
                    if (!string2.isNull(12)) {
                        geofence2.setDistance(string2.getDouble(12));
                    }
                    if (!string2.isNull(13)) {
                        geofence2.setLastTransition(string2.getString(13));
                    }
                    if (bl) {
                        this.fillGeofenceParams(geofence2);
                    }
                    if (bl2) {
                        this.fillGeofenceGroups(geofence2);
                    }
                    object.add(geofence2);
                } while (string2.moveToNext());
            } else {
                object = var5_5;
            }
            string2.close();
        } else {
            object = var5_5;
        }
        return object;
    }

    public List<Geofence> getGeofencesFilteredByGroups(String string2, String[] stringArray, Location location, float f2, boolean bl, boolean bl2) {
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        String[] stringArray2 = stringArray2.getWhereArgsLocationLimit(location, f2, stringArray);
        return stringArray2.getGeofencesFilteredByGroups("(" + string2 + ") AND (" + super.getWhereLocationLimit() + ")", stringArray2, bl, bl2);
    }

    public List<Geofence> getGeofencesFilteredByGroups(String string2, String[] object, boolean bl, boolean bl2) {
        HashMap<String[], Geofence> hashMap;
        HashMap<String[], Geofence> hashMap2 = hashMap;
        hashMap = new HashMap<String[], Geofence>();
        String[] stringArray = new String[14];
        String[] stringArray2 = stringArray;
        stringArray[0] = "geofences._id";
        stringArray[1] = "geofences.server_id";
        stringArray[2] = "geofences.external_id";
        stringArray[3] = "geofences.name";
        stringArray[4] = "geofences.latitude";
        stringArray[5] = "geofences.longitude";
        stringArray[6] = "geofences.radius";
        stringArray[7] = "geofences.detected_time";
        stringArray[8] = "geofences.notified_time";
        stringArray[9] = "geofences.detected_count";
        stringArray[10] = "geofences.device_latitude";
        stringArray[11] = "geofences.device_longitude";
        stringArray[12] = "geofences.distance";
        stringArray[13] = "geofences.transition";
        string2 = this.mAcc.a(A4SContract.Geofences.getGroupsContentFilterUri(this.mContext), stringArray2, string2, (String[])object, null);
        if (string2 != null) {
            if (string2.moveToFirst()) {
                do {
                    Geofence geofence;
                    String string3 = string2;
                    long l2 = string3.getLong(0);
                    object = string3.getString(1);
                    if (hashMap2.containsKey(object)) continue;
                    Geofence geofence2 = geofence;
                    geofence2((String)object);
                    geofence2.setRowId(l2);
                    geofence2.setExternalId(string2.getString(2));
                    geofence2.setName(string2.getString(3));
                    geofence2.setLatitude(string2.getDouble(4));
                    geofence2.setLongitude(string2.getDouble(5));
                    geofence.setRadius(string2.getInt(6));
                    if (!string2.isNull(7)) {
                        geofence2.setDetectedTime(c.convertStringToDate(string2.getString(7)));
                    }
                    if (!string2.isNull(8)) {
                        geofence2.setNotifiedTime(c.convertStringToDate(string2.getString(8)));
                    }
                    if (!string2.isNull(9)) {
                        geofence2.setDetectedCount(string2.getInt(9));
                    }
                    if (!string2.isNull(10)) {
                        geofence2.setDeviceLatitude(string2.getDouble(10));
                    }
                    if (!string2.isNull(11)) {
                        geofence2.setDeviceLongitude(string2.getDouble(11));
                    }
                    if (!string2.isNull(12)) {
                        geofence2.setDistance(string2.getDouble(12));
                    }
                    if (!string2.isNull(13)) {
                        geofence2.setLastTransition(string2.getString(13));
                    }
                    if (bl) {
                        this.fillGeofenceParams(geofence2);
                    }
                    if (bl2) {
                        this.fillGeofenceGroups(geofence2);
                    }
                    hashMap2.put((String[])object, geofence2);
                } while (string2.moveToNext());
            }
            string2.close();
        }
        if (hashMap2.size() == 0) {
            return null;
        }
        return new ArrayList<Geofence>(hashMap2.values());
    }

    public Geofence getGeofenceByClientId(String string2) {
        Object var2_2 = null;
        String[] stringArray = new String[14];
        String[] stringArray2 = stringArray;
        stringArray[0] = "_id";
        stringArray[1] = "server_id";
        stringArray[2] = "external_id";
        stringArray[3] = "name";
        stringArray[4] = "latitude";
        stringArray[5] = "longitude";
        stringArray[6] = "radius";
        stringArray[7] = "detected_time";
        stringArray[8] = "notified_time";
        stringArray[9] = "detected_count";
        stringArray[10] = "device_latitude";
        stringArray[11] = "device_longitude";
        stringArray[12] = "distance";
        stringArray[13] = "transition";
        String[] stringArray3 = new String[1];
        Object object = stringArray3;
        stringArray3[0] = string2;
        string2 = this.mAcc.a(A4SContract.Geofences.getContentUri(this.mContext), stringArray2, "server_id=?", (String[])object, null);
        if (string2 != null) {
            if (string2.getCount() > 0) {
                Geofence geofence;
                String string3 = string2;
                string3.moveToFirst();
                long l2 = string3.getLong(0);
                object = geofence;
                ((Geofence)object)(Integer.toString(string2.getInt(1)));
                ((Geofence)object).setRowId(l2);
                ((Geofence)object).setExternalId(string2.getString(2));
                ((Geofence)object).setName(string2.getString(3));
                ((Geofence)object).setLatitude(string2.getDouble(4));
                ((Geofence)object).setLongitude(string2.getDouble(5));
                geofence.setRadius(string2.getInt(6));
                if (!string3.isNull(7)) {
                    ((Geofence)object).setDetectedTime(c.convertStringToDate(string2.getString(7)));
                }
                if (!string2.isNull(8)) {
                    ((Geofence)object).setNotifiedTime(c.convertStringToDate(string2.getString(8)));
                }
                if (!string2.isNull(9)) {
                    ((Geofence)object).setDetectedCount(string2.getInt(9));
                }
                if (!string2.isNull(10)) {
                    ((Geofence)object).setDeviceLatitude(string2.getDouble(10));
                }
                if (!string2.isNull(11)) {
                    ((Geofence)object).setDeviceLongitude(string2.getDouble(11));
                }
                if (!string2.isNull(12)) {
                    ((Geofence)object).setDistance(string2.getDouble(12));
                }
                if (!string2.isNull(13)) {
                    ((Geofence)object).setLastTransition(string2.getString(13));
                }
                this.fillGeofenceParams((Geofence)object);
                this.fillGeofenceGroups((Geofence)object);
            } else {
                object = var2_2;
            }
            string2.close();
        } else {
            object = var2_2;
        }
        return object;
    }

    public void fillGeofenceParams(Geofence geofence) {
        String[] stringArray = new String[2];
        Object object = stringArray;
        stringArray[0] = "param_key";
        stringArray[1] = "param_value";
        String[] stringArray2 = new String[1];
        String[] stringArray3 = stringArray2;
        stringArray2[0] = Long.toString(geofence.getRowId());
        e e2 = e2.mAcc.a(A4SContract.GeofenceParams.getContentUri(e2.mContext), (String[])object, "geofence_id=?", stringArray3, null);
        if (e2 != null) {
            if (e2.moveToFirst()) {
                HashMap hashMap;
                object = hashMap;
                hashMap = new HashMap(e2.getCount());
                do {
                    object.put(e2.getString(0), e2.getString(1));
                } while (e2.moveToNext());
                geofence.setCustomParams((Map<String, String>)object);
            }
            e2.close();
        }
    }

    public void fillGeofenceGroups(Geofence geofence) {
        String[] stringArray = new String[1];
        Object object = stringArray;
        stringArray[0] = "server_id";
        String[] stringArray2 = new String[1];
        String[] stringArray3 = stringArray2;
        stringArray2[0] = Long.toString(geofence.getRowId());
        e e2 = e2.mAcc.a(A4SContract.BeaconGeofenceGroups.getGeofencesContentFilterUri(e2.mContext), (String[])object, "geofence_id=?", stringArray3, null);
        if (e2 != null) {
            if (e2.moveToFirst()) {
                HashSet hashSet;
                object = hashSet;
                hashSet = new HashSet(e2.getCount());
                do {
                    object.add(e2.getString(0));
                } while (e2.moveToNext());
                geofence.setGroups((Set<String>)object);
            }
            e2.close();
        }
    }

    public long insertGeofence(Geofence geofence) {
        ContentValues contentValues;
        ContentValues contentValues2 = contentValues;
        contentValues2();
        contentValues2.put("server_id", geofence.getId());
        contentValues2.put("external_id", geofence.getExternalId());
        contentValues2.put("name", geofence.getName());
        contentValues2.put("latitude", Double.valueOf(geofence.getLatitude()));
        contentValues2.put("longitude", Double.valueOf(geofence.getLongitude()));
        contentValues.put("radius", Float.valueOf(geofence.getRadius()));
        contentValues2 = this.mAcc.a(A4SContract.Geofences.getContentUri(this.mContext), contentValues2);
        if (contentValues2 == null) {
            return -1L;
        }
        long l2 = Long.valueOf((String)contentValues2.getPathSegments().get(1));
        Log.internal("A4SGeofenceResolver|INSERT geofence id=" + geofence.getId() + ", name: " + geofence.getName() + " at " + l2);
        if (geofence.getCustomParams().size() > 0) {
            this.insertGeofenceParams(l2, geofence.getCustomParams());
        }
        if (geofence.getGroups().size() > 0) {
            this.insertGeofenceGroups(l2, geofence.getGroups());
        }
        return l2;
    }

    public void insertGeofenceParams(long l2, Map<String, String> object) {
        for (Map.Entry entry : object.entrySet()) {
            ContentValues contentValues;
            ContentValues contentValues2 = contentValues;
            contentValues2();
            contentValues2.put("geofence_id", Long.valueOf(l2));
            contentValues2.put("param_key", (String)entry.getKey());
            contentValues.put("param_value", (String)entry.getValue());
            this.mAcc.a(A4SContract.GeofenceParams.getContentUri(this.mContext), contentValues2);
        }
    }

    public void insertGeofenceGroups(long l2, Set<String> object) {
        object = object.iterator();
        while (object.hasNext()) {
            ContentValues contentValues;
            String string2 = (String)object.next();
            long l3 = this.hasGeofenceGroup(string2);
            if (l3 < 0L) {
                ContentValues contentValues2;
                ContentValues contentValues3 = contentValues2;
                new ContentValues().put("server_id", string2);
                l3 = Long.valueOf((String)this.mAcc.a(A4SContract.BeaconGeofenceGroups.getContentUri(this.mContext), contentValues3).getPathSegments().get(1));
            }
            string2 = contentValues;
            string2();
            string2.put("geofence_id", Long.valueOf(l2));
            contentValues.put("group_id", Long.valueOf(l3));
            this.mAcc.a(A4SContract.GeofenceGroups.getContentUri(this.mContext), (ContentValues)string2);
        }
    }

    public int insertGeofences(List<Geofence> contentValuesArray) {
        if (contentValuesArray != null && contentValuesArray.size() != 0) {
            ArrayList<ContentValues> arrayList;
            ArrayList arrayList2;
            int n2 = 0;
            ContentValues[] contentValuesArray3 = new ContentValues[contentValuesArray.size()];
            Iterator iterator = contentValuesArray.iterator();
            while (iterator.hasNext()) {
                ContentValues contentValues;
                Geofence geofence = (Geofence)iterator.next();
                ContentValues contentValues2 = contentValues;
                contentValues2();
                contentValues2.put("server_id", geofence.getId());
                contentValues2.put("external_id", geofence.getExternalId());
                contentValues2.put("name", geofence.getName());
                contentValues2.put("latitude", Double.valueOf(geofence.getLatitude()));
                contentValues2.put("longitude", Double.valueOf(geofence.getLongitude()));
                contentValues.put("radius", Float.valueOf(geofence.getRadius()));
                contentValuesArray3[n2++] = contentValues;
            }
            int n3 = this.mAcc.a(A4SContract.Geofences.getContentUri(this.mContext), contentValuesArray3);
            if (n3 != n2) {
                Log.error("A4SGeofenceResolver|bulkInsert hasn't inserted all geofences, needed=" + n2 + ", inserted=" + n3);
                return n3;
            }
            long l2 = this.hasGeofence(((Geofence)contentValuesArray.get(0)).getId());
            if (l2 < 0L) {
                Log.error("A4SGeofenceResolver|bulkInsert an ID of the first inserted geofence is not found");
                return n3;
            }
            ContentValues[] contentValuesArray2 = contentValuesArray;
            contentValuesArray = arrayList2;
            arrayList2 = new ArrayList();
            ArrayList<ContentValues> arrayList22 = arrayList;
            arrayList = new ArrayList<ContentValues>();
            for (Geofence geofence : contentValuesArray2) {
                if (geofence.getCustomParams().size() > 0) {
                    for (Map.Entry<String, String> entry : geofence.getCustomParams().entrySet()) {
                        ContentValues contentValues;
                        ContentValues contentValues2 = contentValues;
                        contentValues2();
                        contentValues2.put("geofence_id", Long.valueOf(l2));
                        contentValues2.put("param_key", entry.getKey());
                        contentValues.put("param_value", entry.getValue());
                        contentValuesArray.add(contentValues);
                    }
                }
                if (geofence.getGroups().size() > 0) {
                    for (Object object : geofence.getGroups()) {
                        ContentValues contentValues;
                        ContentValues contentValues3 = contentValues;
                        contentValues3();
                        contentValues.put("geofence_id", Long.valueOf(l2));
                        contentValues.put("server_id", (String)object);
                        arrayList22.add(contentValues);
                    }
                }
                ++l2;
            }
            if (contentValuesArray.size() > 0) {
                ContentValues[] contentValuesArray5 = new ContentValues[contentValuesArray.size()];
                this.mAcc.a(A4SContract.GeofenceParams.getContentUri(this.mContext), contentValuesArray.toArray(contentValuesArray5));
            }
            if (arrayList22.size() > 0) {
                contentValuesArray = new ContentValues[arrayList22.size()];
                this.mAcc.a(A4SContract.GeofenceGroups.getCustomContentUri(this.mContext), (ContentValues[])arrayList22.toArray((T[])contentValuesArray));
            }
            return n3;
        }
        Log.warn("A4SGeofenceResolver|bulkInsert no geofences");
        return 0;
    }

    public int updateGeofence(Geofence geofence, boolean bl, boolean bl2) {
        ContentValues contentValues;
        String[] stringArray;
        String string2;
        if (geofence.getRowId() > 0L) {
            string2 = "_id=?";
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = String.valueOf(geofence.getRowId());
        } else {
            string2 = "server_id=?";
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = geofence.getId();
        }
        ContentValues contentValues2 = contentValues;
        contentValues2();
        contentValues2.put("external_id", geofence.getExternalId());
        contentValues2.put("name", geofence.getName());
        contentValues2.put("latitude", Double.valueOf(geofence.getLatitude()));
        contentValues2.put("longitude", Double.valueOf(geofence.getLongitude()));
        contentValues2.put("radius", Float.valueOf(geofence.getRadius()));
        contentValues2.put("detected_time", c.convertDateToString(geofence.getDetectedTime()));
        contentValues2.put("notified_time", c.convertDateToString(geofence.getNotifiedTime()));
        contentValues2.put("detected_count", Integer.valueOf(geofence.getDetectedCount()));
        contentValues2.put("device_latitude", Double.valueOf(geofence.getDeviceLatitude()));
        contentValues2.put("device_longitude", Double.valueOf(geofence.getDeviceLongitude()));
        contentValues2.put("distance", Double.valueOf(geofence.getDistance()));
        contentValues.put("transition", geofence.getLastTransition());
        int n2 = this.mAcc.a(A4SContract.Geofences.getContentUri(this.mContext), contentValues2, string2, stringArray);
        Log.internal("A4SGeofenceResolver|UPDATE geofence id=" + geofence.getId() + ", name: " + geofence.getName());
        long l2 = this.getGeofenceId(geofence);
        if (bl) {
            this.updateGeofenceParams(l2, geofence.getCustomParams());
        }
        if (bl2) {
            this.updateGeofenceGroups(l2, geofence.getGroups());
        }
        return n2;
    }

    public void updateGeofenceParams(long l2, Map<String, String> map) {
        HashMap<String, String> hashMap;
        HashMap<String, String> hashMap2 = hashMap;
        hashMap = new HashMap<String, String>(map);
        Cursor cursor = new String[2];
        Cursor cursor2 = cursor;
        cursor[0] = "_id";
        cursor[1] = "param_key";
        Uri uri = new String[1];
        Uri uri2 = uri;
        uri[0] = Long.toString(l2);
        cursor2 = this.mAcc.a(A4SContract.GeofenceParams.getContentUri(this.mContext), (String[])cursor2, "geofence_id=?", (String[])uri2, null);
        if (cursor2 != null) {
            if (cursor2.moveToFirst()) {
                do {
                    int n2 = cursor2.getInt(0);
                    uri2 = Uri.withAppendedPath((Uri)A4SContract.GeofenceParams.getContentUri(this.mContext), (String)("/" + n2));
                    String string2 = cursor2.getString(1);
                    if (map.containsKey(string2)) {
                        ContentValues contentValues;
                        ContentValues contentValues2 = contentValues;
                        contentValues2();
                        contentValues.put("param_value", map.get(string2));
                        this.mAcc.a(uri2, contentValues2, null, null);
                        hashMap2.remove(string2);
                        continue;
                    }
                    this.mAcc.a(uri2, null, null);
                } while (cursor2.moveToNext());
            }
            cursor2.close();
        }
        if (hashMap2.size() > 0) {
            this.insertGeofenceParams(l2, hashMap2);
        }
    }

    public void updateGeofenceGroups(long l2, Set<String> set) {
        HashSet<String> hashSet;
        HashSet<String> hashSet2 = hashSet;
        hashSet = new HashSet<String>(set);
        Cursor cursor = new String[3];
        Cursor cursor2 = cursor;
        cursor[0] = "beacon_geofence_groups._id";
        cursor[1] = "server_id";
        cursor[2] = "geofence_groups._id";
        String[] stringArray = new String[1];
        String[] stringArray2 = stringArray;
        stringArray[0] = Long.toString(l2);
        cursor2 = this.mAcc.a(A4SContract.BeaconGeofenceGroups.getGeofencesContentFilterUri(this.mContext), (String[])cursor2, "geofence_id=?", stringArray2, null);
        if (cursor2 != null) {
            if (cursor2.moveToFirst()) {
                do {
                    Cursor cursor3 = cursor2;
                    int n2 = cursor3.getInt(0);
                    String string2 = cursor3.getString(1);
                    int n3 = cursor2.getInt(2);
                    if (set.contains(string2)) {
                        hashSet2.remove(string2);
                        continue;
                    }
                    e e2 = this;
                    Uri uri = Uri.withAppendedPath((Uri)A4SContract.BeaconGeofenceGroups.getContentUri(e2.mContext), (String)("/" + n2));
                    e2.mAcc.a(uri, null, null);
                    uri = Uri.withAppendedPath((Uri)A4SContract.GeofenceGroups.getContentUri(e2.mContext), (String)("/" + n3));
                    e2.mAcc.a(uri, null, null);
                } while (cursor2.moveToNext());
            }
            cursor2.close();
        }
        if (hashSet2.size() > 0) {
            this.insertGeofenceGroups(l2, hashSet2);
        }
    }

    public void updateGeofences(List<Geofence> object) {
        object = object.iterator();
        while (object.hasNext()) {
            Geofence geofence = (Geofence)object.next();
            if (this.hasGeofence(geofence.getId()) < 0L) {
                if (geofence.isNeedToBeRemoved()) continue;
                this.insertGeofence(geofence);
                continue;
            }
            if (geofence.isNeedToBeRemoved()) {
                this.deleteGeofence(geofence);
                continue;
            }
            this.updateGeofence(geofence, true, true);
        }
    }

    public int deleteGeofence(Geofence geofence) {
        long l2 = geofence.getRowId() > 0L ? geofence.getRowId() : this.getGeofenceId(geofence);
        e e2 = this;
        Uri uri = Uri.withAppendedPath((Uri)A4SContract.Geofences.getContentUri(e2.mContext), (String)String.valueOf(l2));
        int n2 = e2.mAcc.a(uri, null, null);
        Log.internal("GeofenceHelper|DELETE geofence id=" + geofence.getId() + ", name: " + geofence.getName() + " at " + l2);
        this.mAcc.a(A4SContract.GeofenceParams.getContentUri(this.mContext), "geofence_id=" + l2, null);
        return n2;
    }

    public int deleteAllGeofences() {
        int n2 = this.mAcc.a(A4SContract.Geofences.getContentUri(this.mContext), null, null);
        e e2 = this;
        e2.mAcc.a(A4SContract.GeofenceParams.getContentUri(this.mContext), null, null);
        e2.mAcc.a(A4SContract.GeofenceGroups.getContentUri(this.mContext), null, null);
        return n2;
    }
}

