/*
 * Decompiled with CFR 0.152.
 */
package com.ad4screen.sdk.provider;

import android.content.ContentProviderOperation;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import com.ad4screen.sdk.Log;
import com.ad4screen.sdk.contract.A4SContract;
import com.ad4screen.sdk.plugins.model.Beacon;
import com.ad4screen.sdk.provider.c;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class b
extends c {
    public b(c.a a2, Context context) {
        super(a2, context);
    }

    private long getBeaconId(Beacon beacon) {
        long l2 = -1L;
        String[] stringArray = new String[1];
        String[] stringArray2 = stringArray;
        stringArray[0] = "_id";
        String[] stringArray3 = new String[4];
        String[] stringArray4 = stringArray3;
        stringArray4[0] = beacon.getId();
        stringArray4[1] = beacon.getUuid();
        stringArray4[2] = String.valueOf(beacon.getMajor());
        stringArray3[3] = String.valueOf(beacon.getMinor());
        b b2 = b2.mAcc.a(A4SContract.Beacons.getContentUri(b2.mContext), stringArray2, "server_id=? AND uuid=? AND major=? AND minor=?", stringArray4, null);
        if (b2 != null) {
            int n2 = b2.getCount();
            if (n2 > 0) {
                b b3 = b2;
                b3.moveToFirst();
                l2 = b3.getLong(0);
                if (n2 > 1) {
                    Log.warn("BeaconHelper|getBeaconId|there are " + n2 + " instances of " + beacon);
                }
            }
            b2.close();
        }
        return l2;
    }

    private Beacon getBeaconFromCursor(Cursor cursor, boolean bl, boolean bl2) {
        Beacon beacon;
        Beacon beacon2 = beacon;
        beacon2();
        beacon2.setRowId(cursor.getLong(0));
        beacon2.setId(cursor.getString(1));
        beacon2.setExternalId(cursor.getString(2));
        beacon2.setName(cursor.getString(3));
        beacon2.setUuid(cursor.getString(4));
        beacon2.setMajor(cursor.getInt(5));
        beacon2.setMinor(cursor.getInt(6));
        beacon2.setDetectedTime(c.convertStringToDate(cursor.getString(7)));
        beacon2.setNotifiedTime(c.convertStringToDate(cursor.getString(8)));
        beacon2.setAccuracy(cursor.getString(9));
        beacon2.setTransition(cursor.getString(10));
        beacon.setDistance(cursor.getDouble(11));
        if (bl) {
            this.fillBeaconParams(beacon2);
        }
        if (bl2) {
            this.fillBeaconGroups(beacon2);
        }
        return beacon2;
    }

    public long hasBeacon(String string2) {
        long l2 = -1L;
        String[] stringArray = new String[1];
        String[] stringArray2 = stringArray;
        stringArray[0] = "_id";
        String[] stringArray3 = new String[1];
        String[] stringArray4 = stringArray3;
        stringArray3[0] = string2;
        b b2 = b2.mAcc.a(A4SContract.Beacons.getContentUri(b2.mContext), stringArray2, "server_id=?", stringArray4, null);
        if (b2 != null) {
            if (b2.getCount() > 0) {
                b b3 = b2;
                b3.moveToFirst();
                l2 = b3.getLong(0);
            }
            b2.close();
        }
        return l2;
    }

    public long hasBeaconGroup(String string2) {
        long l2 = -1L;
        String[] stringArray = new String[1];
        String[] stringArray2 = stringArray;
        stringArray[0] = "_id";
        String[] stringArray3 = new String[1];
        String[] stringArray4 = stringArray3;
        stringArray3[0] = string2;
        b b2 = b2.mAcc.a(A4SContract.BeaconGeofenceGroups.getContentUri(b2.mContext), stringArray2, "server_id=?", stringArray4, null);
        if (b2 != null) {
            if (b2.getCount() > 0) {
                b b3 = b2;
                b3.moveToFirst();
                l2 = b3.getLong(0);
            }
            b2.close();
        }
        return l2;
    }

    public int getBeaconsCount() {
        int n2 = -1;
        String[] stringArray = new String[1];
        String[] stringArray2 = stringArray;
        stringArray[0] = "_id";
        b b2 = b2.mAcc.a(A4SContract.Beacons.getContentUri(b2.mContext), stringArray2, null, null, null);
        if (b2 != null) {
            b b3 = b2;
            n2 = b3.getCount();
            b3.close();
        }
        return n2;
    }

    public List<Beacon> getAllBeacons(boolean bl, boolean bl2) {
        return this.getAllBeacons(null, null, bl, bl2);
    }

    public List<Beacon> getAllBeacons(String string2, String[] object, boolean bl, boolean bl2) {
        Object var5_5 = null;
        String[] stringArray = new String[12];
        String[] stringArray2 = stringArray;
        stringArray[0] = "_id";
        stringArray[1] = "server_id";
        stringArray[2] = "external_id";
        stringArray[3] = "name";
        stringArray[4] = "uuid";
        stringArray[5] = "major";
        stringArray[6] = "minor";
        stringArray[7] = "detected_time";
        stringArray[8] = "notified_time";
        stringArray[9] = "lastAccuracy";
        stringArray[10] = "lastTransition";
        stringArray[11] = "lastDistance";
        string2 = this.mAcc.a(A4SContract.Beacons.getContentUri(this.mContext), stringArray2, string2, (String[])object, null);
        if (string2 != null) {
            if (string2.moveToFirst()) {
                ArrayList arrayList;
                object = arrayList;
                arrayList = new ArrayList(string2.getCount());
                do {
                    object.add(this.getBeaconFromCursor((Cursor)string2, bl, bl2));
                } while (string2.moveToNext());
            } else {
                object = var5_5;
            }
            string2.close();
        } else {
            object = var5_5;
        }
        return object;
    }

    public List<Beacon> getBeaconsFilteredByGroups(String string2, String[] object, boolean bl, boolean bl2) {
        HashMap<String[], Beacon> hashMap;
        HashMap<String[], Beacon> hashMap2 = hashMap;
        hashMap = new HashMap<String[], Beacon>();
        String[] stringArray = new String[12];
        String[] stringArray2 = stringArray;
        stringArray[0] = "beacons._id";
        stringArray[1] = "beacons.server_id";
        stringArray[2] = "beacons.external_id";
        stringArray[3] = "beacons.name";
        stringArray[4] = "beacons.uuid";
        stringArray[5] = "beacons.major";
        stringArray[6] = "beacons.minor";
        stringArray[7] = "beacons.detected_time";
        stringArray[8] = "beacons.notified_time";
        stringArray[9] = "beacons.lastAccuracy";
        stringArray[10] = "beacons.lastTransition";
        stringArray[11] = "beacons.lastDistance";
        string2 = this.mAcc.a(A4SContract.Beacons.getGroupsContentFilterUri(this.mContext), stringArray2, string2, (String[])object, null);
        if (string2 != null && string2.moveToFirst()) {
            do {
                if (hashMap2.containsKey(object = string2.getString(1))) continue;
                hashMap2.put((String[])object, this.getBeaconFromCursor((Cursor)string2, bl, bl2));
            } while (string2.moveToNext());
            string2.close();
        }
        if (hashMap2.size() == 0) {
            return null;
        }
        return new ArrayList<Beacon>(hashMap2.values());
    }

    public Beacon getBeaconByClientId(String string2) {
        Beacon beacon = null;
        String[] stringArray = new String[12];
        String[] stringArray2 = stringArray;
        stringArray[0] = "_id";
        stringArray[1] = "server_id";
        stringArray[2] = "external_id";
        stringArray[3] = "name";
        stringArray[4] = "uuid";
        stringArray[5] = "major";
        stringArray[6] = "minor";
        stringArray[7] = "detected_time";
        stringArray[8] = "notified_time";
        stringArray[9] = "lastAccuracy";
        stringArray[10] = "lastTransition";
        stringArray[11] = "lastDistance";
        String[] stringArray3 = new String[1];
        String[] stringArray4 = stringArray3;
        stringArray3[0] = string2;
        string2 = this.mAcc.a(A4SContract.Beacons.getContentUri(this.mContext), stringArray2, "server_id=?", stringArray4, null);
        if (string2 != null) {
            if (string2.getCount() > 0) {
                String string3 = string2;
                string3.moveToFirst();
                beacon = this.getBeaconFromCursor((Cursor)string3, true, true);
            }
            string2.close();
        }
        return beacon;
    }

    public Beacon getBeacon(String string2, String[] stringArray) {
        Beacon beacon = null;
        String[] stringArray2 = new String[12];
        String[] stringArray3 = stringArray2;
        stringArray2[0] = "_id";
        stringArray2[1] = "server_id";
        stringArray2[2] = "external_id";
        stringArray2[3] = "name";
        stringArray2[4] = "uuid";
        stringArray2[5] = "major";
        stringArray2[6] = "minor";
        stringArray2[7] = "detected_time";
        stringArray2[8] = "notified_time";
        stringArray2[9] = "lastAccuracy";
        stringArray2[10] = "lastTransition";
        stringArray2[11] = "lastDistance";
        string2 = this.mAcc.a(A4SContract.Beacons.getContentUri(this.mContext), stringArray3, string2, stringArray, null);
        if (string2 != null) {
            if (string2.getCount() > 0) {
                String string3 = string2;
                string3.moveToFirst();
                beacon = this.getBeaconFromCursor((Cursor)string3, true, true);
            }
            string2.close();
        }
        return beacon;
    }

    public Beacon getBeacon(String string2, int n2, int n3) {
        String[] stringArray = stringArray3;
        String[] stringArray2 = new String[3];
        String[] stringArray3 = stringArray2;
        stringArray3[0] = string2.toUpperCase();
        stringArray3[1] = String.valueOf(n2);
        stringArray2[2] = String.valueOf(n3);
        return stringArray.getBeacon("uuid=? AND major=? AND minor=?", stringArray3);
    }

    public List<Beacon> getDetectedBeacons(Date stringArray, boolean bl, boolean bl2) {
        b b2 = arrayList;
        ArrayList arrayList = c.convertDateToString((Date)stringArray);
        String[] stringArray2 = new String[1];
        stringArray = stringArray2;
        stringArray2[0] = arrayList;
        arrayList = b2.getAllBeacons("detected_time>=?", stringArray, bl, bl2);
        if (arrayList == null) {
            ArrayList arrayList2;
            arrayList = arrayList2;
            arrayList2 = new ArrayList();
        }
        return arrayList;
    }

    public void fillBeaconParams(Beacon beacon) {
        String[] stringArray = new String[2];
        Object object = stringArray;
        stringArray[0] = "param_key";
        stringArray[1] = "param_value";
        String[] stringArray2 = new String[1];
        String[] stringArray3 = stringArray2;
        stringArray2[0] = Long.toString(beacon.getRowId());
        b b2 = b2.mAcc.a(A4SContract.BeaconParams.getContentUri(b2.mContext), (String[])object, "beacon_id=?", stringArray3, null);
        if (b2 != null) {
            if (b2.moveToFirst()) {
                HashMap hashMap;
                object = hashMap;
                hashMap = new HashMap(b2.getCount());
                do {
                    object.put(b2.getString(0), b2.getString(1));
                } while (b2.moveToNext());
                beacon.setCustomParameters((Map<String, String>)object);
            }
            b2.close();
        }
    }

    public void fillBeaconGroups(Beacon beacon) {
        String[] stringArray = new String[1];
        Object object = stringArray;
        stringArray[0] = "server_id";
        String[] stringArray2 = new String[1];
        String[] stringArray3 = stringArray2;
        stringArray2[0] = Long.toString(beacon.getRowId());
        b b2 = b2.mAcc.a(A4SContract.BeaconGeofenceGroups.getBeaconsContentFilterUri(b2.mContext), (String[])object, "beacon_id=?", stringArray3, null);
        if (b2 != null) {
            if (b2.moveToFirst()) {
                HashSet hashSet;
                object = hashSet;
                hashSet = new HashSet(b2.getCount());
                do {
                    object.add(b2.getString(0));
                } while (b2.moveToNext());
                beacon.setGroups((Set<String>)object);
            }
            b2.close();
        }
    }

    public long insertBeacon(Beacon beacon) {
        ContentValues contentValues;
        ContentValues contentValues2 = contentValues;
        contentValues2();
        contentValues2.put("server_id", beacon.getId());
        contentValues2.put("external_id", beacon.getExternalId());
        contentValues2.put("name", beacon.getName());
        contentValues2.put("uuid", beacon.getUuid());
        contentValues2.put("major", Integer.valueOf(beacon.getMajor()));
        contentValues2.put("minor", Integer.valueOf(beacon.getMinor()));
        contentValues2.put("detected_time", c.convertDateToString(beacon.getDetectedTime()));
        contentValues.put("notified_time", c.convertDateToString(beacon.getNotifiedTime()));
        contentValues2 = this.mAcc.a(A4SContract.Beacons.getContentUri(this.mContext), contentValues2);
        if (contentValues2 == null) {
            return -1L;
        }
        Beacon beacon2 = beacon;
        long l2 = Long.valueOf((String)contentValues2.getPathSegments().get(1));
        beacon2.setRowId(l2);
        if (beacon2.getCustomParameters().size() > 0) {
            this.insertBeaconParams(l2, beacon.getCustomParameters());
        }
        if (beacon.getGroups().size() > 0) {
            this.insertBeaconGroups(l2, beacon.getGroups());
        }
        return l2;
    }

    public void insertBeaconParams(long l2, Map<String, String> object) {
        for (Map.Entry entry : object.entrySet()) {
            ContentValues contentValues;
            ContentValues contentValues2 = contentValues;
            contentValues2();
            contentValues2.put("beacon_id", Long.valueOf(l2));
            contentValues2.put("param_key", (String)entry.getKey());
            contentValues.put("param_value", (String)entry.getValue());
            this.mAcc.a(A4SContract.BeaconParams.getContentUri(this.mContext), contentValues2);
        }
    }

    public void insertBeaconGroups(long l2, Set<String> object) {
        object = object.iterator();
        while (object.hasNext()) {
            ContentValues contentValues;
            String string2 = (String)object.next();
            long l3 = this.hasBeaconGroup(string2);
            if (l3 < 0L) {
                ContentValues contentValues2;
                ContentValues contentValues3 = contentValues2;
                new ContentValues().put("server_id", string2);
                l3 = Long.valueOf((String)this.mAcc.a(A4SContract.BeaconGeofenceGroups.getContentUri(this.mContext), contentValues3).getPathSegments().get(1));
            }
            string2 = contentValues;
            string2();
            string2.put("beacon_id", Long.valueOf(l2));
            contentValues.put("group_id", Long.valueOf(l3));
            this.mAcc.a(A4SContract.BeaconGroups.getContentUri(this.mContext), (ContentValues)string2);
        }
    }

    public int insertBeacons(List<Beacon> contentValuesArray) {
        if (contentValuesArray != null && contentValuesArray.size() != 0) {
            ArrayList<ContentValues> arrayList;
            ArrayList arrayList2;
            int n2 = 0;
            ContentValues[] contentValuesArray3 = new ContentValues[contentValuesArray.size()];
            Iterator iterator = contentValuesArray.iterator();
            while (iterator.hasNext()) {
                ContentValues contentValues;
                Beacon beacon = (Beacon)iterator.next();
                ContentValues contentValues2 = contentValues;
                contentValues2();
                contentValues2.put("server_id", beacon.getId());
                contentValues2.put("external_id", beacon.getExternalId());
                contentValues2.put("name", beacon.getName());
                contentValues2.put("uuid", beacon.getUuid());
                contentValues2.put("major", Integer.valueOf(beacon.getMajor()));
                contentValues2.put("minor", Integer.valueOf(beacon.getMinor()));
                contentValues2.put("detected_time", c.convertDateToString(beacon.getDetectedTime()));
                contentValues.put("notified_time", c.convertDateToString(beacon.getNotifiedTime()));
                contentValuesArray3[n2++] = contentValues;
            }
            int n3 = this.mAcc.a(A4SContract.Beacons.getContentUri(this.mContext), contentValuesArray3);
            if (n3 != n2) {
                Log.error("A4SBeaconResolver|bulkInsert hasn't inserted all beacons, needed=" + n2 + ", inserted=" + n3);
                return n3;
            }
            long l2 = this.hasBeacon(((Beacon)contentValuesArray.get(0)).getId());
            if (l2 < 0L) {
                Log.error("A4SBeaconResolver|bulkInsert an ID of the first inserted beacon is not found");
                return n3;
            }
            ContentValues[] contentValuesArray2 = contentValuesArray;
            contentValuesArray = arrayList2;
            arrayList2 = new ArrayList();
            ArrayList<ContentValues> arrayList22 = arrayList;
            arrayList = new ArrayList<ContentValues>();
            for (Beacon beacon : contentValuesArray2) {
                if (beacon.getCustomParameters().size() > 0) {
                    for (Map.Entry<String, String> entry : beacon.getCustomParameters().entrySet()) {
                        ContentValues contentValues;
                        ContentValues contentValues2 = contentValues;
                        contentValues2();
                        contentValues2.put("beacon_id", Long.valueOf(l2));
                        contentValues2.put("param_key", entry.getKey());
                        contentValues.put("param_value", entry.getValue());
                        contentValuesArray.add(contentValues);
                    }
                }
                if (beacon.getGroups().size() > 0) {
                    for (Object object : beacon.getGroups()) {
                        ContentValues contentValues;
                        ContentValues contentValues3 = contentValues;
                        contentValues3();
                        contentValues.put("beacon_id", Long.valueOf(l2));
                        contentValues.put("server_id", (String)object);
                        arrayList22.add(contentValues);
                    }
                }
                ++l2;
            }
            if (contentValuesArray.size() > 0) {
                ContentValues[] contentValuesArray5 = new ContentValues[contentValuesArray.size()];
                this.mAcc.a(A4SContract.BeaconParams.getContentUri(this.mContext), contentValuesArray.toArray(contentValuesArray5));
            }
            if (arrayList22.size() > 0) {
                contentValuesArray = new ContentValues[arrayList22.size()];
                this.mAcc.a(A4SContract.BeaconGroups.getCustomContentUri(this.mContext), (ContentValues[])arrayList22.toArray((T[])contentValuesArray));
            }
            return n3;
        }
        Log.warn("A4SBeaconsResolver|bulkInsert no beacons");
        return 0;
    }

    public int updateBeacon(Beacon beacon, boolean bl, boolean bl2) {
        ContentValues contentValues;
        String[] stringArray;
        String string2;
        if (beacon.getRowId() > 0L) {
            string2 = "_id=?";
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = String.valueOf(beacon.getRowId());
        } else {
            string2 = "server_id=?";
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = beacon.getId();
        }
        ContentValues contentValues2 = contentValues;
        contentValues2();
        contentValues2.put("external_id", beacon.getExternalId());
        contentValues2.put("name", beacon.getName());
        contentValues2.put("uuid", beacon.getUuid());
        contentValues2.put("major", Integer.valueOf(beacon.getMajor()));
        contentValues2.put("minor", Integer.valueOf(beacon.getMinor()));
        contentValues2.put("detected_time", c.convertDateToString(beacon.getDetectedTime()));
        contentValues2.put("notified_time", c.convertDateToString(beacon.getNotifiedTime()));
        contentValues2.put("lastAccuracy", beacon.getAccuracy());
        contentValues2.put("lastTransition", beacon.getTransition());
        contentValues.put("lastDistance", Double.valueOf(beacon.getDistance()));
        int n2 = this.mAcc.a(A4SContract.Beacons.getContentUri(this.mContext), contentValues2, string2, stringArray);
        beacon.setRowId(this.getBeaconId(beacon));
        if (bl) {
            this.updateBeaconParams(beacon.getRowId(), beacon.getCustomParameters());
        }
        if (bl2) {
            this.updateBeaconGroups(beacon.getRowId(), beacon.getGroups());
        }
        return n2;
    }

    public void updateBeaconParams(long l2, Map<String, String> map) {
        HashMap<String, String> hashMap;
        HashMap<String, String> hashMap2 = hashMap;
        hashMap = new HashMap<String, String>(map);
        Cursor cursor = new String[2];
        Cursor cursor2 = cursor;
        cursor[0] = "_id";
        cursor[1] = "param_key";
        Uri uri = new String[1];
        Uri uri2 = uri;
        uri[0] = Long.toString(l2);
        cursor2 = this.mAcc.a(A4SContract.BeaconParams.getContentUri(this.mContext), (String[])cursor2, "beacon_id=?", (String[])uri2, null);
        if (cursor2 != null) {
            if (cursor2.moveToFirst()) {
                do {
                    int n2 = cursor2.getInt(0);
                    uri2 = Uri.withAppendedPath((Uri)A4SContract.BeaconParams.getContentUri(this.mContext), (String)("/" + n2));
                    String string2 = cursor2.getString(1);
                    if (map.containsKey(string2)) {
                        ContentValues contentValues;
                        ContentValues contentValues2 = contentValues;
                        contentValues2();
                        contentValues.put("param_value", map.get(string2));
                        this.mAcc.a(uri2, contentValues2, null, null);
                        hashMap2.remove(string2);
                        continue;
                    }
                    this.mAcc.a(uri2, null, null);
                } while (cursor2.moveToNext());
            }
            cursor2.close();
        }
        if (hashMap2.size() > 0) {
            this.insertBeaconParams(l2, hashMap2);
        }
    }

    public void updateBeaconGroups(long l2, Set<String> set) {
        HashSet<String> hashSet;
        HashSet<String> hashSet2 = hashSet;
        hashSet = new HashSet<String>(set);
        Cursor cursor = new String[3];
        Cursor cursor2 = cursor;
        cursor[0] = "beacon_geofence_groups._id";
        cursor[1] = "server_id";
        cursor[2] = "beacon_groups._id";
        String[] stringArray = new String[1];
        String[] stringArray2 = stringArray;
        stringArray[0] = Long.toString(l2);
        cursor2 = this.mAcc.a(A4SContract.BeaconGeofenceGroups.getBeaconsContentFilterUri(this.mContext), (String[])cursor2, "beacon_id=?", stringArray2, null);
        if (cursor2 != null) {
            if (cursor2.moveToFirst()) {
                do {
                    Cursor cursor3 = cursor2;
                    int n2 = cursor3.getInt(0);
                    String string2 = cursor3.getString(1);
                    int n3 = cursor2.getInt(2);
                    if (set.contains(string2)) {
                        hashSet2.remove(string2);
                        continue;
                    }
                    b b2 = this;
                    Uri uri = Uri.withAppendedPath((Uri)A4SContract.BeaconGeofenceGroups.getContentUri(b2.mContext), (String)("/" + n2));
                    b2.mAcc.a(uri, null, null);
                    uri = Uri.withAppendedPath((Uri)A4SContract.BeaconGroups.getContentUri(b2.mContext), (String)("/" + n3));
                    b2.mAcc.a(uri, null, null);
                } while (cursor2.moveToNext());
            }
            cursor2.close();
        }
        if (hashSet2.size() > 0) {
            this.insertBeaconGroups(l2, hashSet2);
        }
    }

    public void updateBeacons(List<Beacon> object) {
        object = object.iterator();
        while (object.hasNext()) {
            Beacon beacon = (Beacon)object.next();
            if (this.hasBeacon(beacon.getId()) < 0L) {
                if (beacon.isNeedToBeRemoved()) continue;
                this.insertBeacon(beacon);
                continue;
            }
            if (beacon.isNeedToBeRemoved()) {
                this.deleteBeacon(beacon);
                continue;
            }
            this.updateBeacon(beacon, true, true);
        }
    }

    public int deleteBeacon(Beacon beacon) {
        long l2 = beacon.getRowId() > 0L ? beacon.getRowId() : this.getBeaconId(beacon);
        b b2 = this;
        beacon = Uri.withAppendedPath((Uri)A4SContract.Beacons.getContentUri(b2.mContext), (String)String.valueOf(l2));
        int n2 = b2.mAcc.a((Uri)beacon, null, null);
        this.mAcc.a(A4SContract.BeaconParams.getContentUri(this.mContext), "beacon_id=" + l2, null);
        return n2;
    }

    public void deleteBeacons(List<Beacon> object) {
        ArrayList<ContentProviderOperation> arrayList;
        ArrayList<ContentProviderOperation> arrayList2 = arrayList;
        arrayList = new ArrayList<ContentProviderOperation>(object.size());
        if (Build.VERSION.SDK_INT >= 5) {
            object = object.iterator();
            while (object.hasNext()) {
                Beacon beacon = (Beacon)object.next();
                arrayList2.add(ContentProviderOperation.newDelete((Uri)A4SContract.Beacons.getContentUri(this.mContext)).withSelection("server_id=" + beacon.getId(), null).build());
            }
            try {
                this.mAcc.a(arrayList2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public int deleteAllBeacons() {
        int n2 = this.mAcc.a(A4SContract.Beacons.getContentUri(this.mContext), null, null);
        b b2 = this;
        b2.mAcc.a(A4SContract.BeaconParams.getContentUri(this.mContext), null, null);
        b2.mAcc.a(A4SContract.BeaconGroups.getContentUri(this.mContext), null, null);
        return n2;
    }
}

