/*
 * Decompiled with CFR 0.152.
 */
package com.ad4screen.sdk.provider;

import android.content.ContentProvider;
import android.content.ContentProviderOperation;
import android.content.ContentProviderResult;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.content.OperationApplicationException;
import android.content.UriMatcher;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteQueryBuilder;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.ad4screen.sdk.Log;
import com.ad4screen.sdk.contract.A4SContract;
import com.ad4screen.sdk.plugins.model.Beacon;
import com.ad4screen.sdk.plugins.model.Geofence;
import com.ad4screen.sdk.provider.a;
import com.ad4screen.sdk.provider.c;
import com.ad4screen.sdk.provider.e;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class A4SProvider
extends ContentProvider {
    private static UriMatcher c = new UriMatcher(-1);
    private SQLiteDatabase a;
    private final Object b = new Object();

    private void a(Context context) {
        c = new UriMatcher(-1);
        c.addURI(A4SContract.getAuthority(context), "beacons", 100);
        c.addURI(A4SContract.getAuthority(context), "beacons/#", 101);
        c.addURI(A4SContract.getAuthority(context), "beacons/beacon_groups/filter", 102);
        c.addURI(A4SContract.getAuthority(context), "beacon_params", 200);
        c.addURI(A4SContract.getAuthority(context), "beacon_params/#", 201);
        c.addURI(A4SContract.getAuthority(context), "geofences", 300);
        c.addURI(A4SContract.getAuthority(context), "geofences/#", 301);
        c.addURI(A4SContract.getAuthority(context), "geofences/geofence_groups/filter", 302);
        c.addURI(A4SContract.getAuthority(context), "geofence_params", 400);
        c.addURI(A4SContract.getAuthority(context), "geofence_params/#", 401);
        c.addURI(A4SContract.getAuthority(context), "beacon_geofence_groups", 500);
        c.addURI(A4SContract.getAuthority(context), "beacon_geofence_groups/#", 501);
        c.addURI(A4SContract.getAuthority(context), "beacon_geofence_groups/beacon_groups/filter", 502);
        c.addURI(A4SContract.getAuthority(context), "beacon_geofence_groups/geofence_groups/filter", 503);
        c.addURI(A4SContract.getAuthority(context), "beacon_groups", 600);
        c.addURI(A4SContract.getAuthority(context), "beacon_groups/#", 601);
        c.addURI(A4SContract.getAuthority(context), "custom_beacon_groups", 602);
        c.addURI(A4SContract.getAuthority(context), "geofence_groups", 700);
        c.addURI(A4SContract.getAuthority(context), "geofence_groups/#", 701);
        c.addURI(A4SContract.getAuthority(context), "custom_geofence_groups", 702);
        c.addURI(A4SContract.getAuthority(context), "notification_displays", 800);
        c.addURI(A4SContract.getAuthority(context), "notification_displays/#", 801);
        c.addURI(A4SContract.getAuthority(context), "notification_displays/notification_tags/filter", 802);
        c.addURI(A4SContract.getAuthority(context), "notification_displays/last/#", 803);
        c.addURI(A4SContract.getAuthority(context), "notification_tags", 900);
        c.addURI(A4SContract.getAuthority(context), "notification_tags/#", 901);
        c.addURI(A4SContract.getAuthority(context), "notification_tags/notification_displays/filter", 902);
        c.addURI(A4SContract.getAuthority(context), "notification_display_tags", 1000);
        c.addURI(A4SContract.getAuthority(context), "notification_display_tags/#", 1001);
        c.addURI(A4SContract.getAuthority(context), "custom_notification_display_tags", 1002);
    }

    private static String[] a(String[] stringArray, String string2) {
        if (stringArray == null) {
            return new String[]{string2};
        }
        String[] stringArray2 = new String[stringArray.length + 1];
        stringArray2[0] = string2;
        int n2 = stringArray.length;
        System.arraycopy(stringArray, 0, stringArray2, 1, n2);
        return stringArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private SQLiteDatabase a() {
        A4SProvider a4SProvider = this;
        Object object = a4SProvider.b;
        synchronized (object) {
            if (a4SProvider.a != null) {
                return this.a;
            }
            try {
                A4SProvider a4SProvider2 = this;
                a4SProvider2.a = com.ad4screen.sdk.provider.a.a(a4SProvider2.getContext()).getWritableDatabase();
                return a4SProvider2.a;
            }
            catch (Exception exception) {
                Log.error("A4SProvider|Cannot access writable database.", exception);
                return null;
            }
        }
    }

    public boolean onCreate() {
        try {
            A4SProvider a4SProvider = this;
            a4SProvider.a(a4SProvider.getContext());
            return true;
        }
        catch (RuntimeException runtimeException) {
            Log.error("A4SProvider|Cannot start A4SProvider", runtimeException);
            return false;
        }
    }

    public String getType(Uri uri) {
        String string2;
        switch (c.match(uri)) {
            default: {
                throw new IllegalArgumentException("Unsupported URI: " + uri);
            }
            case 901: {
                string2 = A4SContract.NotificationTags.CONTENT_ITEM_TYPE;
                break;
            }
            case 900: {
                string2 = A4SContract.NotificationTags.CONTENT_TYPE;
                break;
            }
            case 801: {
                string2 = A4SContract.NotificationDisplays.CONTENT_ITEM_TYPE;
                break;
            }
            case 800: {
                string2 = A4SContract.NotificationDisplays.CONTENT_TYPE;
                break;
            }
            case 401: {
                string2 = A4SContract.GeofenceParams.CONTENT_ITEM_TYPE;
                break;
            }
            case 400: {
                string2 = A4SContract.GeofenceParams.CONTENT_TYPE;
                break;
            }
            case 301: {
                string2 = A4SContract.Geofences.CONTENT_ITEM_TYPE;
                break;
            }
            case 300: {
                string2 = A4SContract.Geofences.CONTENT_TYPE;
                break;
            }
            case 201: {
                string2 = A4SContract.BeaconParams.CONTENT_ITEM_TYPE;
                break;
            }
            case 200: {
                string2 = A4SContract.BeaconParams.CONTENT_TYPE;
                break;
            }
            case 101: {
                string2 = A4SContract.Beacons.CONTENT_ITEM_TYPE;
                break;
            }
            case 100: {
                string2 = A4SContract.Beacons.CONTENT_TYPE;
            }
        }
        return string2;
    }

    public Cursor query(Uri uri, String[] cursor, String string2, String[] stringArray, String string3) {
        SQLiteQueryBuilder sQLiteQueryBuilder;
        SQLiteQueryBuilder sQLiteQueryBuilder2 = sQLiteQueryBuilder;
        sQLiteQueryBuilder = new SQLiteQueryBuilder();
        SQLiteDatabase sQLiteDatabase = ((A4SProvider)((Object)object)).a();
        if (sQLiteDatabase == null) {
            return null;
        }
        switch (c.match(uri)) {
            default: {
                throw new IllegalArgumentException("Unsupported URI: " + uri);
            }
            case 1001: {
                sQLiteQueryBuilder2.setTables("notif_display_tags");
                stringArray = A4SProvider.a(stringArray, String.valueOf(ContentUris.parseId((Uri)uri)));
                sQLiteQueryBuilder2.appendWhere((CharSequence)"_id=?");
                break;
            }
            case 1000: {
                sQLiteQueryBuilder2.setTables("notif_display_tags");
                break;
            }
            case 902: {
                StringBuffer stringBuffer;
                Object object = stringBuffer;
                stringBuffer = new StringBuffer("SELECT ");
                if (cursor == null) {
                    ((StringBuffer)object).append("*");
                } else {
                    int n2 = ((String[])cursor).length;
                    for (int i2 = 0; i2 < n2; ++i2) {
                        Object object2 = object;
                        ((StringBuffer)object2).append((String)cursor[i2]);
                        ((StringBuffer)object2).append(",");
                    }
                    if (((StringBuffer)object).length() > 0) {
                        Object object3 = object;
                        ((StringBuffer)object3).deleteCharAt(((StringBuffer)object3).length() - 1);
                    }
                }
                Object object4 = object;
                ((StringBuffer)object4).append(" FROM notif_tags");
                ((StringBuffer)object4).append(" INNER JOIN notif_display_tags");
                ((StringBuffer)object4).append(" ON notif_tags._id=notif_display_tags.tag_id");
                if (string2 != null) {
                    ((StringBuffer)object).append(" WHERE " + string2);
                }
                return sQLiteDatabase.rawQuery(((StringBuffer)object).toString(), stringArray);
            }
            case 901: {
                sQLiteQueryBuilder2.setTables("notif_tags");
                stringArray = A4SProvider.a(stringArray, String.valueOf(ContentUris.parseId((Uri)uri)));
                sQLiteQueryBuilder2.appendWhere((CharSequence)"_id=?");
                break;
            }
            case 900: {
                sQLiteQueryBuilder2.setTables("notif_tags");
                break;
            }
            case 802: {
                StringBuffer stringBuffer;
                Object object = stringBuffer;
                stringBuffer = new StringBuffer("SELECT ");
                if (cursor == null) {
                    ((StringBuffer)object).append("*");
                } else {
                    int n3 = ((String[])cursor).length;
                    for (int i3 = 0; i3 < n3; ++i3) {
                        Object object5 = object;
                        ((StringBuffer)object5).append((String)cursor[i3]);
                        ((StringBuffer)object5).append(",");
                    }
                    if (((StringBuffer)object).length() > 0) {
                        Object object6 = object;
                        ((StringBuffer)object6).deleteCharAt(((StringBuffer)object6).length() - 1);
                    }
                }
                Object object7 = object;
                ((StringBuffer)object7).append(" FROM notif_displays");
                ((StringBuffer)object7).append(" INNER JOIN notif_display_tags");
                ((StringBuffer)object7).append(" ON notif_displays._id=notif_display_tags.display_id");
                ((StringBuffer)object7).append(" INNER JOIN notif_tags");
                ((StringBuffer)object7).append(" ON notif_display_tags.tag_id=notif_tags._id");
                if (string2 != null) {
                    ((StringBuffer)object).append(" WHERE " + string2);
                }
                return sQLiteDatabase.rawQuery(((StringBuffer)object).toString(), stringArray);
            }
            case 801: {
                sQLiteQueryBuilder2.setTables("notif_displays");
                stringArray = A4SProvider.a(stringArray, String.valueOf(ContentUris.parseId((Uri)uri)));
                sQLiteQueryBuilder2.appendWhere((CharSequence)"_id=?");
                break;
            }
            case 800: {
                sQLiteQueryBuilder2.setTables("notif_displays");
                break;
            }
            case 701: {
                long l2 = ContentUris.parseId((Uri)uri);
                sQLiteQueryBuilder2.setTables("geofence_groups");
                stringArray = A4SProvider.a(stringArray, String.valueOf(l2));
                sQLiteQueryBuilder2.appendWhere((CharSequence)"_id=?");
                break;
            }
            case 700: {
                sQLiteQueryBuilder2.setTables("geofence_groups");
                break;
            }
            case 601: {
                long l3 = ContentUris.parseId((Uri)uri);
                sQLiteQueryBuilder2.setTables("beacon_groups");
                stringArray = A4SProvider.a(stringArray, String.valueOf(l3));
                sQLiteQueryBuilder2.appendWhere((CharSequence)"_id=?");
                break;
            }
            case 600: {
                sQLiteQueryBuilder2.setTables("beacon_groups");
                break;
            }
            case 503: {
                StringBuffer stringBuffer;
                Object object = stringBuffer;
                stringBuffer = new StringBuffer("SELECT ");
                if (cursor == null) {
                    ((StringBuffer)object).append("*");
                } else {
                    int n4 = ((String[])cursor).length;
                    for (int i4 = 0; i4 < n4; ++i4) {
                        Object object8 = object;
                        ((StringBuffer)object8).append((String)cursor[i4]);
                        ((StringBuffer)object8).append(",");
                    }
                    if (((StringBuffer)object).length() > 0) {
                        Object object9 = object;
                        ((StringBuffer)object9).deleteCharAt(((StringBuffer)object9).length() - 1);
                    }
                }
                Object object10 = object;
                ((StringBuffer)object10).append(" FROM beacon_geofence_groups");
                ((StringBuffer)object10).append(" INNER JOIN geofence_groups");
                ((StringBuffer)object10).append(" ON beacon_geofence_groups._id=geofence_groups.group_id");
                if (string2 != null) {
                    ((StringBuffer)object).append(" WHERE " + string2);
                }
                return sQLiteDatabase.rawQuery(((StringBuffer)object).toString(), stringArray);
            }
            case 502: {
                StringBuffer stringBuffer;
                Object object = stringBuffer;
                stringBuffer = new StringBuffer("SELECT ");
                if (cursor == null) {
                    ((StringBuffer)object).append("*");
                } else {
                    int n5 = ((String[])cursor).length;
                    for (int i5 = 0; i5 < n5; ++i5) {
                        Object object11 = object;
                        ((StringBuffer)object11).append((String)cursor[i5]);
                        ((StringBuffer)object11).append(",");
                    }
                    if (((StringBuffer)object).length() > 0) {
                        Object object12 = object;
                        ((StringBuffer)object12).deleteCharAt(((StringBuffer)object12).length() - 1);
                    }
                }
                Object object13 = object;
                ((StringBuffer)object13).append(" FROM beacon_geofence_groups");
                ((StringBuffer)object13).append(" INNER JOIN beacon_groups");
                ((StringBuffer)object13).append(" ON beacon_geofence_groups._id=beacon_groups.group_id");
                if (string2 != null) {
                    ((StringBuffer)object).append(" WHERE " + string2);
                }
                return sQLiteDatabase.rawQuery(((StringBuffer)object).toString(), stringArray);
            }
            case 501: {
                long l4 = ContentUris.parseId((Uri)uri);
                sQLiteQueryBuilder2.setTables("beacon_geofence_groups");
                stringArray = A4SProvider.a(stringArray, String.valueOf(l4));
                sQLiteQueryBuilder2.appendWhere((CharSequence)"_id=?");
                break;
            }
            case 500: {
                sQLiteQueryBuilder2.setTables("beacon_geofence_groups");
                break;
            }
            case 401: {
                long l5 = ContentUris.parseId((Uri)uri);
                sQLiteQueryBuilder2.setTables("geofence_params");
                stringArray = A4SProvider.a(stringArray, String.valueOf(l5));
                sQLiteQueryBuilder2.appendWhere((CharSequence)"_id=?");
                break;
            }
            case 400: {
                sQLiteQueryBuilder2.setTables("geofence_params");
                break;
            }
            case 302: {
                StringBuffer stringBuffer;
                Object object = stringBuffer;
                stringBuffer = new StringBuffer("SELECT ");
                if (cursor == null) {
                    ((StringBuffer)object).append("*");
                } else {
                    int n6 = ((String[])cursor).length;
                    for (int i6 = 0; i6 < n6; ++i6) {
                        Object object14 = object;
                        ((StringBuffer)object14).append((String)cursor[i6]);
                        ((StringBuffer)object14).append(",");
                    }
                    if (((StringBuffer)object).length() > 0) {
                        Object object15 = object;
                        ((StringBuffer)object15).deleteCharAt(((StringBuffer)object15).length() - 1);
                    }
                }
                Object object16 = object;
                ((StringBuffer)object16).append(" FROM geofences");
                ((StringBuffer)object16).append(" INNER JOIN geofence_groups");
                ((StringBuffer)object16).append(" ON geofences._id=geofence_groups.geofence_id");
                ((StringBuffer)object16).append(" INNER JOIN beacon_geofence_groups");
                ((StringBuffer)object16).append(" ON geofence_groups.group_id=beacon_geofence_groups._id");
                if (string2 != null) {
                    ((StringBuffer)object).append(" WHERE " + string2);
                }
                return sQLiteDatabase.rawQuery(((StringBuffer)object).toString(), stringArray);
            }
            case 301: {
                long l6 = ContentUris.parseId((Uri)uri);
                sQLiteQueryBuilder2.setTables("geofences");
                stringArray = A4SProvider.a(stringArray, String.valueOf(l6));
                sQLiteQueryBuilder2.appendWhere((CharSequence)"_id=?");
                break;
            }
            case 300: {
                sQLiteQueryBuilder2.setTables("geofences");
                break;
            }
            case 201: {
                long l7 = ContentUris.parseId((Uri)uri);
                sQLiteQueryBuilder2.setTables("beacon_params");
                stringArray = A4SProvider.a(stringArray, String.valueOf(l7));
                sQLiteQueryBuilder2.appendWhere((CharSequence)"_id=?");
                break;
            }
            case 200: {
                sQLiteQueryBuilder2.setTables("beacon_params");
                break;
            }
            case 102: {
                StringBuffer stringBuffer;
                Object object = stringBuffer;
                stringBuffer = new StringBuffer("SELECT ");
                if (cursor == null) {
                    ((StringBuffer)object).append("*");
                } else {
                    int n7 = ((String[])cursor).length;
                    for (int i7 = 0; i7 < n7; ++i7) {
                        Object object17 = object;
                        ((StringBuffer)object17).append((String)cursor[i7]);
                        ((StringBuffer)object17).append(",");
                    }
                    if (((StringBuffer)object).length() > 0) {
                        Object object18 = object;
                        ((StringBuffer)object18).deleteCharAt(((StringBuffer)object18).length() - 1);
                    }
                }
                Object object19 = object;
                ((StringBuffer)object19).append(" FROM beacons");
                ((StringBuffer)object19).append(" INNER JOIN beacon_groups");
                ((StringBuffer)object19).append(" ON beacons._id=beacon_groups.beacon_id");
                ((StringBuffer)object19).append(" INNER JOIN beacon_geofence_groups");
                ((StringBuffer)object19).append(" ON beacon_groups.group_id=beacon_geofence_groups._id");
                if (string2 != null) {
                    ((StringBuffer)object).append(" WHERE " + string2);
                }
                if (sQLiteDatabase != null) {
                    return sQLiteDatabase.rawQuery(((StringBuffer)object).toString(), stringArray);
                }
                return null;
            }
            case 101: {
                long l8 = ContentUris.parseId((Uri)uri);
                sQLiteQueryBuilder2.setTables("beacons");
                stringArray = A4SProvider.a(stringArray, String.valueOf(l8));
                sQLiteQueryBuilder2.appendWhere((CharSequence)"_id=?");
                break;
            }
            case 100: {
                sQLiteQueryBuilder2.setTables("beacons");
            }
        }
        cursor = sQLiteQueryBuilder2.query(sQLiteDatabase, (String[])cursor, string2, stringArray, null, null, string3);
        if (cursor != null) {
            cursor.setNotificationUri(object.getContext().getContentResolver(), uri);
        }
        return cursor;
    }

    public Uri insert(Uri uri, ContentValues contentValues) {
        String string2;
        SQLiteDatabase sQLiteDatabase = this.a();
        if (sQLiteDatabase == null) {
            return null;
        }
        switch (c.match(uri)) {
            default: {
                throw new IllegalArgumentException("Unsupported URI: " + uri);
            }
            case 1000: {
                string2 = "notif_display_tags";
                break;
            }
            case 900: {
                string2 = "notif_tags";
                break;
            }
            case 800: {
                string2 = "notif_displays";
                break;
            }
            case 700: {
                string2 = "geofence_groups";
                break;
            }
            case 600: {
                string2 = "beacon_groups";
                break;
            }
            case 500: {
                string2 = "beacon_geofence_groups";
                break;
            }
            case 400: {
                string2 = "geofence_params";
                break;
            }
            case 300: {
                string2 = "geofences";
                break;
            }
            case 200: {
                string2 = "beacon_params";
                break;
            }
            case 100: {
                string2 = "beacons";
            }
        }
        long l2 = sQLiteDatabase.insert(string2, null, contentValues);
        if (l2 > 0L) {
            Uri uri2 = ContentUris.withAppendedId((Uri)uri, (long)l2);
            this.getContext().getContentResolver().notifyChange(uri, null);
            return uri2;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public int bulkInsert(Uri uri, ContentValues[] object) {
        void var2_6;
        String string2;
        int n2;
        int n3;
        ContentValues[] contentValuesArray;
        SQLiteDatabase sQLiteDatabase;
        block30: {
            String string3;
            sQLiteDatabase = this.a();
            if (sQLiteDatabase == null) {
                return 0;
            }
            switch (c.match(uri)) {
                default: {
                    throw new IllegalArgumentException("Unsupported URI: " + uri);
                }
                case 1002: {
                    String n7;
                    String[] stringArray;
                    Cursor cursor;
                    String string4;
                    String string5;
                    long contentValues10;
                    Object object2 = object;
                    int n6 = 0;
                    contentValuesArray = new ContentValues[((Object)object2).length];
                    n3 = ((Object)object2).length;
                    for (n2 = 0; n2 < n3; ++n2) {
                        ContentValues contentValues;
                        Object object3 = object[n2];
                        contentValues10 = -1L;
                        string5 = object3.getAsString("display_id");
                        string4 = object3.getAsString("server_id");
                        Cursor cursor2 = new String[1];
                        cursor = cursor2;
                        cursor2[0] = "_id";
                        String[] stringArray2 = new String[1];
                        stringArray = stringArray2;
                        stringArray2[0] = string4;
                        if ((cursor = sQLiteDatabase.query("notif_tags", (String[])cursor, "server_id=?", stringArray, null, null, null)) != null) {
                            if (cursor.getCount() > 0) {
                                Cursor cursor3 = cursor;
                                cursor3.moveToFirst();
                                contentValues10 = cursor3.getInt(0);
                            }
                            cursor.close();
                        }
                        if (contentValues10 == -1L) {
                            ContentValues contentValues2;
                            ContentValues contentValues3 = contentValues2;
                            new ContentValues().put("server_id", string4);
                            contentValues10 = sQLiteDatabase.insert("notif_tags", null, contentValues3);
                        }
                        String string6 = string4 = contentValues;
                        string6();
                        string6.put("display_id", string5);
                        contentValues.put("tag_id", Long.valueOf(contentValues10));
                        contentValuesArray[n6++] = contentValues;
                    }
                    string2 = n7 = "notif_display_tags";
                    break block30;
                }
                case 1000: {
                    string3 = "notif_display_tags";
                    break;
                }
                case 900: {
                    string3 = "notif_tags";
                    break;
                }
                case 800: {
                    string3 = "notif_displays";
                    break;
                }
                case 702: {
                    String[] stringArray;
                    Cursor cursor;
                    String string4;
                    String string5;
                    long contentValues10;
                    Object object4 = object;
                    int n4 = 0;
                    contentValuesArray = new ContentValues[((Object)object4).length];
                    n3 = ((Object)object4).length;
                    for (n2 = 0; n2 < n3; ++n2) {
                        ContentValues contentValues;
                        Object object5 = object[n2];
                        contentValues10 = -1L;
                        string5 = object5.getAsString("geofence_id");
                        string4 = object5.getAsString("server_id");
                        String[] stringArray3 = new String[1];
                        cursor = stringArray3;
                        stringArray3[0] = "_id";
                        String[] stringArray4 = new String[1];
                        stringArray = stringArray4;
                        stringArray4[0] = string4;
                        if ((cursor = sQLiteDatabase.query("beacon_geofence_groups", (String[])cursor, "server_id=?", stringArray, null, null, null)) != null) {
                            if (cursor.getCount() > 0) {
                                Cursor cursor4 = cursor;
                                cursor4.moveToFirst();
                                contentValues10 = cursor4.getInt(0);
                            }
                            cursor.close();
                        }
                        if (contentValues10 == -1L) {
                            ContentValues contentValues4;
                            ContentValues contentValues5 = contentValues4;
                            new ContentValues().put("server_id", string4);
                            contentValues10 = sQLiteDatabase.insert("beacon_geofence_groups", null, contentValues5);
                        }
                        String string7 = string4 = contentValues;
                        string7();
                        string7.put("geofence_id", string5);
                        contentValues.put("group_id", Long.valueOf(contentValues10));
                        contentValuesArray[n4++] = contentValues;
                    }
                    string2 = "geofence_groups";
                    break block30;
                }
                case 700: {
                    string3 = "geofence_groups";
                    break;
                }
                case 602: {
                    String[] stringArray;
                    Cursor cursor;
                    String string4;
                    String string5;
                    long contentValues10;
                    Object object6 = object;
                    int n5 = 0;
                    contentValuesArray = new ContentValues[((Object)object6).length];
                    n3 = ((Object)object6).length;
                    for (n2 = 0; n2 < n3; ++n2) {
                        ContentValues contentValues;
                        Object object7 = object[n2];
                        contentValues10 = -1L;
                        string5 = object7.getAsString("beacon_id");
                        string4 = object7.getAsString("server_id");
                        String[] stringArray5 = new String[1];
                        cursor = stringArray5;
                        stringArray5[0] = "_id";
                        String[] stringArray6 = new String[1];
                        stringArray = stringArray6;
                        stringArray6[0] = string4;
                        if ((cursor = sQLiteDatabase.query("beacon_geofence_groups", (String[])cursor, "server_id=?", stringArray, null, null, null)) != null) {
                            if (cursor.getCount() > 0) {
                                Cursor cursor5 = cursor;
                                cursor5.moveToFirst();
                                contentValues10 = cursor5.getInt(0);
                            }
                            cursor.close();
                        }
                        if (contentValues10 == -1L) {
                            ContentValues contentValues6;
                            ContentValues contentValues7 = contentValues6;
                            new ContentValues().put("server_id", string4);
                            contentValues10 = sQLiteDatabase.insert("beacon_geofence_groups", null, contentValues7);
                        }
                        String string8 = string4 = contentValues;
                        string8();
                        string8.put("beacon_id", string5);
                        contentValues.put("group_id", Long.valueOf(contentValues10));
                        contentValuesArray[n5++] = contentValues;
                    }
                    string2 = "beacon_groups";
                    break block30;
                }
                case 600: {
                    string3 = "beacon_groups";
                    break;
                }
                case 500: {
                    string3 = "beacon_geofence_groups";
                    break;
                }
                case 400: {
                    string3 = "geofence_params";
                    break;
                }
                case 300: {
                    string3 = "geofences";
                    break;
                }
                case 200: {
                    string3 = "beacon_params";
                    break;
                }
                case 100: {
                    string3 = "beacons";
                }
            }
            string2 = string3;
            contentValuesArray = object;
        }
        boolean bl = false;
        sQLiteDatabase.beginTransaction();
        n3 = contentValuesArray.length;
        for (n2 = 0; n2 < n3; ++n2) {
            if (sQLiteDatabase.insert(string2, null, contentValuesArray[n2]) < 0L) continue;
            ++var2_6;
        }
        SQLiteDatabase sQLiteDatabase2 = sQLiteDatabase;
        sQLiteDatabase2.setTransactionSuccessful();
        sQLiteDatabase2.endTransaction();
        if (var2_6 > 0) {
            this.getContext().getContentResolver().notifyChange(uri, null);
        }
        return (int)var2_6;
    }

    public int delete(Uri uri, String string2, String[] object) {
        String string3;
        String[] stringArray;
        Object object2;
        SQLiteDatabase sQLiteDatabase = this.a();
        if (sQLiteDatabase == null) {
            return 0;
        }
        String[] stringArray2 = null;
        switch (c.match(uri)) {
            default: {
                throw new IllegalArgumentException("Unsupported URI: " + uri);
            }
            case 1001: {
                String[] stringArray3 = object;
                object = "notif_display_tags";
                stringArray2 = A4SProvider.a(stringArray3, String.valueOf(ContentUris.parseId((Uri)uri)));
                object2 = new StringBuilder().append("_id=?");
                string2 = !TextUtils.isEmpty((CharSequence)string2) ? " AND (" + string2 + ")" : "";
                string2 = ((StringBuilder)object2).append(string2).toString();
                object2 = A4SContract.NotificationDisplayTags.getContentUri(this.getContext());
                Object object3 = object;
                object = object2;
                stringArray = stringArray2;
                string3 = string2;
                object2 = object3;
                break;
            }
            case 1000: {
                object2 = "notif_display_tags";
                String[] stringArray4 = object;
                object = stringArray2;
                stringArray = stringArray4;
                string3 = string2;
                break;
            }
            case 901: {
                object2 = "notif_tags";
                stringArray2 = A4SProvider.a((String[])object, String.valueOf(ContentUris.parseId((Uri)uri)));
                object = new StringBuilder().append("_id=?");
                string2 = !TextUtils.isEmpty((CharSequence)string2) ? " AND (" + string2 + ")" : "";
                string2 = ((StringBuilder)object).append(string2).toString();
                object = A4SContract.NotificationTags.getContentUri(this.getContext());
                stringArray = stringArray2;
                string3 = string2;
                break;
            }
            case 900: {
                object2 = "notif_tags";
                String[] stringArray5 = object;
                object = stringArray2;
                stringArray = stringArray5;
                string3 = string2;
                break;
            }
            case 803: {
                object2 = "notif_displays";
                long l2 = ContentUris.parseId((Uri)uri);
                string3 = "server_id=? AND displayed_time = (SELECT MAX(displayed_time) FROM notif_displays WHERE server_id=?);";
                String[] stringArray6 = new String[2];
                stringArray = stringArray6;
                stringArray[0] = String.valueOf(l2);
                stringArray6[1] = String.valueOf(l2);
                object = stringArray2;
                break;
            }
            case 801: {
                object2 = "notif_displays";
                stringArray = A4SProvider.a((String[])object, String.valueOf(ContentUris.parseId((Uri)uri)));
                object = new StringBuilder().append("_id=?");
                string2 = !TextUtils.isEmpty((CharSequence)string2) ? " AND (" + string2 + ")" : "";
                string3 = ((StringBuilder)object).append(string2).toString();
                object = A4SContract.NotificationDisplays.getContentUri(this.getContext());
                break;
            }
            case 800: {
                object2 = "notif_displays";
                String[] stringArray7 = object;
                object = stringArray2;
                stringArray = stringArray7;
                string3 = string2;
                break;
            }
            case 701: {
                object2 = "geofence_groups";
                stringArray = A4SProvider.a((String[])object, String.valueOf(ContentUris.parseId((Uri)uri)));
                object = new StringBuilder().append("_id=?");
                string2 = !TextUtils.isEmpty((CharSequence)string2) ? " AND (" + string2 + ")" : "";
                string3 = ((StringBuilder)object).append(string2).toString();
                object = A4SContract.GeofenceGroups.getContentUri(this.getContext());
                break;
            }
            case 700: {
                object2 = "geofence_groups";
                String[] stringArray8 = object;
                object = stringArray2;
                stringArray = stringArray8;
                string3 = string2;
                break;
            }
            case 601: {
                object2 = "beacon_groups";
                stringArray = A4SProvider.a((String[])object, String.valueOf(ContentUris.parseId((Uri)uri)));
                object = new StringBuilder().append("_id=?");
                string2 = !TextUtils.isEmpty((CharSequence)string2) ? " AND (" + string2 + ")" : "";
                string3 = ((StringBuilder)object).append(string2).toString();
                object = A4SContract.BeaconGroups.getContentUri(this.getContext());
                break;
            }
            case 600: {
                object2 = "beacon_groups";
                String[] stringArray9 = object;
                object = stringArray2;
                stringArray = stringArray9;
                string3 = string2;
                break;
            }
            case 501: {
                object2 = "beacon_geofence_groups";
                stringArray = A4SProvider.a((String[])object, String.valueOf(ContentUris.parseId((Uri)uri)));
                object = new StringBuilder().append("_id=?");
                string2 = !TextUtils.isEmpty((CharSequence)string2) ? " AND (" + string2 + ")" : "";
                string3 = ((StringBuilder)object).append(string2).toString();
                object = A4SContract.BeaconGeofenceGroups.getContentUri(this.getContext());
                break;
            }
            case 500: {
                object2 = "beacon_geofence_groups";
                String[] stringArray10 = object;
                object = stringArray2;
                stringArray = stringArray10;
                string3 = string2;
                break;
            }
            case 401: {
                object2 = "geofence_params";
                stringArray = A4SProvider.a((String[])object, String.valueOf(ContentUris.parseId((Uri)uri)));
                object = new StringBuilder().append("_id=?");
                string2 = !TextUtils.isEmpty((CharSequence)string2) ? " AND (" + string2 + ")" : "";
                string3 = ((StringBuilder)object).append(string2).toString();
                object = A4SContract.GeofenceParams.getContentUri(this.getContext());
                break;
            }
            case 400: {
                object2 = "geofence_params";
                String[] stringArray11 = object;
                object = stringArray2;
                stringArray = stringArray11;
                string3 = string2;
                break;
            }
            case 301: {
                object2 = "geofences";
                stringArray = A4SProvider.a((String[])object, String.valueOf(ContentUris.parseId((Uri)uri)));
                object = new StringBuilder().append("_id=?");
                string2 = !TextUtils.isEmpty((CharSequence)string2) ? " AND (" + string2 + ")" : "";
                string3 = ((StringBuilder)object).append(string2).toString();
                object = A4SContract.Geofences.getContentUri(this.getContext());
                break;
            }
            case 300: {
                object2 = "geofences";
                String[] stringArray12 = object;
                object = stringArray2;
                stringArray = stringArray12;
                string3 = string2;
                break;
            }
            case 201: {
                object2 = "beacon_params";
                stringArray = A4SProvider.a((String[])object, String.valueOf(ContentUris.parseId((Uri)uri)));
                object = new StringBuilder().append("_id=?");
                string2 = !TextUtils.isEmpty((CharSequence)string2) ? " AND (" + string2 + ")" : "";
                string3 = ((StringBuilder)object).append(string2).toString();
                object = A4SContract.BeaconParams.getContentUri(this.getContext());
                break;
            }
            case 200: {
                object2 = "beacon_params";
                String[] stringArray13 = object;
                object = stringArray2;
                stringArray = stringArray13;
                string3 = string2;
                break;
            }
            case 101: {
                object2 = "beacons";
                stringArray = A4SProvider.a((String[])object, String.valueOf(ContentUris.parseId((Uri)uri)));
                object = new StringBuilder().append("_id=?");
                string2 = !TextUtils.isEmpty((CharSequence)string2) ? " AND (" + string2 + ")" : "";
                string3 = ((StringBuilder)object).append(string2).toString();
                object = A4SContract.Beacons.getContentUri(this.getContext());
                break;
            }
            case 100: {
                object2 = "beacons";
                String[] stringArray14 = object;
                object = stringArray2;
                stringArray = stringArray14;
                string3 = string2;
            }
        }
        int n2 = sQLiteDatabase.delete((String)object2, string3, stringArray);
        if (n2 > 0) {
            this.getContext().getContentResolver().notifyChange(uri, null);
            if (object != null) {
                this.getContext().getContentResolver().notifyChange((Uri)object, null);
            }
        }
        return n2;
    }

    public int update(Uri uri, ContentValues contentValues, String string2, String[] stringArray) {
        String[] stringArray2;
        SQLiteDatabase sQLiteDatabase = this.a();
        if (sQLiteDatabase == null) {
            return 0;
        }
        switch (c.match(uri)) {
            default: {
                throw new IllegalArgumentException("Unsupported URI: " + uri);
            }
            case 1001: {
                String[] stringArray3 = stringArray;
                stringArray = "notif_display_tags";
                stringArray2 = A4SProvider.a(stringArray3, String.valueOf(ContentUris.parseId((Uri)uri)));
                StringBuilder stringBuilder = new StringBuilder().append("_id=?");
                string2 = !TextUtils.isEmpty((CharSequence)string2) ? " AND (" + string2 + ")" : "";
                string2 = stringBuilder.append(string2).toString();
                String[] stringArray4 = stringArray;
                stringArray = stringArray2;
                stringArray2 = stringArray4;
                break;
            }
            case 1000: {
                stringArray2 = "notif_display_tags";
                break;
            }
            case 901: {
                stringArray2 = "notif_tags";
                stringArray = A4SProvider.a(stringArray, String.valueOf(ContentUris.parseId((Uri)uri)));
                StringBuilder stringBuilder = new StringBuilder().append("_id=?");
                string2 = !TextUtils.isEmpty((CharSequence)string2) ? " AND (" + string2 + ")" : "";
                string2 = stringBuilder.append(string2).toString();
                break;
            }
            case 900: {
                stringArray2 = "notif_tags";
                break;
            }
            case 801: {
                stringArray2 = "notif_displays";
                stringArray = A4SProvider.a(stringArray, String.valueOf(ContentUris.parseId((Uri)uri)));
                StringBuilder stringBuilder = new StringBuilder().append("_id=?");
                string2 = !TextUtils.isEmpty((CharSequence)string2) ? " AND (" + string2 + ")" : "";
                string2 = stringBuilder.append(string2).toString();
                break;
            }
            case 800: {
                stringArray2 = "notif_displays";
                break;
            }
            case 701: {
                stringArray2 = "geofence_groups";
                stringArray = A4SProvider.a(stringArray, String.valueOf(ContentUris.parseId((Uri)uri)));
                StringBuilder stringBuilder = new StringBuilder().append("_id=?");
                string2 = !TextUtils.isEmpty((CharSequence)string2) ? " AND (" + string2 + ")" : "";
                string2 = stringBuilder.append(string2).toString();
                break;
            }
            case 700: {
                stringArray2 = "geofence_groups";
                break;
            }
            case 601: {
                stringArray2 = "beacon_groups";
                stringArray = A4SProvider.a(stringArray, String.valueOf(ContentUris.parseId((Uri)uri)));
                StringBuilder stringBuilder = new StringBuilder().append("_id=?");
                string2 = !TextUtils.isEmpty((CharSequence)string2) ? " AND (" + string2 + ")" : "";
                string2 = stringBuilder.append(string2).toString();
                break;
            }
            case 600: {
                stringArray2 = "beacon_groups";
                break;
            }
            case 501: {
                stringArray2 = "beacon_geofence_groups";
                stringArray = A4SProvider.a(stringArray, String.valueOf(ContentUris.parseId((Uri)uri)));
                StringBuilder stringBuilder = new StringBuilder().append("_id=?");
                string2 = !TextUtils.isEmpty((CharSequence)string2) ? " AND (" + string2 + ")" : "";
                string2 = stringBuilder.append(string2).toString();
                break;
            }
            case 500: {
                stringArray2 = "beacon_geofence_groups";
                break;
            }
            case 401: {
                stringArray2 = "geofence_params";
                stringArray = A4SProvider.a(stringArray, String.valueOf(ContentUris.parseId((Uri)uri)));
                StringBuilder stringBuilder = new StringBuilder().append("_id=?");
                string2 = !TextUtils.isEmpty((CharSequence)string2) ? " AND (" + string2 + ")" : "";
                string2 = stringBuilder.append(string2).toString();
                break;
            }
            case 400: {
                stringArray2 = "geofence_params";
                break;
            }
            case 301: {
                stringArray2 = "geofences";
                stringArray = A4SProvider.a(stringArray, String.valueOf(ContentUris.parseId((Uri)uri)));
                StringBuilder stringBuilder = new StringBuilder().append("_id=?");
                string2 = !TextUtils.isEmpty((CharSequence)string2) ? " AND (" + string2 + ")" : "";
                string2 = stringBuilder.append(string2).toString();
                break;
            }
            case 300: {
                stringArray2 = "geofences";
                break;
            }
            case 201: {
                stringArray2 = "beacon_params";
                stringArray = A4SProvider.a(stringArray, String.valueOf(ContentUris.parseId((Uri)uri)));
                StringBuilder stringBuilder = new StringBuilder().append("_id=?");
                string2 = !TextUtils.isEmpty((CharSequence)string2) ? " AND (" + string2 + ")" : "";
                string2 = stringBuilder.append(string2).toString();
                break;
            }
            case 200: {
                stringArray2 = "beacon_params";
                break;
            }
            case 101: {
                stringArray2 = "beacons";
                stringArray = A4SProvider.a(stringArray, String.valueOf(ContentUris.parseId((Uri)uri)));
                StringBuilder stringBuilder = new StringBuilder().append("_id=?");
                string2 = !TextUtils.isEmpty((CharSequence)string2) ? " AND (" + string2 + ")" : "";
                string2 = stringBuilder.append(string2).toString();
                break;
            }
            case 100: {
                stringArray2 = "beacons";
            }
        }
        int n2 = sQLiteDatabase.update((String)stringArray2, contentValues, string2, stringArray);
        if (n2 > 0) {
            this.getContext().getContentResolver().notifyChange(uri, null);
        }
        return n2;
    }

    public Bundle call(String object, String string2, Bundle bundle) {
        int n2 = -1;
        int n3 = ((String)object).hashCode();
        if (n3 != -1897996758) {
            if (n3 == -1730717786 && ((String)object).equals("updateBeacons")) {
                n2 = 1;
            }
        } else if (((String)object).equals("updateGeofences")) {
            n2 = 0;
        }
        if (n2 != 0) {
            if (n2 != 1) {
                Log.warn("A4SProvider|call method is not found");
            } else {
                Bundle bundle2 = bundle;
                bundle2.setClassLoader(Beacon.class.getClassLoader());
                object = bundle2.getParcelableArrayList("beacons");
                if (object != null) {
                    new b(new c()).updateBeacons((List<Beacon>)object);
                }
            }
        } else {
            Bundle bundle3 = bundle;
            bundle3.setClassLoader(Geofence.class.getClassLoader());
            object = bundle3.getParcelableArrayList("geofences");
            if (object != null) {
                new d(new c()).updateGeofences((List<Geofence>)object);
            }
        }
        return null;
    }

    private class c
    implements c.a {
        private c() {
        }

        @Override
        public ContentProviderResult[] a(ArrayList<ContentProviderOperation> arrayList) throws OperationApplicationException {
            return A4SProvider.this.applyBatch(arrayList);
        }

        @Override
        public Uri a(Uri uri, ContentValues contentValues) {
            return A4SProvider.this.insert(uri, contentValues);
        }

        @Override
        public int a(Uri uri, ContentValues[] contentValuesArray) {
            return A4SProvider.this.bulkInsert(uri, contentValuesArray);
        }

        @Override
        public Cursor a(Uri uri, String[] stringArray, String string2, String[] stringArray2, String string3) {
            return A4SProvider.this.query(uri, stringArray, string2, stringArray2, string3);
        }

        @Override
        public int a(Uri uri, ContentValues contentValues, String string2, String[] stringArray) {
            return A4SProvider.this.update(uri, contentValues, string2, stringArray);
        }

        @Override
        public int a(Uri uri, String string2, String[] stringArray) {
            return A4SProvider.this.delete(uri, string2, stringArray);
        }
    }

    private class b
    extends com.ad4screen.sdk.provider.b {
        public b(c.a a2) {
            super(a2, A4SProvider.this.getContext());
        }

        @Override
        public void updateBeacons(List<Beacon> list) {
            int n2;
            int n3;
            int n4;
            SQLiteDatabase sQLiteDatabase;
            block17: {
                ArrayList<Beacon> arrayList;
                sQLiteDatabase = A4SProvider.this.a();
                if (sQLiteDatabase == null) {
                    return;
                }
                n4 = 0;
                n3 = 0;
                n2 = 0;
                ArrayList<Beacon> arrayList2 = arrayList;
                arrayList = new ArrayList<Beacon>();
                sQLiteDatabase.beginTransaction();
                Iterator<Beacon> iterator = list.iterator();
                while (true) {
                    Beacon beacon;
                    block16: {
                        block15: {
                            if (!iterator.hasNext()) break;
                            beacon = iterator.next();
                            beacon.setRowId(this.hasBeacon(beacon.getId()));
                            if (beacon.getRowId() >= 0L) break block15;
                            if (beacon.isNeedToBeRemoved()) continue;
                            arrayList2.add(beacon);
                            continue;
                        }
                        if (!beacon.isNeedToBeRemoved()) break block16;
                        n2 += this.deleteBeacon(beacon);
                        continue;
                    }
                    n3 += this.updateBeacon(beacon, true, true);
                    continue;
                    break;
                }
                try {
                    if (arrayList2.size() <= 0) break block17;
                }
                catch (Throwable throwable) {
                    sQLiteDatabase.endTransaction();
                    throw throwable;
                }
                n4 = this.insertBeacons(arrayList2);
            }
            SQLiteDatabase sQLiteDatabase2 = sQLiteDatabase;
            sQLiteDatabase2.setTransactionSuccessful();
            Log.debug("A4SProvider|updateBeacons inserted: " + n4 + ", updated: " + n3 + ", deleted: " + n2);
            sQLiteDatabase2.endTransaction();
        }
    }

    private class d
    extends e {
        public d(c.a a2) {
            super(a2, A4SProvider.this.getContext());
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void updateGeofences(List<Geofence> var1_1) {
            block28: {
                block25: {
                    block24: {
                        var2_2 = A4SProvider.a(A4SProvider.this);
                        if (var2_2 == null) {
                            return;
                        }
                        var3_3 = 0;
                        var4_4 = 0;
                        var5_5 = 0;
                        var6_6 = v0;
                        v0 = new ArrayList<Geofence>();
                        var2_2.beginTransaction();
                        if (this.getGeofencesCount() != 0) break block24;
                        var1_1 = var1_1.iterator();
                        while (true) {
                            ** if (!var1_1.hasNext()) goto lbl-1000
lbl-1000:
                            // 1 sources

                            {
                                var7_7 = var1_1.next();
                                if (var7_7.isNeedToBeRemoved()) continue;
                                var6_6.add(var7_7);
                                continue;
                            }
lbl-1000:
                            // 1 sources

                            {
                                break block25;
                            }
                            break;
                        }
                    }
                    var1_1 = var1_1.iterator();
                    while (true) {
                        block27: {
                            block26: {
                                if (!var1_1.hasNext()) break;
                                v1 = this;
                                var7_8 = var1_1.next();
                                var8_9 = v1.hasGeofence(var7_8.getId());
                                var7_8.setRowId(var8_9);
                                if (var8_9 >= 0L) break block26;
                                if (var7_8.isNeedToBeRemoved()) continue;
                                var6_6.add(var7_8);
                                continue;
                            }
                            if (!var7_8.isNeedToBeRemoved()) break block27;
                            var5_5 += this.deleteGeofence(var7_8);
                            continue;
                        }
                        var4_4 += this.updateGeofence(var7_8, true, true);
                        continue;
                        break;
                    }
                }
                try {
                    if (var6_6.size() <= 0) break block28;
                }
                catch (Throwable v2) {
                    var2_2.endTransaction();
                    throw v2;
                }
                var3_3 = this.insertGeofences(var6_6);
            }
            v3 = var2_2;
            v3.setTransactionSuccessful();
            Log.debug("A4SProvider|updateGeofences inserted: " + var3_3 + ", updated: " + var4_4 + ", deleted: " + var5_5);
            v3.endTransaction();
        }
    }
}

