/*
 * Decompiled with CFR 0.152.
 */
package com.ad4screen.sdk.plugins.model;

import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import com.ad4screen.sdk.common.annotations.API;
import com.ad4screen.sdk.common.n.c;
import com.ad4screen.sdk.common.n.d;
import com.ad4screen.sdk.model.displayformats.Format;
import com.ad4screen.sdk.provider.A4SGeofenceResolver;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@API
public class Geofence
implements Comparable<Geofence>,
d,
c<Geofence>,
Parcelable {
    public static final String KEY_NAME = "name";
    public static final String KEY_TARGET_LATITUDE = "targetLat";
    public static final String KEY_TARGET_LONGITUDE = "targetLong";
    public static final String KEY_CUSTOM_PARAMS = "data";
    public static final String KEY_GROUPS = "groups";
    public static final String KEY_EXTERNAL_ID = "externalId";
    public static int GEOFENCE_TRANSITION_ENTER = 1;
    public static int GEOFENCE_TRANSITION_EXIT = 2;
    public static int GEOFENCE_TRANSITION_DWELL = 4;
    private static final String CLASS_KEY = "com.ad4screen.sdk.plugins.model.Geofence";
    public static final Parcelable.Creator<Geofence> CREATOR = new Parcelable.Creator<Geofence>(){

        public Geofence createFromParcel(Parcel parcel) {
            return new Geofence(parcel);
        }

        public Geofence[] newArray(int n2) {
            return new Geofence[n2];
        }
    };
    public long mRowId;
    private String mId;
    private String mExternalId;
    private String mName;
    private double mLatitude;
    private double mLongitude;
    private float mRadius;
    private boolean mIsNeedToBeRemoved;
    private Date mDetectedTime;
    private Date mNotifiedTime;
    private int mDetectedCount;
    private double mDeviceLatitude;
    private double mDeviceLongitude;
    private double mDistance;
    private String mLastTransition;
    private Map<String, String> mCustomParams;
    private Set<String> mGroups;

    public Geofence(String string2) {
        Geofence geofence = this;
        this.mRowId = -1L;
        this.mIsNeedToBeRemoved = false;
        this.mDetectedTime = new Date(0L);
        this.mNotifiedTime = new Date(0L);
        this.mDetectedCount = 0;
        this.mDeviceLatitude = 0.0;
        this.mDeviceLongitude = 0.0;
        this.mDistance = 0.0;
        this.mCustomParams = new HashMap<String, String>();
        this.mGroups = new HashSet<String>();
        geofence.mId = string2;
        geofence.mExternalId = "";
    }

    protected Geofence(Parcel parcel) {
        String string2;
        int n2;
        this.mRowId = -1L;
        this.mIsNeedToBeRemoved = false;
        this.mDetectedTime = new Date(0L);
        this.mNotifiedTime = new Date(0L);
        this.mDetectedCount = 0;
        this.mDeviceLatitude = 0.0;
        this.mDeviceLongitude = 0.0;
        this.mDistance = 0.0;
        this.mCustomParams = new HashMap<String, String>();
        this.mGroups = new HashSet<String>();
        this.mId = parcel.readString();
        this.mRowId = parcel.readLong();
        this.mExternalId = parcel.readString();
        this.mLatitude = parcel.readDouble();
        this.mLongitude = parcel.readDouble();
        this.mRadius = parcel.readFloat();
        int n3 = parcel.readInt() != 0 ? 1 : 0;
        this.mIsNeedToBeRemoved = n3;
        this.mDeviceLatitude = parcel.readDouble();
        this.mDeviceLongitude = parcel.readDouble();
        this.mDistance = parcel.readDouble();
        this.mName = parcel.readString();
        this.mDetectedCount = parcel.readInt();
        n3 = parcel.readInt();
        this.mCustomParams = new HashMap<String, String>(n3);
        for (n2 = 0; n2 < n3; ++n2) {
            Parcel parcel2 = parcel;
            string2 = parcel2.readString();
            String string3 = parcel2.readString();
            this.mCustomParams.put(string2, string3);
        }
        n3 = parcel.readInt();
        this.mGroups = new HashSet<String>(n3);
        for (n2 = 0; n2 < n3; ++n2) {
            string2 = parcel.readString();
            this.mGroups.add(string2);
        }
        this.mLastTransition = parcel.readString();
    }

    public long getRowId() {
        return this.mRowId;
    }

    public void setRowId(long l2) {
        this.mRowId = l2;
    }

    public String getId() {
        return this.mId;
    }

    public void setExternalId(String string2) {
        this.mExternalId = string2;
    }

    public String getExternalId() {
        return this.mExternalId;
    }

    public String getName() {
        return this.mName;
    }

    public void setName(String string2) {
        this.mName = string2;
    }

    public double getLatitude() {
        return this.mLatitude;
    }

    public void setLatitude(double d2) {
        this.mLatitude = d2;
    }

    public double getLongitude() {
        return this.mLongitude;
    }

    public void setLongitude(double d2) {
        this.mLongitude = d2;
    }

    public float getRadius() {
        return this.mRadius;
    }

    public void setRadius(float f2) {
        this.mRadius = f2;
    }

    public boolean isNeedToBeRemoved() {
        return this.mIsNeedToBeRemoved;
    }

    public void setNeedToBeRemoved(boolean bl) {
        this.mIsNeedToBeRemoved = bl;
    }

    public Date getDetectedTime() {
        return new Date(this.mDetectedTime.getTime());
    }

    public void setDetectedTime(Date date) {
        this.mDetectedTime = new Date(date.getTime());
    }

    public Date getNotifiedTime() {
        return new Date(this.mNotifiedTime.getTime());
    }

    public void setNotifiedTime(Date date) {
        this.mNotifiedTime = new Date(date.getTime());
    }

    public Map<String, String> getCustomParams() {
        return this.mCustomParams;
    }

    public double getDeviceLatitude() {
        return this.mDeviceLatitude;
    }

    public void setDeviceLatitude(double d2) {
        this.mDeviceLatitude = d2;
    }

    public double getDeviceLongitude() {
        return this.mDeviceLongitude;
    }

    public void setDeviceLongitude(double d2) {
        this.mDeviceLongitude = d2;
    }

    public double getDistance() {
        return this.mDistance;
    }

    public void setDistance(double d2) {
        this.mDistance = d2;
    }

    public void setCustomParams(Map<String, String> map) {
        this.mCustomParams = map;
    }

    public int getDetectedCount() {
        return this.mDetectedCount;
    }

    public void setDetectedCount(int n2) {
        this.mDetectedCount = n2;
    }

    public void parseCustomParams(JSONObject jSONObject) throws JSONException {
        jSONObject = jSONObject.getJSONObject(KEY_CUSTOM_PARAMS);
        Iterator iterator = jSONObject.keys();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            String string3 = jSONObject.getString(string2);
            if (!this.mCustomParams.containsKey(string2)) {
                this.mCustomParams.put(string2, string3);
                continue;
            }
            throw new JSONException(string2 + " already exists beacon: " + this.mId);
        }
    }

    public Set<String> getGroups() {
        return this.mGroups;
    }

    public void setGroups(Set<String> set) {
        this.mGroups = set;
    }

    public void parseGroups(JSONObject jSONObject) throws JSONException {
        jSONObject = jSONObject.getJSONArray(KEY_GROUPS);
        for (int i2 = 0; i2 < jSONObject.length(); ++i2) {
            String string2 = jSONObject.getString(i2);
            this.mGroups.add(string2);
        }
    }

    @Override
    public int compareTo(Geofence geofence) {
        return (int)(this.mDistance - geofence.getDistance());
    }

    @Override
    public Geofence fromJSON(String object) throws JSONException {
        Geofence geofence;
        JSONObject jSONObject;
        Geofence geofence2 = jSONObject;
        jSONObject = new JSONObject((String)object);
        object = geofence;
        ((Geofence)object)(geofence2.getString("id"));
        ((Geofence)object).setRowId(geofence2.getLong("rowId"));
        ((Geofence)object).setExternalId(geofence2.getString(KEY_EXTERNAL_ID));
        ((Geofence)object).setLatitude(geofence2.getDouble("latitude"));
        ((Geofence)object).setLongitude(geofence2.getDouble("longitude"));
        ((Geofence)object).setRadius((float)geofence2.getDouble("radius"));
        ((Geofence)object).setNeedToBeRemoved(geofence2.getBoolean("toRemove"));
        ((Geofence)object).setDeviceLatitude(geofence2.getDouble("device_latitude"));
        ((Geofence)object).setDeviceLongitude(geofence2.getDouble("device_longitude"));
        ((Geofence)object).setDistance(geofence2.getDouble("distance"));
        ((Geofence)object).setName(geofence2.getString(KEY_NAME));
        geofence.setDetectedCount(geofence2.getInt("detected_count"));
        if (!jSONObject.isNull(KEY_CUSTOM_PARAMS)) {
            ((Geofence)object).parseCustomParams((JSONObject)geofence2);
        }
        if (!geofence2.isNull(KEY_GROUPS)) {
            ((Geofence)object).parseGroups((JSONObject)geofence2);
        }
        Object object2 = object;
        ((Geofence)object2).setLastTransition(geofence2.getString("lastTransition"));
        return object2;
    }

    public String getClassKey() {
        return CLASS_KEY;
    }

    @Override
    public JSONObject toJSON() throws JSONException {
        JSONArray jSONArray;
        JSONObject jSONObject;
        JSONObject jSONObject2;
        JSONObject jSONObject3 = jSONObject2;
        jSONObject3();
        jSONObject3.put("id", (Object)this.mId);
        long l2 = this.mRowId;
        jSONObject3.put("rowId", l2);
        jSONObject3.put(KEY_EXTERNAL_ID, (Object)this.mExternalId);
        double d2 = this.mLatitude;
        jSONObject3.put("latitude", d2);
        d2 = this.mLongitude;
        jSONObject3.put("longitude", d2);
        d2 = this.mRadius;
        jSONObject3.put("radius", d2);
        jSONObject3.put("toRemove", this.mIsNeedToBeRemoved);
        d2 = this.mDeviceLatitude;
        jSONObject3.put("device_latitude", d2);
        d2 = this.mDeviceLongitude;
        jSONObject3.put("device_longitude", d2);
        d2 = this.mDistance;
        jSONObject3.put("distance", d2);
        jSONObject3.put(KEY_NAME, (Object)this.mName);
        jSONObject2.put("detected_count", this.mDetectedCount);
        JSONObject jSONObject4 = jSONObject;
        jSONObject = new JSONObject();
        for (Map.Entry<String, String> entry : this.mCustomParams.entrySet()) {
            jSONObject4.put(entry.getKey(), (Object)entry.getValue());
        }
        jSONObject3.put(KEY_CUSTOM_PARAMS, (Object)jSONObject4);
        jSONObject4 = jSONArray;
        jSONArray = new JSONArray();
        Iterator<Object> iterator = this.mGroups.iterator();
        while (iterator.hasNext()) {
            jSONObject4.put((Object)((String)iterator.next()));
        }
        JSONObject jSONObject5 = jSONObject3;
        jSONObject3.put(KEY_GROUPS, (Object)jSONObject4);
        jSONObject5.put("lastTransition", (Object)this.mLastTransition);
        return jSONObject5;
    }

    public String toString() {
        return "Geofence: " + this.mId + ", " + this.mName + ", distance: " + this.mDistance + ", groups: " + this.mGroups.toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n2) {
        parcel.writeString(this.mId);
        parcel.writeLong(this.mRowId);
        parcel.writeString(this.mExternalId);
        parcel.writeDouble(this.mLatitude);
        parcel.writeDouble(this.mLongitude);
        parcel.writeFloat(this.mRadius);
        parcel.writeInt(this.mIsNeedToBeRemoved ? 1 : 0);
        parcel.writeDouble(this.mDeviceLatitude);
        parcel.writeDouble(this.mDeviceLongitude);
        parcel.writeDouble(this.mDistance);
        parcel.writeString(this.mName);
        parcel.writeInt(this.mDetectedCount);
        parcel.writeInt(this.mCustomParams.size());
        Iterator<Object> iterator = this.mCustomParams.entrySet().iterator();
        while (iterator.hasNext()) {
            Parcel parcel2 = parcel;
            Map.Entry<String, String> entry = iterator.next();
            parcel2.writeString(entry.getKey());
            parcel2.writeString(entry.getValue());
        }
        parcel.writeInt(this.mGroups.size());
        iterator = this.mGroups.iterator();
        while (iterator.hasNext()) {
            parcel.writeString((String)iterator.next());
        }
        parcel.writeString(this.mLastTransition);
    }

    public String getLastTransition() {
        return this.mLastTransition;
    }

    public void setLastTransition(String string2) {
        this.mLastTransition = string2;
    }

    public static class PersonalParamsReplacer
    implements Format.a {
        private Geofence mGeofence;

        public PersonalParamsReplacer(Context context, String string2) {
            this.mGeofence = new A4SGeofenceResolver(context).getGeofenceByClientId(string2);
        }

        @Override
        public void onPersonalParamFound(String string2, StringBuffer stringBuffer) {
            if (Geofence.KEY_NAME.equals(string2)) {
                stringBuffer.append(this.mGeofence.getName());
            } else if (Geofence.KEY_TARGET_LATITUDE.equals(string2)) {
                stringBuffer.append(String.valueOf(this.mGeofence.getLatitude()));
            } else if (Geofence.KEY_TARGET_LONGITUDE.equals(string2)) {
                stringBuffer.append(String.valueOf(this.mGeofence.getLongitude()));
            } else if (this.mGeofence.getCustomParams().containsKey(string2)) {
                stringBuffer.append(this.mGeofence.getCustomParams().get(string2));
            }
        }
    }
}

