/*
 * Decompiled with CFR 0.152.
 */
package com.ad4screen.sdk.plugins.beacons;

import android.app.ActivityManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.ResolveInfo;
import android.os.IBinder;
import android.os.IInterface;
import com.ad4screen.sdk.Log;
import com.ad4screen.sdk.plugins.beacons.BeaconProviderCallback;
import com.ad4screen.sdk.plugins.beacons.IBeaconServiceConnection;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BindBeaconProvider<T extends IInterface> {
    private static final String TAG = "BindBeaconService";
    private final Context mContext;
    private final Intent mIntent;
    private final Class<T> mParameterType;
    private final BeaconProviderCallback<T> mCallback;
    private List<IBeaconServiceConnection<T>> mProvidersConnections;
    private List<T> mProviders;
    private int mMax;

    public BindBeaconProvider(Context context, String string2, String string3, Class<T> clazz, BeaconProviderCallback<T> beaconProviderCallback) {
        BindBeaconProvider bindBeaconProvider = this;
        this.mProvidersConnections = new ArrayList<IBeaconServiceConnection<T>>();
        this.mProviders = new ArrayList<T>();
        bindBeaconProvider.mContext = context;
        bindBeaconProvider.mIntent = new Intent(string2);
        if (string3 != null) {
            this.mIntent.addCategory(string3);
        }
        this.mParameterType = clazz;
        this.mCallback = beaconProviderCallback;
    }

    private boolean isServiceRunning(String string2, String string3) {
        for (ActivityManager.RunningServiceInfo runningServiceInfo : ((ActivityManager)((BindBeaconProvider)this).mContext.getSystemService("activity")).getRunningServices(Integer.MAX_VALUE)) {
            if (!string2.equals(runningServiceInfo.service.getClassName()) || !string3.equals(runningServiceInfo.service.getPackageName())) continue;
            Log.info("BindBeaconService|" + string2 + " running");
            return true;
        }
        Log.info("BindBeaconService|" + string2 + " not running");
        return false;
    }

    private List<ResolveInfo> getServicesForIntent(Intent intent) {
        return this.mContext.getPackageManager().queryIntentServices(intent, 0);
    }

    private void onFinishToBind() {
        Log.info("BindBeaconService|onFinishToBind with " + this.mProvidersConnections.size() + " items");
        BeaconProviderCallback<T> beaconProviderCallback = this.mProvidersConnections.iterator();
        while (beaconProviderCallback.hasNext()) {
            IInterface iInterface = (IInterface)beaconProviderCallback.next().getProvider();
            if (iInterface == null) continue;
            this.mProviders.add(iInterface);
        }
        beaconProviderCallback = this.mCallback;
        if (beaconProviderCallback != null) {
            beaconProviderCallback.onProvidersBinded(this.mProviders);
        }
    }

    private void onProviderDisconnected(T t2) {
        this.mProviders.remove(t2);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void connectToFirstRunningService() {
        v0 = this;
        var1_1 = Collections.synchronizedList(new ArrayList<E>());
        var2_2 = v0.getServicesForIntent(v0.mIntent).iterator();
        while (var2_2.hasNext()) {
            var3_3 = var2_2.next();
            var4_4 /* !! */  = var3_3.serviceInfo;
            if (var4_4 /* !! */  == null || !this.isServiceRunning(var4_4 /* !! */ .name, var4_4 /* !! */ .packageName)) continue;
            Log.info("BindBeaconService|Service found " + var3_3);
            var5_6 = v1;
            var5_6(this.mIntent);
            v1.setClassName(var4_4 /* !! */ .packageName, var4_4 /* !! */ .name);
            var4_4 /* !! */  = v2;
            v2 = new BeaconServiceConnection(var1_1);
            Log.info("BindBeaconService|Binding...");
            if (!this.mContext.bindService(var5_6, (ServiceConnection)var4_4 /* !! */ , 1)) ** GOTO lbl24
            var1_1.add(var4_4 /* !! */ );
            try {
                Log.info("BindBeaconService|Bind OK !");
                continue;
lbl24:
                // 1 sources

                Log.error("BindBeaconService|Impossible to bind to service " + var3_3);
            }
            catch (SecurityException var4_5) {
                Log.warn("BindBeaconService|Impossible to bind to '" + var3_3.serviceInfo.name + "' in app '" + var3_3.serviceInfo.applicationInfo.packageName + "'", var4_5);
            }
        }
        this.mMax = var1_1.size();
        if (this.mMax == 0 && (var2_2 = this.mCallback) != null) {
            var2_2.onProvidersBinded(this.mProviders);
        }
        this.mProvidersConnections = var1_1;
    }

    public List<T> getProviders() {
        return this.mProviders;
    }

    public void closeConnections() {
        Log.info("BindBeaconService|Clear " + this.mProvidersConnections.size() + " binded interface");
        for (IBeaconServiceConnection<T> iBeaconServiceConnection : this.mProvidersConnections) {
            this.mContext.unbindService(iBeaconServiceConnection);
        }
        BindBeaconProvider bindBeaconProvider = this;
        bindBeaconProvider.mProvidersConnections.clear();
        bindBeaconProvider.mProviders.clear();
        bindBeaconProvider.mMax = 0;
    }

    private final class BeaconServiceConnection
    implements IBeaconServiceConnection<T> {
        private List<IBeaconServiceConnection<T>> mProvidersConnection;
        private T mProvider;

        private BeaconServiceConnection(List<IBeaconServiceConnection<T>> list) {
            this.mProvidersConnection = list;
        }

        public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            BeaconServiceConnection beaconServiceConnection = this;
            Log.debug("BindBeaconService|onServiceConnected " + componentName);
            Class<?> clazz = Class.forName(BindBeaconProvider.this.mParameterType.getName() + "$Stub");
            Class[] classArray = new Class[1];
            classArray[0] = IBinder.class;
            Method method = clazz.getMethod("asInterface", classArray);
            try {
                beaconServiceConnection.mProvider = (IInterface)method.invoke(null, iBinder);
            }
            catch (Exception exception) {
                Log.error("BindBeaconService|Ignore provider. Invalid type " + BindBeaconProvider.this.mParameterType.getName() + " in " + BeaconServiceConnection.class, exception);
            }
            BeaconServiceConnection beaconServiceConnection2 = this;
            beaconServiceConnection2.BindBeaconProvider.this.mMax--;
            if (beaconServiceConnection2.BindBeaconProvider.this.mMax == 0) {
                BindBeaconProvider.this.onFinishToBind();
            }
        }

        public void onServiceDisconnected(ComponentName componentName) {
            BeaconServiceConnection beaconServiceConnection = this;
            Log.debug("BindBeaconService|onServiceDisconnected");
            beaconServiceConnection.mProvidersConnection.remove(this);
            beaconServiceConnection.BindBeaconProvider.this.onProviderDisconnected(this.mProvider);
            beaconServiceConnection.mProvider = null;
        }

        @Override
        public T getProvider() {
            return this.mProvider;
        }
    }
}

