/*
 * Decompiled with CFR 0.152.
 */
package com.ad4screen.sdk.service.modules.e;

import com.ad4screen.sdk.Log;
import com.ad4screen.sdk.common.h;
import com.ad4screen.sdk.plugins.model.Geofence;
import com.ad4screen.sdk.service.modules.e.a;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class c {
    public void a(JSONObject jSONObject, a a2) {
        try {
            JSONObject jSONObject2 = jSONObject.getJSONObject("geofences");
            a2.a(h.a(jSONObject2.getString("date"), h.a.b));
            a2.a(jSONObject2.getBoolean("nearestCalculated"));
            a2.b(jSONObject2.getBoolean("differentialUpdate"));
            this.a(jSONObject2.getJSONArray("points"), a2);
        }
        catch (JSONException jSONException) {
            Log.internal("GeofencingResponseParser|Error during Geofences parsing", jSONException);
        }
    }

    private void a(JSONArray jSONArray, a a2) throws JSONException {
        Map<String, Geofence> map = a2.a();
        for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
            try {
                Geofence geofence = this.a(jSONArray.getJSONObject(i2));
                if (!this.a(geofence)) continue;
                map.put(geofence.getId(), geofence);
                continue;
            }
            catch (JSONException jSONException) {
                Log.internal("GeofencingResponseParser|Geofence " + jSONArray.getJSONObject(i2) + " parse error: ", jSONException);
            }
        }
    }

    private boolean a(Geofence geofence) {
        if ((double)geofence.getRadius() <= 0.0) {
            Log.warn("GeofencingResponseParser|parseGeofences|geofence has unsupported radius '" + geofence.getRadius() + "' and will be ignored");
            return false;
        }
        if (geofence.getLatitude() > 90.0 || geofence.getLatitude() < -90.0) {
            Log.warn("GeofencingResponseParser|parseGeofences|geofence has unsupported latitude '" + geofence.getLatitude() + "' and will be ignored");
            return false;
        }
        if (geofence.getLongitude() > 180.0 || geofence.getLongitude() < -180.0) {
            Log.warn("GeofencingResponseParser|parseGeofences|geofence has unsupported longitude '" + geofence.getLongitude() + "' and will be ignored");
            return false;
        }
        return true;
    }

    private Geofence a(JSONObject jSONObject) throws JSONException {
        Geofence geofence = new Geofence(jSONObject.getString("id"));
        geofence.setNeedToBeRemoved(jSONObject.getString("action").equalsIgnoreCase("delete"));
        if (!jSONObject.isNull("name")) {
            geofence.setName(jSONObject.getString("name"));
        }
        if (!jSONObject.isNull("lat")) {
            geofence.setLatitude(jSONObject.getDouble("lat"));
        }
        if (!jSONObject.isNull("lon")) {
            geofence.setLongitude(jSONObject.getDouble("lon"));
        }
        if (!jSONObject.isNull("radius")) {
            geofence.setRadius(jSONObject.getInt("radius"));
        }
        if (!jSONObject.isNull("data")) {
            geofence.parseCustomParams(jSONObject);
        }
        if (!jSONObject.isNull("groups")) {
            geofence.parseGroups(jSONObject);
        }
        if (!jSONObject.isNull("externalId")) {
            geofence.setExternalId(jSONObject.getString("externalId"));
        }
        return geofence;
    }
}

