/*
 * Decompiled with CFR 0.152.
 */
package com.ad4screen.sdk.provider;

import android.content.ContentProviderOperation;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import com.ad4screen.sdk.Log;
import com.ad4screen.sdk.contract.A4SContract;
import com.ad4screen.sdk.plugins.model.Beacon;
import com.ad4screen.sdk.provider.c;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class b
extends c {
    public b(c.a a2, Context context) {
        super(a2, context);
    }

    public long hasBeacon(String string2) {
        long l2 = -1L;
        String[] stringArray = new String[]{"_id"};
        String string3 = "server_id=?";
        String[] stringArray2 = new String[]{string2};
        Cursor cursor = this.mAcc.a(A4SContract.Beacons.getContentUri(this.mContext), stringArray, string3, stringArray2, null);
        if (cursor != null) {
            if (cursor.getCount() > 0) {
                cursor.moveToFirst();
                l2 = cursor.getLong(0);
            }
            cursor.close();
        }
        return l2;
    }

    private long getBeaconId(Beacon beacon) {
        long l2 = -1L;
        String[] stringArray = new String[]{"_id"};
        String string2 = "server_id=? AND uuid=? AND major=? AND minor=?";
        String[] stringArray2 = new String[]{beacon.id, beacon.uuid, String.valueOf(beacon.major), String.valueOf(beacon.minor)};
        Cursor cursor = this.mAcc.a(A4SContract.Beacons.getContentUri(this.mContext), stringArray, string2, stringArray2, null);
        if (cursor != null) {
            int n2 = cursor.getCount();
            if (n2 > 0) {
                cursor.moveToFirst();
                l2 = cursor.getLong(0);
                if (n2 > 1) {
                    Log.warn("BeaconHelper|getBeaconId|there are " + n2 + " instances of " + beacon);
                }
            }
            cursor.close();
        }
        return l2;
    }

    public long hasBeaconGroup(String string2) {
        long l2 = -1L;
        String[] stringArray = new String[]{"_id"};
        String string3 = "server_id=?";
        String[] stringArray2 = new String[]{string2};
        Cursor cursor = this.mAcc.a(A4SContract.BeaconGeofenceGroups.getContentUri(this.mContext), stringArray, string3, stringArray2, null);
        if (cursor != null) {
            if (cursor.getCount() > 0) {
                cursor.moveToFirst();
                l2 = cursor.getLong(0);
            }
            cursor.close();
        }
        return l2;
    }

    public int getBeaconsCount() {
        int n2 = -1;
        String[] stringArray = new String[]{"_id"};
        Cursor cursor = this.mAcc.a(A4SContract.Beacons.getContentUri(this.mContext), stringArray, null, null, null);
        if (cursor != null) {
            n2 = cursor.getCount();
            cursor.close();
        }
        return n2;
    }

    public List<Beacon> getAllBeacons() {
        return this.getAllBeacons(null, null);
    }

    public List<Beacon> getAllBeacons(String string2, String[] stringArray) {
        ArrayList<Beacon> arrayList = null;
        String[] stringArray2 = new String[]{"_id", "server_id", "external_id", "name", "uuid", "major", "minor", "detected_time", "notified_time"};
        Cursor cursor = this.mAcc.a(A4SContract.Beacons.getContentUri(this.mContext), stringArray2, string2, stringArray, null);
        if (cursor != null) {
            if (cursor.moveToFirst()) {
                arrayList = new ArrayList<Beacon>(cursor.getCount());
                do {
                    Beacon beacon = new Beacon();
                    beacon.rowId = cursor.getLong(0);
                    beacon.id = cursor.getString(1);
                    beacon.externalId = cursor.getString(2);
                    beacon.name = cursor.getString(3);
                    beacon.uuid = cursor.getString(4);
                    beacon.major = cursor.getInt(5);
                    beacon.minor = cursor.getInt(6);
                    beacon.setDetectedTime(b.convertStringToDate(cursor.getString(7)));
                    beacon.setNotifiedTime(b.convertStringToDate(cursor.getString(8)));
                    this.fillBeaconParams(beacon);
                    this.fillBeaconGroups(beacon);
                    arrayList.add(beacon);
                } while (cursor.moveToNext());
            }
            cursor.close();
        }
        return arrayList;
    }

    public List<Beacon> getBeaconsFilteredByGroups(String string2, String[] stringArray) {
        HashMap<String, Beacon> hashMap = new HashMap<String, Beacon>();
        String[] stringArray2 = new String[]{"beacons._id", "beacons.server_id", "beacons.external_id", "beacons.name", "beacons.uuid", "beacons.major", "beacons.minor", "beacons.detected_time", "beacons.notified_time"};
        Cursor cursor = this.mAcc.a(A4SContract.Beacons.getGroupsContentFilterUri(this.mContext), stringArray2, string2, stringArray, null);
        if (cursor != null && cursor.moveToFirst()) {
            do {
                long l2 = cursor.getLong(0);
                String string3 = cursor.getString(1);
                if (hashMap.containsKey(string3)) continue;
                Beacon beacon = new Beacon();
                beacon.id = string3;
                beacon.rowId = l2;
                beacon.externalId = cursor.getString(2);
                beacon.name = cursor.getString(3);
                beacon.uuid = cursor.getString(4);
                beacon.major = cursor.getInt(5);
                beacon.minor = cursor.getInt(6);
                beacon.setDetectedTime(b.convertStringToDate(cursor.getString(7)));
                beacon.setNotifiedTime(b.convertStringToDate(cursor.getString(8)));
                this.fillBeaconParams(beacon);
                this.fillBeaconGroups(beacon);
                hashMap.put(string3, beacon);
            } while (cursor.moveToNext());
            cursor.close();
        }
        if (hashMap.size() == 0) {
            return null;
        }
        return new ArrayList<Beacon>(hashMap.values());
    }

    public Beacon getBeaconByClientId(String string2) {
        Beacon beacon = null;
        String[] stringArray = new String[]{"_id", "server_id", "external_id", "name", "uuid", "major", "minor", "detected_time", "notified_time"};
        String string3 = "server_id=?";
        String[] stringArray2 = new String[]{string2};
        Cursor cursor = this.mAcc.a(A4SContract.Beacons.getContentUri(this.mContext), stringArray, string3, stringArray2, null);
        if (cursor != null) {
            if (cursor.getCount() > 0) {
                cursor.moveToFirst();
                beacon = new Beacon();
                beacon.rowId = cursor.getLong(0);
                beacon.id = cursor.getString(1);
                beacon.externalId = cursor.getString(2);
                beacon.name = cursor.getString(3);
                beacon.uuid = cursor.getString(4);
                beacon.major = cursor.getInt(5);
                beacon.minor = cursor.getInt(6);
                beacon.setDetectedTime(b.convertStringToDate(cursor.getString(7)));
                beacon.setNotifiedTime(b.convertStringToDate(cursor.getString(8)));
                this.fillBeaconParams(beacon);
                this.fillBeaconGroups(beacon);
            }
            cursor.close();
        }
        return beacon;
    }

    public Beacon getBeacon(String string2, String[] stringArray) {
        Beacon beacon = null;
        String[] stringArray2 = new String[]{"_id", "server_id", "external_id", "name", "uuid", "major", "minor", "detected_time", "notified_time"};
        Cursor cursor = this.mAcc.a(A4SContract.Beacons.getContentUri(this.mContext), stringArray2, string2, stringArray, null);
        if (cursor != null) {
            if (cursor.getCount() > 0) {
                cursor.moveToFirst();
                beacon = new Beacon();
                beacon.rowId = cursor.getLong(0);
                beacon.id = cursor.getString(1);
                beacon.externalId = cursor.getString(2);
                beacon.name = cursor.getString(3);
                beacon.uuid = cursor.getString(4);
                beacon.major = cursor.getInt(5);
                beacon.minor = cursor.getInt(6);
                beacon.setDetectedTime(b.convertStringToDate(cursor.getString(7)));
                beacon.setNotifiedTime(b.convertStringToDate(cursor.getString(8)));
                this.fillBeaconParams(beacon);
            }
            cursor.close();
        }
        return beacon;
    }

    public void fillBeaconParams(Beacon beacon) {
        String[] stringArray = new String[]{"param_key", "param_value"};
        String string2 = "beacon_id=?";
        String[] stringArray2 = new String[]{Long.toString(beacon.rowId)};
        Cursor cursor = this.mAcc.a(A4SContract.BeaconParams.getContentUri(this.mContext), stringArray, string2, stringArray2, null);
        if (cursor != null) {
            if (cursor.moveToFirst()) {
                HashMap<String, String> hashMap = new HashMap<String, String>(cursor.getCount());
                do {
                    String string3 = cursor.getString(0);
                    String string4 = cursor.getString(1);
                    hashMap.put(string3, string4);
                } while (cursor.moveToNext());
                beacon.customs = hashMap;
            }
            cursor.close();
        }
    }

    public void fillBeaconGroups(Beacon beacon) {
        String[] stringArray = new String[]{"server_id"};
        String string2 = "beacon_id=?";
        String[] stringArray2 = new String[]{Long.toString(beacon.rowId)};
        Cursor cursor = this.mAcc.a(A4SContract.BeaconGeofenceGroups.getBeaconsContentFilterUri(this.mContext), stringArray, string2, stringArray2, null);
        if (cursor != null) {
            if (cursor.moveToFirst()) {
                HashSet<String> hashSet = new HashSet<String>(cursor.getCount());
                do {
                    String string3 = cursor.getString(0);
                    hashSet.add(string3);
                } while (cursor.moveToNext());
                beacon.setGroups(hashSet);
            }
            cursor.close();
        }
    }

    public long insertBeacon(Beacon beacon) {
        long l2;
        ContentValues contentValues = new ContentValues();
        contentValues.put("server_id", beacon.id);
        contentValues.put("external_id", beacon.externalId);
        contentValues.put("name", beacon.name);
        contentValues.put("uuid", beacon.uuid);
        contentValues.put("major", Integer.valueOf(beacon.major));
        contentValues.put("minor", Integer.valueOf(beacon.minor));
        contentValues.put("detected_time", b.convertDateToString(beacon.getDetectedTime()));
        contentValues.put("notified_time", b.convertDateToString(beacon.getNotifiedTime()));
        Uri uri = this.mAcc.a(A4SContract.Beacons.getContentUri(this.mContext), contentValues);
        if (uri == null) {
            return -1L;
        }
        beacon.rowId = l2 = Long.valueOf((String)uri.getPathSegments().get(1)).longValue();
        if (beacon.customs.size() > 0) {
            this.insertBeaconParams(l2, beacon.customs);
        }
        if (beacon.getGroups().size() > 0) {
            this.insertBeaconGroups(l2, beacon.getGroups());
        }
        return l2;
    }

    public void insertBeaconParams(long l2, Map<String, String> map) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            ContentValues contentValues = new ContentValues();
            contentValues.put("beacon_id", Long.valueOf(l2));
            contentValues.put("param_key", entry.getKey());
            contentValues.put("param_value", entry.getValue());
            this.mAcc.a(A4SContract.BeaconParams.getContentUri(this.mContext), contentValues);
        }
    }

    public void insertBeaconGroups(long l2, Set<String> set) {
        for (String string2 : set) {
            ContentValues contentValues;
            long l3 = this.hasBeaconGroup(string2);
            if (l3 < 0L) {
                contentValues = new ContentValues();
                contentValues.put("server_id", string2);
                Uri uri = this.mAcc.a(A4SContract.BeaconGeofenceGroups.getContentUri(this.mContext), contentValues);
                l3 = Long.valueOf((String)uri.getPathSegments().get(1));
            }
            contentValues = new ContentValues();
            contentValues.put("beacon_id", Long.valueOf(l2));
            contentValues.put("group_id", Long.valueOf(l3));
            this.mAcc.a(A4SContract.BeaconGroups.getContentUri(this.mContext), contentValues);
        }
    }

    public int insertBeacons(List<Beacon> list) {
        if (list == null || list.size() == 0) {
            Log.warn("A4SBeaconsResolver|bulkInsert no beacons");
            return 0;
        }
        int n2 = 0;
        ContentValues[] contentValuesArray = new ContentValues[list.size()];
        for (Beacon beacon : list) {
            ContentValues contentValues = new ContentValues();
            contentValues.put("server_id", beacon.id);
            contentValues.put("external_id", beacon.externalId);
            contentValues.put("name", beacon.name);
            contentValues.put("uuid", beacon.uuid);
            contentValues.put("major", Integer.valueOf(beacon.major));
            contentValues.put("minor", Integer.valueOf(beacon.minor));
            contentValues.put("detected_time", b.convertDateToString(beacon.getDetectedTime()));
            contentValues.put("notified_time", b.convertDateToString(beacon.getNotifiedTime()));
            contentValuesArray[n2++] = contentValues;
        }
        int n3 = this.mAcc.a(A4SContract.Beacons.getContentUri(this.mContext), contentValuesArray);
        if (n3 != n2) {
            Log.error("A4SBeaconResolver|bulkInsert hasn't inserted all beacons, needed=" + n2 + ", inserted=" + n3);
            return n3;
        }
        long l2 = this.hasBeacon(list.get((int)0).id);
        if (l2 < 0L) {
            Log.error("A4SBeaconResolver|bulkInsert an ID of the first inserted beacon is not found");
            return n3;
        }
        ArrayList<ContentValues> arrayList = new ArrayList<ContentValues>();
        ArrayList<ContentValues> arrayList2 = new ArrayList<ContentValues>();
        for (Beacon beacon : list) {
            ContentValues contentValues;
            if (beacon.customs.size() > 0) {
                for (Map.Entry entry : beacon.customs.entrySet()) {
                    contentValues = new ContentValues();
                    contentValues.put("beacon_id", Long.valueOf(l2));
                    contentValues.put("param_key", (String)entry.getKey());
                    contentValues.put("param_value", (String)entry.getValue());
                    arrayList.add(contentValues);
                }
            }
            if (beacon.getGroups().size() > 0) {
                for (String string2 : beacon.getGroups()) {
                    contentValues = new ContentValues();
                    contentValues.put("beacon_id", Long.valueOf(l2));
                    contentValues.put("server_id", string2);
                    arrayList2.add(contentValues);
                }
            }
            ++l2;
        }
        if (arrayList.size() > 0) {
            contentValuesArray = new ContentValues[arrayList.size()];
            this.mAcc.a(A4SContract.BeaconParams.getContentUri(this.mContext), arrayList.toArray(contentValuesArray));
        }
        if (arrayList2.size() > 0) {
            contentValuesArray = new ContentValues[arrayList2.size()];
            this.mAcc.a(A4SContract.BeaconGroups.getCustomContentUri(this.mContext), arrayList2.toArray(contentValuesArray));
        }
        return n3;
    }

    public int updateBeacon(Beacon beacon) {
        String[] stringArray;
        String string2;
        if (beacon.rowId > 0L) {
            string2 = "_id=?";
            stringArray = new String[]{String.valueOf(beacon.rowId)};
        } else {
            string2 = "server_id=?";
            stringArray = new String[]{beacon.id};
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("external_id", beacon.externalId);
        contentValues.put("name", beacon.name);
        contentValues.put("uuid", beacon.uuid);
        contentValues.put("major", Integer.valueOf(beacon.major));
        contentValues.put("minor", Integer.valueOf(beacon.minor));
        contentValues.put("detected_time", b.convertDateToString(beacon.getDetectedTime()));
        contentValues.put("notified_time", b.convertDateToString(beacon.getNotifiedTime()));
        int n2 = this.mAcc.a(A4SContract.Beacons.getContentUri(this.mContext), contentValues, string2, stringArray);
        long l2 = beacon.rowId = this.getBeaconId(beacon);
        this.updateBeaconParams(l2, beacon.customs);
        this.updateBeaconGroups(l2, beacon.getGroups());
        return n2;
    }

    public void updateBeaconParams(long l2, Map<String, String> map) {
        HashMap<String, String> hashMap = new HashMap<String, String>(map);
        String[] stringArray = new String[]{"_id", "param_key"};
        String string2 = "beacon_id=?";
        String[] stringArray2 = new String[]{Long.toString(l2)};
        Cursor cursor = this.mAcc.a(A4SContract.BeaconParams.getContentUri(this.mContext), stringArray, string2, stringArray2, null);
        if (cursor != null) {
            if (cursor.moveToFirst()) {
                do {
                    int n2 = cursor.getInt(0);
                    Uri uri = Uri.withAppendedPath((Uri)A4SContract.BeaconParams.getContentUri(this.mContext), (String)("/" + n2));
                    String string3 = cursor.getString(1);
                    if (map.containsKey(string3)) {
                        ContentValues contentValues = new ContentValues();
                        contentValues.put("param_value", map.get(string3));
                        this.mAcc.a(uri, contentValues, null, null);
                        hashMap.remove(string3);
                        continue;
                    }
                    this.mAcc.a(uri, null, null);
                } while (cursor.moveToNext());
            }
            cursor.close();
        }
        if (hashMap.size() > 0) {
            this.insertBeaconParams(l2, hashMap);
        }
    }

    public void updateBeaconGroups(long l2, Set<String> set) {
        HashSet<String> hashSet = new HashSet<String>(set);
        String[] stringArray = new String[]{"beacon_geofence_groups._id", "server_id", "beacon_groups._id"};
        String string2 = "beacon_id=?";
        String[] stringArray2 = new String[]{Long.toString(l2)};
        Cursor cursor = this.mAcc.a(A4SContract.BeaconGeofenceGroups.getBeaconsContentFilterUri(this.mContext), stringArray, string2, stringArray2, null);
        if (cursor != null) {
            if (cursor.moveToFirst()) {
                do {
                    int n2 = cursor.getInt(0);
                    String string3 = cursor.getString(1);
                    int n3 = cursor.getInt(2);
                    if (set.contains(string3)) {
                        hashSet.remove(string3);
                        continue;
                    }
                    Uri uri = Uri.withAppendedPath((Uri)A4SContract.BeaconGeofenceGroups.getContentUri(this.mContext), (String)("/" + n2));
                    this.mAcc.a(uri, null, null);
                    uri = Uri.withAppendedPath((Uri)A4SContract.BeaconGroups.getContentUri(this.mContext), (String)("/" + n3));
                    this.mAcc.a(uri, null, null);
                } while (cursor.moveToNext());
            }
            cursor.close();
        }
        if (hashSet.size() > 0) {
            this.insertBeaconGroups(l2, hashSet);
        }
    }

    public void updateBeacons(List<Beacon> list) {
        for (Beacon beacon : list) {
            if (this.hasBeacon(beacon.id) < 0L) {
                if (beacon.isNeedToBeRemoved) continue;
                this.insertBeacon(beacon);
                continue;
            }
            if (beacon.isNeedToBeRemoved) {
                this.deleteBeacon(beacon);
                continue;
            }
            this.updateBeacon(beacon);
        }
    }

    public int deleteBeacon(Beacon beacon) {
        long l2 = beacon.rowId > 0L ? beacon.rowId : this.getBeaconId(beacon);
        Uri uri = Uri.withAppendedPath((Uri)A4SContract.Beacons.getContentUri(this.mContext), (String)String.valueOf(l2));
        int n2 = this.mAcc.a(uri, null, null);
        this.mAcc.a(A4SContract.BeaconParams.getContentUri(this.mContext), "beacon_id=" + l2, null);
        return n2;
    }

    public void deleteBeacons(List<Beacon> list) {
        ArrayList<ContentProviderOperation> arrayList = new ArrayList<ContentProviderOperation>(list.size());
        if (Build.VERSION.SDK_INT >= 5) {
            for (Beacon beacon : list) {
                arrayList.add(ContentProviderOperation.newDelete((Uri)A4SContract.Beacons.getContentUri(this.mContext)).withSelection("server_id=" + beacon.id, null).build());
            }
            try {
                this.mAcc.a(arrayList);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public int deleteAllBeacons() {
        int n2 = this.mAcc.a(A4SContract.Beacons.getContentUri(this.mContext), null, null);
        this.mAcc.a(A4SContract.BeaconParams.getContentUri(this.mContext), null, null);
        this.mAcc.a(A4SContract.BeaconGroups.getContentUri(this.mContext), null, null);
        return n2;
    }
}

