/*
 * Decompiled with CFR 0.152.
 */
package com.ad4screen.sdk.provider;

import android.content.ContentProvider;
import android.content.ContentProviderOperation;
import android.content.ContentProviderResult;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.content.OperationApplicationException;
import android.content.UriMatcher;
import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteQueryBuilder;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import com.ad4screen.sdk.Log;
import com.ad4screen.sdk.contract.A4SContract;
import com.ad4screen.sdk.plugins.model.Beacon;
import com.ad4screen.sdk.plugins.model.Geofence;
import com.ad4screen.sdk.provider.c;
import com.ad4screen.sdk.provider.e;
import java.util.ArrayList;
import java.util.List;

public class A4SProvider
extends ContentProvider {
    private static UriMatcher a = new UriMatcher(-1);
    private SQLiteDatabase b;
    private b c;
    private a d;
    private c e;

    public boolean onCreate() {
        try {
            return this.a();
        }
        catch (RuntimeException runtimeException) {
            Log.error("A4SProvider|Cannot start A4SProvider", runtimeException);
            return false;
        }
    }

    private boolean a() {
        Context context = this.getContext();
        this.a(context);
        com.ad4screen.sdk.provider.a a2 = com.ad4screen.sdk.provider.a.a(context);
        this.b = a2.getWritableDatabase();
        this.c = new b();
        this.d = new a(this.c);
        this.e = new c(this.c);
        return this.b != null;
    }

    private void a(Context context) {
        a = new UriMatcher(-1);
        a.addURI(A4SContract.getAuthority(context), "beacons", 100);
        a.addURI(A4SContract.getAuthority(context), "beacons/#", 101);
        a.addURI(A4SContract.getAuthority(context), "beacons/beacon_groups/filter", 102);
        a.addURI(A4SContract.getAuthority(context), "beacon_params", 200);
        a.addURI(A4SContract.getAuthority(context), "beacon_params/#", 201);
        a.addURI(A4SContract.getAuthority(context), "geofences", 300);
        a.addURI(A4SContract.getAuthority(context), "geofences/#", 301);
        a.addURI(A4SContract.getAuthority(context), "geofences/geofence_groups/filter", 302);
        a.addURI(A4SContract.getAuthority(context), "geofence_params", 400);
        a.addURI(A4SContract.getAuthority(context), "geofence_params/#", 401);
        a.addURI(A4SContract.getAuthority(context), "beacon_geofence_groups", 500);
        a.addURI(A4SContract.getAuthority(context), "beacon_geofence_groups/#", 501);
        a.addURI(A4SContract.getAuthority(context), "beacon_geofence_groups/beacon_groups/filter", 502);
        a.addURI(A4SContract.getAuthority(context), "beacon_geofence_groups/geofence_groups/filter", 503);
        a.addURI(A4SContract.getAuthority(context), "beacon_groups", 600);
        a.addURI(A4SContract.getAuthority(context), "beacon_groups/#", 601);
        a.addURI(A4SContract.getAuthority(context), "custom_beacon_groups", 602);
        a.addURI(A4SContract.getAuthority(context), "geofence_groups", 700);
        a.addURI(A4SContract.getAuthority(context), "geofence_groups/#", 701);
        a.addURI(A4SContract.getAuthority(context), "custom_geofence_groups", 702);
    }

    public String getType(Uri uri) {
        String string2;
        int n2 = a.match(uri);
        switch (n2) {
            case 100: {
                string2 = A4SContract.Beacons.CONTENT_TYPE;
                break;
            }
            case 101: {
                string2 = A4SContract.Beacons.CONTENT_ITEM_TYPE;
                break;
            }
            case 200: {
                string2 = A4SContract.BeaconParams.CONTENT_TYPE;
                break;
            }
            case 201: {
                string2 = A4SContract.BeaconParams.CONTENT_ITEM_TYPE;
                break;
            }
            case 300: {
                string2 = A4SContract.Geofences.CONTENT_TYPE;
                break;
            }
            case 301: {
                string2 = A4SContract.Geofences.CONTENT_ITEM_TYPE;
                break;
            }
            case 400: {
                string2 = A4SContract.GeofenceParams.CONTENT_TYPE;
                break;
            }
            case 401: {
                string2 = A4SContract.GeofenceParams.CONTENT_ITEM_TYPE;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported URI: " + uri);
            }
        }
        return string2;
    }

    private String[] a(String[] stringArray, String string2) {
        if (stringArray == null) {
            return new String[]{string2};
        }
        int n2 = stringArray.length + 1;
        String[] stringArray2 = new String[n2];
        stringArray2[0] = string2;
        System.arraycopy(stringArray, 0, stringArray2, 1, stringArray.length);
        return stringArray2;
    }

    public Cursor query(Uri uri, String[] stringArray, String string2, String[] stringArray2, String string3) {
        SQLiteQueryBuilder sQLiteQueryBuilder = new SQLiteQueryBuilder();
        int n2 = a.match(uri);
        switch (n2) {
            case 100: {
                sQLiteQueryBuilder.setTables("beacons");
                break;
            }
            case 101: {
                long l2 = ContentUris.parseId((Uri)uri);
                sQLiteQueryBuilder.setTables("beacons");
                stringArray2 = this.a(stringArray2, String.valueOf(l2));
                sQLiteQueryBuilder.appendWhere((CharSequence)"_id=?");
                break;
            }
            case 102: {
                StringBuffer stringBuffer = new StringBuffer("SELECT ");
                if (stringArray == null) {
                    stringBuffer.append("*");
                } else {
                    for (String string4 : stringArray) {
                        stringBuffer.append(string4);
                        stringBuffer.append(",");
                    }
                    if (stringBuffer.length() > 0) {
                        stringBuffer.deleteCharAt(stringBuffer.length() - 1);
                    }
                }
                stringBuffer.append(" FROM beacons");
                stringBuffer.append(" INNER JOIN beacon_groups");
                stringBuffer.append(" ON beacons._id=beacon_groups.beacon_id");
                stringBuffer.append(" INNER JOIN beacon_geofence_groups");
                stringBuffer.append(" ON beacon_groups.group_id=beacon_geofence_groups._id");
                if (string2 != null) {
                    stringBuffer.append(" WHERE " + string2);
                }
                return this.b.rawQuery(stringBuffer.toString(), stringArray2);
            }
            case 200: {
                sQLiteQueryBuilder.setTables("beacon_params");
                break;
            }
            case 201: {
                long l2 = ContentUris.parseId((Uri)uri);
                sQLiteQueryBuilder.setTables("beacon_params");
                stringArray2 = this.a(stringArray2, String.valueOf(l2));
                sQLiteQueryBuilder.appendWhere((CharSequence)"_id=?");
                break;
            }
            case 300: {
                sQLiteQueryBuilder.setTables("geofences");
                break;
            }
            case 301: {
                long l2 = ContentUris.parseId((Uri)uri);
                sQLiteQueryBuilder.setTables("geofences");
                stringArray2 = this.a(stringArray2, String.valueOf(l2));
                sQLiteQueryBuilder.appendWhere((CharSequence)"_id=?");
                break;
            }
            case 302: {
                StringBuffer stringBuffer = new StringBuffer("SELECT ");
                if (stringArray == null) {
                    stringBuffer.append("*");
                } else {
                    for (String string5 : stringArray) {
                        stringBuffer.append(string5);
                        stringBuffer.append(",");
                    }
                    if (stringBuffer.length() > 0) {
                        stringBuffer.deleteCharAt(stringBuffer.length() - 1);
                    }
                }
                stringBuffer.append(" FROM geofences");
                stringBuffer.append(" INNER JOIN geofence_groups");
                stringBuffer.append(" ON geofences._id=geofence_groups.geofence_id");
                stringBuffer.append(" INNER JOIN beacon_geofence_groups");
                stringBuffer.append(" ON geofence_groups.group_id=beacon_geofence_groups._id");
                if (string2 != null) {
                    stringBuffer.append(" WHERE " + string2);
                }
                return this.b.rawQuery(stringBuffer.toString(), stringArray2);
            }
            case 400: {
                sQLiteQueryBuilder.setTables("geofence_params");
                break;
            }
            case 401: {
                long l2 = ContentUris.parseId((Uri)uri);
                sQLiteQueryBuilder.setTables("geofence_params");
                stringArray2 = this.a(stringArray2, String.valueOf(l2));
                sQLiteQueryBuilder.appendWhere((CharSequence)"_id=?");
                break;
            }
            case 500: {
                sQLiteQueryBuilder.setTables("beacon_geofence_groups");
                break;
            }
            case 501: {
                long l2 = ContentUris.parseId((Uri)uri);
                sQLiteQueryBuilder.setTables("beacon_geofence_groups");
                stringArray2 = this.a(stringArray2, String.valueOf(l2));
                sQLiteQueryBuilder.appendWhere((CharSequence)"_id=?");
                break;
            }
            case 502: {
                StringBuffer stringBuffer = new StringBuffer("SELECT ");
                if (stringArray == null) {
                    stringBuffer.append("*");
                } else {
                    for (String string6 : stringArray) {
                        stringBuffer.append(string6);
                        stringBuffer.append(",");
                    }
                    if (stringBuffer.length() > 0) {
                        stringBuffer.deleteCharAt(stringBuffer.length() - 1);
                    }
                }
                stringBuffer.append(" FROM beacon_geofence_groups");
                stringBuffer.append(" INNER JOIN beacon_groups");
                stringBuffer.append(" ON beacon_geofence_groups._id=beacon_groups.group_id");
                if (string2 != null) {
                    stringBuffer.append(" WHERE " + string2);
                }
                return this.b.rawQuery(stringBuffer.toString(), stringArray2);
            }
            case 503: {
                StringBuffer stringBuffer = new StringBuffer("SELECT ");
                if (stringArray == null) {
                    stringBuffer.append("*");
                } else {
                    for (String string7 : stringArray) {
                        stringBuffer.append(string7);
                        stringBuffer.append(",");
                    }
                    if (stringBuffer.length() > 0) {
                        stringBuffer.deleteCharAt(stringBuffer.length() - 1);
                    }
                }
                stringBuffer.append(" FROM beacon_geofence_groups");
                stringBuffer.append(" INNER JOIN geofence_groups");
                stringBuffer.append(" ON beacon_geofence_groups._id=geofence_groups.group_id");
                if (string2 != null) {
                    stringBuffer.append(" WHERE " + string2);
                }
                return this.b.rawQuery(stringBuffer.toString(), stringArray2);
            }
            case 600: {
                sQLiteQueryBuilder.setTables("beacon_groups");
                break;
            }
            case 601: {
                long l2 = ContentUris.parseId((Uri)uri);
                sQLiteQueryBuilder.setTables("beacon_groups");
                stringArray2 = this.a(stringArray2, String.valueOf(l2));
                sQLiteQueryBuilder.appendWhere((CharSequence)"_id=?");
                break;
            }
            case 700: {
                sQLiteQueryBuilder.setTables("geofence_groups");
                break;
            }
            case 701: {
                long l2 = ContentUris.parseId((Uri)uri);
                sQLiteQueryBuilder.setTables("geofence_groups");
                stringArray2 = this.a(stringArray2, String.valueOf(l2));
                sQLiteQueryBuilder.appendWhere((CharSequence)"_id=?");
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported URI: " + uri);
            }
        }
        Cursor cursor = sQLiteQueryBuilder.query(this.b, stringArray, string2, stringArray2, null, null, string3);
        if (cursor != null) {
            cursor.setNotificationUri(this.getContext().getContentResolver(), uri);
        }
        return cursor;
    }

    public Uri insert(Uri uri, ContentValues contentValues) {
        String string2;
        int n2 = a.match(uri);
        switch (n2) {
            case 100: {
                string2 = "beacons";
                break;
            }
            case 200: {
                string2 = "beacon_params";
                break;
            }
            case 300: {
                string2 = "geofences";
                break;
            }
            case 400: {
                string2 = "geofence_params";
                break;
            }
            case 500: {
                string2 = "beacon_geofence_groups";
                break;
            }
            case 600: {
                string2 = "beacon_groups";
                break;
            }
            case 700: {
                string2 = "geofence_groups";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported URI: " + uri);
            }
        }
        long l2 = this.b.insert(string2, null, contentValues);
        if (l2 > 0L) {
            Uri uri2 = ContentUris.withAppendedId((Uri)uri, (long)l2);
            this.getContext().getContentResolver().notifyChange(uri, null);
            return uri2;
        }
        throw new SQLException("Failed to insert row into " + uri);
    }

    public int bulkInsert(Uri uri, ContentValues[] contentValuesArray) {
        int n2;
        String string2;
        int n3 = a.match(uri);
        switch (n3) {
            case 100: {
                string2 = "beacons";
                break;
            }
            case 200: {
                string2 = "beacon_params";
                break;
            }
            case 300: {
                string2 = "geofences";
                break;
            }
            case 400: {
                string2 = "geofence_params";
                break;
            }
            case 500: {
                string2 = "beacon_geofence_groups";
                break;
            }
            case 600: {
                string2 = "beacon_groups";
                break;
            }
            case 602: {
                ContentValues contentValues;
                Cursor cursor;
                String string3;
                String string4;
                long l2;
                ContentValues contentValues2;
                int n4;
                n2 = 0;
                ContentValues[] contentValuesArray2 = new ContentValues[contentValuesArray.length];
                ContentValues[] contentValuesArray3 = contentValuesArray;
                int n5 = contentValuesArray3.length;
                for (n4 = 0; n4 < n5; ++n4) {
                    contentValues2 = contentValuesArray3[n4];
                    l2 = -1L;
                    string4 = contentValues2.getAsString("beacon_id");
                    string3 = contentValues2.getAsString("server_id");
                    cursor = this.b.query("beacon_geofence_groups", new String[]{"_id"}, "server_id=?", new String[]{string3}, null, null, null);
                    if (cursor != null) {
                        if (cursor.getCount() > 0) {
                            cursor.moveToFirst();
                            l2 = cursor.getInt(0);
                        }
                        cursor.close();
                    }
                    if (l2 == -1L) {
                        contentValues = new ContentValues();
                        contentValues.put("server_id", string3);
                        l2 = this.b.insert("beacon_geofence_groups", null, contentValues);
                    }
                    contentValues = new ContentValues();
                    contentValues.put("beacon_id", string4);
                    contentValues.put("group_id", Long.valueOf(l2));
                    contentValuesArray2[n2++] = contentValues;
                }
                string2 = "beacon_groups";
                contentValuesArray = contentValuesArray2;
                break;
            }
            case 702: {
                ContentValues contentValues;
                Cursor cursor;
                String string3;
                String string4;
                long l2;
                ContentValues contentValues2;
                int n4;
                n2 = 0;
                ContentValues[] contentValuesArray2 = new ContentValues[contentValuesArray.length];
                ContentValues[] contentValuesArray3 = contentValuesArray;
                int n5 = contentValuesArray3.length;
                for (n4 = 0; n4 < n5; ++n4) {
                    contentValues2 = contentValuesArray3[n4];
                    l2 = -1L;
                    string4 = contentValues2.getAsString("geofence_id");
                    string3 = contentValues2.getAsString("server_id");
                    cursor = this.b.query("beacon_geofence_groups", new String[]{"_id"}, "server_id=?", new String[]{string3}, null, null, null);
                    if (cursor != null) {
                        if (cursor.getCount() > 0) {
                            cursor.moveToFirst();
                            l2 = cursor.getInt(0);
                        }
                        cursor.close();
                    }
                    if (l2 == -1L) {
                        contentValues = new ContentValues();
                        contentValues.put("server_id", string3);
                        l2 = this.b.insert("beacon_geofence_groups", null, contentValues);
                    }
                    contentValues = new ContentValues();
                    contentValues.put("geofence_id", string4);
                    contentValues.put("group_id", Long.valueOf(l2));
                    contentValuesArray2[n2++] = contentValues;
                }
                string2 = "geofence_groups";
                contentValuesArray = contentValuesArray2;
                break;
            }
            case 700: {
                string2 = "geofence_groups";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported URI: " + uri);
            }
        }
        n2 = 0;
        this.b.beginTransaction();
        for (ContentValues contentValues : contentValuesArray) {
            long l3 = this.b.insert(string2, null, contentValues);
            if (l3 < 0L) continue;
            ++n2;
        }
        this.b.setTransactionSuccessful();
        this.b.endTransaction();
        if (n2 > 0) {
            this.getContext().getContentResolver().notifyChange(uri, null);
        }
        return n2;
    }

    public int delete(Uri uri, String string2, String[] stringArray) {
        String string3;
        String string4 = string2;
        String[] stringArray2 = stringArray;
        Uri uri2 = null;
        int n2 = a.match(uri);
        switch (n2) {
            case 100: {
                string3 = "beacons";
                break;
            }
            case 101: {
                string3 = "beacons";
                long l2 = ContentUris.parseId((Uri)uri);
                stringArray2 = this.a(stringArray, String.valueOf(l2));
                string4 = "_id=?" + (!TextUtils.isEmpty((CharSequence)string2) ? " AND (" + string2 + ")" : "");
                uri2 = A4SContract.Beacons.getContentUri(this.getContext());
                break;
            }
            case 200: {
                string3 = "beacon_params";
                break;
            }
            case 201: {
                string3 = "beacon_params";
                long l2 = ContentUris.parseId((Uri)uri);
                stringArray2 = this.a(stringArray, String.valueOf(l2));
                string4 = "_id=?" + (!TextUtils.isEmpty((CharSequence)string2) ? " AND (" + string2 + ")" : "");
                uri2 = A4SContract.BeaconParams.getContentUri(this.getContext());
                break;
            }
            case 300: {
                string3 = "geofences";
                break;
            }
            case 301: {
                string3 = "geofences";
                long l2 = ContentUris.parseId((Uri)uri);
                stringArray2 = this.a(stringArray, String.valueOf(l2));
                string4 = "_id=?" + (!TextUtils.isEmpty((CharSequence)string2) ? " AND (" + string2 + ")" : "");
                uri2 = A4SContract.Geofences.getContentUri(this.getContext());
                break;
            }
            case 400: {
                string3 = "geofence_params";
                break;
            }
            case 401: {
                string3 = "geofence_params";
                long l2 = ContentUris.parseId((Uri)uri);
                stringArray2 = this.a(stringArray, String.valueOf(l2));
                string4 = "_id=?" + (!TextUtils.isEmpty((CharSequence)string2) ? " AND (" + string2 + ")" : "");
                uri2 = A4SContract.GeofenceParams.getContentUri(this.getContext());
                break;
            }
            case 500: {
                string3 = "beacon_geofence_groups";
                break;
            }
            case 501: {
                string3 = "beacon_geofence_groups";
                long l2 = ContentUris.parseId((Uri)uri);
                stringArray2 = this.a(stringArray, String.valueOf(l2));
                string4 = "_id=?" + (!TextUtils.isEmpty((CharSequence)string2) ? " AND (" + string2 + ")" : "");
                uri2 = A4SContract.BeaconGeofenceGroups.getContentUri(this.getContext());
                break;
            }
            case 600: {
                string3 = "beacon_groups";
                break;
            }
            case 601: {
                string3 = "beacon_groups";
                long l2 = ContentUris.parseId((Uri)uri);
                stringArray2 = this.a(stringArray, String.valueOf(l2));
                string4 = "_id=?" + (!TextUtils.isEmpty((CharSequence)string2) ? " AND (" + string2 + ")" : "");
                uri2 = A4SContract.BeaconGroups.getContentUri(this.getContext());
                break;
            }
            case 700: {
                string3 = "geofence_groups";
                break;
            }
            case 701: {
                string3 = "geofence_groups";
                long l2 = ContentUris.parseId((Uri)uri);
                stringArray2 = this.a(stringArray, String.valueOf(l2));
                string4 = "_id=?" + (!TextUtils.isEmpty((CharSequence)string2) ? " AND (" + string2 + ")" : "");
                uri2 = A4SContract.GeofenceGroups.getContentUri(this.getContext());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported URI: " + uri);
            }
        }
        int n3 = this.b.delete(string3, string4, stringArray2);
        if (n3 > 0) {
            this.getContext().getContentResolver().notifyChange(uri, null);
            if (uri2 != null) {
                this.getContext().getContentResolver().notifyChange(uri2, null);
            }
        }
        return n3;
    }

    public int update(Uri uri, ContentValues contentValues, String string2, String[] stringArray) {
        String string3;
        String string4 = string2;
        String[] stringArray2 = stringArray;
        int n2 = a.match(uri);
        switch (n2) {
            case 100: {
                string3 = "beacons";
                break;
            }
            case 101: {
                string3 = "beacons";
                long l2 = ContentUris.parseId((Uri)uri);
                stringArray2 = this.a(stringArray, String.valueOf(l2));
                string4 = "_id=?" + (!TextUtils.isEmpty((CharSequence)string2) ? " AND (" + string2 + ")" : "");
                break;
            }
            case 200: {
                string3 = "beacon_params";
                break;
            }
            case 201: {
                string3 = "beacon_params";
                long l2 = ContentUris.parseId((Uri)uri);
                stringArray2 = this.a(stringArray, String.valueOf(l2));
                string4 = "_id=?" + (!TextUtils.isEmpty((CharSequence)string2) ? " AND (" + string2 + ")" : "");
                break;
            }
            case 300: {
                string3 = "geofences";
                break;
            }
            case 301: {
                string3 = "geofences";
                long l2 = ContentUris.parseId((Uri)uri);
                stringArray2 = this.a(stringArray, String.valueOf(l2));
                string4 = "_id=?" + (!TextUtils.isEmpty((CharSequence)string2) ? " AND (" + string2 + ")" : "");
                break;
            }
            case 400: {
                string3 = "geofence_params";
                break;
            }
            case 401: {
                string3 = "geofence_params";
                long l2 = ContentUris.parseId((Uri)uri);
                stringArray2 = this.a(stringArray, String.valueOf(l2));
                string4 = "_id=?" + (!TextUtils.isEmpty((CharSequence)string2) ? " AND (" + string2 + ")" : "");
                break;
            }
            case 500: {
                string3 = "beacon_geofence_groups";
                break;
            }
            case 501: {
                string3 = "beacon_geofence_groups";
                long l2 = ContentUris.parseId((Uri)uri);
                stringArray2 = this.a(stringArray, String.valueOf(l2));
                string4 = "_id=?" + (!TextUtils.isEmpty((CharSequence)string2) ? " AND (" + string2 + ")" : "");
                break;
            }
            case 600: {
                string3 = "beacon_groups";
                break;
            }
            case 601: {
                string3 = "beacon_groups";
                long l2 = ContentUris.parseId((Uri)uri);
                stringArray2 = this.a(stringArray, String.valueOf(l2));
                string4 = "_id=?" + (!TextUtils.isEmpty((CharSequence)string2) ? " AND (" + string2 + ")" : "");
                break;
            }
            case 700: {
                string3 = "geofence_groups";
                break;
            }
            case 701: {
                string3 = "geofence_groups";
                long l2 = ContentUris.parseId((Uri)uri);
                stringArray2 = this.a(stringArray, String.valueOf(l2));
                string4 = "_id=?" + (!TextUtils.isEmpty((CharSequence)string2) ? " AND (" + string2 + ")" : "");
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported URI: " + uri);
            }
        }
        int n3 = this.b.update(string3, contentValues, string4, stringArray2);
        if (n3 > 0) {
            this.getContext().getContentResolver().notifyChange(uri, null);
        }
        return n3;
    }

    public Bundle call(String string2, String string3, Bundle bundle) {
        switch (string2) {
            case "updateGeofences": {
                bundle.setClassLoader(Geofence.class.getClassLoader());
                ArrayList arrayList = bundle.getParcelableArrayList("geofences");
                this.e.updateGeofences(arrayList);
                break;
            }
            case "updateBeacons": {
                bundle.setClassLoader(Beacon.class.getClassLoader());
                ArrayList arrayList = bundle.getParcelableArrayList("beacons");
                this.d.updateBeacons(arrayList);
                break;
            }
            default: {
                Log.warn("A4SProvider|call method is not found");
            }
        }
        return null;
    }

    private class b
    implements c.a {
        private b() {
        }

        @Override
        public ContentProviderResult[] a(ArrayList<ContentProviderOperation> arrayList) throws OperationApplicationException {
            if (Build.VERSION.SDK_INT >= 5) {
                return A4SProvider.this.applyBatch(arrayList);
            }
            return null;
        }

        @Override
        public Uri a(Uri uri, ContentValues contentValues) {
            return A4SProvider.this.insert(uri, contentValues);
        }

        @Override
        public int a(Uri uri, ContentValues[] contentValuesArray) {
            return A4SProvider.this.bulkInsert(uri, contentValuesArray);
        }

        @Override
        public Cursor a(Uri uri, String[] stringArray, String string2, String[] stringArray2, String string3) {
            return A4SProvider.this.query(uri, stringArray, string2, stringArray2, string3);
        }

        @Override
        public int a(Uri uri, ContentValues contentValues, String string2, String[] stringArray) {
            return A4SProvider.this.update(uri, contentValues, string2, stringArray);
        }

        @Override
        public int a(Uri uri, String string2, String[] stringArray) {
            return A4SProvider.this.delete(uri, string2, stringArray);
        }
    }

    private class a
    extends com.ad4screen.sdk.provider.b {
        public a(c.a a2) {
            super(a2, A4SProvider.this.getContext());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void updateBeacons(List<Beacon> list) {
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            ArrayList<Beacon> arrayList = new ArrayList<Beacon>();
            A4SProvider.this.b.beginTransaction();
            try {
                for (Beacon beacon : list) {
                    beacon.rowId = this.hasBeacon(beacon.id);
                    if (beacon.rowId < 0L) {
                        if (beacon.isNeedToBeRemoved) continue;
                        arrayList.add(beacon);
                        continue;
                    }
                    if (beacon.isNeedToBeRemoved) {
                        n4 += this.deleteBeacon(beacon);
                        continue;
                    }
                    n3 += this.updateBeacon(beacon);
                }
                if (arrayList.size() > 0) {
                    n2 = this.insertBeacons(arrayList);
                }
                A4SProvider.this.b.setTransactionSuccessful();
                Log.debug("A4SProvider|updateBeacons inserted: " + n2 + ", updated: " + n3 + ", deleted: " + n4);
            }
            finally {
                A4SProvider.this.b.endTransaction();
            }
        }
    }

    private class c
    extends e {
        public c(c.a a2) {
            super(a2, A4SProvider.this.getContext());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void updateGeofences(List<Geofence> list) {
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            ArrayList<Geofence> arrayList = new ArrayList<Geofence>();
            A4SProvider.this.b.beginTransaction();
            try {
                for (Geofence geofence : list) {
                    long l2 = this.hasGeofence(geofence.getId());
                    geofence.setRowId(l2);
                    if (l2 < 0L) {
                        if (geofence.isNeedToBeRemoved()) continue;
                        arrayList.add(geofence);
                        continue;
                    }
                    if (geofence.isNeedToBeRemoved()) {
                        n4 += this.deleteGeofence(geofence);
                        continue;
                    }
                    n3 += this.updateGeofence(geofence);
                }
                if (arrayList.size() > 0) {
                    n2 = this.insertGeofences(arrayList);
                }
                A4SProvider.this.b.setTransactionSuccessful();
                Log.debug("A4SProvider|updateGeofences inserted: " + n2 + ", updated: " + n3 + ", deleted: " + n4);
            }
            finally {
                A4SProvider.this.b.endTransaction();
            }
        }
    }
}

