/*
 * Decompiled with CFR 0.152.
 */
package com.ad4screen.sdk.plugins.model;

import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import com.ad4screen.sdk.c.a.d;
import com.ad4screen.sdk.common.annotations.API;
import com.ad4screen.sdk.common.c.c;
import com.ad4screen.sdk.common.c.d;
import com.ad4screen.sdk.provider.A4SGeofenceResolver;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@API
public class Geofence
implements Parcelable,
c<Geofence>,
d,
Comparable<Geofence> {
    public static final String KEY_NAME = "name";
    public static final String KEY_TARGET_LATITUDE = "targetLat";
    public static final String KEY_TARGET_LONGITUDE = "targetLong";
    public static final String KEY_CUSTOM_PARAMS = "data";
    public static final String KEY_GROUPS = "groups";
    public static final String KEY_EXTERNAL_ID = "externalId";
    private static final String CLASS_KEY = "com.ad4screen.sdk.plugins.model.Geofence";
    public long mRowId = -1L;
    private String mId;
    private String mExternalId;
    private String mName;
    private double mLatitude;
    private double mLongitude;
    private float mRadius;
    private boolean mIsNeedToBeRemoved = false;
    private int mDistance;
    private Map<String, String> mCustomParams = new HashMap<String, String>();
    private Set<String> mGroups = new HashSet<String>();
    private Date mDetectedTime = new Date(0L);
    private Date mNotifiedTime = new Date(0L);
    public static final Parcelable.Creator<Geofence> CREATOR = new Parcelable.Creator<Geofence>(){

        public Geofence createFromParcel(Parcel parcel) {
            return new Geofence(parcel);
        }

        public Geofence[] newArray(int n2) {
            return new Geofence[n2];
        }
    };

    public Geofence(String string2) {
        this.mId = string2;
        this.mExternalId = "";
    }

    protected Geofence(Parcel parcel) {
        String string2;
        int n2;
        this.mId = parcel.readString();
        this.mRowId = parcel.readLong();
        this.mExternalId = parcel.readString();
        this.mLatitude = parcel.readDouble();
        this.mLongitude = parcel.readDouble();
        this.mRadius = parcel.readFloat();
        this.mIsNeedToBeRemoved = parcel.readInt() != 0;
        this.mDistance = parcel.readInt();
        this.mName = parcel.readString();
        int n3 = parcel.readInt();
        this.mCustomParams = new HashMap<String, String>(n3);
        for (n2 = 0; n2 < n3; ++n2) {
            string2 = parcel.readString();
            String string3 = parcel.readString();
            this.mCustomParams.put(string2, string3);
        }
        n3 = parcel.readInt();
        this.mGroups = new HashSet<String>(n3);
        for (n2 = 0; n2 < n3; ++n2) {
            string2 = parcel.readString();
            this.mGroups.add(string2);
        }
    }

    public long getRowId() {
        return this.mRowId;
    }

    public void setRowId(long l2) {
        this.mRowId = l2;
    }

    public String getId() {
        return this.mId;
    }

    public void setExternalId(String string2) {
        this.mExternalId = string2;
    }

    public String getExternalId() {
        return this.mExternalId;
    }

    public String getName() {
        return this.mName;
    }

    public void setName(String string2) {
        this.mName = string2;
    }

    public double getLatitude() {
        return this.mLatitude;
    }

    public void setLatitude(double d2) {
        this.mLatitude = d2;
    }

    public double getLongitude() {
        return this.mLongitude;
    }

    public void setLongitude(double d2) {
        this.mLongitude = d2;
    }

    public float getRadius() {
        return this.mRadius;
    }

    public void setRadius(float f2) {
        this.mRadius = f2;
    }

    public boolean isNeedToBeRemoved() {
        return this.mIsNeedToBeRemoved;
    }

    public void setNeedToBeRemoved(boolean bl) {
        this.mIsNeedToBeRemoved = bl;
    }

    public int getDistance() {
        return this.mDistance;
    }

    public void setDistance(int n2) {
        this.mDistance = n2;
    }

    public Date getDetectedTime() {
        return new Date(this.mDetectedTime.getTime());
    }

    public void setDetectedTime(Date date) {
        this.mDetectedTime = new Date(date.getTime());
    }

    public Date getNotifiedTime() {
        return new Date(this.mNotifiedTime.getTime());
    }

    public void setNotifiedTime(Date date) {
        this.mNotifiedTime = new Date(date.getTime());
    }

    public Map<String, String> getCustomParams() {
        return this.mCustomParams;
    }

    public void setCustomParams(Map<String, String> map) {
        this.mCustomParams = map;
    }

    public void parseCustomParams(JSONObject jSONObject) throws JSONException {
        JSONObject jSONObject2 = jSONObject.getJSONObject(KEY_CUSTOM_PARAMS);
        Iterator iterator = jSONObject2.keys();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            String string3 = jSONObject2.getString(string2);
            if (this.mCustomParams.containsKey(string2)) {
                throw new JSONException(string2 + " already exists beacon: " + this.mId);
            }
            this.mCustomParams.put(string2, string3);
        }
    }

    public Set<String> getGroups() {
        return this.mGroups;
    }

    public void setGroups(Set<String> set) {
        this.mGroups = set;
    }

    public void parseGroups(JSONObject jSONObject) throws JSONException {
        JSONArray jSONArray = jSONObject.getJSONArray(KEY_GROUPS);
        for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
            String string2 = jSONArray.getString(i2);
            this.mGroups.add(string2);
        }
    }

    @Override
    public int compareTo(Geofence geofence) {
        return this.mDistance - geofence.getDistance();
    }

    @Override
    public Geofence fromJSON(String string2) throws JSONException {
        JSONObject jSONObject = new JSONObject(string2);
        Geofence geofence = new Geofence(jSONObject.getString("id"));
        geofence.setRowId(jSONObject.getLong("rowId"));
        geofence.setExternalId(jSONObject.getString(KEY_EXTERNAL_ID));
        geofence.setLatitude(jSONObject.getDouble("latitude"));
        geofence.setLongitude(jSONObject.getDouble("longitude"));
        geofence.setRadius((float)jSONObject.getDouble("radius"));
        geofence.setNeedToBeRemoved(jSONObject.getBoolean("toRemove"));
        geofence.setDistance(jSONObject.getInt("distance"));
        geofence.setName(jSONObject.getString(KEY_NAME));
        if (!jSONObject.isNull(KEY_CUSTOM_PARAMS)) {
            geofence.parseCustomParams(jSONObject);
        }
        if (!jSONObject.isNull(KEY_GROUPS)) {
            geofence.parseGroups(jSONObject);
        }
        return geofence;
    }

    @Override
    public String getClassKey() {
        return CLASS_KEY;
    }

    @Override
    public JSONObject toJSON() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("id", (Object)this.mId);
        jSONObject.put("rowId", this.mRowId);
        jSONObject.put(KEY_EXTERNAL_ID, (Object)this.mExternalId);
        jSONObject.put("latitude", this.mLatitude);
        jSONObject.put("longitude", this.mLongitude);
        jSONObject.put("radius", (double)this.mRadius);
        jSONObject.put("toRemove", this.mIsNeedToBeRemoved);
        jSONObject.put("distance", this.mDistance);
        jSONObject.put(KEY_NAME, (Object)this.mName);
        JSONObject jSONObject2 = new JSONObject();
        for (Map.Entry<String, String> object : this.mCustomParams.entrySet()) {
            String string2 = object.getKey();
            String string3 = object.getValue();
            jSONObject2.put(string2, (Object)string3);
        }
        jSONObject.put(KEY_CUSTOM_PARAMS, (Object)jSONObject2);
        JSONArray jSONArray = new JSONArray();
        for (String string2 : this.mGroups) {
            jSONArray.put((Object)string2);
        }
        jSONObject.put(KEY_GROUPS, (Object)jSONArray);
        return jSONObject;
    }

    public String toString() {
        return "Geofence: " + this.mId + ", " + this.mName + ", distance: " + this.mDistance + ", groups: " + this.mGroups.toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n2) {
        parcel.writeString(this.mId);
        parcel.writeLong(this.mRowId);
        parcel.writeString(this.mExternalId);
        parcel.writeDouble(this.mLatitude);
        parcel.writeDouble(this.mLongitude);
        parcel.writeFloat(this.mRadius);
        parcel.writeInt(this.mIsNeedToBeRemoved ? 1 : 0);
        parcel.writeInt(this.mDistance);
        parcel.writeString(this.mName);
        parcel.writeInt(this.mCustomParams.size());
        for (Map.Entry<String, String> object : this.mCustomParams.entrySet()) {
            parcel.writeString(object.getKey());
            parcel.writeString(object.getValue());
        }
        parcel.writeInt(this.mGroups.size());
        for (String string2 : this.mGroups) {
            parcel.writeString(string2);
        }
    }

    public static class PersonalParamsReplacer
    implements d.a {
        private Geofence mGeofence;

        public PersonalParamsReplacer(Context context, String string2) {
            A4SGeofenceResolver a4SGeofenceResolver = new A4SGeofenceResolver(context);
            this.mGeofence = a4SGeofenceResolver.getGeofenceByClientId(string2);
        }

        @Override
        public void onPersonalParamFound(String string2, StringBuffer stringBuffer) {
            if (Geofence.KEY_NAME.equals(string2)) {
                stringBuffer.append(this.mGeofence.getName());
            } else if (Geofence.KEY_TARGET_LATITUDE.equals(string2)) {
                stringBuffer.append(String.valueOf(this.mGeofence.getLatitude()));
            } else if (Geofence.KEY_TARGET_LONGITUDE.equals(string2)) {
                stringBuffer.append(String.valueOf(this.mGeofence.getLongitude()));
            } else if (this.mGeofence.getCustomParams().containsKey(string2)) {
                stringBuffer.append(this.mGeofence.getCustomParams().get(string2));
            }
        }
    }
}

