/*
 * Decompiled with CFR 0.152.
 */
package com.ad4screen.sdk.plugins.beacons;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.RemoteException;
import com.ad4screen.sdk.A4S;
import com.ad4screen.sdk.Log;
import com.ad4screen.sdk.plugins.beacons.BeaconProviderCallback;
import com.ad4screen.sdk.plugins.beacons.BindBeaconProvider;
import com.ad4screen.sdk.plugins.beacons.IBeaconService;
import java.util.List;

public class BindBeaconService {
    private Context mContext;
    private IBeaconService mService;
    private BindBeaconProvider<IBeaconService> mBindProvider;

    public BindBeaconService(Context context) {
        this.mContext = context;
    }

    public void unbindService() {
        if (this.mBindProvider != null) {
            this.mBindProvider.closeConnections();
        }
    }

    public IBeaconService getService(A4S.Callback<IBeaconService> callback) {
        if (this.mService == null) {
            this.bindToService(callback);
        } else {
            try {
                Log.internal("BindBeaconService|Service running with v" + this.mService.getVersion());
                if (callback != null) {
                    callback.onResult(this.mService);
                }
            }
            catch (RemoteException remoteException) {
                Log.error("BindBeaconService|Error while getting service", remoteException);
                this.bindToService(callback);
            }
        }
        return this.mService;
    }

    private void bindToService(final A4S.Callback<IBeaconService> callback) {
        Log.internal("BindBeaconService|Finding service...");
        this.mBindProvider = new BindBeaconProvider<IBeaconService>(this.mContext, "com.ad4screen.sdk.intent.action.QUERY", "com.ad4screen.sdk.intent.category.BEACON_NOTIFICATIONS", IBeaconService.class, new BeaconProviderCallback<IBeaconService>(){

            @Override
            public void onProvidersBinded(List<IBeaconService> list) {
                BindBeaconService.this.mService = this.firstMatchingVersionService(list);
                if (BindBeaconService.this.mService == null) {
                    try {
                        BindBeaconService.this.mContext.bindService(new Intent(BindBeaconService.this.mContext, Class.forName("com.ad4screen.sdk.A4SBeaconService")), new ServiceConnection(){

                            public void onServiceDisconnected(ComponentName componentName) {
                                BindBeaconService.this.mService = null;
                            }

                            public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
                                BindBeaconService.this.mService = IBeaconService.Stub.asInterface(iBinder);
                                if (callback != null) {
                                    callback.onResult(BindBeaconService.this.mService);
                                }
                            }
                        }, 1);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        Log.error("BindBeaconService|Can't create com.ad4screen.sdk.A4SBeaconService", classNotFoundException);
                    }
                } else if (callback != null) {
                    callback.onResult(BindBeaconService.this.mService);
                }
            }

            private IBeaconService firstMatchingVersionService(List<IBeaconService> list) {
                for (IBeaconService iBeaconService : list) {
                    try {
                        if (2L != iBeaconService.getVersion()) continue;
                        return iBeaconService;
                    }
                    catch (RemoteException remoteException) {
                        Log.internal("BindBeaconService|Remote exception while binding to service", remoteException);
                    }
                }
                Log.internal("BindBeaconService|No service found with version 2");
                return null;
            }
        });
        this.mBindProvider.connectToFirstRunningService();
    }
}

