/*
 * Decompiled with CFR 0.152.
 */
package com.ad4screen.sdk.plugins.beacons;

import android.app.ActivityManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.os.IBinder;
import android.os.IInterface;
import com.ad4screen.sdk.Log;
import com.ad4screen.sdk.plugins.beacons.BeaconProviderCallback;
import com.ad4screen.sdk.plugins.beacons.IBeaconServiceConnection;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BindBeaconProvider<T extends IInterface> {
    private static final String TAG = "BindBeaconService";
    private final Context mContext;
    private final Intent mIntent;
    private final Class<T> mParameterType;
    private final BeaconProviderCallback<T> mCallback;
    private List<IBeaconServiceConnection<T>> mProvidersConnections = new ArrayList<IBeaconServiceConnection<T>>();
    private List<T> mProviders = new ArrayList<T>();
    private int mMax;

    public BindBeaconProvider(Context context, String string2, String string3, Class<T> clazz, BeaconProviderCallback<T> beaconProviderCallback) {
        this.mContext = context;
        this.mIntent = new Intent(string2);
        if (string3 != null) {
            this.mIntent.addCategory(string3);
        }
        this.mParameterType = clazz;
        this.mCallback = beaconProviderCallback;
    }

    public void connectToFirstRunningService() {
        List<BeaconServiceConnection> list = Collections.synchronizedList(new ArrayList());
        List<ResolveInfo> list2 = this.getServicesForIntent(this.mIntent);
        for (ResolveInfo resolveInfo : list2) {
            ServiceInfo serviceInfo = resolveInfo.serviceInfo;
            if (serviceInfo == null || !this.isServiceRunning(serviceInfo.name, serviceInfo.packageName)) continue;
            Log.info("BindBeaconService|Service found " + resolveInfo);
            Intent intent = new Intent(this.mIntent);
            intent.setClassName(serviceInfo.packageName, serviceInfo.name);
            BeaconServiceConnection beaconServiceConnection = new BeaconServiceConnection(list);
            try {
                Log.info("BindBeaconService|Binding...");
                boolean bl = this.mContext.bindService(intent, (ServiceConnection)beaconServiceConnection, 1);
                if (bl) {
                    list.add(beaconServiceConnection);
                    Log.info("BindBeaconService|Bind OK !");
                    continue;
                }
                Log.error("BindBeaconService|Impossible to bind to service " + resolveInfo);
            }
            catch (SecurityException securityException) {
                Log.warn("BindBeaconService|Impossible to bind to '" + resolveInfo.serviceInfo.name + "' in app '" + resolveInfo.serviceInfo.applicationInfo.packageName + "'", securityException);
            }
        }
        this.mMax = list.size();
        if (this.mMax == 0 && this.mCallback != null) {
            this.mCallback.onProvidersBinded(this.mProviders);
        }
        this.mProvidersConnections = list;
    }

    public List<T> getProviders() {
        return this.mProviders;
    }

    public void closeConnections() {
        Log.info("BindBeaconService|Clear " + this.mProvidersConnections.size() + " binded interface");
        for (IBeaconServiceConnection<T> iBeaconServiceConnection : this.mProvidersConnections) {
            this.mContext.unbindService(iBeaconServiceConnection);
        }
        this.mProvidersConnections.clear();
        this.mProviders.clear();
        this.mMax = 0;
    }

    private boolean isServiceRunning(String string2, String string3) {
        ActivityManager activityManager = (ActivityManager)this.mContext.getSystemService("activity");
        for (ActivityManager.RunningServiceInfo runningServiceInfo : activityManager.getRunningServices(Integer.MAX_VALUE)) {
            if (!string2.equals(runningServiceInfo.service.getClassName()) || !string3.equals(runningServiceInfo.service.getPackageName())) continue;
            Log.info("BindBeaconService|" + string2 + " running");
            return true;
        }
        Log.info("BindBeaconService|" + string2 + " not running");
        return false;
    }

    private List<ResolveInfo> getServicesForIntent(Intent intent) {
        return this.mContext.getPackageManager().queryIntentServices(intent, 0);
    }

    private void onFinishToBind() {
        Log.info("BindBeaconService|onFinishToBind with " + this.mProvidersConnections.size() + " items");
        for (IBeaconServiceConnection<T> iBeaconServiceConnection : this.mProvidersConnections) {
            IInterface iInterface = (IInterface)iBeaconServiceConnection.getProvider();
            if (iInterface == null) continue;
            this.mProviders.add(iInterface);
        }
        if (this.mCallback != null) {
            this.mCallback.onProvidersBinded(this.mProviders);
        }
    }

    private void onProviderDisconnected(T t) {
        this.mProviders.remove(t);
    }

    private final class BeaconServiceConnection
    implements IBeaconServiceConnection<T> {
        private List<IBeaconServiceConnection<T>> mProvidersConnection;
        private T mProvider;

        private BeaconServiceConnection(List<IBeaconServiceConnection<T>> list) {
            this.mProvidersConnection = list;
        }

        public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            try {
                Log.debug("BindBeaconService|onServiceConnected " + componentName);
                Class<?> clazz = Class.forName(BindBeaconProvider.this.mParameterType.getName() + "$Stub");
                Method method = clazz.getMethod("asInterface", IBinder.class);
                this.mProvider = (IInterface)method.invoke(null, iBinder);
            }
            catch (Exception exception) {
                Log.error("BindBeaconService|Ignore provider. Invalid type " + BindBeaconProvider.this.mParameterType.getName() + " in " + this.getClass(), exception);
            }
            BindBeaconProvider.this.mMax--;
            if (BindBeaconProvider.this.mMax == 0) {
                BindBeaconProvider.this.onFinishToBind();
            }
        }

        public void onServiceDisconnected(ComponentName componentName) {
            Log.debug("BindBeaconService|onServiceDisconnected");
            this.mProvidersConnection.remove(this);
            BindBeaconProvider.this.onProviderDisconnected(this.mProvider);
            this.mProvider = null;
        }

        @Override
        public T getProvider() {
            return this.mProvider;
        }
    }
}

