/*
 * Decompiled with CFR 0.152.
 */
package com.ad4screen.sdk.analytics;

import android.os.Parcel;
import android.os.Parcelable;
import com.ad4screen.sdk.common.annotations.API;
import com.ad4screen.sdk.common.c.d;
import java.util.Currency;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;

@API
public class Item
implements Parcelable,
d,
Cloneable {
    public static final String KEY_ID = "articleId";
    public static final String KEY_CURRENCY = "currency";
    public static final String KEY_LABEL = "label";
    public static final String KEY_CATEGORY = "category";
    public static final String KEY_PRICE = "price";
    public static final String KEY_QUANTITY = "quantity";
    private String a;
    private String b;
    private String c;
    private String d;
    private double e;
    private int f;
    public static final Parcelable.Creator<Item> CREATOR = new Parcelable.Creator<Item>(){

        public Item a(Parcel parcel) {
            return new Item(parcel);
        }

        public Item[] a(int n2) {
            return new Item[n2];
        }

        public /* synthetic */ Object[] newArray(int n2) {
            return this.a(n2);
        }

        public /* synthetic */ Object createFromParcel(Parcel parcel) {
            return this.a(parcel);
        }
    };

    public Item(String string, String string2, String string3, String string4, double d2, int n2) throws IllegalArgumentException {
        this.setId(string);
        this.setLabel(string2);
        this.setCategory(string3);
        this.setCurrency(string4);
        this.setPrice(d2);
        this.setQuantity(n2);
    }

    public String getId() {
        return this.a;
    }

    public void setId(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Item id cannot be null");
        }
        this.a = string;
    }

    public String getLabel() {
        return this.c;
    }

    public void setLabel(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Item label cannot be null");
        }
        this.c = string;
    }

    public String getCategory() {
        return this.d;
    }

    public void setCategory(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Item category cannot be null");
        }
        this.d = string;
    }

    public String getCurrency() {
        return this.b;
    }

    public void setCurrency(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("Item currency cannot be null and should be in ISO4217 format (3 letters)");
        }
        if (string.length() < 3) {
            throw new IllegalArgumentException("Item currency should be in ISO4217 format (3 letters)");
        }
        String string2 = Currency.getInstance(string.substring(0, 3).toUpperCase(Locale.US)).getCurrencyCode();
        if (string2.equals("XXX")) {
            throw new IllegalArgumentException("Item currency can't be XXX (no currency)");
        }
        this.b = string2;
    }

    public double getPrice() {
        return this.e;
    }

    public void setPrice(double d2) {
        this.e = d2;
    }

    public int getQuantity() {
        return this.f;
    }

    public void setQuantity(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Item quantity must be positive");
        }
        this.f = n2;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n2) {
        parcel.writeString(this.a);
        parcel.writeString(this.c);
        parcel.writeString(this.d);
        parcel.writeString(this.b);
        parcel.writeDouble(this.e);
        parcel.writeInt(this.f);
    }

    private Item(Parcel parcel) {
        this.a = parcel.readString();
        this.c = parcel.readString();
        this.d = parcel.readString();
        this.b = parcel.readString();
        this.e = parcel.readDouble();
        this.f = parcel.readInt();
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public JSONObject toJSON() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put(KEY_ID, (Object)this.a);
        jSONObject.put(KEY_LABEL, (Object)this.c);
        jSONObject.put(KEY_CATEGORY, (Object)this.d);
        jSONObject.put(KEY_CURRENCY, (Object)this.b);
        jSONObject.put(KEY_PRICE, this.e);
        jSONObject.put(KEY_QUANTITY, this.f);
        return jSONObject;
    }
}

