/*
 * Decompiled with CFR 0.152.
 */
package com.ad4screen.sdk.provider;

import android.content.ContentProviderOperation;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import com.ad4screen.sdk.Log;
import com.ad4screen.sdk.contract.A4SContract;
import com.ad4screen.sdk.plugins.model.Geofence;
import com.ad4screen.sdk.provider.c;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class e
extends c {
    public e(c.a a2, Context context) {
        super(a2, context);
    }

    public long hasGeofence(String string2) {
        long l2 = -1L;
        String[] stringArray = new String[]{"_id"};
        String string3 = "server_id=?";
        String[] stringArray2 = new String[]{string2};
        Cursor cursor = this.mAcc.a(A4SContract.Geofences.getContentUri(this.mContext), stringArray, string3, stringArray2, null);
        if (cursor != null) {
            if (cursor.getCount() > 0) {
                cursor.moveToFirst();
                l2 = cursor.getLong(0);
            }
            cursor.close();
        }
        return l2;
    }

    private long getGeofenceId(Geofence geofence) {
        long l2 = -1L;
        String[] stringArray = new String[]{"_id"};
        String string2 = "server_id=?";
        String[] stringArray2 = new String[]{geofence.getId()};
        Cursor cursor = this.mAcc.a(A4SContract.Geofences.getContentUri(this.mContext), stringArray, string2, stringArray2, null);
        if (cursor != null) {
            int n2 = cursor.getCount();
            if (n2 > 0) {
                cursor.moveToFirst();
                l2 = cursor.getLong(0);
                if (n2 > 1) {
                    Log.warn("A4SGeofenceResolver|getGeofenceId|there are " + n2 + " instances of " + geofence);
                }
            }
            cursor.close();
        }
        return l2;
    }

    public long hasGeofenceGroup(String string2) {
        long l2 = -1L;
        String[] stringArray = new String[]{"_id"};
        String string3 = "server_id=?";
        String[] stringArray2 = new String[]{string2};
        Cursor cursor = this.mAcc.a(A4SContract.BeaconGeofenceGroups.getContentUri(this.mContext), stringArray, string3, stringArray2, null);
        if (cursor != null) {
            if (cursor.getCount() > 0) {
                cursor.moveToFirst();
                l2 = cursor.getLong(0);
            }
            cursor.close();
        }
        return l2;
    }

    public int getGeofencesCount() {
        int n2 = -1;
        String[] stringArray = new String[]{"_id"};
        Cursor cursor = this.mAcc.a(A4SContract.Geofences.getContentUri(this.mContext), stringArray, null, null, null);
        if (cursor != null) {
            n2 = cursor.getCount();
            cursor.close();
        }
        return n2;
    }

    public List<Geofence> getAllGeofences() {
        return this.getAllGeofences(null, null);
    }

    public List<Geofence> getAllGeofences(String string2, String[] stringArray) {
        ArrayList<Geofence> arrayList = null;
        String[] stringArray2 = new String[]{"_id", "server_id", "external_id", "name", "latitude", "longitude", "radius", "detected_time", "notified_time"};
        Cursor cursor = this.mAcc.a(A4SContract.Geofences.getContentUri(this.mContext), stringArray2, string2, stringArray, null);
        if (cursor != null) {
            if (cursor.moveToFirst()) {
                arrayList = new ArrayList<Geofence>(cursor.getCount());
                do {
                    long l2 = cursor.getLong(0);
                    Geofence geofence = new Geofence(cursor.getString(1));
                    geofence.setRowId(l2);
                    geofence.setExternalId(cursor.getString(2));
                    geofence.setName(cursor.getString(3));
                    geofence.setLatitude(cursor.getDouble(4));
                    geofence.setLongitude(cursor.getDouble(5));
                    geofence.setRadius(cursor.getInt(6));
                    geofence.setDetectedTime(e.convertStringToDate(cursor.getString(7)));
                    geofence.setNotifiedTime(e.convertStringToDate(cursor.getString(8)));
                    this.fillGeofenceParams(geofence);
                    this.fillGeofenceGroups(geofence);
                    arrayList.add(geofence);
                } while (cursor.moveToNext());
            }
            cursor.close();
        }
        return arrayList;
    }

    public List<Geofence> getGeofencesFilteredByGroups(String string2, String[] stringArray) {
        HashMap<String, Geofence> hashMap = new HashMap<String, Geofence>();
        String[] stringArray2 = new String[]{"geofences._id", "geofences.server_id", "geofences.external_id", "geofences.name", "geofences.latitude", "geofences.longitude", "geofences.radius", "geofences.detected_time", "geofences.notified_time"};
        Cursor cursor = this.mAcc.a(A4SContract.Geofences.getGroupsContentFilterUri(this.mContext), stringArray2, string2, stringArray, null);
        if (cursor != null) {
            if (cursor.moveToFirst()) {
                do {
                    long l2 = cursor.getLong(0);
                    String string3 = cursor.getString(1);
                    if (hashMap.containsKey(string3)) continue;
                    Geofence geofence = new Geofence(string3);
                    geofence.setRowId(l2);
                    geofence.setExternalId(cursor.getString(2));
                    geofence.setName(cursor.getString(3));
                    geofence.setLatitude(cursor.getDouble(4));
                    geofence.setLongitude(cursor.getDouble(5));
                    geofence.setRadius(cursor.getInt(6));
                    geofence.setDetectedTime(e.convertStringToDate(cursor.getString(7)));
                    geofence.setNotifiedTime(e.convertStringToDate(cursor.getString(8)));
                    this.fillGeofenceParams(geofence);
                    this.fillGeofenceGroups(geofence);
                    hashMap.put(string3, geofence);
                } while (cursor.moveToNext());
            }
            cursor.close();
        }
        if (hashMap.size() == 0) {
            return null;
        }
        return new ArrayList<Geofence>(hashMap.values());
    }

    public Geofence getGeofenceByClientId(String string2) {
        Geofence geofence = null;
        String[] stringArray = new String[]{"_id", "server_id", "external_id", "name", "latitude", "longitude", "radius", "detected_time", "notified_time"};
        String string3 = "server_id=?";
        String[] stringArray2 = new String[]{string2};
        Cursor cursor = this.mAcc.a(A4SContract.Geofences.getContentUri(this.mContext), stringArray, string3, stringArray2, null);
        if (cursor != null) {
            if (cursor.getCount() > 0) {
                cursor.moveToFirst();
                long l2 = cursor.getLong(0);
                geofence = new Geofence(Integer.toString(cursor.getInt(1)));
                geofence.setRowId(l2);
                geofence.setExternalId(cursor.getString(2));
                geofence.setName(cursor.getString(3));
                geofence.setLatitude(cursor.getDouble(4));
                geofence.setLongitude(cursor.getDouble(5));
                geofence.setRadius(cursor.getInt(6));
                geofence.setDetectedTime(e.convertStringToDate(cursor.getString(7)));
                geofence.setNotifiedTime(e.convertStringToDate(cursor.getString(8)));
                this.fillGeofenceParams(geofence);
                this.fillGeofenceGroups(geofence);
            }
            cursor.close();
        }
        return geofence;
    }

    public void fillGeofenceParams(Geofence geofence) {
        String[] stringArray = new String[]{"param_key", "param_value"};
        String string2 = "geofence_id=?";
        String[] stringArray2 = new String[]{Long.toString(geofence.getRowId())};
        Cursor cursor = this.mAcc.a(A4SContract.GeofenceParams.getContentUri(this.mContext), stringArray, string2, stringArray2, null);
        if (cursor != null) {
            if (cursor.moveToFirst()) {
                HashMap<String, String> hashMap = new HashMap<String, String>(cursor.getCount());
                do {
                    String string3 = cursor.getString(0);
                    String string4 = cursor.getString(1);
                    hashMap.put(string3, string4);
                } while (cursor.moveToNext());
                geofence.setCustomParams(hashMap);
            }
            cursor.close();
        }
    }

    public void fillGeofenceGroups(Geofence geofence) {
        String[] stringArray = new String[]{"server_id"};
        String string2 = "geofence_id=?";
        String[] stringArray2 = new String[]{Long.toString(geofence.getRowId())};
        Cursor cursor = this.mAcc.a(A4SContract.BeaconGeofenceGroups.getGeofencesContentFilterUri(this.mContext), stringArray, string2, stringArray2, null);
        if (cursor != null) {
            if (cursor.moveToFirst()) {
                HashSet<String> hashSet = new HashSet<String>(cursor.getCount());
                do {
                    String string3 = cursor.getString(0);
                    hashSet.add(string3);
                } while (cursor.moveToNext());
                geofence.setGroups(hashSet);
            }
            cursor.close();
        }
    }

    public long insertGeofence(Geofence geofence) {
        ContentValues contentValues = new ContentValues();
        contentValues.put("server_id", geofence.getId());
        contentValues.put("external_id", geofence.getExternalId());
        contentValues.put("name", geofence.getName());
        contentValues.put("latitude", Double.valueOf(geofence.getLatitude()));
        contentValues.put("longitude", Double.valueOf(geofence.getLongitude()));
        contentValues.put("radius", Float.valueOf(geofence.getRadius()));
        contentValues.put("detected_time", e.convertDateToString(geofence.getDetectedTime()));
        contentValues.put("notified_time", e.convertDateToString(geofence.getNotifiedTime()));
        Uri uri = this.mAcc.a(A4SContract.Geofences.getContentUri(this.mContext), contentValues);
        if (uri == null) {
            return -1L;
        }
        long l2 = Long.valueOf((String)uri.getPathSegments().get(1));
        Log.internal("A4SGeofenceResolver|INSERT geofence id=" + geofence.getId() + ", name: " + geofence.getName() + " at " + l2);
        if (geofence.getCustomParams().size() > 0) {
            this.insertGeofenceParams(l2, geofence.getCustomParams());
        }
        if (geofence.getGroups().size() > 0) {
            this.insertGeofenceGroups(l2, geofence.getGroups());
        }
        return l2;
    }

    public void insertGeofenceParams(long l2, Map<String, String> map) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            ContentValues contentValues = new ContentValues();
            contentValues.put("geofence_id", Long.valueOf(l2));
            contentValues.put("param_key", entry.getKey());
            contentValues.put("param_value", entry.getValue());
            this.mAcc.a(A4SContract.GeofenceParams.getContentUri(this.mContext), contentValues);
        }
    }

    public void insertGeofenceGroups(long l2, Set<String> set) {
        for (String string2 : set) {
            ContentValues contentValues;
            long l3 = this.hasGeofenceGroup(string2);
            if (l3 < 0L) {
                contentValues = new ContentValues();
                contentValues.put("server_id", string2);
                Uri uri = this.mAcc.a(A4SContract.BeaconGeofenceGroups.getContentUri(this.mContext), contentValues);
                l3 = Long.valueOf((String)uri.getPathSegments().get(1));
            }
            contentValues = new ContentValues();
            contentValues.put("geofence_id", Long.valueOf(l2));
            contentValues.put("group_id", Long.valueOf(l3));
            this.mAcc.a(A4SContract.GeofenceGroups.getContentUri(this.mContext), contentValues);
        }
    }

    public int insertGeofences(List<Geofence> list) {
        if (list == null || list.size() == 0) {
            Log.warn("A4SGeofenceResolver|bulkInsert no geofences");
            return 0;
        }
        int n2 = 0;
        ContentValues[] contentValuesArray = new ContentValues[list.size()];
        for (Geofence geofence : list) {
            ContentValues contentValues = new ContentValues();
            contentValues.put("server_id", geofence.getId());
            contentValues.put("external_id", geofence.getExternalId());
            contentValues.put("name", geofence.getName());
            contentValues.put("latitude", Double.valueOf(geofence.getLatitude()));
            contentValues.put("longitude", Double.valueOf(geofence.getLongitude()));
            contentValues.put("radius", Float.valueOf(geofence.getRadius()));
            contentValues.put("detected_time", e.convertDateToString(geofence.getDetectedTime()));
            contentValues.put("notified_time", e.convertDateToString(geofence.getNotifiedTime()));
            contentValuesArray[n2++] = contentValues;
        }
        int n3 = this.mAcc.a(A4SContract.Geofences.getContentUri(this.mContext), contentValuesArray);
        if (n3 != n2) {
            Log.error("A4SGeofenceResolver|bulkInsert hasn't inserted all geofences, needed=" + n2 + ", inserted=" + n3);
            return n3;
        }
        long l2 = this.hasGeofence(list.get(0).getId());
        if (l2 < 0L) {
            Log.error("A4SGeofenceResolver|bulkInsert an ID of the first inserted geofence is not found");
            return n3;
        }
        ArrayList<ContentValues> arrayList = new ArrayList<ContentValues>();
        ArrayList<ContentValues> arrayList2 = new ArrayList<ContentValues>();
        for (Geofence geofence : list) {
            ContentValues contentValues;
            if (geofence.getCustomParams().size() > 0) {
                for (Map.Entry entry : geofence.getCustomParams().entrySet()) {
                    contentValues = new ContentValues();
                    contentValues.put("geofence_id", Long.valueOf(l2));
                    contentValues.put("param_key", (String)entry.getKey());
                    contentValues.put("param_value", (String)entry.getValue());
                    arrayList.add(contentValues);
                }
            }
            if (geofence.getGroups().size() > 0) {
                for (String string2 : geofence.getGroups()) {
                    contentValues = new ContentValues();
                    contentValues.put("geofence_id", Long.valueOf(l2));
                    contentValues.put("server_id", string2);
                    arrayList2.add(contentValues);
                }
            }
            ++l2;
        }
        if (arrayList.size() > 0) {
            contentValuesArray = new ContentValues[arrayList.size()];
            this.mAcc.a(A4SContract.GeofenceParams.getContentUri(this.mContext), arrayList.toArray(contentValuesArray));
        }
        if (arrayList2.size() > 0) {
            contentValuesArray = new ContentValues[arrayList2.size()];
            this.mAcc.a(A4SContract.GeofenceGroups.getCustomContentUri(this.mContext), arrayList2.toArray(contentValuesArray));
        }
        return n3;
    }

    public int updateGeofence(Geofence geofence) {
        String[] stringArray;
        String string2;
        if (geofence.getRowId() > 0L) {
            string2 = "_id=?";
            stringArray = new String[]{String.valueOf(geofence.getRowId())};
        } else {
            string2 = "server_id=?";
            stringArray = new String[]{geofence.getId()};
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("external_id", geofence.getExternalId());
        contentValues.put("name", geofence.getName());
        contentValues.put("latitude", Double.valueOf(geofence.getLatitude()));
        contentValues.put("longitude", Double.valueOf(geofence.getLongitude()));
        contentValues.put("radius", Float.valueOf(geofence.getRadius()));
        contentValues.put("detected_time", e.convertDateToString(geofence.getDetectedTime()));
        contentValues.put("notified_time", e.convertDateToString(geofence.getNotifiedTime()));
        int n2 = this.mAcc.a(A4SContract.Geofences.getContentUri(this.mContext), contentValues, string2, stringArray);
        Log.internal("A4SGeofenceResolver|UPDATE geofence id=" + geofence.getId() + ", name: " + geofence.getName());
        long l2 = this.getGeofenceId(geofence);
        this.updateGeofenceParams(l2, geofence.getCustomParams());
        this.updateGeofenceGroups(l2, geofence.getGroups());
        return n2;
    }

    public void updateGeofenceParams(long l2, Map<String, String> map) {
        HashMap<String, String> hashMap = new HashMap<String, String>(map);
        String[] stringArray = new String[]{"_id", "param_key"};
        String string2 = "geofence_id=?";
        String[] stringArray2 = new String[]{Long.toString(l2)};
        Cursor cursor = this.mAcc.a(A4SContract.GeofenceParams.getContentUri(this.mContext), stringArray, string2, stringArray2, null);
        if (cursor != null) {
            if (cursor.moveToFirst()) {
                do {
                    int n2 = cursor.getInt(0);
                    Uri uri = Uri.withAppendedPath((Uri)A4SContract.GeofenceParams.getContentUri(this.mContext), (String)("/" + n2));
                    String string3 = cursor.getString(1);
                    if (map.containsKey(string3)) {
                        ContentValues contentValues = new ContentValues();
                        contentValues.put("param_value", map.get(string3));
                        this.mAcc.a(uri, contentValues, null, null);
                        hashMap.remove(string3);
                        continue;
                    }
                    this.mAcc.a(uri, null, null);
                } while (cursor.moveToNext());
            }
            cursor.close();
        }
        if (hashMap.size() > 0) {
            this.insertGeofenceParams(l2, hashMap);
        }
    }

    public void updateGeofenceGroups(long l2, Set<String> set) {
        HashSet<String> hashSet = new HashSet<String>(set);
        String[] stringArray = new String[]{"beacon_geofence_groups._id", "server_id", "geofence_groups._id"};
        String string2 = "geofence_id=?";
        String[] stringArray2 = new String[]{Long.toString(l2)};
        Cursor cursor = this.mAcc.a(A4SContract.BeaconGeofenceGroups.getGeofencesContentFilterUri(this.mContext), stringArray, string2, stringArray2, null);
        if (cursor != null) {
            if (cursor.moveToFirst()) {
                do {
                    int n2 = cursor.getInt(0);
                    String string3 = cursor.getString(1);
                    int n3 = cursor.getInt(2);
                    if (set.contains(string3)) {
                        hashSet.remove(string3);
                        continue;
                    }
                    Uri uri = Uri.withAppendedPath((Uri)A4SContract.BeaconGeofenceGroups.getContentUri(this.mContext), (String)("/" + n2));
                    this.mAcc.a(uri, null, null);
                    uri = Uri.withAppendedPath((Uri)A4SContract.GeofenceGroups.getContentUri(this.mContext), (String)("/" + n3));
                    this.mAcc.a(uri, null, null);
                } while (cursor.moveToNext());
            }
            cursor.close();
        }
        if (hashSet.size() > 0) {
            this.insertGeofenceGroups(l2, hashSet);
        }
    }

    public void updateGeofences(List<Geofence> list) {
        for (Geofence geofence : list) {
            if (this.hasGeofence(geofence.getId()) < 0L) {
                if (geofence.isNeedToBeRemoved()) continue;
                this.insertGeofence(geofence);
                continue;
            }
            if (geofence.isNeedToBeRemoved()) {
                this.deleteGeofence(geofence);
                continue;
            }
            this.updateGeofence(geofence);
        }
    }

    public int deleteGeofence(Geofence geofence) {
        long l2 = geofence.getRowId() > 0L ? geofence.getRowId() : this.getGeofenceId(geofence);
        Uri uri = Uri.withAppendedPath((Uri)A4SContract.Geofences.getContentUri(this.mContext), (String)String.valueOf(l2));
        int n2 = this.mAcc.a(uri, null, null);
        Log.internal("BeaconHelper|DELETE geofence id=" + geofence.getId() + ", name: " + geofence.getName() + " at " + l2);
        this.mAcc.a(A4SContract.GeofenceParams.getContentUri(this.mContext), "geofence_id=" + l2, null);
        return n2;
    }

    public void deleteBeacons(List<Geofence> list) {
        ArrayList<ContentProviderOperation> arrayList = new ArrayList<ContentProviderOperation>(list.size());
        if (Build.VERSION.SDK_INT >= 5) {
            for (Geofence geofence : list) {
                arrayList.add(ContentProviderOperation.newDelete((Uri)A4SContract.Beacons.getContentUri(this.mContext)).withSelection("server_id=" + geofence.getId(), null).build());
            }
            try {
                this.mAcc.a(arrayList);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public int deleteAllGeofences() {
        int n2 = this.mAcc.a(A4SContract.Geofences.getContentUri(this.mContext), null, null);
        this.mAcc.a(A4SContract.GeofenceParams.getContentUri(this.mContext), null, null);
        this.mAcc.a(A4SContract.GeofenceGroups.getContentUri(this.mContext), null, null);
        return n2;
    }
}

