/*
 * Decompiled with CFR 0.152.
 */
package com.ad4screen.sdk.plugins.model;

import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import com.ad4screen.sdk.c.a.d;
import com.ad4screen.sdk.common.c.c;
import com.ad4screen.sdk.common.c.d;
import com.ad4screen.sdk.provider.A4SBeaconResolver;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Beacon
implements Parcelable,
c<Beacon>,
d {
    public static final int UNKNOWN_BEACON = 0;
    public static final String KEY_NAME = "name";
    public static final String KEY_CUSTOM_PARAMS = "data";
    public static final String KEY_GROUPS = "groups";
    public static final String KEY_EXTERNAL_ID = "externalId";
    private static final String CLASS_KEY = "com.ad4screen.sdk.plugins.model.Beacon";
    public long rowId = -1L;
    public String id;
    public String externalId = "";
    public boolean isNeedToBeRemoved = false;
    public String name = "";
    public Map<String, String> customs = new HashMap<String, String>();
    public String uuid = "";
    public int minor = -1;
    public int major = -1;
    private Set<String> mGroups = new HashSet<String>();
    private Date mDetectedTime = new Date(0L);
    private Date mNotifiedTime = new Date(0L);
    public static final Parcelable.Creator<Beacon> CREATOR = new Parcelable.Creator<Beacon>(){

        public Beacon createFromParcel(Parcel parcel) {
            return new Beacon(parcel);
        }

        public Beacon[] newArray(int n2) {
            return new Beacon[n2];
        }
    };

    public Beacon() {
    }

    public Beacon(String string2) {
        this.id = string2;
    }

    public Beacon(String string2, String string3, int n2, int n3) {
        this.id = string2;
        this.uuid = string3;
        this.major = n2;
        this.minor = n3;
    }

    public Beacon(int n2, String string2, int n3, int n4) {
        this.id = Integer.toString(n2);
        this.uuid = string2;
        this.major = n3;
        this.minor = n4;
    }

    public Set<String> getGroups() {
        return this.mGroups;
    }

    public void setGroups(Set<String> set) {
        this.mGroups = set;
    }

    public void parseGroups(JSONObject jSONObject) throws JSONException {
        JSONArray jSONArray = jSONObject.getJSONArray(KEY_GROUPS);
        for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
            String string2 = jSONArray.getString(i2);
            this.mGroups.add(string2);
        }
    }

    public Date getDetectedTime() {
        return new Date(this.mDetectedTime.getTime());
    }

    public void setDetectedTime(Date date) {
        this.mDetectedTime = new Date(date.getTime());
    }

    public Date getNotifiedTime() {
        return new Date(this.mNotifiedTime.getTime());
    }

    public void setNotifiedTime(Date date) {
        this.mNotifiedTime = new Date(date.getTime());
    }

    @Override
    public Beacon fromJSON(String string2) throws JSONException {
        JSONObject jSONObject = new JSONObject(string2);
        Beacon beacon = new Beacon(jSONObject.getString("id"));
        beacon.rowId = jSONObject.getLong("rowId");
        beacon.externalId = jSONObject.getString(KEY_EXTERNAL_ID);
        beacon.uuid = jSONObject.getString("uuid");
        beacon.isNeedToBeRemoved = jSONObject.getBoolean("enabled");
        beacon.major = jSONObject.getInt("major");
        beacon.minor = jSONObject.getInt("minor");
        if (!jSONObject.isNull(KEY_CUSTOM_PARAMS)) {
            beacon.parseCustomParams(jSONObject);
        }
        if (!jSONObject.isNull(KEY_GROUPS)) {
            beacon.parseGroups(jSONObject);
        }
        return beacon;
    }

    public void parseCustomParams(JSONObject jSONObject) throws JSONException {
        JSONObject jSONObject2 = jSONObject.getJSONObject(KEY_CUSTOM_PARAMS);
        Iterator iterator = jSONObject2.keys();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            String string3 = jSONObject2.getString(string2);
            if (this.customs.containsKey(string2)) {
                throw new JSONException(string2 + " already exists beacon: " + this.id);
            }
            this.customs.put(string2, string3);
        }
    }

    @Override
    public String getClassKey() {
        return CLASS_KEY;
    }

    @Override
    public JSONObject toJSON() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("id", (Object)this.id);
        jSONObject.put("rowId", this.rowId);
        jSONObject.put(KEY_EXTERNAL_ID, (Object)this.externalId);
        jSONObject.put("uuid", (Object)this.uuid);
        jSONObject.put("enabled", this.isNeedToBeRemoved);
        jSONObject.put("major", this.major);
        jSONObject.put("minor", this.minor);
        JSONObject jSONObject2 = new JSONObject();
        for (Map.Entry<String, String> object : this.customs.entrySet()) {
            String string2 = object.getKey();
            String string3 = object.getValue();
            jSONObject2.put(string2, (Object)string3);
        }
        jSONObject.put(KEY_CUSTOM_PARAMS, (Object)jSONObject2);
        JSONArray jSONArray = new JSONArray();
        for (String string2 : this.mGroups) {
            jSONArray.put((Object)string2);
        }
        jSONObject.put(KEY_GROUPS, (Object)jSONArray);
        return jSONObject;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n2) {
        parcel.writeString(this.id);
        parcel.writeLong(this.rowId);
        parcel.writeString(this.externalId);
        parcel.writeString(this.uuid);
        parcel.writeInt(this.major);
        parcel.writeInt(this.minor);
        parcel.writeInt(this.isNeedToBeRemoved ? 1 : 0);
        parcel.writeInt(this.customs.size());
        for (Map.Entry<String, String> object : this.customs.entrySet()) {
            parcel.writeString(object.getKey());
            parcel.writeString(object.getValue());
        }
        parcel.writeInt(this.mGroups.size());
        for (String string2 : this.mGroups) {
            parcel.writeString(string2);
        }
    }

    public Beacon(Parcel parcel) {
        String string2;
        int n2;
        this.id = parcel.readString();
        this.rowId = parcel.readLong();
        this.externalId = parcel.readString();
        this.uuid = parcel.readString();
        this.major = parcel.readInt();
        this.minor = parcel.readInt();
        this.isNeedToBeRemoved = parcel.readInt() == 1;
        int n3 = parcel.readInt();
        this.customs = new HashMap<String, String>(n3);
        for (n2 = 0; n2 < n3; ++n2) {
            string2 = parcel.readString();
            String string3 = parcel.readString();
            this.customs.put(string2, string3);
        }
        n3 = parcel.readInt();
        this.mGroups = new HashSet<String>(n3);
        for (n2 = 0; n2 < n3; ++n2) {
            string2 = parcel.readString();
            this.mGroups.add(string2);
        }
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.id == null ? 0 : this.id.hashCode());
        return n3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Beacon beacon = (Beacon)object;
        return !(this.id == null ? beacon.id != null : !this.id.equals(beacon.id));
    }

    public String toString() {
        return "Beacon: " + this.id + ", name: " + this.name + ", externalId: " + this.externalId + ", uuid: " + this.uuid + ", major: " + String.valueOf(this.major) + ", minor: " + String.valueOf(this.minor);
    }

    public static class PersonalParamsReplacer
    implements d.a {
        private A4SBeaconResolver mResolver;
        private Beacon mBeacon;

        public PersonalParamsReplacer(Context context, String string2) {
            this.mResolver = new A4SBeaconResolver(context);
            this.mBeacon = this.mResolver.getBeaconByClientId(string2);
        }

        @Override
        public void onPersonalParamFound(String string2, StringBuffer stringBuffer) {
            if (Beacon.KEY_NAME.equals(string2)) {
                stringBuffer.append(this.mBeacon.name);
            } else if (this.mBeacon.customs.containsKey(string2)) {
                stringBuffer.append(this.mBeacon.customs.get(string2));
            }
        }
    }
}

