/*
 * Decompiled with CFR 0.152.
 */
package com.ad4screen.sdk.analytics;

import android.os.Parcel;
import android.os.Parcelable;
import com.ad4screen.sdk.analytics.Item;
import com.ad4screen.sdk.common.annotations.API;
import com.ad4screen.sdk.common.c.d;
import com.ad4screen.sdk.common.c.e;
import java.util.Currency;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@API
public class Purchase
implements Parcelable,
d,
Cloneable {
    public static final String KEY_ID = "purchaseId";
    public static final String KEY_CURRENCY = "currency";
    public static final String KEY_TOTAL_PRICE = "total";
    public static final String KEY_ITEMS = "items";
    private String a;
    private String b;
    private double c;
    private Item[] d;
    public static final Parcelable.Creator<Purchase> CREATOR = new Parcelable.Creator<Purchase>(){

        public Purchase a(Parcel parcel) {
            return new Purchase(parcel);
        }

        public Purchase[] a(int n2) {
            return new Purchase[n2];
        }

        public /* synthetic */ Object[] newArray(int n2) {
            return this.a(n2);
        }

        public /* synthetic */ Object createFromParcel(Parcel parcel) {
            return this.a(parcel);
        }
    };

    public Purchase(String string, String string2, double d2) throws IllegalArgumentException {
        this.setId(string);
        this.setCurrency(string2);
        this.setTotalPrice(d2);
    }

    public Purchase(String string, String string2, double d2, Item[] itemArray) {
        this.setId(string);
        this.setCurrency(string2);
        this.setTotalPrice(d2);
        this.setItems(itemArray);
    }

    public String getId() {
        return this.a;
    }

    public void setId(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Purchase id cannot be null");
        }
        this.a = string;
    }

    public String getCurrency() {
        return this.b;
    }

    public void setCurrency(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("Purchase currency cannot be null and should be in ISO4217 format (3 letters)");
        }
        if (string.length() < 3) {
            throw new IllegalArgumentException("Purchase currency should be in ISO4217 format (3 letters)");
        }
        String string2 = Currency.getInstance(string.substring(0, 3).toUpperCase(Locale.US)).getCurrencyCode();
        if (string2.equals("XXX")) {
            throw new IllegalArgumentException("Purchase currency can't be XXX (no currency)");
        }
        this.b = string2;
    }

    public double getTotalPrice() {
        return this.c;
    }

    public void setTotalPrice(double d2) {
        this.c = d2;
    }

    public Item[] getItems() {
        return this.d;
    }

    public void setItems(Item[] itemArray) {
        this.d = itemArray;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n2) {
        parcel.writeString(this.a);
        parcel.writeString(this.b);
        parcel.writeArray((Object[])this.d);
        parcel.writeDouble(this.c);
    }

    private Purchase(Parcel parcel) {
        this.a = parcel.readString();
        this.b = parcel.readString();
        Object[] objectArray = parcel.readArray(this.getClass().getClassLoader());
        if (objectArray != null) {
            this.d = new Item[objectArray.length];
            System.arraycopy(objectArray, 0, this.d, 0, objectArray.length);
        }
        this.c = parcel.readDouble();
    }

    public Object clone() throws CloneNotSupportedException {
        Purchase purchase = (Purchase)super.clone();
        if (this.d != null) {
            Item[] itemArray = new Item[this.d.length];
            for (int i2 = 0; i2 < this.d.length; ++i2) {
                itemArray[i2] = (Item)this.d[i2].clone();
            }
            purchase.d = itemArray;
        }
        return purchase;
    }

    @Override
    public JSONObject toJSON() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put(KEY_CURRENCY, (Object)this.b);
        if (this.d != null) {
            JSONArray jSONArray = new JSONArray();
            e e2 = new e();
            for (int i2 = 0; i2 < this.d.length; ++i2) {
                JSONObject jSONObject2 = e2.a(this.d[i2]);
                jSONObject2.remove("articleId");
                jSONObject2.put("id", (Object)this.d[i2].getId());
                jSONArray.put((Object)jSONObject2);
            }
            jSONObject.put(KEY_ITEMS, (Object)jSONArray);
        }
        jSONObject.put(KEY_TOTAL_PRICE, this.c);
        jSONObject.put(KEY_ID, (Object)this.a);
        return jSONObject;
    }
}

