/*
 * Decompiled with CFR 0.152.
 */
package com.ad4screen.sdk.plugins.GooglePlayServices.common;

import android.app.Service;
import android.content.ComponentName;
import android.content.Context;
import android.content.pm.ServiceInfo;
import com.ad4screen.sdk.Log;
import com.google.android.gms.common.GooglePlayServicesUtil;

public class Utils {
    public static boolean checkPlayServices(Context context) {
        try {
            int resultCode = GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)context);
            return resultCode == 0;
        }
        catch (NoClassDefFoundError e) {
            Log.error((String)"Plugin|GooglePlayServices not found. Please add GooglePlayServices Library to your app", (Throwable)e);
        }
        catch (Exception e) {
            Log.error((String)"Plugin|Error while checking Google Play Services", (Throwable)e);
        }
        return false;
    }

    public static boolean isServiceDeclared(Context context, Class<? extends Service> service) {
        if (context == null) {
            return false;
        }
        Context appContext = context.getApplicationContext();
        try {
            appContext.getPackageManager().getServiceInfo(new ComponentName(appContext, service), 128);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String loadServiceMetadata(Context context, String key, Class<? extends Service> service) {
        if (context == null) {
            return null;
        }
        Context appContext = context.getApplicationContext();
        try {
            ServiceInfo info = appContext.getPackageManager().getServiceInfo(new ComponentName(appContext, service), 128);
            if (info.metaData == null) {
                return null;
            }
            if (!info.metaData.containsKey(key)) {
                return null;
            }
            return info.metaData.get(key).toString();
        }
        catch (Exception e) {
            Log.internal((String)"Could not load service metadata", (Throwable)e);
            return null;
        }
    }
}

