/*
 * Decompiled with CFR 0.152.
 */
package com.ad4screen.sdk.plugins.GooglePlayServices.managers;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import com.ad4screen.sdk.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.location.LocationServices;
import java.util.List;

public class GeofenceRemover
implements GoogleApiClient.ConnectionCallbacks,
GoogleApiClient.OnConnectionFailedListener,
ResultCallback<Status> {
    private static final int DEFAULT_BACKOFF_MS = 3000;
    private static final int MAX_BACKOFF_MS = 3600000;
    private int mCurrentBackoff = 3000;
    private Context mContext;
    private List<String> mGeofencesToRemove;
    private GoogleApiClient mLocationClient;
    private boolean mInProgress;
    private OnGeofencesRemoveListener mListener;

    public GeofenceRemover(Context context, OnGeofencesRemoveListener listener) {
        this.mContext = context;
        this.mGeofencesToRemove = null;
        this.mLocationClient = null;
        this.mInProgress = false;
        this.mListener = listener;
    }

    public void setInProgressFlag(boolean flag) {
        this.mInProgress = flag;
    }

    public boolean getInProgressFlag() {
        return this.mInProgress;
    }

    public void removeGeofencesById(List<String> geofenceIds) {
        if (null == geofenceIds || geofenceIds.size() == 0) {
            return;
        }
        if (!this.mInProgress) {
            this.mGeofencesToRemove = geofenceIds;
            this.requestConnection();
        } else {
            this.retry();
        }
    }

    private void continueRemoveGeofences() {
        LocationServices.GeofencingApi.removeGeofences(this.mLocationClient, this.mGeofencesToRemove).setResultCallback((ResultCallback)this);
    }

    private void requestConnection() {
        this.getLocationClient().connect();
    }

    private GoogleApiClient getLocationClient() {
        if (this.mLocationClient == null) {
            this.mLocationClient = new GoogleApiClient.Builder(this.mContext).addConnectionCallbacks((GoogleApiClient.ConnectionCallbacks)this).addOnConnectionFailedListener((GoogleApiClient.OnConnectionFailedListener)this).addApi(LocationServices.API).build();
        }
        return this.mLocationClient;
    }

    private void requestDisconnection() {
        this.mInProgress = false;
        this.getLocationClient().disconnect();
        Log.debug((String)"Geofence Plugin|Location client disconnected");
    }

    public void onConnected(Bundle arg0) {
        try {
            this.mCurrentBackoff = 3000;
            Log.debug((String)"Geofence Plugin|Location client connected");
            this.continueRemoveGeofences();
        }
        catch (IllegalStateException e) {
            Log.debug((String)"Geofence Plugin|Location client error, retrying", (Throwable)e);
            this.mLocationClient.connect();
        }
    }

    public void onConnectionSuspended(int code) {
        this.mInProgress = false;
        Log.debug((String)"Geofence Plugin|Location client connection lost");
        this.mLocationClient = null;
    }

    public void onConnectionFailed(ConnectionResult connectionResult) {
        this.mInProgress = false;
        Log.debug((String)"Geofence Plugin|Connection failed to Location client");
        this.retry();
    }

    private void retry() {
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                if (GeofenceRemover.this.mGeofencesToRemove != null && GeofenceRemover.this.mGeofencesToRemove.size() > 0) {
                    GeofenceRemover.this.removeGeofencesById(GeofenceRemover.this.mGeofencesToRemove);
                }
            }
        }, (long)this.mCurrentBackoff);
        this.mCurrentBackoff *= 2;
        if (this.mCurrentBackoff > 3600000) {
            this.mCurrentBackoff = 3600000;
        }
    }

    public void onResult(Status status) {
        int statusCode = status.getStatusCode();
        String[] geofences = new String[this.mGeofencesToRemove.size()];
        this.mGeofencesToRemove.toArray(geofences);
        if (0 == statusCode) {
            if (this.mListener != null) {
                this.mListener.onGeofencesRemoved(geofences);
            }
            for (int i = 0; i < geofences.length; ++i) {
                this.mGeofencesToRemove.remove(geofences[i]);
            }
        }
        this.requestDisconnection();
    }

    public static interface OnGeofencesRemoveListener {
        public void onGeofencesRemoved(String[] var1);
    }
}

