/*
 * Decompiled with CFR 0.152.
 */
package com.ad4screen.sdk.plugins.GooglePlayServices;

import android.content.Context;
import com.ad4screen.sdk.A4SGeofencingService;
import com.ad4screen.sdk.Log;
import com.ad4screen.sdk.plugins.GeofencePlugin;
import com.ad4screen.sdk.plugins.GooglePlayServices.common.Utils;
import com.ad4screen.sdk.plugins.GooglePlayServices.managers.GeofenceRemover;
import com.ad4screen.sdk.plugins.GooglePlayServices.managers.GeofenceRequester;
import com.ad4screen.sdk.plugins.GooglePlayServices.model.SimpleGeofence;
import com.ad4screen.sdk.plugins.model.Geofence;
import java.util.ArrayList;

public class Geofencing
implements GeofencePlugin {
    private static final int PLUGIN_VERSION = 2;
    private GeofenceRequester requester;
    private GeofenceRemover remover;
    private ArrayList<com.google.android.gms.location.Geofence> mGeofencesToAdd;
    private ArrayList<String> mGeofencesToRemove;

    public int getPluginVersion() {
        return 2;
    }

    public void add(Context context, Geofence[] geofences) {
        if (!Utils.checkPlayServices(context)) {
            Log.error((String)"Geofence Plugin|Google Play Services unavailable");
            return;
        }
        try {
            if (this.requester == null) {
                this.requester = new GeofenceRequester(context, new GeofenceRequester.onGeofenceRequestListener(){

                    @Override
                    public void onGeofencesAdded(String[] ids) {
                        Log.debug((String)("Geofence Plugin|Added " + ids.length + " geofences"));
                        for (int i = 0; i < ids.length; ++i) {
                            for (int j = 0; j < Geofencing.this.mGeofencesToAdd.size(); ++j) {
                                if (!((com.google.android.gms.location.Geofence)Geofencing.this.mGeofencesToAdd.get(j)).getRequestId().equals(ids[i])) continue;
                                Geofencing.this.mGeofencesToAdd.remove(j);
                            }
                        }
                    }
                });
            }
            if (this.mGeofencesToAdd == null) {
                this.mGeofencesToAdd = new ArrayList();
            }
            for (int i = 0; i < geofences.length; ++i) {
                this.mGeofencesToAdd.add(new SimpleGeofence(geofences[i].id, geofences[i].latitude, geofences[i].longitude, geofences[i].radius, -1L, 3).toGeofence());
            }
            this.requester.addGeofences(this.mGeofencesToAdd);
        }
        catch (Exception e) {
            Log.error((String)"Geofence Plugin|Exception occured when adding Geofence", (Throwable)e);
        }
        catch (Error e) {
            Log.error((String)"Geofence Plugin|Error occured when adding Geofence", (Throwable)e);
        }
    }

    public void remove(Context context, String[] ids) {
        if (!Utils.checkPlayServices(context)) {
            Log.error((String)"Geofence Plugin|Google Play Services unavailable");
            return;
        }
        try {
            if (this.remover == null) {
                this.remover = new GeofenceRemover(context, new GeofenceRemover.OnGeofencesRemoveListener(){

                    @Override
                    public void onGeofencesRemoved(String[] ids) {
                        Log.debug((String)("Geofence Plugin|Removed " + ids.length + " geofences"));
                        for (int i = 0; i < ids.length; ++i) {
                            Geofencing.this.mGeofencesToRemove.remove(ids[i]);
                        }
                    }
                });
            }
            if (this.mGeofencesToRemove == null) {
                this.mGeofencesToRemove = new ArrayList();
            }
            for (int i = 0; i < ids.length; ++i) {
                this.mGeofencesToRemove.add(ids[i]);
            }
            this.remover.removeGeofencesById(this.mGeofencesToRemove);
        }
        catch (Exception e) {
            Log.error((String)"Geofence Plugin|Exception occured when removing Geofence", (Throwable)e);
        }
        catch (Error e) {
            Log.error((String)"Geofence Plugin|Error occured when removing Geofence", (Throwable)e);
        }
    }

    public boolean isGeofencingServiceDeclared(Context context) {
        return Utils.isServiceDeclared(context, A4SGeofencingService.class);
    }
}

