/*
 * Decompiled with CFR 0.152.
 */
package com.ad4screen.sdk.plugins.GooglePlayServices;

import android.content.Context;
import android.content.Intent;
import com.ad4screen.sdk.Log;
import com.ad4screen.sdk.plugins.GCMPlugin;
import com.ad4screen.sdk.plugins.GooglePlayServices.common.Utils;
import com.google.android.gms.gcm.GoogleCloudMessaging;
import java.io.IOException;

public class GCM
implements GCMPlugin {
    private static final int PLUGIN_VERSION = 1;
    private GoogleCloudMessaging mGcm;
    private String mRegistrationId;

    public int getPluginVersion() {
        return 1;
    }

    public String register(Context context, String senderId) {
        try {
            if (Utils.checkPlayServices(context)) {
                this.mGcm = GoogleCloudMessaging.getInstance((Context)context);
                this.mRegistrationId = this.mGcm.register(new String[]{senderId});
            }
        }
        catch (Exception e) {
            Log.error((String)"Plugin|Error occured when registering to GCM", (Throwable)e);
        }
        catch (Error e) {
            Log.error((String)"Plugin|Error occured when registering to GCM", (Throwable)e);
        }
        return this.mRegistrationId;
    }

    public boolean unregister(Context context) {
        try {
            if (Utils.checkPlayServices(context)) {
                this.mGcm = GoogleCloudMessaging.getInstance((Context)context);
                this.mGcm.unregister();
                this.sendGcmUnregistrationBroadcast(context);
                return true;
            }
        }
        catch (IOException e) {
            Log.error((String)"Plugin|Exception occured when unregistering to GCM", (Throwable)e);
        }
        catch (Error e) {
            Log.error((String)"Plugin|Error occured when unregistering to GCM", (Throwable)e);
        }
        return false;
    }

    private void sendGcmUnregistrationBroadcast(Context context) {
        Intent intent = new Intent("com.google.android.c2dm.intent.REGISTRATION");
        intent.setPackage(context.getPackageName());
        intent.putExtra("unregistered", context.getPackageName());
        context.sendBroadcast(intent);
    }
}

