/*
 * Decompiled with CFR 0.152.
 */
package com.ad4screen.sdk.plugins.badger.badgers;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import com.ad4screen.sdk.plugins.badger.Badger;
import com.ad4screen.sdk.plugins.badger.BadgerException;
import com.ad4screen.sdk.plugins.badger.util.BroadcastHelper;
import java.util.Arrays;
import java.util.List;

public class DefaultBadger
implements Badger {
    private static final String INTENT_ACTION = "android.intent.action.BADGE_COUNT_UPDATE";
    private static final String INTENT_EXTRA_BADGE_COUNT = "badge_count";
    private static final String INTENT_EXTRA_PACKAGENAME = "badge_count_package_name";
    private static final String INTENT_EXTRA_ACTIVITY_NAME = "badge_count_class_name";

    @Override
    public void executeBadge(Context context, ComponentName componentName, int n) throws BadgerException {
        Intent intent;
        DefaultBadger defaultBadger = this = intent;
        defaultBadger(INTENT_ACTION);
        defaultBadger.putExtra(INTENT_EXTRA_BADGE_COUNT, n);
        this.putExtra(INTENT_EXTRA_PACKAGENAME, componentName.getPackageName());
        intent.putExtra(INTENT_EXTRA_ACTIVITY_NAME, componentName.getClassName());
        if (BroadcastHelper.canResolveBroadcast(context, intent)) {
            context.sendBroadcast((Intent)this);
            return;
        }
        throw new BadgerException("unable to resolve intent: " + this.toString());
    }

    @Override
    public List<String> getSupportLaunchers() {
        return Arrays.asList("fr.neamar.kiss", "com.quaap.launchtime", "com.quaap.launchtime_official");
    }

    boolean isSupported(Context context) {
        return BroadcastHelper.canResolveBroadcast(context, new Intent(INTENT_ACTION));
    }
}

