/*
 * Decompiled with CFR 0.152.
 */
package com.ad4screen.sdk.plugins.badger.badgers;

import android.annotation.TargetApi;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import com.ad4screen.sdk.plugins.badger.Badger;
import com.ad4screen.sdk.plugins.badger.BadgerException;
import com.ad4screen.sdk.plugins.badger.util.BroadcastHelper;
import com.ad4screen.sdk.plugins.badger.util.CloseHelper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;

public class OPPOHomeBader
implements Badger {
    private static final String PROVIDER_CONTENT_URI = "content://com.android.badge/badge";
    private static final String INTENT_ACTION = "com.oppo.unsettledevent";
    private static final String INTENT_EXTRA_PACKAGENAME = "pakeageName";
    private static final String INTENT_EXTRA_BADGE_COUNT = "number";
    private static final String INTENT_EXTRA_BADGE_UPGRADENUMBER = "upgradeNumber";
    private static final String INTENT_EXTRA_BADGEUPGRADE_COUNT = "app_badge_count";
    private static int ROMVERSION = -1;

    @Override
    @TargetApi(value=11)
    public void executeBadge(Context context, ComponentName componentName, int n) throws BadgerException {
        if (n == 0) {
            n = -1;
        }
        Intent intent = new Intent(INTENT_ACTION);
        intent.putExtra(INTENT_EXTRA_PACKAGENAME, componentName.getPackageName());
        intent.putExtra(INTENT_EXTRA_BADGE_COUNT, n);
        intent.putExtra(INTENT_EXTRA_BADGE_UPGRADENUMBER, n);
        if (BroadcastHelper.canResolveBroadcast(context, intent)) {
            context.sendBroadcast(intent);
        } else {
            int n2 = this.getSupportVersion();
            if (n2 == 6) {
                try {
                    Bundle bundle = new Bundle();
                    bundle.putInt(INTENT_EXTRA_BADGEUPGRADE_COUNT, n);
                    context.getContentResolver().call(Uri.parse((String)PROVIDER_CONTENT_URI), "setAppBadgeCount", null, bundle);
                }
                catch (Throwable throwable) {
                    throw new BadgerException("unable to resolve intent: " + intent.toString());
                }
            }
        }
    }

    @Override
    public List<String> getSupportLaunchers() {
        return Collections.singletonList("com.oppo.launcher");
    }

    private int getSupportVersion() {
        int n = ROMVERSION;
        if (n >= 0) {
            return ROMVERSION;
        }
        try {
            n = (Integer)this.executeClassLoad(this.getClass("com.color.os.ColorBuild"), "getColorOSVERSION", null, null);
        }
        catch (Exception exception) {
            n = 0;
        }
        if (n == 0) {
            try {
                String string = this.getSystemProperty("ro.build.version.opporom");
                if (string.startsWith("V1.4")) {
                    return 3;
                }
                if (string.startsWith("V2.0")) {
                    return 4;
                }
                if (string.startsWith("V2.1")) {
                    return 5;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        ROMVERSION = n;
        return ROMVERSION;
    }

    private Object executeClassLoad(Class clazz, String string, Class[] classArray, Object[] objectArray) {
        Method method;
        Object object = null;
        if (clazz != null && !this.checkObjExists(string) && (method = this.getMethod(clazz, string, classArray)) != null) {
            method.setAccessible(true);
            try {
                object = method.invoke(null, objectArray);
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
        }
        return object;
    }

    private Method getMethod(Class clazz, String string, Class[] classArray) {
        Method method = null;
        if (clazz == null || this.checkObjExists(string)) {
            return method;
        }
        try {
            clazz.getMethods();
            clazz.getDeclaredMethods();
            return clazz.getDeclaredMethod(string, classArray);
        }
        catch (Exception exception) {
            try {
                return clazz.getMethod(string, classArray);
            }
            catch (Exception exception2) {
                return clazz.getSuperclass() != null ? this.getMethod(clazz.getSuperclass(), string, classArray) : method;
            }
        }
    }

    private Class getClass(String string) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return clazz;
    }

    private boolean checkObjExists(Object object) {
        return object == null || object.toString().equals("") || object.toString().trim().equals("null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getSystemProperty(String string) {
        String string2;
        BufferedReader bufferedReader = null;
        try {
            Process process = Runtime.getRuntime().exec("getprop " + string);
            bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()), 1024);
            string2 = bufferedReader.readLine();
            bufferedReader.close();
            CloseHelper.closeQuietly(bufferedReader);
        }
        catch (IOException iOException) {
            String string3 = null;
            return string3;
        }
        finally {
            CloseHelper.closeQuietly(bufferedReader);
        }
        return string2;
    }
}

