/*
 * Decompiled with CFR 0.152.
 */
package com.ad4screen.sdk.plugins.badger.badgers;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import com.ad4screen.sdk.plugins.badger.Badger;
import com.ad4screen.sdk.plugins.badger.BadgerException;
import com.ad4screen.sdk.plugins.badger.util.BroadcastHelper;
import java.util.Collections;
import java.util.List;

public class HtcHomeBadger
implements Badger {
    private static final String INTENT_UPDATE_SHORTCUT = "com.htc.launcher.action.UPDATE_SHORTCUT";
    private static final String INTENT_SET_NOTIFICATION = "com.htc.launcher.action.SET_NOTIFICATION";
    private static final String PACKAGENAME = "packagename";
    private static final String COUNT = "count";
    private static final String EXTRA_COMPONENT = "com.htc.launcher.extra.COMPONENT";
    private static final String EXTRA_COUNT = "com.htc.launcher.extra.COUNT";

    @Override
    public void executeBadge(Context context, ComponentName componentName, int n) throws BadgerException {
        Intent intent = new Intent(INTENT_SET_NOTIFICATION);
        intent.putExtra(EXTRA_COMPONENT, componentName.flattenToShortString());
        intent.putExtra(EXTRA_COUNT, n);
        Intent intent2 = new Intent(INTENT_UPDATE_SHORTCUT);
        intent2.putExtra(PACKAGENAME, componentName.getPackageName());
        intent2.putExtra(COUNT, n);
        if (!BroadcastHelper.canResolveBroadcast(context, intent) && !BroadcastHelper.canResolveBroadcast(context, intent2)) {
            throw new BadgerException("unable to resolve intent: " + intent2.toString());
        }
        context.sendBroadcast(intent);
        context.sendBroadcast(intent2);
    }

    @Override
    public List<String> getSupportLaunchers() {
        return Collections.singletonList("com.htc.launcher");
    }
}

