/*
 * Decompiled with CFR 0.152.
 */
package com.ad4screen.sdk.plugins.badger;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.os.Build;
import android.util.Log;
import com.ad4screen.sdk.plugins.BadgerPlugin;
import com.ad4screen.sdk.plugins.badger.Badger;
import com.ad4screen.sdk.plugins.badger.BadgerException;
import com.ad4screen.sdk.plugins.badger.badgers.AdwHomeBadger;
import com.ad4screen.sdk.plugins.badger.badgers.ApexHomeBadger;
import com.ad4screen.sdk.plugins.badger.badgers.AsusHomeBadger;
import com.ad4screen.sdk.plugins.badger.badgers.DefaultBadger;
import com.ad4screen.sdk.plugins.badger.badgers.EverythingMeHomeBadger;
import com.ad4screen.sdk.plugins.badger.badgers.HtcHomeBadger;
import com.ad4screen.sdk.plugins.badger.badgers.HuaweiHomeBadger;
import com.ad4screen.sdk.plugins.badger.badgers.NovaHomeBadger;
import com.ad4screen.sdk.plugins.badger.badgers.OPPOHomeBader;
import com.ad4screen.sdk.plugins.badger.badgers.SamsungHomeBadger;
import com.ad4screen.sdk.plugins.badger.badgers.SonyHomeBadger;
import com.ad4screen.sdk.plugins.badger.badgers.VivoHomeBadger;
import com.ad4screen.sdk.plugins.badger.badgers.ZTEHomeBadger;
import com.ad4screen.sdk.plugins.badger.badgers.ZukHomeBadger;
import java.util.LinkedList;
import java.util.List;

public final class BadgerFactory
implements BadgerPlugin {
    private static final String LOG_TAG = "PluginBadger";
    private static final List<Class<? extends Badger>> BADGERS = new LinkedList<Class<? extends Badger>>();
    private static Badger sShortcutBadger;
    private static ComponentName sComponentName;

    private static void applyCount(Context context, int n) {
        block2: {
            try {
                BadgerFactory.applyCountOrThrow(context, n);
            }
            catch (BadgerException badgerException) {
                if (!Log.isLoggable((String)LOG_TAG, (int)3)) break block2;
                Log.d((String)LOG_TAG, (String)"Unable to execute badge", (Throwable)badgerException);
            }
        }
    }

    private static void applyCountOrThrow(Context context, int n) throws BadgerException {
        boolean bl;
        if (sShortcutBadger == null && !(bl = BadgerFactory.initBadger(context))) {
            throw new BadgerException("No default launcher available");
        }
        try {
            sShortcutBadger.executeBadge(context, sComponentName, n);
        }
        catch (Exception exception) {
            throw new BadgerException("Unable to execute badge", exception);
        }
    }

    private static void removeCount(Context context) {
        BadgerFactory.applyCount(context, 0);
    }

    private static boolean initBadger(Context context) {
        Intent intent = context.getPackageManager().getLaunchIntentForPackage(context.getPackageName());
        if (intent == null) {
            Log.e((String)LOG_TAG, (String)("Unable to find launch intent for package " + context.getPackageName()));
            return false;
        }
        sComponentName = intent.getComponent();
        Intent intent2 = new Intent("android.intent.action.MAIN");
        intent2.addCategory("android.intent.category.HOME");
        List list = context.getPackageManager().queryIntentActivities(intent2, 65536);
        block2: for (ResolveInfo resolveInfo : list) {
            String string = resolveInfo.activityInfo.packageName;
            for (Class<? extends Badger> clazz : BADGERS) {
                Badger badger = null;
                try {
                    badger = clazz.newInstance();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (badger == null || !badger.getSupportLaunchers().contains(string)) continue;
                sShortcutBadger = badger;
                continue block2;
            }
        }
        if (sShortcutBadger == null) {
            sShortcutBadger = Build.MANUFACTURER.equalsIgnoreCase("ZUK") ? new ZukHomeBadger() : (Build.MANUFACTURER.equalsIgnoreCase("OPPO") ? new OPPOHomeBader() : (Build.MANUFACTURER.equalsIgnoreCase("VIVO") ? new VivoHomeBadger() : (Build.MANUFACTURER.equalsIgnoreCase("ZTE") ? new ZTEHomeBadger() : new DefaultBadger())));
        }
        return true;
    }

    public int getPluginVersion() {
        return 1;
    }

    public void setBadge(Context context, int n) {
        if (n == 0) {
            BadgerFactory.removeCount(context);
        } else {
            BadgerFactory.applyCount(context, n);
        }
    }

    static {
        BADGERS.add(AdwHomeBadger.class);
        BADGERS.add(ApexHomeBadger.class);
        BADGERS.add(DefaultBadger.class);
        BADGERS.add(HtcHomeBadger.class);
        BADGERS.add(NovaHomeBadger.class);
        BADGERS.add(SonyHomeBadger.class);
        BADGERS.add(AsusHomeBadger.class);
        BADGERS.add(HuaweiHomeBadger.class);
        BADGERS.add(OPPOHomeBader.class);
        BADGERS.add(SamsungHomeBadger.class);
        BADGERS.add(ZukHomeBadger.class);
        BADGERS.add(VivoHomeBadger.class);
        BADGERS.add(ZTEHomeBadger.class);
        BADGERS.add(EverythingMeHomeBadger.class);
    }
}

