/*
 * Decompiled with CFR 0.152.
 */
package com.ad4screen.sdk.plugins.badger.badgers;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import com.ad4screen.sdk.plugins.badger.Badger;
import com.ad4screen.sdk.plugins.badger.BadgerException;
import com.ad4screen.sdk.plugins.badger.util.BroadcastHelper;
import java.util.Collections;
import java.util.List;

public class AsusHomeBadger
implements Badger {
    private static final String INTENT_ACTION = "android.intent.action.BADGE_COUNT_UPDATE";
    private static final String INTENT_EXTRA_BADGE_COUNT = "badge_count";
    private static final String INTENT_EXTRA_PACKAGENAME = "badge_count_package_name";
    private static final String INTENT_EXTRA_ACTIVITY_NAME = "badge_count_class_name";

    @Override
    public void executeBadge(Context context, ComponentName componentName, int n) throws BadgerException {
        Intent intent = new Intent(INTENT_ACTION);
        intent.putExtra(INTENT_EXTRA_BADGE_COUNT, n);
        intent.putExtra(INTENT_EXTRA_PACKAGENAME, componentName.getPackageName());
        intent.putExtra(INTENT_EXTRA_ACTIVITY_NAME, componentName.getClassName());
        intent.putExtra("badge_vip_count", 0);
        if (!BroadcastHelper.canResolveBroadcast(context, intent)) {
            throw new BadgerException("unable to resolve intent: " + intent.toString());
        }
        context.sendBroadcast(intent);
    }

    @Override
    public List<String> getSupportLaunchers() {
        return Collections.singletonList("com.asus.launcher");
    }
}

