/*
 * Decompiled with CFR 0.152.
 */
package com.ad4screen.sdk.plugins.badger.badgers;

import android.content.AsyncQueryHandler;
import android.content.ComponentName;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ProviderInfo;
import android.net.Uri;
import com.ad4screen.sdk.Log;
import com.ad4screen.sdk.plugins.badger.BadgerUtil;
import com.ad4screen.sdk.plugins.badger.badgers.Badger;

public class SonyBadger
implements Badger {
    private static final String INTENT_ACTION = "com.sonyericsson.home.action.UPDATE_BADGE";
    private static final String INTENT_EXTRA_PACKAGE_NAME = "com.sonyericsson.home.intent.extra.badge.PACKAGE_NAME";
    private static final String INTENT_EXTRA_ACTIVITY_NAME = "com.sonyericsson.home.intent.extra.badge.ACTIVITY_NAME";
    private static final String INTENT_EXTRA_MESSAGE = "com.sonyericsson.home.intent.extra.badge.MESSAGE";
    private static final String INTENT_EXTRA_SHOW_MESSAGE = "com.sonyericsson.home.intent.extra.badge.SHOW_MESSAGE";
    private static final String PROVIDER_CONTENT_URI = "content://com.sonymobile.home.resourceprovider/badge";
    private static final String PROVIDER_COLUMNS_BADGE_COUNT = "badge_count";
    private static final String PROVIDER_COLUMNS_PACKAGE_NAME = "package_name";
    private static final String PROVIDER_COLUMNS_ACTIVITY_NAME = "activity_name";
    private static final String SONY_HOME_PROVIDER_NAME = "com.sonymobile.home.resourceprovider";
    private final Uri BADGE_CONTENT_URI = Uri.parse((String)"content://com.sonymobile.home.resourceprovider/badge");
    private AsyncQueryHandler mQueryHandler;

    @Override
    public void setBadge(Context context, int n) {
        ComponentName componentName = BadgerUtil.getComponentName(context);
        if (componentName == null) {
            return;
        }
        if (SonyBadger.sonyBadgeContentProviderExists(context)) {
            this.executeBadgeByContentProvider(context, componentName, n);
        } else {
            SonyBadger.executeBadgeByBroadcast(context, componentName, n);
        }
    }

    @Override
    public boolean isSupported(Context context, String string) {
        return "com.sonyericsson.home".equals(string);
    }

    private static boolean sonyBadgeContentProviderExists(Context context) {
        ProviderInfo providerInfo = context.getPackageManager().resolveContentProvider(SONY_HOME_PROVIDER_NAME, 0);
        return providerInfo != null;
    }

    private static void executeBadgeByBroadcast(Context context, ComponentName componentName, int n) {
        Intent intent = new Intent(INTENT_ACTION);
        intent.putExtra(INTENT_EXTRA_PACKAGE_NAME, componentName.getPackageName());
        intent.putExtra(INTENT_EXTRA_ACTIVITY_NAME, componentName.getClassName());
        intent.putExtra(INTENT_EXTRA_MESSAGE, String.valueOf(n));
        intent.putExtra(INTENT_EXTRA_SHOW_MESSAGE, n > 0);
        if (BadgerUtil.canResolveBroadcast(context, intent)) {
            context.sendBroadcast(intent);
        } else {
            Log.warn((String)("Unable to resolve intent: " + intent.toString()));
        }
    }

    private void executeBadgeByContentProvider(Context context, ComponentName componentName, int n) {
        if (n < 0) {
            return;
        }
        if (this.mQueryHandler == null) {
            this.mQueryHandler = new AsyncQueryHandler(context.getApplicationContext().getContentResolver()){};
        }
        this.insertBadgeAsync(n, componentName.getPackageName(), componentName.getClassName());
    }

    private void insertBadgeAsync(int n, String string, String string2) {
        try {
            ContentValues contentValues = new ContentValues();
            contentValues.put(PROVIDER_COLUMNS_BADGE_COUNT, Integer.valueOf(n));
            contentValues.put(PROVIDER_COLUMNS_PACKAGE_NAME, string);
            contentValues.put(PROVIDER_COLUMNS_ACTIVITY_NAME, string2);
            this.mQueryHandler.startInsert(0, null, this.BADGE_CONTENT_URI, contentValues);
        }
        catch (Exception exception) {
            Log.warn((String)"Impossible to set badge for this Sony Launcher", (Throwable)exception);
        }
    }
}

