/*
 * Decompiled with CFR 0.152.
 */
package com.ad4screen.sdk.plugins.badger.badgers;

import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import com.ad4screen.sdk.Log;
import com.ad4screen.sdk.plugins.badger.BadgerUtil;
import com.ad4screen.sdk.plugins.badger.badgers.Badger;

public class SamsungBadger
implements Badger {
    private static final String CONTENT_URI = "content://com.sec.badge/apps?notify=true";
    private static final String[] CONTENT_PROJECTION = new String[]{"_id", "class"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBadge(Context context, int n) {
        ComponentName componentName = BadgerUtil.getComponentName(context);
        if (componentName == null) {
            return;
        }
        Uri uri = Uri.parse((String)CONTENT_URI);
        ContentResolver contentResolver = context.getContentResolver();
        Cursor cursor = null;
        try {
            cursor = contentResolver.query(uri, CONTENT_PROJECTION, "package=?", new String[]{componentName.getPackageName()}, null);
            if (cursor != null) {
                String string = componentName.getClassName();
                boolean bl = false;
                while (cursor.moveToNext()) {
                    int n2 = cursor.getInt(0);
                    ContentValues contentValues = this.getContentValues(componentName, n, false);
                    contentResolver.update(uri, contentValues, "_id=?", new String[]{String.valueOf(n2)});
                    if (!string.equals(cursor.getString(cursor.getColumnIndex("class")))) continue;
                    bl = true;
                }
                if (!bl) {
                    ContentValues contentValues = this.getContentValues(componentName, n, true);
                    contentResolver.insert(uri, contentValues);
                }
            }
            BadgerUtil.close(cursor);
        }
        catch (Exception exception) {
            Log.warn((String)"Impossible to set badge for this Samsung Launcher", (Throwable)exception);
        }
        finally {
            BadgerUtil.close(cursor);
        }
    }

    private ContentValues getContentValues(ComponentName componentName, int n, boolean bl) {
        ContentValues contentValues = new ContentValues();
        if (bl) {
            contentValues.put("package", componentName.getPackageName());
            contentValues.put("class", componentName.getClassName());
        }
        contentValues.put("badgecount", Integer.valueOf(n));
        return contentValues;
    }

    @Override
    public boolean isSupported(Context context, String string) {
        return "com.sec.android.app.launcher".equals(string) || "com.sec.android.app.twlauncher".equals(string);
    }
}

