/*
 * Decompiled with CFR 0.152.
 */
package com.ad4screen.sdk.plugins.badger.badgers;

import android.content.ComponentName;
import android.content.Context;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import com.ad4screen.sdk.Log;
import com.ad4screen.sdk.plugins.badger.BadgerUtil;
import com.ad4screen.sdk.plugins.badger.badgers.Badger;

public class HuaweiBadger
implements Badger {
    private static final String BUNDLE_EXTRA_PACKAGE = "package";
    private static final String BUNDLE_EXTRA_CLASS = "class";
    private static final String BUNDLE_EXTRA_COUNT = "badgenumber";
    private static final Uri RESOVLER_URI = Uri.parse((String)"content://com.huawei.android.launcher.settings/badge/");
    private static final String RESOLVER_ACTION = "change_badge";

    @Override
    public void setBadge(Context context, int n) {
        if (Build.VERSION.SDK_INT >= 11) {
            ComponentName componentName = BadgerUtil.getComponentName(context);
            if (componentName == null) {
                return;
            }
            Bundle bundle = new Bundle();
            bundle.putString(BUNDLE_EXTRA_PACKAGE, context.getPackageName());
            bundle.putString(BUNDLE_EXTRA_CLASS, componentName.getClassName());
            bundle.putInt(BUNDLE_EXTRA_COUNT, n);
            try {
                context.getContentResolver().call(RESOVLER_URI, RESOLVER_ACTION, null, bundle);
            }
            catch (Exception exception) {
                Log.warn((String)"Impossible to set badge for this Huawei Launcher", (Throwable)exception);
            }
        }
    }

    @Override
    public boolean isSupported(Context context, String string) {
        return "com.huawei.android.launcher".equals(string) && Build.VERSION.SDK_INT >= 11;
    }
}

