/*
 * Decompiled with CFR 0.152.
 */
package com.ad4screen.sdk.plugins.badger;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Build;
import com.ad4screen.sdk.Log;
import com.ad4screen.sdk.plugins.BadgerPlugin;
import com.ad4screen.sdk.plugins.badger.badgers.AdwBadger;
import com.ad4screen.sdk.plugins.badger.badgers.ApexBadger;
import com.ad4screen.sdk.plugins.badger.badgers.AsusBadger;
import com.ad4screen.sdk.plugins.badger.badgers.Badger;
import com.ad4screen.sdk.plugins.badger.badgers.DefaultBadger;
import com.ad4screen.sdk.plugins.badger.badgers.HtcBadger;
import com.ad4screen.sdk.plugins.badger.badgers.HuaweiBadger;
import com.ad4screen.sdk.plugins.badger.badgers.NovaBadger;
import com.ad4screen.sdk.plugins.badger.badgers.OppoBadger;
import com.ad4screen.sdk.plugins.badger.badgers.SamsungBadger;
import com.ad4screen.sdk.plugins.badger.badgers.SonyBadger;
import com.ad4screen.sdk.plugins.badger.badgers.XiaomiBadger;
import com.ad4screen.sdk.plugins.badger.badgers.ZukBadger;
import java.util.Arrays;
import java.util.List;

public final class BadgerFactory
implements BadgerPlugin {
    private static final int PLUGIN_BADGER_VERSION = 1;
    private static Badger mBadger;

    public static Badger get(Context context) {
        if (mBadger == null) {
            mBadger = BadgerFactory.getBadger(context);
            Log.info((String)("BadgerFactory|Badger loaded: " + mBadger.getClass().getName()));
        }
        return mBadger;
    }

    private static Badger getBadger(Context context) {
        List<Badger> list = BadgerFactory.getAvailableBadgers();
        String string = BadgerFactory.getCurrentHomePackage(context);
        if (string != null) {
            for (Badger badger : list) {
                if (!badger.isSupported(context, string)) continue;
                return badger;
            }
        }
        if ("Xiaomi".equalsIgnoreCase(Build.MANUFACTURER)) {
            return new XiaomiBadger();
        }
        if ("ZUK".equalsIgnoreCase(Build.MANUFACTURER)) {
            return new ZukBadger();
        }
        if ("OPPO".equalsIgnoreCase(Build.MANUFACTURER)) {
            return new OppoBadger();
        }
        return new DefaultBadger();
    }

    private static List<Badger> getAvailableBadgers() {
        return Arrays.asList(new AdwBadger(), new ApexBadger(), new AsusBadger(), new HtcBadger(), new HuaweiBadger(), new NovaBadger(), new OppoBadger(), new SamsungBadger(), new SonyBadger(), new XiaomiBadger(), new ZukBadger());
    }

    private static String getCurrentHomePackage(Context context) {
        if (context == null) {
            return null;
        }
        PackageManager packageManager = context.getPackageManager();
        if (packageManager == null) {
            return null;
        }
        Intent intent = new Intent("android.intent.action.MAIN");
        intent.addCategory("android.intent.category.HOME");
        ResolveInfo resolveInfo = packageManager.resolveActivity(intent, 65536);
        if (resolveInfo == null) {
            return null;
        }
        return resolveInfo.activityInfo.packageName;
    }

    public void setBadge(Context context, int n) {
        try {
            BadgerFactory.get(context).setBadge(context, n);
        }
        catch (Exception exception) {
            Log.warn((String)"Badge cannot be set", (Throwable)exception);
        }
    }

    public int getPluginVersion() {
        return 1;
    }
}

