/*
 * Decompiled with CFR 0.152.
 */
package com.ad4screen.sdk.plugins.badger;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import com.ad4screen.sdk.Log;
import com.ad4screen.sdk.plugins.BadgerPlugin;
import com.ad4screen.sdk.plugins.badger.badgers.AdwBadger;
import com.ad4screen.sdk.plugins.badger.badgers.ApexBadger;
import com.ad4screen.sdk.plugins.badger.badgers.AsusBadger;
import com.ad4screen.sdk.plugins.badger.badgers.Badger;
import com.ad4screen.sdk.plugins.badger.badgers.DefaultBadger;
import com.ad4screen.sdk.plugins.badger.badgers.HtcBadger;
import com.ad4screen.sdk.plugins.badger.badgers.NovaBadger;
import com.ad4screen.sdk.plugins.badger.badgers.SolidBadger;
import com.ad4screen.sdk.plugins.badger.badgers.SonyBadger;
import com.ad4screen.sdk.plugins.badger.badgers.XiaomiBadger;
import java.util.Arrays;
import java.util.List;

public final class BadgerFactory
implements BadgerPlugin {
    private static final int PLUGIN_BADGER_VERSION = 1;
    private static Badger mBadger;

    public static Badger get(Context context) {
        if (mBadger == null) {
            mBadger = BadgerFactory.getBadger(context);
            Log.info((String)("BadgerFactory|Badger loaded: " + mBadger.getClass().getName()));
        }
        return mBadger;
    }

    private static Badger getBadger(Context context) {
        List<Badger> list = BadgerFactory.getAvailableBadgers();
        String string = BadgerFactory.getCurrentHomePackage(context);
        if (string != null) {
            for (Badger badger : list) {
                if (!badger.isSupported(context, string)) continue;
                return badger;
            }
        }
        return new DefaultBadger();
    }

    private static List<Badger> getAvailableBadgers() {
        return Arrays.asList(new AdwBadger(), new ApexBadger(), new AsusBadger(), new HtcBadger(), new NovaBadger(), new SolidBadger(), new SonyBadger(), new XiaomiBadger());
    }

    private static String getCurrentHomePackage(Context context) {
        Intent intent = new Intent("android.intent.action.MAIN");
        intent.addCategory("android.intent.category.HOME");
        ResolveInfo resolveInfo = context.getPackageManager().resolveActivity(intent, 65536);
        return resolveInfo.activityInfo.packageName;
    }

    public void setBadge(Context context, int n) {
        BadgerFactory.get(context).setBadge(context, n);
    }

    public int getPluginVersion() {
        return 1;
    }
}

