/*
 * Decompiled with CFR 0.152.
 */
package com.actionjava.mvn.plugins.assets.parsers;

import com.actionjava.mvn.plugins.assets.data.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class AbstractParser {
    protected Parameter[] parseParams(String paramsRaw) {
        String[] paramsSplit = paramsRaw.split(",(?![^\\[]*\\])");
        Parameter[] params = new Parameter[paramsSplit.length];
        for (int i = 0; i < paramsSplit.length; ++i) {
            try {
                params[i] = new Parameter(paramsSplit[i]);
                continue;
            }
            catch (Exception e) {
                System.out.println("AbstractParser.parseParams??: " + e.getMessage() + " paramsSplit[i]: " + paramsSplit[i]);
            }
        }
        return params;
    }

    protected List<String[]> seperateContent(String[] lines, String beginRegEx, String endRegEx) {
        return this.seperateContent(lines, beginRegEx, endRegEx, false);
    }

    protected List<String[]> seperateContent(String[] linesRaw, String beginRegEx, String endRegEx, boolean removeLastLine) {
        int lineCount = 0;
        String[] lines = linesRaw;
        ArrayList<String[]> scrapedContent = new ArrayList<String[]>();
        if (lines != null && lines.length > 0) {
            String[] content;
            while ((content = this.scrapeContent(lines, beginRegEx, endRegEx, removeLastLine)) != null && content.length > 0) {
                scrapedContent.add(content);
                ArrayList<String> lineList = new ArrayList<String>();
                for (int i = lineCount += content.length; i < linesRaw.length; ++i) {
                    lineList.add(linesRaw[i]);
                }
                lines = lineList.toArray(new String[lineList.size()]);
            }
        }
        return scrapedContent;
    }

    protected String[] scrapeContent(String[] lines, String beginRegEx, String endRegEx) {
        return this.scrapeContent(lines, beginRegEx, endRegEx, false);
    }

    protected String[] scrapeContent(String[] lines, String beginRegEx, String endRegEx, boolean removeLastLine) {
        String line;
        int i;
        ArrayList<String> lineList = new ArrayList<String>();
        int startLine = 0;
        int endLine = 0;
        boolean found = false;
        for (i = 0; i < lines.length; ++i) {
            Matcher matcher;
            Pattern pattern;
            line = lines[i];
            if (!found) {
                pattern = Pattern.compile(beginRegEx);
                matcher = pattern.matcher(line);
                if (!matcher.find()) continue;
                startLine = i;
                found = true;
                continue;
            }
            pattern = Pattern.compile(endRegEx);
            matcher = pattern.matcher(line);
            if (!matcher.find()) continue;
            endLine = removeLastLine ? i : i + 1;
            break;
        }
        if (startLine != 0 && endLine != 0) {
            for (i = startLine; i < endLine; ++i) {
                line = lines[i];
                if (line.isEmpty()) continue;
                lineList.add(lines[i]);
            }
            return lineList.toArray(new String[lineList.size()]);
        }
        return null;
    }

    protected int getLineNumberByRegEx(String[] lines, String regEx) {
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            if (!Pattern.matches(regEx, line)) continue;
            return i;
        }
        return -1;
    }

    protected int getLineNumberByRegExFromIndex(String[] lines, String regEx, int from) {
        if (from < lines.length) {
            for (int i = from; i < lines.length; ++i) {
                String line = lines[i];
                if (!Pattern.matches(regEx, line)) continue;
                return i;
            }
        }
        return -1;
    }

    protected String[] copyRangeFromArray(String[] targetArr, int begin, int end) {
        String[] newArr = Arrays.copyOfRange(targetArr, begin, end);
        return newArr;
    }

    protected String[] removeRangeFromArray(String[] targetArr, int begin, int end) {
        ArrayList<String> list = new ArrayList<String>();
        String[] newArr1 = Arrays.copyOfRange(targetArr, 0, begin);
        for (int i = 0; i < newArr1.length; ++i) {
            list.add(newArr1[i]);
        }
        String[] newArr2 = Arrays.copyOfRange(targetArr, end, targetArr.length);
        for (int i = 0; i < newArr2.length; ++i) {
            list.add(newArr2[i]);
        }
        return list.toArray(new String[list.size()]);
    }
}

