/*
 * Decompiled with CFR 0.152.
 */
package com.actionjava.mvn.plugins.assets.io;

import com.actionjava.mvn.plugins.assets.data.Instance;
import com.actionjava.mvn.plugins.assets.data.Symbol;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;

public class AssetWriter {
    private static final long serialVersionUID = 4748880101699843087L;
    private static final String VM_ENCODING = "utf-8";
    private static final String VM_PROPERTIES = "/velocity.properties";
    private static final String VM_SYMBOL_TEMPLATE = "/templates/symbol.vm";
    private static final String VM_BITMAP_TEMPLATE = "/templates/bitmap.vm";
    private static final String VM_SHAPE_TEMPLATE = "/templates/components/shape.vm";
    private File outputDirectory;
    private File packageDirectory;
    private VelocityEngine velocityEngine;

    public AssetWriter(File outputDirectory) {
        this.initialize(outputDirectory);
    }

    private void initialize(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public void write(List<Symbol> symbols) {
        for (int i = 0; i < symbols.size(); ++i) {
            Symbol symbol = symbols.get(i);
            File packageDirectory = this.createPackage(this.outputDirectory, symbol, false);
            File file = this.createSymbol(packageDirectory, symbol, true);
        }
    }

    private File createPackage(File outputDirectory, Symbol symbol, boolean overwrite) {
        File curDirectory = outputDirectory;
        if (!curDirectory.exists()) {
            curDirectory.mkdirs();
        }
        String[] packageSplit = symbol.getPackage().split("\\.");
        for (int i = 0; i < packageSplit.length; ++i) {
            if ((curDirectory = new File(curDirectory.getAbsolutePath() + "\\" + packageSplit[i])).exists()) continue;
            try {
                curDirectory.mkdir();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return curDirectory;
    }

    private File createSymbol(File packageDirectory, Symbol symbol, boolean overwrite) {
        VelocityContext context = new VelocityContext();
        VelocityEngine velocityEngine = this.initVelocity();
        this.setVelocityValues(context, symbol.getName(), symbol.getPackage(), symbol.getBitmapUrl(), symbol.getChildren());
        StringWriter writer = new StringWriter();
        velocityEngine.mergeTemplate(symbol.getType().equals("bitmap") ? VM_BITMAP_TEMPLATE : VM_SYMBOL_TEMPLATE, VM_ENCODING, (Context)context, (Writer)writer);
        File symbolClassFile = new File(packageDirectory.getAbsoluteFile() + "\\" + symbol.getName() + ".java");
        if (!symbolClassFile.exists() || symbolClassFile.exists() && overwrite) {
            try {
                if (symbolClassFile.exists()) {
                    symbolClassFile.delete();
                }
                symbolClassFile.createNewFile();
                PrintWriter out = new PrintWriter(symbolClassFile.getAbsoluteFile());
                out.println(writer.toString());
                out.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return symbolClassFile;
    }

    private VelocityEngine initVelocity() {
        Velocity.init();
        Properties properties = null;
        try {
            properties = new Properties();
            properties.load(this.getClass().getResourceAsStream(VM_PROPERTIES));
            return new VelocityEngine(properties);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void setVelocityValues(VelocityContext context, String symName, String symPackage, String bitmapUrl, Instance[] instances) {
        context.put("name", (Object)symName);
        context.put("package", (Object)symPackage);
        context.put("bitmapUrl", (Object)bitmapUrl);
        context.put("instances", Arrays.asList(instances));
    }
}

