/*
 * Decompiled with CFR 0.152.
 */
package com.actionjava.mvn.plugins.assets.io;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import java.util.regex.Pattern;

public class AssetReader {
    private static final Charset ENCODING = StandardCharsets.UTF_8;
    private File assetJS;
    private List<String> assetLines;

    public AssetReader(File assetJS) {
        this.initialize(assetJS);
    }

    private void initialize(File assetJS) {
        this.assetJS = assetJS;
        this.assetLines = new ArrayList<String>();
    }

    public void read() {
        try {
            Scanner scanner = new Scanner(Paths.get(this.assetJS.getAbsolutePath(), new String[0]), ENCODING.name());
            while (scanner.hasNextLine()) {
                this.processLine(scanner.nextLine());
            }
            scanner.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void processLine(String assetLine) {
        if (!Pattern.matches("\\s*", assetLine)) {
            this.assetLines.add(assetLine);
        }
    }

    public String[] getAssetLines() {
        return this.assetLines.toArray(new String[this.assetLines.size()]);
    }
}

