/*
 * Decompiled with CFR 0.152.
 */
package com.actionjava.mvn.plugins.assets.data.instr;

import com.actionjava.mvn.plugins.assets.data.Parameter;
import com.actionjava.mvn.plugins.assets.data.instr.Instruction;

public class DrawCircle
extends Instruction {
    public static final String ID = "dc";
    public static final String NAME = "drawCircle";
    private double x;
    private double y;
    private double radius;

    public DrawCircle() {
        super(ID, NAME);
        this.initialize(0.0, 0.0, 0.0);
    }

    public DrawCircle(double x, double y, double radius) {
        super(ID, NAME);
        this.initialize(x, y, radius);
    }

    private void initialize(double x, double y, double radius) {
        this.x = x;
        this.y = y;
        this.radius = radius;
    }

    @Override
    public Instruction createNew(Parameter[] params) throws Exception {
        if (params.length != 3) {
            throw new Exception("Param count does not match the Instruction");
        }
        return new DrawCircle(params[0].getNumberValue(), params[1].getNumberValue(), params[2].getNumberValue());
    }

    @Override
    public String toMethod() {
        return super.toMethod() + this.getMethodParams();
    }

    @Override
    public String getMethodParams() {
        String methodParams = "(";
        methodParams = methodParams + this.x + ",";
        methodParams = methodParams + this.y + ",";
        methodParams = methodParams + this.radius;
        methodParams = methodParams + ")";
        return methodParams;
    }

    @Override
    public String toString() {
        return "DrawCircle [x: " + this.x + ", y: " + this.y + ", radius: " + this.radius + "]";
    }

    public double getX() {
        return this.x;
    }

    public void setX(double x) {
        this.x = x;
    }

    public double getY() {
        return this.y;
    }

    public void setY(double y) {
        this.y = y;
    }

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double radius) {
        this.radius = radius;
    }
}

