/*
 * Decompiled with CFR 0.152.
 */
package com.actionjava.mvn.plugins.assets;

import com.actionjava.mvn.plugins.assets.parsers.AssetParser;
import com.actionjava.mvn.plugins.assets.vo.AssetSettings;
import com.actionjava.mvn.plugins.assets.vo.GlobalSettings;
import java.io.File;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="convert")
public class AssetsMojo
extends AbstractMojo {
    private static final String SHAPE_TEMPLATE = "templates/shape.vm";
    private static final String SYMBOL_TEMPLATE = "templates/symbol.vm";
    @Parameter(defaultValue="${basedir}", readonly=true)
    private File baseDirectory;
    @Parameter(defaultValue="${project.build.directory}", readonly=true)
    private File targetDirectory;
    @Parameter
    private GlobalSettings settings;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.initialize();
        if (this.settings.getAutoDetect()) {
            this.detectAssets();
        }
        this.parseAssets();
    }

    private void initialize() {
    }

    private void detectAssets() {
    }

    private void parseAssets() {
        AssetSettings[] assets = this.settings.getAssets();
        if (assets != null) {
            for (int i = 0; i < assets.length; ++i) {
                AssetSettings assetSettings = assets[i];
                AssetParser assetParser = new AssetParser(assetSettings, this.baseDirectory);
                assetParser.read();
                assetParser.parse();
                assetParser.write();
            }
        }
    }
}

