/*
 * Decompiled with CFR 0.152.
 */
package com.acmerobotics.roadrunner.util;

import com.acmerobotics.roadrunner.geometry.Vector2d;
import com.acmerobotics.roadrunner.path.Path;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0010B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\u0002\u0010\bJ\u0019\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005H\u0086\u0002J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00052\b\b\u0002\u0010\u000f\u001a\u00020\u0005R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/acmerobotics/roadrunner/util/GuidingVectorField;", "", "path", "Lcom/acmerobotics/roadrunner/path/Path;", "kN", "", "errorMapFunc", "Lkotlin/Function1;", "(Lcom/acmerobotics/roadrunner/path/Path;DLkotlin/jvm/functions/Function1;)V", "get", "Lcom/acmerobotics/roadrunner/geometry/Vector2d;", "x", "y", "getExtended", "Lcom/acmerobotics/roadrunner/util/GuidingVectorField$GVFResult;", "projectGuess", "GVFResult", "core"})
public final class GuidingVectorField {
    private final Path path;
    private final double kN;
    private final Function1<Double, Double> errorMapFunc;

    @NotNull
    public final GVFResult getExtended(double x, double y, double projectGuess) {
        Vector2d point = new Vector2d(x, y);
        double displacement = this.path.fastProject(new Vector2d(x, y), projectGuess);
        Vector2d pathPoint = Path.get$default(this.path, displacement, 0.0, 2, null).vec();
        Vector2d tangent = Path.deriv$default(this.path, displacement, 0.0, 2, null).vec();
        Vector2d pathToPoint = point.minus(pathPoint);
        double d = pathToPoint.getX() * tangent.getY() - pathToPoint.getY() * tangent.getX();
        boolean bl = false;
        double orientation = -Math.signum(d);
        double error = orientation * pathToPoint.norm();
        Vector2d normal = tangent.rotated(1.5707963267948966);
        Vector2d vector = tangent.minus(normal.times(this.kN).times(((Number)this.errorMapFunc.invoke((Object)error)).doubleValue()));
        return new GVFResult(vector.div(vector.norm()), pathPoint, displacement, error);
    }

    public static /* synthetic */ GVFResult getExtended$default(GuidingVectorField guidingVectorField, double d, double d2, double d3, int n, Object object) {
        if ((n & 4) != 0) {
            d3 = guidingVectorField.path.length() / 2.0;
        }
        return guidingVectorField.getExtended(d, d2, d3);
    }

    @NotNull
    public final Vector2d get(double x, double y) {
        return GuidingVectorField.getExtended$default(this, x, y, 0.0, 4, null).getVector();
    }

    public GuidingVectorField(@NotNull Path path, double kN, @NotNull Function1<? super Double, Double> errorMapFunc) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(errorMapFunc, (String)"errorMapFunc");
        this.path = path;
        this.kN = kN;
        this.errorMapFunc = errorMapFunc;
    }

    public /* synthetic */ GuidingVectorField(Path path, double d, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            function1 = 1.INSTANCE;
        }
        this(path, d, (Function1<? super Double, Double>)function1);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0006H\u00c6\u0003J1\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\r\u00a8\u0006\u001b"}, d2={"Lcom/acmerobotics/roadrunner/util/GuidingVectorField$GVFResult;", "", "vector", "Lcom/acmerobotics/roadrunner/geometry/Vector2d;", "pathPoint", "displacement", "", "error", "(Lcom/acmerobotics/roadrunner/geometry/Vector2d;Lcom/acmerobotics/roadrunner/geometry/Vector2d;DD)V", "getDisplacement", "()D", "getError", "getPathPoint", "()Lcom/acmerobotics/roadrunner/geometry/Vector2d;", "getVector", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "", "core"})
    public static final class GVFResult {
        @NotNull
        private final Vector2d vector;
        @NotNull
        private final Vector2d pathPoint;
        private final double displacement;
        private final double error;

        @NotNull
        public final Vector2d getVector() {
            return this.vector;
        }

        @NotNull
        public final Vector2d getPathPoint() {
            return this.pathPoint;
        }

        public final double getDisplacement() {
            return this.displacement;
        }

        public final double getError() {
            return this.error;
        }

        public GVFResult(@NotNull Vector2d vector, @NotNull Vector2d pathPoint, double displacement, double error) {
            Intrinsics.checkNotNullParameter((Object)vector, (String)"vector");
            Intrinsics.checkNotNullParameter((Object)pathPoint, (String)"pathPoint");
            this.vector = vector;
            this.pathPoint = pathPoint;
            this.displacement = displacement;
            this.error = error;
        }

        @NotNull
        public final Vector2d component1() {
            return this.vector;
        }

        @NotNull
        public final Vector2d component2() {
            return this.pathPoint;
        }

        public final double component3() {
            return this.displacement;
        }

        public final double component4() {
            return this.error;
        }

        @NotNull
        public final GVFResult copy(@NotNull Vector2d vector, @NotNull Vector2d pathPoint, double displacement, double error) {
            Intrinsics.checkNotNullParameter((Object)vector, (String)"vector");
            Intrinsics.checkNotNullParameter((Object)pathPoint, (String)"pathPoint");
            return new GVFResult(vector, pathPoint, displacement, error);
        }

        public static /* synthetic */ GVFResult copy$default(GVFResult gVFResult, Vector2d vector2d, Vector2d vector2d2, double d, double d2, int n, Object object) {
            if ((n & 1) != 0) {
                vector2d = gVFResult.vector;
            }
            if ((n & 2) != 0) {
                vector2d2 = gVFResult.pathPoint;
            }
            if ((n & 4) != 0) {
                d = gVFResult.displacement;
            }
            if ((n & 8) != 0) {
                d2 = gVFResult.error;
            }
            return gVFResult.copy(vector2d, vector2d2, d, d2);
        }

        @NotNull
        public String toString() {
            return "GVFResult(vector=" + this.vector + ", pathPoint=" + this.pathPoint + ", displacement=" + this.displacement + ", error=" + this.error + ")";
        }

        public int hashCode() {
            Vector2d vector2d = this.vector;
            Vector2d vector2d2 = this.pathPoint;
            return (((vector2d != null ? ((Object)vector2d).hashCode() : 0) * 31 + (vector2d2 != null ? ((Object)vector2d2).hashCode() : 0)) * 31 + Double.hashCode(this.displacement)) * 31 + Double.hashCode(this.error);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof GVFResult)) break block3;
                    GVFResult gVFResult = (GVFResult)object;
                    if (!Intrinsics.areEqual((Object)this.vector, (Object)gVFResult.vector) || !Intrinsics.areEqual((Object)this.pathPoint, (Object)gVFResult.pathPoint) || Double.compare(this.displacement, gVFResult.displacement) != 0 || Double.compare(this.error, gVFResult.error) != 0) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

