/*
 * Decompiled with CFR 0.152.
 */
package com.acmerobotics.roadrunner.util;

import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\b\u0018\u0000 )2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002)*B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0002J\t\u0010\u000f\u001a\u00020\u0002H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0002H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0006H\u00c6\u0003J\u0011\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u0002H\u0086\u0002J'\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0004\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00132\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u00d6\u0003J\u000e\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0002J\u0011\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u0006H\u0086\u0002J\t\u0010\u001b\u001a\u00020\u0006H\u00d6\u0001J\u0006\u0010\u001c\u001a\u00020\u0013J\r\u0010\u001d\u001a\u00060\u001eR\u00020\u0000H\u0096\u0002J\u0011\u0010\u001f\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\u0002H\u0086\u0002J\u0011\u0010!\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\u0002H\u0086\u0002J\u0010\u0010\"\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u0002H\u0002J\u0006\u0010\u0005\u001a\u00020\u0006J\u001a\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00000$2\u0006\u0010%\u001a\u00020\u0002J\t\u0010&\u001a\u00020'H\u00d6\u0001J\t\u0010(\u001a\u00020\u0000H\u0086\u0002R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006+"}, d2={"Lcom/acmerobotics/roadrunner/util/DoubleProgression;", "", "", "start", "step", "size", "", "(DDI)V", "getSize", "()I", "getStart", "()D", "getStep", "ceilIndex", "query", "component1", "component2", "component3", "contains", "", "copy", "equals", "other", "", "floorIndex", "get", "index", "hashCode", "isEmpty", "iterator", "Lcom/acmerobotics/roadrunner/util/DoubleProgression$IteratorImpl;", "minus", "offset", "plus", "rawIndex", "split", "Lkotlin/Pair;", "sep", "toString", "", "unaryMinus", "Companion", "IteratorImpl", "core"})
public final class DoubleProgression
implements Iterable<Double>,
KMappedMarker {
    private final double start;
    private final double step;
    private final int size;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final DoubleProgression plus(double offset) {
        return new DoubleProgression(this.start + offset, this.step, this.size);
    }

    @NotNull
    public final DoubleProgression minus(double offset) {
        return new DoubleProgression(this.start - offset, this.step, this.size);
    }

    @NotNull
    public final DoubleProgression unaryMinus() {
        return new DoubleProgression(-this.start, -this.step, this.size);
    }

    public final boolean isEmpty() {
        return this.size == 0;
    }

    private final double rawIndex(double query) {
        return (query - this.start) / this.step;
    }

    public final int floorIndex(double query) {
        double d = this.rawIndex(query);
        boolean bl = false;
        return (int)Math.floor(d);
    }

    public final int ceilIndex(double query) {
        double d = this.rawIndex(query);
        boolean bl = false;
        return (int)Math.ceil(d);
    }

    public final double get(int index) {
        return this.start + this.step * (double)index;
    }

    public final boolean contains(double query) {
        boolean bl;
        double rawIndex = this.rawIndex(query);
        if (rawIndex < 0.0) {
            bl = false;
        } else {
            boolean bl2 = false;
            bl = Math.ceil(rawIndex) < (double)this.size;
        }
        return bl;
    }

    public final int size() {
        return this.size;
    }

    @NotNull
    public final Pair<DoubleProgression, DoubleProgression> split(double sep) {
        int sepIndex = this.ceilIndex(sep);
        return sepIndex < 0 ? TuplesKt.to((Object)new DoubleProgression(sep, this.step, 0), (Object)this) : (sepIndex >= this.size ? TuplesKt.to((Object)this, (Object)new DoubleProgression(sep, this.step, 0)) : TuplesKt.to((Object)new DoubleProgression(this.start, this.step, sepIndex), (Object)new DoubleProgression(this.get(sepIndex), this.step, this.size - sepIndex)));
    }

    @NotNull
    public IteratorImpl iterator() {
        return new IteratorImpl();
    }

    public final double getStart() {
        return this.start;
    }

    public final double getStep() {
        return this.step;
    }

    public final int getSize() {
        return this.size;
    }

    public DoubleProgression(double start, double step, int size) {
        this.start = start;
        this.step = step;
        this.size = size;
    }

    public final double component1() {
        return this.start;
    }

    public final double component2() {
        return this.step;
    }

    public final int component3() {
        return this.size;
    }

    @NotNull
    public final DoubleProgression copy(double start, double step, int size) {
        return new DoubleProgression(start, step, size);
    }

    public static /* synthetic */ DoubleProgression copy$default(DoubleProgression doubleProgression, double d, double d2, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            d = doubleProgression.start;
        }
        if ((n2 & 2) != 0) {
            d2 = doubleProgression.step;
        }
        if ((n2 & 4) != 0) {
            n = doubleProgression.size;
        }
        return doubleProgression.copy(d, d2, n);
    }

    @NotNull
    public String toString() {
        return "DoubleProgression(start=" + this.start + ", step=" + this.step + ", size=" + this.size + ")";
    }

    public int hashCode() {
        return (Double.hashCode(this.start) * 31 + Double.hashCode(this.step)) * 31 + Integer.hashCode(this.size);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof DoubleProgression)) break block3;
                DoubleProgression doubleProgression = (DoubleProgression)object;
                if (Double.compare(this.start, doubleProgression.start) != 0 || Double.compare(this.step, doubleProgression.step) != 0 || this.size != doubleProgression.size) break block3;
            }
            return true;
        }
        return false;
    }

    @JvmStatic
    @NotNull
    public static final DoubleProgression fromClosedInterval(double start, double endInclusive, int count) {
        return Companion.fromClosedInterval(start, endInclusive, count);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010(\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\t\u0010\u0006\u001a\u00020\u0007H\u0096\u0002J\u000e\u0010\b\u001a\u00020\u0002H\u0096\u0002\u00a2\u0006\u0002\u0010\tR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00050\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/acmerobotics/roadrunner/util/DoubleProgression$IteratorImpl;", "", "", "(Lcom/acmerobotics/roadrunner/util/DoubleProgression;)V", "iterator", "", "hasNext", "", "next", "()Ljava/lang/Double;", "core"})
    public final class IteratorImpl
    implements Iterator<Double>,
    KMappedMarker {
        private final Iterator<Integer> iterator;

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        @NotNull
        public Double next() {
            return DoubleProgression.this.get(((Number)this.iterator.next()).intValue());
        }

        public IteratorImpl() {
            this.iterator = (Iterator)new IntRange(0, DoubleProgression.this.getSize() - 1).iterator();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0007\u00a8\u0006\n"}, d2={"Lcom/acmerobotics/roadrunner/util/DoubleProgression$Companion;", "", "()V", "fromClosedInterval", "Lcom/acmerobotics/roadrunner/util/DoubleProgression;", "start", "", "endInclusive", "count", "", "core"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final DoubleProgression fromClosedInterval(double start, double endInclusive, int count) {
            double step = count == 0 ? 0.0 : (endInclusive - start) / (double)(count - 1);
            return new DoubleProgression(start, step, count);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

