/*
 * Decompiled with CFR 0.152.
 */
package com.acmerobotics.roadrunner.trajectory.constraints;

import com.acmerobotics.roadrunner.geometry.Pose2d;
import com.acmerobotics.roadrunner.kinematics.Kinematics;
import com.acmerobotics.roadrunner.trajectory.constraints.TrajectoryVelocityConstraint;
import com.acmerobotics.roadrunner.trajectory.constraints.UnsatisfiableConstraint;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J)\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bH\u0096\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/acmerobotics/roadrunner/trajectory/constraints/TranslationalVelocityConstraint;", "Lcom/acmerobotics/roadrunner/trajectory/constraints/TrajectoryVelocityConstraint;", "maxTranslationalVel", "", "(D)V", "get", "s", "pose", "Lcom/acmerobotics/roadrunner/geometry/Pose2d;", "deriv", "baseRobotVel", "core"})
public final class TranslationalVelocityConstraint
implements TrajectoryVelocityConstraint {
    private final double maxTranslationalVel;

    @Override
    public double get(double s, @NotNull Pose2d pose, @NotNull Pose2d deriv, @NotNull Pose2d baseRobotVel) {
        Intrinsics.checkNotNullParameter((Object)pose, (String)"pose");
        Intrinsics.checkNotNullParameter((Object)deriv, (String)"deriv");
        Intrinsics.checkNotNullParameter((Object)baseRobotVel, (String)"baseRobotVel");
        double v0 = baseRobotVel.vec().norm();
        if (v0 >= this.maxTranslationalVel) {
            throw (Throwable)new UnsatisfiableConstraint();
        }
        Pose2d robotDeriv = Kinematics.fieldToRobotVelocity(pose, deriv);
        double b = baseRobotVel.vec().dot(robotDeriv.vec());
        double d = b * b - v0 * v0 + this.maxTranslationalVel * this.maxTranslationalVel;
        boolean bl = false;
        return Math.sqrt(d) - b;
    }

    public TranslationalVelocityConstraint(double maxTranslationalVel) {
        this.maxTranslationalVel = maxTranslationalVel;
    }
}

