/*
 * Decompiled with CFR 0.152.
 */
package com.acmerobotics.roadrunner.trajectory.constraints;

import com.acmerobotics.roadrunner.geometry.Pose2d;
import com.acmerobotics.roadrunner.kinematics.Kinematics;
import com.acmerobotics.roadrunner.kinematics.MecanumKinematics;
import com.acmerobotics.roadrunner.trajectory.constraints.TrajectoryVelocityConstraint;
import com.acmerobotics.roadrunner.trajectory.constraints.UnsatisfiableConstraint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B+\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J)\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000bH\u0096\u0002R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/acmerobotics/roadrunner/trajectory/constraints/MecanumVelocityConstraint;", "Lcom/acmerobotics/roadrunner/trajectory/constraints/TrajectoryVelocityConstraint;", "maxWheelVel", "", "trackWidth", "wheelBase", "lateralMultiplier", "(DDDD)V", "get", "s", "pose", "Lcom/acmerobotics/roadrunner/geometry/Pose2d;", "deriv", "baseRobotVel", "core"})
public class MecanumVelocityConstraint
implements TrajectoryVelocityConstraint {
    private final double maxWheelVel;
    private final double trackWidth;
    private final double wheelBase;
    private final double lateralMultiplier;

    /*
     * WARNING - void declaration
     */
    @Override
    public double get(double s, @NotNull Pose2d pose, @NotNull Pose2d deriv, @NotNull Pose2d baseRobotVel) {
        void $this$mapTo$iv$iv;
        Double d;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)pose, (String)"pose");
        Intrinsics.checkNotNullParameter((Object)deriv, (String)"deriv");
        Intrinsics.checkNotNullParameter((Object)baseRobotVel, (String)"baseRobotVel");
        List<Double> wheel0 = MecanumKinematics.robotToWheelVelocities(baseRobotVel, this.trackWidth, this.wheelBase, this.lateralMultiplier);
        Iterable $this$map$iv = wheel0;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void p1;
            double d2 = ((Number)item$iv$iv).doubleValue();
            collection = destination$iv$iv;
            boolean bl = false;
            boolean bl2 = false;
            d = Math.abs((double)p1);
            collection.add(d);
        }
        Double d3 = CollectionsKt.maxOrNull((Iterable)((List)destination$iv$iv));
        Intrinsics.checkNotNull((Object)d3);
        if (d3 >= this.maxWheelVel) {
            throw (Throwable)new UnsatisfiableConstraint();
        }
        Pose2d robotDeriv = Kinematics.fieldToRobotVelocity(pose, deriv);
        List<Double> wheel = MecanumKinematics.robotToWheelVelocities(robotDeriv, this.trackWidth, this.wheelBase, this.lateralMultiplier);
        Iterable $this$map$iv2 = CollectionsKt.zip((Iterable)wheel0, (Iterable)wheel);
        boolean $i$f$map2 = false;
        Iterable $i$f$mapTo22 = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pair bl = (Pair)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl3 = false;
            double d4 = (this.maxWheelVel - ((Number)it.getFirst()).doubleValue()) / ((Number)it.getSecond()).doubleValue();
            double d5 = (-this.maxWheelVel - ((Number)it.getFirst()).doubleValue()) / ((Number)it.getSecond()).doubleValue();
            boolean bl4 = false;
            d = Math.max(d4, d5);
            collection.add(d);
        }
        Double d6 = CollectionsKt.minOrNull((Iterable)((List)destination$iv$iv2));
        Intrinsics.checkNotNull((Object)d6);
        return d6;
    }

    @JvmOverloads
    public MecanumVelocityConstraint(double maxWheelVel, double trackWidth, double wheelBase, double lateralMultiplier) {
        this.maxWheelVel = maxWheelVel;
        this.trackWidth = trackWidth;
        this.wheelBase = wheelBase;
        this.lateralMultiplier = lateralMultiplier;
    }

    public /* synthetic */ MecanumVelocityConstraint(double d, double d2, double d3, double d4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            d3 = d2;
        }
        if ((n & 8) != 0) {
            d4 = 1.0;
        }
        this(d, d2, d3, d4);
    }

    @JvmOverloads
    public MecanumVelocityConstraint(double maxWheelVel, double trackWidth, double wheelBase) {
        this(maxWheelVel, trackWidth, wheelBase, 0.0, 8, null);
    }

    @JvmOverloads
    public MecanumVelocityConstraint(double maxWheelVel, double trackWidth) {
        this(maxWheelVel, trackWidth, 0.0, 0.0, 12, null);
    }
}

