/*
 * Decompiled with CFR 0.152.
 */
package com.acmerobotics.roadrunner.trajectory.config;

import com.acmerobotics.roadrunner.trajectory.config.TrajectoryGroupConfig$WhenMappings;
import com.acmerobotics.roadrunner.trajectory.constraints.AngularVelocityConstraint;
import com.acmerobotics.roadrunner.trajectory.constraints.MecanumVelocityConstraint;
import com.acmerobotics.roadrunner.trajectory.constraints.MinVelocityConstraint;
import com.acmerobotics.roadrunner.trajectory.constraints.ProfileAccelerationConstraint;
import com.acmerobotics.roadrunner.trajectory.constraints.TankVelocityConstraint;
import com.acmerobotics.roadrunner.trajectory.constraints.TrajectoryAccelerationConstraint;
import com.acmerobotics.roadrunner.trajectory.constraints.TrajectoryVelocityConstraint;
import com.acmerobotics.roadrunner.trajectory.constraints.TranslationalVelocityConstraint;
import com.fasterxml.jackson.annotation.JsonIgnore;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001:\u00018B[\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\f\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u000eJ\t\u0010%\u001a\u00020\u0003H\u00c6\u0003J\u0010\u0010&\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0016J\t\u0010'\u001a\u00020\u0003H\u00c6\u0003J\t\u0010(\u001a\u00020\u0003H\u00c6\u0003J\t\u0010)\u001a\u00020\u0003H\u00c6\u0003J\t\u0010*\u001a\u00020\u0003H\u00c6\u0003J\t\u0010+\u001a\u00020\u0003H\u00c6\u0003J\t\u0010,\u001a\u00020\nH\u00c6\u0003J\u0010\u0010-\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0016J\u0010\u0010.\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0016Jx\u0010/\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\u00032\b\b\u0002\u0010\t\u001a\u00020\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001\u00a2\u0006\u0002\u00100J\u0013\u00101\u001a\u0002022\b\u00103\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u00104\u001a\u000205H\u00d6\u0001J\t\u00106\u001a\u000207H\u00d6\u0001R\u0016\u0010\u000f\u001a\u00020\u00108\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0015\u0010\r\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\u0017\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0019R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0019R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0019R\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0019R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0019R\u0015\u0010\u000b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\u0017\u001a\u0004\b\u001f\u0010\u0016R\u0016\u0010 \u001a\u00020!8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0015\u0010\f\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\u0017\u001a\u0004\b$\u0010\u0016\u00a8\u00069"}, d2={"Lcom/acmerobotics/roadrunner/trajectory/config/TrajectoryGroupConfig;", "", "maxVel", "", "maxAccel", "maxAngVel", "maxAngAccel", "robotLength", "robotWidth", "driveType", "Lcom/acmerobotics/roadrunner/trajectory/config/TrajectoryGroupConfig$DriveType;", "trackWidth", "wheelBase", "lateralMultiplier", "(DDDDDDLcom/acmerobotics/roadrunner/trajectory/config/TrajectoryGroupConfig$DriveType;Ljava/lang/Double;Ljava/lang/Double;Ljava/lang/Double;)V", "accelConstraint", "Lcom/acmerobotics/roadrunner/trajectory/constraints/TrajectoryAccelerationConstraint;", "getAccelConstraint", "()Lcom/acmerobotics/roadrunner/trajectory/constraints/TrajectoryAccelerationConstraint;", "getDriveType", "()Lcom/acmerobotics/roadrunner/trajectory/config/TrajectoryGroupConfig$DriveType;", "getLateralMultiplier", "()Ljava/lang/Double;", "Ljava/lang/Double;", "getMaxAccel", "()D", "getMaxAngAccel", "getMaxAngVel", "getMaxVel", "getRobotLength", "getRobotWidth", "getTrackWidth", "velConstraint", "Lcom/acmerobotics/roadrunner/trajectory/constraints/TrajectoryVelocityConstraint;", "getVelConstraint", "()Lcom/acmerobotics/roadrunner/trajectory/constraints/TrajectoryVelocityConstraint;", "getWheelBase", "component1", "component10", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "(DDDDDDLcom/acmerobotics/roadrunner/trajectory/config/TrajectoryGroupConfig$DriveType;Ljava/lang/Double;Ljava/lang/Double;Ljava/lang/Double;)Lcom/acmerobotics/roadrunner/trajectory/config/TrajectoryGroupConfig;", "equals", "", "other", "hashCode", "", "toString", "", "DriveType", "core"})
public final class TrajectoryGroupConfig {
    @JsonIgnore
    @NotNull
    private final TrajectoryVelocityConstraint velConstraint;
    @JsonIgnore
    @NotNull
    private final TrajectoryAccelerationConstraint accelConstraint;
    private final double maxVel;
    private final double maxAccel;
    private final double maxAngVel;
    private final double maxAngAccel;
    private final double robotLength;
    private final double robotWidth;
    @NotNull
    private final DriveType driveType;
    @Nullable
    private final Double trackWidth;
    @Nullable
    private final Double wheelBase;
    @Nullable
    private final Double lateralMultiplier;

    @NotNull
    public final TrajectoryVelocityConstraint getVelConstraint() {
        return this.velConstraint;
    }

    @NotNull
    public final TrajectoryAccelerationConstraint getAccelConstraint() {
        return this.accelConstraint;
    }

    public final double getMaxVel() {
        return this.maxVel;
    }

    public final double getMaxAccel() {
        return this.maxAccel;
    }

    public final double getMaxAngVel() {
        return this.maxAngVel;
    }

    public final double getMaxAngAccel() {
        return this.maxAngAccel;
    }

    public final double getRobotLength() {
        return this.robotLength;
    }

    public final double getRobotWidth() {
        return this.robotWidth;
    }

    @NotNull
    public final DriveType getDriveType() {
        return this.driveType;
    }

    @Nullable
    public final Double getTrackWidth() {
        return this.trackWidth;
    }

    @Nullable
    public final Double getWheelBase() {
        return this.wheelBase;
    }

    @Nullable
    public final Double getLateralMultiplier() {
        return this.lateralMultiplier;
    }

    public TrajectoryGroupConfig(double maxVel, double maxAccel, double maxAngVel, double maxAngAccel, double robotLength, double robotWidth, @NotNull DriveType driveType, @Nullable Double trackWidth, @Nullable Double wheelBase, @Nullable Double lateralMultiplier) {
        TrajectoryVelocityConstraint trajectoryVelocityConstraint;
        Intrinsics.checkNotNullParameter((Object)((Object)driveType), (String)"driveType");
        this.maxVel = maxVel;
        this.maxAccel = maxAccel;
        this.maxAngVel = maxAngVel;
        this.maxAngAccel = maxAngAccel;
        this.robotLength = robotLength;
        this.robotWidth = robotWidth;
        this.driveType = driveType;
        this.trackWidth = trackWidth;
        this.wheelBase = wheelBase;
        this.lateralMultiplier = lateralMultiplier;
        Object[] objectArray = new TrajectoryVelocityConstraint[2];
        objectArray[0] = new AngularVelocityConstraint(this.maxAngVel);
        switch (TrajectoryGroupConfig$WhenMappings.$EnumSwitchMapping$0[this.driveType.ordinal()]) {
            case 1: {
                trajectoryVelocityConstraint = new TranslationalVelocityConstraint(this.maxVel);
                break;
            }
            case 2: {
                Double d = this.trackWidth;
                Intrinsics.checkNotNull((Object)d);
                double d2 = d;
                Double d3 = this.wheelBase;
                double d4 = d3 != null ? d3.doubleValue() : this.trackWidth.doubleValue();
                Double d5 = this.lateralMultiplier;
                Intrinsics.checkNotNull((Object)d5);
                trajectoryVelocityConstraint = new MecanumVelocityConstraint(this.maxVel, d2, d4, d5);
                break;
            }
            case 3: {
                Double d = this.trackWidth;
                Intrinsics.checkNotNull((Object)d);
                trajectoryVelocityConstraint = new TankVelocityConstraint(this.maxVel, d);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        objectArray[1] = trajectoryVelocityConstraint;
        this.velConstraint = new MinVelocityConstraint(CollectionsKt.listOf((Object[])objectArray));
        this.accelConstraint = new ProfileAccelerationConstraint(this.maxAccel);
    }

    public final double component1() {
        return this.maxVel;
    }

    public final double component2() {
        return this.maxAccel;
    }

    public final double component3() {
        return this.maxAngVel;
    }

    public final double component4() {
        return this.maxAngAccel;
    }

    public final double component5() {
        return this.robotLength;
    }

    public final double component6() {
        return this.robotWidth;
    }

    @NotNull
    public final DriveType component7() {
        return this.driveType;
    }

    @Nullable
    public final Double component8() {
        return this.trackWidth;
    }

    @Nullable
    public final Double component9() {
        return this.wheelBase;
    }

    @Nullable
    public final Double component10() {
        return this.lateralMultiplier;
    }

    @NotNull
    public final TrajectoryGroupConfig copy(double maxVel, double maxAccel, double maxAngVel, double maxAngAccel, double robotLength, double robotWidth, @NotNull DriveType driveType, @Nullable Double trackWidth, @Nullable Double wheelBase, @Nullable Double lateralMultiplier) {
        Intrinsics.checkNotNullParameter((Object)((Object)driveType), (String)"driveType");
        return new TrajectoryGroupConfig(maxVel, maxAccel, maxAngVel, maxAngAccel, robotLength, robotWidth, driveType, trackWidth, wheelBase, lateralMultiplier);
    }

    public static /* synthetic */ TrajectoryGroupConfig copy$default(TrajectoryGroupConfig trajectoryGroupConfig, double d, double d2, double d3, double d4, double d5, double d6, DriveType driveType, Double d7, Double d8, Double d9, int n, Object object) {
        if ((n & 1) != 0) {
            d = trajectoryGroupConfig.maxVel;
        }
        if ((n & 2) != 0) {
            d2 = trajectoryGroupConfig.maxAccel;
        }
        if ((n & 4) != 0) {
            d3 = trajectoryGroupConfig.maxAngVel;
        }
        if ((n & 8) != 0) {
            d4 = trajectoryGroupConfig.maxAngAccel;
        }
        if ((n & 0x10) != 0) {
            d5 = trajectoryGroupConfig.robotLength;
        }
        if ((n & 0x20) != 0) {
            d6 = trajectoryGroupConfig.robotWidth;
        }
        if ((n & 0x40) != 0) {
            driveType = trajectoryGroupConfig.driveType;
        }
        if ((n & 0x80) != 0) {
            d7 = trajectoryGroupConfig.trackWidth;
        }
        if ((n & 0x100) != 0) {
            d8 = trajectoryGroupConfig.wheelBase;
        }
        if ((n & 0x200) != 0) {
            d9 = trajectoryGroupConfig.lateralMultiplier;
        }
        return trajectoryGroupConfig.copy(d, d2, d3, d4, d5, d6, driveType, d7, d8, d9);
    }

    @NotNull
    public String toString() {
        return "TrajectoryGroupConfig(maxVel=" + this.maxVel + ", maxAccel=" + this.maxAccel + ", maxAngVel=" + this.maxAngVel + ", maxAngAccel=" + this.maxAngAccel + ", robotLength=" + this.robotLength + ", robotWidth=" + this.robotWidth + ", driveType=" + (Object)((Object)this.driveType) + ", trackWidth=" + this.trackWidth + ", wheelBase=" + this.wheelBase + ", lateralMultiplier=" + this.lateralMultiplier + ")";
    }

    public int hashCode() {
        DriveType driveType = this.driveType;
        Double d = this.trackWidth;
        Double d2 = this.wheelBase;
        Double d3 = this.lateralMultiplier;
        return ((((((((Double.hashCode(this.maxVel) * 31 + Double.hashCode(this.maxAccel)) * 31 + Double.hashCode(this.maxAngVel)) * 31 + Double.hashCode(this.maxAngAccel)) * 31 + Double.hashCode(this.robotLength)) * 31 + Double.hashCode(this.robotWidth)) * 31 + (driveType != null ? ((Object)((Object)driveType)).hashCode() : 0)) * 31 + (d != null ? ((Object)d).hashCode() : 0)) * 31 + (d2 != null ? ((Object)d2).hashCode() : 0)) * 31 + (d3 != null ? ((Object)d3).hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof TrajectoryGroupConfig)) break block3;
                TrajectoryGroupConfig trajectoryGroupConfig = (TrajectoryGroupConfig)object;
                if (Double.compare(this.maxVel, trajectoryGroupConfig.maxVel) != 0 || Double.compare(this.maxAccel, trajectoryGroupConfig.maxAccel) != 0 || Double.compare(this.maxAngVel, trajectoryGroupConfig.maxAngVel) != 0 || Double.compare(this.maxAngAccel, trajectoryGroupConfig.maxAngAccel) != 0 || Double.compare(this.robotLength, trajectoryGroupConfig.robotLength) != 0 || Double.compare(this.robotWidth, trajectoryGroupConfig.robotWidth) != 0 || !Intrinsics.areEqual((Object)((Object)this.driveType), (Object)((Object)trajectoryGroupConfig.driveType)) || !Intrinsics.areEqual((Object)this.trackWidth, (Object)trajectoryGroupConfig.trackWidth) || !Intrinsics.areEqual((Object)this.wheelBase, (Object)trajectoryGroupConfig.wheelBase) || !Intrinsics.areEqual((Object)this.lateralMultiplier, (Object)trajectoryGroupConfig.lateralMultiplier)) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/acmerobotics/roadrunner/trajectory/config/TrajectoryGroupConfig$DriveType;", "", "(Ljava/lang/String;I)V", "GENERIC", "MECANUM", "TANK", "core"})
    public static final class DriveType
    extends Enum<DriveType> {
        public static final /* enum */ DriveType GENERIC;
        public static final /* enum */ DriveType MECANUM;
        public static final /* enum */ DriveType TANK;
        private static final /* synthetic */ DriveType[] $VALUES;

        static {
            DriveType[] driveTypeArray = new DriveType[3];
            DriveType[] driveTypeArray2 = driveTypeArray;
            driveTypeArray[0] = GENERIC = new DriveType();
            driveTypeArray[1] = MECANUM = new DriveType();
            driveTypeArray[2] = TANK = new DriveType();
            $VALUES = driveTypeArray;
        }

        public static DriveType[] values() {
            return (DriveType[])$VALUES.clone();
        }

        public static DriveType valueOf(String string) {
            return Enum.valueOf(DriveType.class, string);
        }
    }
}

