/*
 * Decompiled with CFR 0.152.
 */
package com.acmerobotics.roadrunner.trajectory.config;

import com.acmerobotics.roadrunner.geometry.Pose2d;
import com.acmerobotics.roadrunner.geometry.Vector2d;
import com.acmerobotics.roadrunner.trajectory.Trajectory;
import com.acmerobotics.roadrunner.trajectory.TrajectoryBuilder;
import com.acmerobotics.roadrunner.trajectory.config.TrajectoryConfig$WhenMappings;
import com.acmerobotics.roadrunner.trajectory.config.TrajectoryGroupConfig;
import com.acmerobotics.roadrunner.util.Angle;
import com.acmerobotics.roadrunner.util.MathUtilKt;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001:\u0002'(B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0005H\u00c6\u0003J\u000f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0005H\u00c6\u0003J7\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\b\b\u0002\u0010\t\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001J\u0010\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010#\u001a\u00020$J\u0010\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010#\u001a\u00020$R\u0011\u0010\t\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR\u0014\u0010\u0010\u001a\u00020\u0011X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006)"}, d2={"Lcom/acmerobotics/roadrunner/trajectory/config/TrajectoryConfig;", "", "startPose", "Lcom/acmerobotics/roadrunner/geometry/Pose2d;", "startTangent", "", "waypoints", "", "Lcom/acmerobotics/roadrunner/trajectory/config/TrajectoryConfig$Waypoint;", "resolution", "(Lcom/acmerobotics/roadrunner/geometry/Pose2d;DLjava/util/List;D)V", "getResolution", "()D", "getStartPose", "()Lcom/acmerobotics/roadrunner/geometry/Pose2d;", "getStartTangent", "version", "", "getVersion", "()I", "getWaypoints", "()Ljava/util/List;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "", "toTrajectory", "Lcom/acmerobotics/roadrunner/trajectory/Trajectory;", "groupConfig", "Lcom/acmerobotics/roadrunner/trajectory/config/TrajectoryGroupConfig;", "toTrajectoryBuilder", "Lcom/acmerobotics/roadrunner/trajectory/TrajectoryBuilder;", "HeadingInterpolationType", "Waypoint", "core"})
public final class TrajectoryConfig {
    private final int version;
    @NotNull
    private final Pose2d startPose;
    private final double startTangent;
    @NotNull
    private final List<Waypoint> waypoints;
    private final double resolution;

    public final int getVersion() {
        return this.version;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final TrajectoryBuilder toTrajectoryBuilder(@NotNull TrajectoryGroupConfig groupConfig) {
        Intrinsics.checkNotNullParameter((Object)groupConfig, (String)"groupConfig");
        TrajectoryBuilder builder = new TrajectoryBuilder(this.startPose, this.startTangent, groupConfig.getVelConstraint(), groupConfig.getAccelConstraint(), this.resolution);
        int n = 0;
        int n2 = ((Collection)this.waypoints).size();
        while (n < n2) {
            void tangent;
            void position;
            void i;
            Waypoint waypoint = this.waypoints.get((int)i);
            Vector2d vector2d = waypoint.component1();
            double d = waypoint.component2();
            double d2 = waypoint.component3();
            HeadingInterpolationType interpolationType = waypoint.component4();
            double prevTangent = i == false ? this.startTangent : this.waypoints.get((int)(i - true)).getTangent();
            Vector2d prevPosition = i == false ? this.startPose.vec() : this.waypoints.get((int)(i - true)).getPosition();
            double interWaypointAngle = position.minus(prevPosition).angle();
            boolean line = MathUtilKt.epsilonEquals(Angle.normDelta(prevTangent - tangent), 0.0) && MathUtilKt.epsilonEquals(Angle.normDelta((double)(tangent - interWaypointAngle)), 0.0);
            switch (TrajectoryConfig$WhenMappings.$EnumSwitchMapping$0[interpolationType.ordinal()]) {
                case 1: {
                    if (line) {
                        builder.lineTo((Vector2d)position);
                        break;
                    }
                    builder.splineTo((Vector2d)position, (double)tangent);
                    break;
                }
                case 2: {
                    if (line) {
                        builder.lineToConstantHeading((Vector2d)position);
                        break;
                    }
                    builder.splineToConstantHeading((Vector2d)position, (double)tangent);
                    break;
                }
                case 3: {
                    void heading;
                    if (line) {
                        builder.lineToLinearHeading(new Pose2d((Vector2d)position, (double)heading));
                        break;
                    }
                    builder.splineToLinearHeading(new Pose2d((Vector2d)position, (double)heading), (double)tangent);
                    break;
                }
                case 4: {
                    void heading;
                    if (line) {
                        builder.lineToSplineHeading(new Pose2d((Vector2d)position, (double)heading));
                        break;
                    }
                    builder.splineToSplineHeading(new Pose2d((Vector2d)position, (double)heading), (double)tangent);
                    break;
                }
            }
            ++i;
        }
        return builder;
    }

    @Nullable
    public final Trajectory toTrajectory(@NotNull TrajectoryGroupConfig groupConfig) {
        Intrinsics.checkNotNullParameter((Object)groupConfig, (String)"groupConfig");
        TrajectoryBuilder trajectoryBuilder = this.toTrajectoryBuilder(groupConfig);
        return trajectoryBuilder != null ? trajectoryBuilder.build() : null;
    }

    @NotNull
    public final Pose2d getStartPose() {
        return this.startPose;
    }

    public final double getStartTangent() {
        return this.startTangent;
    }

    @NotNull
    public final List<Waypoint> getWaypoints() {
        return this.waypoints;
    }

    public final double getResolution() {
        return this.resolution;
    }

    public TrajectoryConfig(@NotNull Pose2d startPose, double startTangent, @NotNull List<Waypoint> waypoints, double resolution) {
        Intrinsics.checkNotNullParameter((Object)startPose, (String)"startPose");
        Intrinsics.checkNotNullParameter(waypoints, (String)"waypoints");
        this.startPose = startPose;
        this.startTangent = startTangent;
        this.waypoints = waypoints;
        this.resolution = resolution;
        this.version = 1;
    }

    @NotNull
    public final Pose2d component1() {
        return this.startPose;
    }

    public final double component2() {
        return this.startTangent;
    }

    @NotNull
    public final List<Waypoint> component3() {
        return this.waypoints;
    }

    public final double component4() {
        return this.resolution;
    }

    @NotNull
    public final TrajectoryConfig copy(@NotNull Pose2d startPose, double startTangent, @NotNull List<Waypoint> waypoints, double resolution) {
        Intrinsics.checkNotNullParameter((Object)startPose, (String)"startPose");
        Intrinsics.checkNotNullParameter(waypoints, (String)"waypoints");
        return new TrajectoryConfig(startPose, startTangent, waypoints, resolution);
    }

    public static /* synthetic */ TrajectoryConfig copy$default(TrajectoryConfig trajectoryConfig, Pose2d pose2d, double d, List list, double d2, int n, Object object) {
        if ((n & 1) != 0) {
            pose2d = trajectoryConfig.startPose;
        }
        if ((n & 2) != 0) {
            d = trajectoryConfig.startTangent;
        }
        if ((n & 4) != 0) {
            list = trajectoryConfig.waypoints;
        }
        if ((n & 8) != 0) {
            d2 = trajectoryConfig.resolution;
        }
        return trajectoryConfig.copy(pose2d, d, list, d2);
    }

    @NotNull
    public String toString() {
        return "TrajectoryConfig(startPose=" + this.startPose + ", startTangent=" + this.startTangent + ", waypoints=" + this.waypoints + ", resolution=" + this.resolution + ")";
    }

    public int hashCode() {
        Pose2d pose2d = this.startPose;
        List<Waypoint> list = this.waypoints;
        return (((pose2d != null ? ((Object)pose2d).hashCode() : 0) * 31 + Double.hashCode(this.startTangent)) * 31 + (list != null ? ((Object)list).hashCode() : 0)) * 31 + Double.hashCode(this.resolution);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof TrajectoryConfig)) break block3;
                TrajectoryConfig trajectoryConfig = (TrajectoryConfig)object;
                if (!Intrinsics.areEqual((Object)this.startPose, (Object)trajectoryConfig.startPose) || Double.compare(this.startTangent, trajectoryConfig.startTangent) != 0 || !Intrinsics.areEqual(this.waypoints, trajectoryConfig.waypoints) || Double.compare(this.resolution, trajectoryConfig.resolution) != 0) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/acmerobotics/roadrunner/trajectory/config/TrajectoryConfig$HeadingInterpolationType;", "", "(Ljava/lang/String;I)V", "TANGENT", "CONSTANT", "LINEAR", "SPLINE", "core"})
    public static final class HeadingInterpolationType
    extends Enum<HeadingInterpolationType> {
        public static final /* enum */ HeadingInterpolationType TANGENT;
        public static final /* enum */ HeadingInterpolationType CONSTANT;
        public static final /* enum */ HeadingInterpolationType LINEAR;
        public static final /* enum */ HeadingInterpolationType SPLINE;
        private static final /* synthetic */ HeadingInterpolationType[] $VALUES;

        static {
            HeadingInterpolationType[] headingInterpolationTypeArray = new HeadingInterpolationType[4];
            HeadingInterpolationType[] headingInterpolationTypeArray2 = headingInterpolationTypeArray;
            headingInterpolationTypeArray[0] = TANGENT = new HeadingInterpolationType();
            headingInterpolationTypeArray[1] = CONSTANT = new HeadingInterpolationType();
            headingInterpolationTypeArray[2] = LINEAR = new HeadingInterpolationType();
            headingInterpolationTypeArray[3] = SPLINE = new HeadingInterpolationType();
            $VALUES = headingInterpolationTypeArray;
        }

        public static HeadingInterpolationType[] values() {
            return (HeadingInterpolationType[])$VALUES.clone();
        }

        public static HeadingInterpolationType valueOf(String string) {
            return Enum.valueOf(HeadingInterpolationType.class, string);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\bH\u00c6\u0003J1\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000b\u00a8\u0006\u001d"}, d2={"Lcom/acmerobotics/roadrunner/trajectory/config/TrajectoryConfig$Waypoint;", "", "position", "Lcom/acmerobotics/roadrunner/geometry/Vector2d;", "heading", "", "tangent", "interpolationType", "Lcom/acmerobotics/roadrunner/trajectory/config/TrajectoryConfig$HeadingInterpolationType;", "(Lcom/acmerobotics/roadrunner/geometry/Vector2d;DDLcom/acmerobotics/roadrunner/trajectory/config/TrajectoryConfig$HeadingInterpolationType;)V", "getHeading", "()D", "getInterpolationType", "()Lcom/acmerobotics/roadrunner/trajectory/config/TrajectoryConfig$HeadingInterpolationType;", "getPosition", "()Lcom/acmerobotics/roadrunner/geometry/Vector2d;", "getTangent", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "", "core"})
    public static final class Waypoint {
        @NotNull
        private final Vector2d position;
        private final double heading;
        private final double tangent;
        @NotNull
        private final HeadingInterpolationType interpolationType;

        @NotNull
        public final Vector2d getPosition() {
            return this.position;
        }

        public final double getHeading() {
            return this.heading;
        }

        public final double getTangent() {
            return this.tangent;
        }

        @NotNull
        public final HeadingInterpolationType getInterpolationType() {
            return this.interpolationType;
        }

        public Waypoint(@NotNull Vector2d position, double heading, double tangent, @NotNull HeadingInterpolationType interpolationType) {
            Intrinsics.checkNotNullParameter((Object)position, (String)"position");
            Intrinsics.checkNotNullParameter((Object)((Object)interpolationType), (String)"interpolationType");
            this.position = position;
            this.heading = heading;
            this.tangent = tangent;
            this.interpolationType = interpolationType;
        }

        @NotNull
        public final Vector2d component1() {
            return this.position;
        }

        public final double component2() {
            return this.heading;
        }

        public final double component3() {
            return this.tangent;
        }

        @NotNull
        public final HeadingInterpolationType component4() {
            return this.interpolationType;
        }

        @NotNull
        public final Waypoint copy(@NotNull Vector2d position, double heading, double tangent, @NotNull HeadingInterpolationType interpolationType) {
            Intrinsics.checkNotNullParameter((Object)position, (String)"position");
            Intrinsics.checkNotNullParameter((Object)((Object)interpolationType), (String)"interpolationType");
            return new Waypoint(position, heading, tangent, interpolationType);
        }

        public static /* synthetic */ Waypoint copy$default(Waypoint waypoint, Vector2d vector2d, double d, double d2, HeadingInterpolationType headingInterpolationType, int n, Object object) {
            if ((n & 1) != 0) {
                vector2d = waypoint.position;
            }
            if ((n & 2) != 0) {
                d = waypoint.heading;
            }
            if ((n & 4) != 0) {
                d2 = waypoint.tangent;
            }
            if ((n & 8) != 0) {
                headingInterpolationType = waypoint.interpolationType;
            }
            return waypoint.copy(vector2d, d, d2, headingInterpolationType);
        }

        @NotNull
        public String toString() {
            return "Waypoint(position=" + this.position + ", heading=" + this.heading + ", tangent=" + this.tangent + ", interpolationType=" + (Object)((Object)this.interpolationType) + ")";
        }

        public int hashCode() {
            Vector2d vector2d = this.position;
            HeadingInterpolationType headingInterpolationType = this.interpolationType;
            return (((vector2d != null ? ((Object)vector2d).hashCode() : 0) * 31 + Double.hashCode(this.heading)) * 31 + Double.hashCode(this.tangent)) * 31 + (headingInterpolationType != null ? ((Object)((Object)headingInterpolationType)).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Waypoint)) break block3;
                    Waypoint waypoint = (Waypoint)object;
                    if (!Intrinsics.areEqual((Object)this.position, (Object)waypoint.position) || Double.compare(this.heading, waypoint.heading) != 0 || Double.compare(this.tangent, waypoint.tangent) != 0 || !Intrinsics.areEqual((Object)((Object)this.interpolationType), (Object)((Object)waypoint.interpolationType))) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

