/*
 * Decompiled with CFR 0.152.
 */
package com.acmerobotics.roadrunner.trajectory;

import com.acmerobotics.roadrunner.geometry.Pose2d;
import com.acmerobotics.roadrunner.geometry.Vector2d;
import com.acmerobotics.roadrunner.path.Path;
import com.acmerobotics.roadrunner.profile.AccelerationConstraint;
import com.acmerobotics.roadrunner.profile.MotionProfile;
import com.acmerobotics.roadrunner.profile.MotionProfileGenerator;
import com.acmerobotics.roadrunner.profile.MotionState;
import com.acmerobotics.roadrunner.profile.VelocityConstraint;
import com.acmerobotics.roadrunner.trajectory.DisplacementMarker;
import com.acmerobotics.roadrunner.trajectory.MarkerCallback;
import com.acmerobotics.roadrunner.trajectory.SpatialMarker;
import com.acmerobotics.roadrunner.trajectory.TemporalMarker;
import com.acmerobotics.roadrunner.trajectory.TimeProducer;
import com.acmerobotics.roadrunner.trajectory.Trajectory;
import com.acmerobotics.roadrunner.trajectory.TrajectoryMarker;
import com.acmerobotics.roadrunner.trajectory.constraints.TrajectoryAccelerationConstraint;
import com.acmerobotics.roadrunner.trajectory.constraints.TrajectoryVelocityConstraint;
import com.acmerobotics.roadrunner.util.MathUtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JH\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00042\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u00042\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0004H\u0002J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0011H\u0002J8\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u0011H\u0002J0\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0002Jl\u0010 \u001a\u00020!2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020\u00112\b\b\u0002\u0010\u0018\u001a\u00020\u00192\b\b\u0002\u0010\u001a\u001a\u00020\u00192\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00042\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u00042\u000e\b\u0002\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0004H\u0007Jn\u0010\"\u001a\u00020!2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\u0018\u001a\u00020\u00192\b\b\u0002\u0010\u001a\u001a\u00020\u00192\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00042\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u00042\u000e\b\u0002\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00042\b\b\u0002\u0010\u001b\u001a\u00020\u0011H\u0007J \u0010#\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010$\u001a\u00020%H\u0002\u00a8\u0006&"}, d2={"Lcom/acmerobotics/roadrunner/trajectory/TrajectoryGenerator;", "", "()V", "convertMarkers", "", "Lcom/acmerobotics/roadrunner/trajectory/TrajectoryMarker;", "path", "Lcom/acmerobotics/roadrunner/path/Path;", "profile", "Lcom/acmerobotics/roadrunner/profile/MotionProfile;", "temporalMarkers", "Lcom/acmerobotics/roadrunner/trajectory/TemporalMarker;", "displacementMarkers", "Lcom/acmerobotics/roadrunner/trajectory/DisplacementMarker;", "spatialMarkers", "Lcom/acmerobotics/roadrunner/trajectory/SpatialMarker;", "displacementToTime", "", "s", "generateProfile", "velocityConstraint", "Lcom/acmerobotics/roadrunner/trajectory/constraints/TrajectoryVelocityConstraint;", "accelerationConstraint", "Lcom/acmerobotics/roadrunner/trajectory/constraints/TrajectoryAccelerationConstraint;", "start", "Lcom/acmerobotics/roadrunner/profile/MotionState;", "goal", "resolution", "generateSimpleProfile", "maxProfileVel", "maxProfileAccel", "maxProfileJerk", "generateSimpleTrajectory", "Lcom/acmerobotics/roadrunner/trajectory/Trajectory;", "generateTrajectory", "pointToTime", "point", "Lcom/acmerobotics/roadrunner/geometry/Vector2d;", "core"})
public final class TrajectoryGenerator {
    public static final TrajectoryGenerator INSTANCE;

    private final MotionProfile generateProfile(Path path, TrajectoryVelocityConstraint velocityConstraint, TrajectoryAccelerationConstraint accelerationConstraint, MotionState start, MotionState goal, double resolution) {
        return MotionProfileGenerator.generateMotionProfile(start, goal, new VelocityConstraint(path, velocityConstraint){
            final /* synthetic */ Path $path;
            final /* synthetic */ TrajectoryVelocityConstraint $velocityConstraint;

            public final double get(double s) {
                double t = this.$path.reparam$core(s);
                return this.$velocityConstraint.get(s, this.$path.get(s, t), this.$path.deriv(s, t), new Pose2d(0.0, 0.0, 0.0, 7, null));
            }
            {
                this.$path = path;
                this.$velocityConstraint = trajectoryVelocityConstraint;
            }
        }, new AccelerationConstraint(path, accelerationConstraint){
            final /* synthetic */ Path $path;
            final /* synthetic */ TrajectoryAccelerationConstraint $accelerationConstraint;

            public final double get(double s) {
                double t = this.$path.reparam$core(s);
                return this.$accelerationConstraint.get(s, this.$path.get(s, t), this.$path.deriv(s, t), new Pose2d(0.0, 0.0, 0.0, 7, null));
            }
            {
                this.$path = path;
                this.$accelerationConstraint = trajectoryAccelerationConstraint;
            }
        }, resolution);
    }

    private final MotionProfile generateSimpleProfile(double maxProfileVel, double maxProfileAccel, double maxProfileJerk, MotionState start, MotionState goal) {
        return MotionProfileGenerator.generateSimpleMotionProfile$default(start, goal, maxProfileVel, maxProfileAccel, maxProfileJerk, false, 32, null);
    }

    private final double displacementToTime(MotionProfile profile, double s) {
        double tLo = 0.0;
        double tHi = profile.duration();
        while (!MathUtilKt.epsilonEquals(tLo, tHi)) {
            double tMid = 0.5 * (tLo + tHi);
            if (profile.get(tMid).getX() > s) {
                tHi = tMid;
                continue;
            }
            tLo = tMid;
        }
        return 0.5 * (tLo + tHi);
    }

    private final double pointToTime(Path path, MotionProfile profile, Vector2d point) {
        return this.displacementToTime(profile, Path.project$default(path, point, 0.0, 2, null));
    }

    /*
     * WARNING - void declaration
     */
    private final List<TrajectoryMarker> convertMarkers(Path path, MotionProfile profile, List<TemporalMarker> temporalMarkers, List<DisplacementMarker> displacementMarkers, List<SpatialMarker> spatialMarkers) {
        TrajectoryMarker trajectoryMarker;
        Object object;
        Object producer;
        MarkerCallback callback;
        Object $dstr$producer$callback;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv = temporalMarkers;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            TemporalMarker temporalMarker = (TemporalMarker)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            TimeProducer timeProducer = ((TemporalMarker)$dstr$producer$callback).component1();
            callback = ((TemporalMarker)$dstr$producer$callback).component2();
            object = new TrajectoryMarker(producer.produce(profile.duration()), callback);
            collection.add(object);
        }
        $this$map$iv = displacementMarkers;
        collection = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            $dstr$producer$callback = (DisplacementMarker)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            producer = ((DisplacementMarker)$dstr$producer$callback).component1();
            callback = ((DisplacementMarker)$dstr$producer$callback).component2();
            trajectoryMarker = new TrajectoryMarker(INSTANCE.displacementToTime(profile, producer.produce(path.length())), callback);
            object.add(trajectoryMarker);
        }
        object = (List)destination$iv$iv;
        $this$map$iv = spatialMarkers;
        collection = CollectionsKt.plus((Collection)collection, (Iterable)((Iterable)object));
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void point;
            void $dstr$point$callback;
            $dstr$producer$callback = (SpatialMarker)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            producer = $dstr$point$callback.component1();
            callback = $dstr$point$callback.component2();
            trajectoryMarker = new TrajectoryMarker(INSTANCE.pointToTime(path, profile, (Vector2d)point), callback);
            object.add(trajectoryMarker);
        }
        object = (List)destination$iv$iv;
        return CollectionsKt.plus((Collection)collection, (Iterable)((Iterable)object));
    }

    @JvmOverloads
    @NotNull
    public final Trajectory generateTrajectory(@NotNull Path path, @NotNull TrajectoryVelocityConstraint velocityConstraint, @NotNull TrajectoryAccelerationConstraint accelerationConstraint, @NotNull MotionState start, @NotNull MotionState goal, @NotNull List<TemporalMarker> temporalMarkers, @NotNull List<DisplacementMarker> displacementMarkers, @NotNull List<SpatialMarker> spatialMarkers, double resolution) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)velocityConstraint, (String)"velocityConstraint");
        Intrinsics.checkNotNullParameter((Object)accelerationConstraint, (String)"accelerationConstraint");
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)goal, (String)"goal");
        Intrinsics.checkNotNullParameter(temporalMarkers, (String)"temporalMarkers");
        Intrinsics.checkNotNullParameter(displacementMarkers, (String)"displacementMarkers");
        Intrinsics.checkNotNullParameter(spatialMarkers, (String)"spatialMarkers");
        MotionProfile profile = this.generateProfile(path, velocityConstraint, accelerationConstraint, start, goal, resolution);
        List<TrajectoryMarker> markers = this.convertMarkers(path, profile, temporalMarkers, displacementMarkers, spatialMarkers);
        return new Trajectory(path, profile, markers);
    }

    public static /* synthetic */ Trajectory generateTrajectory$default(TrajectoryGenerator trajectoryGenerator, Path path, TrajectoryVelocityConstraint trajectoryVelocityConstraint, TrajectoryAccelerationConstraint trajectoryAccelerationConstraint, MotionState motionState, MotionState motionState2, List list, List list2, List list3, double d, int n, Object object) {
        if ((n & 8) != 0) {
            motionState = new MotionState(0.0, 0.0, 0.0, 0.0, 8, null);
        }
        if ((n & 0x10) != 0) {
            motionState2 = new MotionState(path.length(), 0.0, 0.0, 0.0, 8, null);
        }
        if ((n & 0x20) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 0x40) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n & 0x80) != 0) {
            list3 = CollectionsKt.emptyList();
        }
        if ((n & 0x100) != 0) {
            d = 0.25;
        }
        return trajectoryGenerator.generateTrajectory(path, trajectoryVelocityConstraint, trajectoryAccelerationConstraint, motionState, motionState2, list, list2, list3, d);
    }

    @JvmOverloads
    @NotNull
    public final Trajectory generateTrajectory(@NotNull Path path, @NotNull TrajectoryVelocityConstraint velocityConstraint, @NotNull TrajectoryAccelerationConstraint accelerationConstraint, @NotNull MotionState start, @NotNull MotionState goal, @NotNull List<TemporalMarker> temporalMarkers, @NotNull List<DisplacementMarker> displacementMarkers, @NotNull List<SpatialMarker> spatialMarkers) {
        return TrajectoryGenerator.generateTrajectory$default(this, path, velocityConstraint, accelerationConstraint, start, goal, temporalMarkers, displacementMarkers, spatialMarkers, 0.0, 256, null);
    }

    @JvmOverloads
    @NotNull
    public final Trajectory generateTrajectory(@NotNull Path path, @NotNull TrajectoryVelocityConstraint velocityConstraint, @NotNull TrajectoryAccelerationConstraint accelerationConstraint, @NotNull MotionState start, @NotNull MotionState goal, @NotNull List<TemporalMarker> temporalMarkers, @NotNull List<DisplacementMarker> displacementMarkers) {
        return TrajectoryGenerator.generateTrajectory$default(this, path, velocityConstraint, accelerationConstraint, start, goal, temporalMarkers, displacementMarkers, null, 0.0, 384, null);
    }

    @JvmOverloads
    @NotNull
    public final Trajectory generateTrajectory(@NotNull Path path, @NotNull TrajectoryVelocityConstraint velocityConstraint, @NotNull TrajectoryAccelerationConstraint accelerationConstraint, @NotNull MotionState start, @NotNull MotionState goal, @NotNull List<TemporalMarker> temporalMarkers) {
        return TrajectoryGenerator.generateTrajectory$default(this, path, velocityConstraint, accelerationConstraint, start, goal, temporalMarkers, null, null, 0.0, 448, null);
    }

    @JvmOverloads
    @NotNull
    public final Trajectory generateTrajectory(@NotNull Path path, @NotNull TrajectoryVelocityConstraint velocityConstraint, @NotNull TrajectoryAccelerationConstraint accelerationConstraint, @NotNull MotionState start, @NotNull MotionState goal) {
        return TrajectoryGenerator.generateTrajectory$default(this, path, velocityConstraint, accelerationConstraint, start, goal, null, null, null, 0.0, 480, null);
    }

    @JvmOverloads
    @NotNull
    public final Trajectory generateTrajectory(@NotNull Path path, @NotNull TrajectoryVelocityConstraint velocityConstraint, @NotNull TrajectoryAccelerationConstraint accelerationConstraint, @NotNull MotionState start) {
        return TrajectoryGenerator.generateTrajectory$default(this, path, velocityConstraint, accelerationConstraint, start, null, null, null, null, 0.0, 496, null);
    }

    @JvmOverloads
    @NotNull
    public final Trajectory generateTrajectory(@NotNull Path path, @NotNull TrajectoryVelocityConstraint velocityConstraint, @NotNull TrajectoryAccelerationConstraint accelerationConstraint) {
        return TrajectoryGenerator.generateTrajectory$default(this, path, velocityConstraint, accelerationConstraint, null, null, null, null, null, 0.0, 504, null);
    }

    @JvmOverloads
    @NotNull
    public final Trajectory generateSimpleTrajectory(@NotNull Path path, double maxProfileVel, double maxProfileAccel, double maxProfileJerk, @NotNull MotionState start, @NotNull MotionState goal, @NotNull List<TemporalMarker> temporalMarkers, @NotNull List<DisplacementMarker> displacementMarkers, @NotNull List<SpatialMarker> spatialMarkers) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)goal, (String)"goal");
        Intrinsics.checkNotNullParameter(temporalMarkers, (String)"temporalMarkers");
        Intrinsics.checkNotNullParameter(displacementMarkers, (String)"displacementMarkers");
        Intrinsics.checkNotNullParameter(spatialMarkers, (String)"spatialMarkers");
        MotionProfile profile = this.generateSimpleProfile(maxProfileVel, maxProfileAccel, maxProfileJerk, start, goal);
        List<TrajectoryMarker> markers = this.convertMarkers(path, profile, temporalMarkers, displacementMarkers, spatialMarkers);
        return new Trajectory(path, profile, markers);
    }

    public static /* synthetic */ Trajectory generateSimpleTrajectory$default(TrajectoryGenerator trajectoryGenerator, Path path, double d, double d2, double d3, MotionState motionState, MotionState motionState2, List list, List list2, List list3, int n, Object object) {
        if ((n & 0x10) != 0) {
            motionState = new MotionState(0.0, 0.0, 0.0, 0.0);
        }
        if ((n & 0x20) != 0) {
            motionState2 = new MotionState(path.length(), 0.0, 0.0, 0.0);
        }
        if ((n & 0x40) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 0x80) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n & 0x100) != 0) {
            list3 = CollectionsKt.emptyList();
        }
        return trajectoryGenerator.generateSimpleTrajectory(path, d, d2, d3, motionState, motionState2, list, list2, list3);
    }

    @JvmOverloads
    @NotNull
    public final Trajectory generateSimpleTrajectory(@NotNull Path path, double maxProfileVel, double maxProfileAccel, double maxProfileJerk, @NotNull MotionState start, @NotNull MotionState goal, @NotNull List<TemporalMarker> temporalMarkers, @NotNull List<DisplacementMarker> displacementMarkers) {
        return TrajectoryGenerator.generateSimpleTrajectory$default(this, path, maxProfileVel, maxProfileAccel, maxProfileJerk, start, goal, temporalMarkers, displacementMarkers, null, 256, null);
    }

    @JvmOverloads
    @NotNull
    public final Trajectory generateSimpleTrajectory(@NotNull Path path, double maxProfileVel, double maxProfileAccel, double maxProfileJerk, @NotNull MotionState start, @NotNull MotionState goal, @NotNull List<TemporalMarker> temporalMarkers) {
        return TrajectoryGenerator.generateSimpleTrajectory$default(this, path, maxProfileVel, maxProfileAccel, maxProfileJerk, start, goal, temporalMarkers, null, null, 384, null);
    }

    @JvmOverloads
    @NotNull
    public final Trajectory generateSimpleTrajectory(@NotNull Path path, double maxProfileVel, double maxProfileAccel, double maxProfileJerk, @NotNull MotionState start, @NotNull MotionState goal) {
        return TrajectoryGenerator.generateSimpleTrajectory$default(this, path, maxProfileVel, maxProfileAccel, maxProfileJerk, start, goal, null, null, null, 448, null);
    }

    @JvmOverloads
    @NotNull
    public final Trajectory generateSimpleTrajectory(@NotNull Path path, double maxProfileVel, double maxProfileAccel, double maxProfileJerk, @NotNull MotionState start) {
        return TrajectoryGenerator.generateSimpleTrajectory$default(this, path, maxProfileVel, maxProfileAccel, maxProfileJerk, start, null, null, null, null, 480, null);
    }

    @JvmOverloads
    @NotNull
    public final Trajectory generateSimpleTrajectory(@NotNull Path path, double maxProfileVel, double maxProfileAccel, double maxProfileJerk) {
        return TrajectoryGenerator.generateSimpleTrajectory$default(this, path, maxProfileVel, maxProfileAccel, maxProfileJerk, null, null, null, null, null, 496, null);
    }

    private TrajectoryGenerator() {
    }

    static {
        TrajectoryGenerator trajectoryGenerator;
        INSTANCE = trajectoryGenerator = new TrajectoryGenerator();
    }
}

