/*
 * Decompiled with CFR 0.152.
 */
package com.acmerobotics.roadrunner.trajectory;

import com.acmerobotics.roadrunner.geometry.Pose2d;
import com.acmerobotics.roadrunner.geometry.Vector2d;
import com.acmerobotics.roadrunner.path.Path;
import com.acmerobotics.roadrunner.profile.MotionState;
import com.acmerobotics.roadrunner.trajectory.BaseTrajectoryBuilder;
import com.acmerobotics.roadrunner.trajectory.DisplacementMarker;
import com.acmerobotics.roadrunner.trajectory.IntervalAccelerationConstraint;
import com.acmerobotics.roadrunner.trajectory.IntervalVelocityConstraint;
import com.acmerobotics.roadrunner.trajectory.PiecewiseAccelerationConstraint;
import com.acmerobotics.roadrunner.trajectory.PiecewiseVelocityConstraint;
import com.acmerobotics.roadrunner.trajectory.SpatialMarker;
import com.acmerobotics.roadrunner.trajectory.TemporalMarker;
import com.acmerobotics.roadrunner.trajectory.Trajectory;
import com.acmerobotics.roadrunner.trajectory.TrajectoryBuilderKt;
import com.acmerobotics.roadrunner.trajectory.TrajectoryGenerator;
import com.acmerobotics.roadrunner.trajectory.constraints.TrajectoryAccelerationConstraint;
import com.acmerobotics.roadrunner.trajectory.constraints.TrajectoryVelocityConstraint;
import com.acmerobotics.roadrunner.util.Angle;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B3\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u000bB1\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u000eB1\b\u0017\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0012BO\b\u0002\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u0012\b\u0010\u0011\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u0012\u0006\u0010\n\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0015J*\u0010\u001b\u001a\u00020\u00002\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\b\u0010\u001f\u001a\u0004\u0018\u00010\u00072\b\u0010 \u001a\u0004\u0018\u00010\tH\u0002J\"\u0010!\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\u00052\b\u0010\u001f\u001a\u0004\u0018\u00010\u00072\b\u0010 \u001a\u0004\u0018\u00010\tJ:\u0010#\u001a\u00020\u00102\u0006\u0010$\u001a\u00020%2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020*0'2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020,0'H\u0014J\"\u0010-\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\u00052\b\u0010\u001f\u001a\u0004\u0018\u00010\u00072\b\u0010 \u001a\u0004\u0018\u00010\tJ\"\u0010.\u001a\u00020\u00002\u0006\u0010/\u001a\u0002002\b\u0010\u001f\u001a\u0004\u0018\u00010\u00072\b\u0010 \u001a\u0004\u0018\u00010\tJ\"\u00101\u001a\u00020\u00002\u0006\u0010/\u001a\u0002002\b\u0010\u001f\u001a\u0004\u0018\u00010\u00072\b\u0010 \u001a\u0004\u0018\u00010\tJ\"\u00102\u001a\u00020\u00002\u0006\u00103\u001a\u00020\u00032\b\u0010\u001f\u001a\u0004\u0018\u00010\u00072\b\u0010 \u001a\u0004\u0018\u00010\tJ\"\u00104\u001a\u00020\u00002\u0006\u00103\u001a\u00020\u00032\b\u0010\u001f\u001a\u0004\u0018\u00010\u00072\b\u0010 \u001a\u0004\u0018\u00010\tJ*\u00105\u001a\u00020\u00002\u0006\u0010/\u001a\u0002002\u0006\u00106\u001a\u00020\u00052\b\u0010\u001f\u001a\u0004\u0018\u00010\u00072\b\u0010 \u001a\u0004\u0018\u00010\tJ*\u00107\u001a\u00020\u00002\u0006\u0010/\u001a\u0002002\u0006\u00106\u001a\u00020\u00052\b\u0010\u001f\u001a\u0004\u0018\u00010\u00072\b\u0010 \u001a\u0004\u0018\u00010\tJ*\u00108\u001a\u00020\u00002\u0006\u00103\u001a\u00020\u00032\u0006\u00106\u001a\u00020\u00052\b\u0010\u001f\u001a\u0004\u0018\u00010\u00072\b\u0010 \u001a\u0004\u0018\u00010\tJ*\u00109\u001a\u00020\u00002\u0006\u00103\u001a\u00020\u00032\u0006\u00106\u001a\u00020\u00052\b\u0010\u001f\u001a\u0004\u0018\u00010\u00072\b\u0010 \u001a\u0004\u0018\u00010\tJ\"\u0010:\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\u00052\b\u0010\u001f\u001a\u0004\u0018\u00010\u00072\b\u0010 \u001a\u0004\u0018\u00010\tJ\"\u0010;\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\u00052\b\u0010\u001f\u001a\u0004\u0018\u00010\u00072\b\u0010 \u001a\u0004\u0018\u00010\tJ\"\u0010<\u001a\u00020\u00002\u0006\u0010/\u001a\u0002002\b\u0010\u001f\u001a\u0004\u0018\u00010\u00072\b\u0010 \u001a\u0004\u0018\u00010\tR\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lcom/acmerobotics/roadrunner/trajectory/TrajectoryBuilder;", "Lcom/acmerobotics/roadrunner/trajectory/BaseTrajectoryBuilder;", "startPose", "Lcom/acmerobotics/roadrunner/geometry/Pose2d;", "startTangent", "", "baseVelConstraint", "Lcom/acmerobotics/roadrunner/trajectory/constraints/TrajectoryVelocityConstraint;", "baseAccelConstraint", "Lcom/acmerobotics/roadrunner/trajectory/constraints/TrajectoryAccelerationConstraint;", "resolution", "(Lcom/acmerobotics/roadrunner/geometry/Pose2d;DLcom/acmerobotics/roadrunner/trajectory/constraints/TrajectoryVelocityConstraint;Lcom/acmerobotics/roadrunner/trajectory/constraints/TrajectoryAccelerationConstraint;D)V", "reversed", "", "(Lcom/acmerobotics/roadrunner/geometry/Pose2d;ZLcom/acmerobotics/roadrunner/trajectory/constraints/TrajectoryVelocityConstraint;Lcom/acmerobotics/roadrunner/trajectory/constraints/TrajectoryAccelerationConstraint;D)V", "trajectory", "Lcom/acmerobotics/roadrunner/trajectory/Trajectory;", "t", "(Lcom/acmerobotics/roadrunner/trajectory/Trajectory;DLcom/acmerobotics/roadrunner/trajectory/constraints/TrajectoryVelocityConstraint;Lcom/acmerobotics/roadrunner/trajectory/constraints/TrajectoryAccelerationConstraint;D)V", "start", "Lcom/acmerobotics/roadrunner/profile/MotionState;", "(Lcom/acmerobotics/roadrunner/geometry/Pose2d;Ljava/lang/Double;Lcom/acmerobotics/roadrunner/trajectory/Trajectory;Ljava/lang/Double;Lcom/acmerobotics/roadrunner/trajectory/constraints/TrajectoryVelocityConstraint;Lcom/acmerobotics/roadrunner/trajectory/constraints/TrajectoryAccelerationConstraint;Lcom/acmerobotics/roadrunner/profile/MotionState;D)V", "accelConstraintOverrides", "", "Lcom/acmerobotics/roadrunner/trajectory/IntervalAccelerationConstraint;", "velConstraintOverrides", "Lcom/acmerobotics/roadrunner/trajectory/IntervalVelocityConstraint;", "addSegment", "add", "Lkotlin/Function0;", "", "velConstraintOverride", "accelConstraintOverride", "back", "distance", "buildTrajectory", "path", "Lcom/acmerobotics/roadrunner/path/Path;", "temporalMarkers", "", "Lcom/acmerobotics/roadrunner/trajectory/TemporalMarker;", "displacementMarkers", "Lcom/acmerobotics/roadrunner/trajectory/DisplacementMarker;", "spatialMarkers", "Lcom/acmerobotics/roadrunner/trajectory/SpatialMarker;", "forward", "lineTo", "endPosition", "Lcom/acmerobotics/roadrunner/geometry/Vector2d;", "lineToConstantHeading", "lineToLinearHeading", "endPose", "lineToSplineHeading", "splineTo", "endTangent", "splineToConstantHeading", "splineToLinearHeading", "splineToSplineHeading", "strafeLeft", "strafeRight", "strafeTo", "core"})
public final class TrajectoryBuilder
extends BaseTrajectoryBuilder<TrajectoryBuilder> {
    private final List<IntervalVelocityConstraint> velConstraintOverrides;
    private final List<IntervalAccelerationConstraint> accelConstraintOverrides;
    private final TrajectoryVelocityConstraint baseVelConstraint;
    private final TrajectoryAccelerationConstraint baseAccelConstraint;
    private final MotionState start;
    private final double resolution;

    private final TrajectoryBuilder addSegment(Function0<Unit> add, TrajectoryVelocityConstraint velConstraintOverride, TrajectoryAccelerationConstraint accelConstraintOverride) {
        double start = this.getPathBuilder().build().length();
        add.invoke();
        double end = this.getPathBuilder().build().length();
        if (velConstraintOverride != null) {
            this.velConstraintOverrides.add(new IntervalVelocityConstraint(start, end, velConstraintOverride));
        }
        if (accelConstraintOverride != null) {
            this.accelConstraintOverrides.add(new IntervalAccelerationConstraint(start, end, accelConstraintOverride));
        }
        return this;
    }

    @NotNull
    public final TrajectoryBuilder lineTo(@NotNull Vector2d endPosition, @Nullable TrajectoryVelocityConstraint velConstraintOverride, @Nullable TrajectoryAccelerationConstraint accelConstraintOverride) {
        Intrinsics.checkNotNullParameter((Object)endPosition, (String)"endPosition");
        return this.addSegment((Function0<Unit>)((Function0)new Function0<Unit>(this, endPosition){
            final /* synthetic */ TrajectoryBuilder this$0;
            final /* synthetic */ Vector2d $endPosition;

            public final void invoke() {
                this.this$0.lineTo(this.$endPosition);
            }
            {
                this.this$0 = trajectoryBuilder;
                this.$endPosition = vector2d;
                super(0);
            }
        }), velConstraintOverride, accelConstraintOverride);
    }

    @NotNull
    public final TrajectoryBuilder lineToConstantHeading(@NotNull Vector2d endPosition, @Nullable TrajectoryVelocityConstraint velConstraintOverride, @Nullable TrajectoryAccelerationConstraint accelConstraintOverride) {
        Intrinsics.checkNotNullParameter((Object)endPosition, (String)"endPosition");
        return this.addSegment((Function0<Unit>)((Function0)new Function0<Unit>(this, endPosition){
            final /* synthetic */ TrajectoryBuilder this$0;
            final /* synthetic */ Vector2d $endPosition;

            public final void invoke() {
                this.this$0.lineToConstantHeading(this.$endPosition);
            }
            {
                this.this$0 = trajectoryBuilder;
                this.$endPosition = vector2d;
                super(0);
            }
        }), velConstraintOverride, accelConstraintOverride);
    }

    @NotNull
    public final TrajectoryBuilder lineToLinearHeading(@NotNull Pose2d endPose, @Nullable TrajectoryVelocityConstraint velConstraintOverride, @Nullable TrajectoryAccelerationConstraint accelConstraintOverride) {
        Intrinsics.checkNotNullParameter((Object)endPose, (String)"endPose");
        return this.addSegment((Function0<Unit>)((Function0)new Function0<Unit>(this, endPose){
            final /* synthetic */ TrajectoryBuilder this$0;
            final /* synthetic */ Pose2d $endPose;

            public final void invoke() {
                this.this$0.lineToLinearHeading(this.$endPose);
            }
            {
                this.this$0 = trajectoryBuilder;
                this.$endPose = pose2d;
                super(0);
            }
        }), velConstraintOverride, accelConstraintOverride);
    }

    @NotNull
    public final TrajectoryBuilder lineToSplineHeading(@NotNull Pose2d endPose, @Nullable TrajectoryVelocityConstraint velConstraintOverride, @Nullable TrajectoryAccelerationConstraint accelConstraintOverride) {
        Intrinsics.checkNotNullParameter((Object)endPose, (String)"endPose");
        return this.addSegment((Function0<Unit>)((Function0)new Function0<Unit>(this, endPose){
            final /* synthetic */ TrajectoryBuilder this$0;
            final /* synthetic */ Pose2d $endPose;

            public final void invoke() {
                this.this$0.lineToSplineHeading(this.$endPose);
            }
            {
                this.this$0 = trajectoryBuilder;
                this.$endPose = pose2d;
                super(0);
            }
        }), velConstraintOverride, accelConstraintOverride);
    }

    @NotNull
    public final TrajectoryBuilder strafeTo(@NotNull Vector2d endPosition, @Nullable TrajectoryVelocityConstraint velConstraintOverride, @Nullable TrajectoryAccelerationConstraint accelConstraintOverride) {
        Intrinsics.checkNotNullParameter((Object)endPosition, (String)"endPosition");
        return this.addSegment((Function0<Unit>)((Function0)new Function0<Unit>(this, endPosition){
            final /* synthetic */ TrajectoryBuilder this$0;
            final /* synthetic */ Vector2d $endPosition;

            public final void invoke() {
                this.this$0.strafeTo(this.$endPosition);
            }
            {
                this.this$0 = trajectoryBuilder;
                this.$endPosition = vector2d;
                super(0);
            }
        }), velConstraintOverride, accelConstraintOverride);
    }

    @NotNull
    public final TrajectoryBuilder forward(double distance, @Nullable TrajectoryVelocityConstraint velConstraintOverride, @Nullable TrajectoryAccelerationConstraint accelConstraintOverride) {
        return this.addSegment((Function0<Unit>)((Function0)new Function0<Unit>(this, distance){
            final /* synthetic */ TrajectoryBuilder this$0;
            final /* synthetic */ double $distance;

            public final void invoke() {
                this.this$0.forward(this.$distance);
            }
            {
                this.this$0 = trajectoryBuilder;
                this.$distance = d;
                super(0);
            }
        }), velConstraintOverride, accelConstraintOverride);
    }

    @NotNull
    public final TrajectoryBuilder back(double distance, @Nullable TrajectoryVelocityConstraint velConstraintOverride, @Nullable TrajectoryAccelerationConstraint accelConstraintOverride) {
        return this.addSegment((Function0<Unit>)((Function0)new Function0<Unit>(this, distance){
            final /* synthetic */ TrajectoryBuilder this$0;
            final /* synthetic */ double $distance;

            public final void invoke() {
                this.this$0.back(this.$distance);
            }
            {
                this.this$0 = trajectoryBuilder;
                this.$distance = d;
                super(0);
            }
        }), velConstraintOverride, accelConstraintOverride);
    }

    @NotNull
    public final TrajectoryBuilder strafeLeft(double distance, @Nullable TrajectoryVelocityConstraint velConstraintOverride, @Nullable TrajectoryAccelerationConstraint accelConstraintOverride) {
        return this.addSegment((Function0<Unit>)((Function0)new Function0<Unit>(this, distance){
            final /* synthetic */ TrajectoryBuilder this$0;
            final /* synthetic */ double $distance;

            public final void invoke() {
                this.this$0.strafeLeft(this.$distance);
            }
            {
                this.this$0 = trajectoryBuilder;
                this.$distance = d;
                super(0);
            }
        }), velConstraintOverride, accelConstraintOverride);
    }

    @NotNull
    public final TrajectoryBuilder strafeRight(double distance, @Nullable TrajectoryVelocityConstraint velConstraintOverride, @Nullable TrajectoryAccelerationConstraint accelConstraintOverride) {
        return this.addSegment((Function0<Unit>)((Function0)new Function0<Unit>(this, distance){
            final /* synthetic */ TrajectoryBuilder this$0;
            final /* synthetic */ double $distance;

            public final void invoke() {
                this.this$0.strafeRight(this.$distance);
            }
            {
                this.this$0 = trajectoryBuilder;
                this.$distance = d;
                super(0);
            }
        }), velConstraintOverride, accelConstraintOverride);
    }

    @NotNull
    public final TrajectoryBuilder splineTo(@NotNull Vector2d endPosition, double endTangent, @Nullable TrajectoryVelocityConstraint velConstraintOverride, @Nullable TrajectoryAccelerationConstraint accelConstraintOverride) {
        Intrinsics.checkNotNullParameter((Object)endPosition, (String)"endPosition");
        return this.addSegment((Function0<Unit>)((Function0)new Function0<Unit>(this, endPosition, endTangent){
            final /* synthetic */ TrajectoryBuilder this$0;
            final /* synthetic */ Vector2d $endPosition;
            final /* synthetic */ double $endTangent;

            public final void invoke() {
                this.this$0.splineTo(this.$endPosition, this.$endTangent);
            }
            {
                this.this$0 = trajectoryBuilder;
                this.$endPosition = vector2d;
                this.$endTangent = d;
                super(0);
            }
        }), velConstraintOverride, accelConstraintOverride);
    }

    @NotNull
    public final TrajectoryBuilder splineToConstantHeading(@NotNull Vector2d endPosition, double endTangent, @Nullable TrajectoryVelocityConstraint velConstraintOverride, @Nullable TrajectoryAccelerationConstraint accelConstraintOverride) {
        Intrinsics.checkNotNullParameter((Object)endPosition, (String)"endPosition");
        return this.addSegment((Function0<Unit>)((Function0)new Function0<Unit>(this, endPosition, endTangent){
            final /* synthetic */ TrajectoryBuilder this$0;
            final /* synthetic */ Vector2d $endPosition;
            final /* synthetic */ double $endTangent;

            public final void invoke() {
                this.this$0.splineToConstantHeading(this.$endPosition, this.$endTangent);
            }
            {
                this.this$0 = trajectoryBuilder;
                this.$endPosition = vector2d;
                this.$endTangent = d;
                super(0);
            }
        }), velConstraintOverride, accelConstraintOverride);
    }

    @NotNull
    public final TrajectoryBuilder splineToLinearHeading(@NotNull Pose2d endPose, double endTangent, @Nullable TrajectoryVelocityConstraint velConstraintOverride, @Nullable TrajectoryAccelerationConstraint accelConstraintOverride) {
        Intrinsics.checkNotNullParameter((Object)endPose, (String)"endPose");
        return this.addSegment((Function0<Unit>)((Function0)new Function0<Unit>(this, endPose, endTangent){
            final /* synthetic */ TrajectoryBuilder this$0;
            final /* synthetic */ Pose2d $endPose;
            final /* synthetic */ double $endTangent;

            public final void invoke() {
                this.this$0.splineToLinearHeading(this.$endPose, this.$endTangent);
            }
            {
                this.this$0 = trajectoryBuilder;
                this.$endPose = pose2d;
                this.$endTangent = d;
                super(0);
            }
        }), velConstraintOverride, accelConstraintOverride);
    }

    @NotNull
    public final TrajectoryBuilder splineToSplineHeading(@NotNull Pose2d endPose, double endTangent, @Nullable TrajectoryVelocityConstraint velConstraintOverride, @Nullable TrajectoryAccelerationConstraint accelConstraintOverride) {
        Intrinsics.checkNotNullParameter((Object)endPose, (String)"endPose");
        return this.addSegment((Function0<Unit>)((Function0)new Function0<Unit>(this, endPose, endTangent){
            final /* synthetic */ TrajectoryBuilder this$0;
            final /* synthetic */ Pose2d $endPose;
            final /* synthetic */ double $endTangent;

            public final void invoke() {
                this.this$0.splineToSplineHeading(this.$endPose, this.$endTangent);
            }
            {
                this.this$0 = trajectoryBuilder;
                this.$endPose = pose2d;
                this.$endTangent = d;
                super(0);
            }
        }), velConstraintOverride, accelConstraintOverride);
    }

    @Override
    @NotNull
    protected Trajectory buildTrajectory(@NotNull Path path, @NotNull List<TemporalMarker> temporalMarkers, @NotNull List<DisplacementMarker> displacementMarkers, @NotNull List<SpatialMarker> spatialMarkers) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(temporalMarkers, (String)"temporalMarkers");
        Intrinsics.checkNotNullParameter(displacementMarkers, (String)"displacementMarkers");
        Intrinsics.checkNotNullParameter(spatialMarkers, (String)"spatialMarkers");
        MotionState goal = new MotionState(path.length(), 0.0, 0.0, 0.0, 8, null);
        return TrajectoryGenerator.INSTANCE.generateTrajectory(path, new PiecewiseVelocityConstraint(this.baseVelConstraint, this.velConstraintOverrides), new PiecewiseAccelerationConstraint(this.baseAccelConstraint, this.accelConstraintOverrides), this.start, goal, temporalMarkers, displacementMarkers, spatialMarkers, this.resolution);
    }

    private TrajectoryBuilder(Pose2d startPose, Double startTangent, Trajectory trajectory, Double t, TrajectoryVelocityConstraint baseVelConstraint, TrajectoryAccelerationConstraint baseAccelConstraint, MotionState start, double resolution) {
        super(startPose, startTangent, trajectory, t);
        this.baseVelConstraint = baseVelConstraint;
        this.baseAccelConstraint = baseAccelConstraint;
        this.start = start;
        this.resolution = resolution;
        boolean bl = false;
        this.velConstraintOverrides = new ArrayList();
        bl = false;
        this.accelConstraintOverrides = new ArrayList();
    }

    @JvmOverloads
    public TrajectoryBuilder(@NotNull Pose2d startPose, double startTangent, @NotNull TrajectoryVelocityConstraint baseVelConstraint, @NotNull TrajectoryAccelerationConstraint baseAccelConstraint, double resolution) {
        Intrinsics.checkNotNullParameter((Object)startPose, (String)"startPose");
        Intrinsics.checkNotNullParameter((Object)baseVelConstraint, (String)"baseVelConstraint");
        Intrinsics.checkNotNullParameter((Object)baseAccelConstraint, (String)"baseAccelConstraint");
        this(startPose, startTangent, null, null, baseVelConstraint, baseAccelConstraint, new MotionState(0.0, 0.0, 0.0, 0.0, 8, null), resolution);
    }

    public /* synthetic */ TrajectoryBuilder(Pose2d pose2d, double d, TrajectoryVelocityConstraint trajectoryVelocityConstraint, TrajectoryAccelerationConstraint trajectoryAccelerationConstraint, double d2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            d = pose2d.getHeading();
        }
        if ((n & 0x10) != 0) {
            d2 = 0.25;
        }
        this(pose2d, d, trajectoryVelocityConstraint, trajectoryAccelerationConstraint, d2);
    }

    @JvmOverloads
    public TrajectoryBuilder(@NotNull Pose2d startPose, double startTangent, @NotNull TrajectoryVelocityConstraint baseVelConstraint, @NotNull TrajectoryAccelerationConstraint baseAccelConstraint) {
        this(startPose, startTangent, baseVelConstraint, baseAccelConstraint, 0.0, 16, null);
    }

    @JvmOverloads
    public TrajectoryBuilder(@NotNull Pose2d startPose, @NotNull TrajectoryVelocityConstraint baseVelConstraint, @NotNull TrajectoryAccelerationConstraint baseAccelConstraint) {
        this(startPose, 0.0, baseVelConstraint, baseAccelConstraint, 0.0, 18, null);
    }

    @JvmOverloads
    public TrajectoryBuilder(@NotNull Pose2d startPose, boolean reversed, @NotNull TrajectoryVelocityConstraint baseVelConstraint, @NotNull TrajectoryAccelerationConstraint baseAccelConstraint, double resolution) {
        Intrinsics.checkNotNullParameter((Object)startPose, (String)"startPose");
        Intrinsics.checkNotNullParameter((Object)baseVelConstraint, (String)"baseVelConstraint");
        Intrinsics.checkNotNullParameter((Object)baseAccelConstraint, (String)"baseAccelConstraint");
        this(startPose, Angle.norm(startPose.getHeading() + (reversed ? Math.PI : 0.0)), baseVelConstraint, baseAccelConstraint, resolution);
    }

    public /* synthetic */ TrajectoryBuilder(Pose2d pose2d, boolean bl, TrajectoryVelocityConstraint trajectoryVelocityConstraint, TrajectoryAccelerationConstraint trajectoryAccelerationConstraint, double d, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            d = 0.25;
        }
        this(pose2d, bl, trajectoryVelocityConstraint, trajectoryAccelerationConstraint, d);
    }

    @JvmOverloads
    public TrajectoryBuilder(@NotNull Pose2d startPose, boolean reversed, @NotNull TrajectoryVelocityConstraint baseVelConstraint, @NotNull TrajectoryAccelerationConstraint baseAccelConstraint) {
        this(startPose, reversed, baseVelConstraint, baseAccelConstraint, 0.0, 16, null);
    }

    @JvmOverloads
    public TrajectoryBuilder(@NotNull Trajectory trajectory, double t, @NotNull TrajectoryVelocityConstraint baseVelConstraint, @NotNull TrajectoryAccelerationConstraint baseAccelConstraint, double resolution) {
        Intrinsics.checkNotNullParameter((Object)trajectory, (String)"trajectory");
        Intrinsics.checkNotNullParameter((Object)baseVelConstraint, (String)"baseVelConstraint");
        Intrinsics.checkNotNullParameter((Object)baseAccelConstraint, (String)"baseAccelConstraint");
        this(null, null, trajectory, t, baseVelConstraint, baseAccelConstraint, TrajectoryBuilderKt.access$zeroPosition(trajectory.getProfile().get(t)), resolution);
    }

    public /* synthetic */ TrajectoryBuilder(Trajectory trajectory, double d, TrajectoryVelocityConstraint trajectoryVelocityConstraint, TrajectoryAccelerationConstraint trajectoryAccelerationConstraint, double d2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            d2 = 0.25;
        }
        this(trajectory, d, trajectoryVelocityConstraint, trajectoryAccelerationConstraint, d2);
    }

    @JvmOverloads
    public TrajectoryBuilder(@NotNull Trajectory trajectory, double t, @NotNull TrajectoryVelocityConstraint baseVelConstraint, @NotNull TrajectoryAccelerationConstraint baseAccelConstraint) {
        this(trajectory, t, baseVelConstraint, baseAccelConstraint, 0.0, 16, null);
    }
}

