/*
 * Decompiled with CFR 0.152.
 */
package com.acmerobotics.roadrunner.trajectory;

import com.acmerobotics.roadrunner.geometry.Pose2d;
import com.acmerobotics.roadrunner.path.Path;
import com.acmerobotics.roadrunner.profile.MotionProfile;
import com.acmerobotics.roadrunner.profile.MotionState;
import com.acmerobotics.roadrunner.trajectory.TrajectoryMarker;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\u0018\u00002\u00020\u0001B'\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\u0013J\u0006\u0010\u0015\u001a\u00020\u0011J\u0011\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0086\u0002J\u0006\u0010\u0017\u001a\u00020\u0011J\u000e\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0019"}, d2={"Lcom/acmerobotics/roadrunner/trajectory/Trajectory;", "", "path", "Lcom/acmerobotics/roadrunner/path/Path;", "profile", "Lcom/acmerobotics/roadrunner/profile/MotionProfile;", "markers", "", "Lcom/acmerobotics/roadrunner/trajectory/TrajectoryMarker;", "(Lcom/acmerobotics/roadrunner/path/Path;Lcom/acmerobotics/roadrunner/profile/MotionProfile;Ljava/util/List;)V", "getMarkers", "()Ljava/util/List;", "getPath", "()Lcom/acmerobotics/roadrunner/path/Path;", "getProfile", "()Lcom/acmerobotics/roadrunner/profile/MotionProfile;", "acceleration", "Lcom/acmerobotics/roadrunner/geometry/Pose2d;", "time", "", "duration", "end", "get", "start", "velocity", "core"})
public final class Trajectory {
    @NotNull
    private final Path path;
    @NotNull
    private final MotionProfile profile;
    @NotNull
    private final List<TrajectoryMarker> markers;

    public final double duration() {
        return this.profile.duration();
    }

    @NotNull
    public final Pose2d get(double time) {
        return Path.get$default(this.path, this.profile.get(time).getX(), 0.0, 2, null);
    }

    @NotNull
    public final Pose2d velocity(double time) {
        MotionState motionState = this.profile.get(time);
        return Path.deriv$default(this.path, motionState.getX(), 0.0, 2, null).times(motionState.getV());
    }

    @NotNull
    public final Pose2d acceleration(double time) {
        MotionState motionState = this.profile.get(time);
        return Path.secondDeriv$default(this.path, motionState.getX(), 0.0, 2, null).times(motionState.getV()).times(motionState.getV()).plus(Path.deriv$default(this.path, motionState.getX(), 0.0, 2, null).times(motionState.getA()));
    }

    @NotNull
    public final Pose2d start() {
        return this.path.get(0.0, 0.0);
    }

    @NotNull
    public final Pose2d end() {
        return this.path.get(this.path.length(), 1.0);
    }

    @NotNull
    public final Path getPath() {
        return this.path;
    }

    @NotNull
    public final MotionProfile getProfile() {
        return this.profile;
    }

    @NotNull
    public final List<TrajectoryMarker> getMarkers() {
        return this.markers;
    }

    @JvmOverloads
    public Trajectory(@NotNull Path path, @NotNull MotionProfile profile, @NotNull List<TrajectoryMarker> markers) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        Intrinsics.checkNotNullParameter(markers, (String)"markers");
        this.path = path;
        this.profile = profile;
        this.markers = markers;
    }

    public /* synthetic */ Trajectory(Path path, MotionProfile motionProfile, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            list = CollectionsKt.emptyList();
        }
        this(path, motionProfile, list);
    }

    @JvmOverloads
    public Trajectory(@NotNull Path path, @NotNull MotionProfile profile) {
        this(path, profile, null, 4, null);
    }
}

