/*
 * Decompiled with CFR 0.152.
 */
package com.acmerobotics.roadrunner.trajectory;

import com.acmerobotics.roadrunner.geometry.Pose2d;
import com.acmerobotics.roadrunner.path.Path;
import com.acmerobotics.roadrunner.profile.MotionState;
import com.acmerobotics.roadrunner.trajectory.BaseTrajectoryBuilder;
import com.acmerobotics.roadrunner.trajectory.DisplacementMarker;
import com.acmerobotics.roadrunner.trajectory.SimpleTrajectoryBuilderKt;
import com.acmerobotics.roadrunner.trajectory.SpatialMarker;
import com.acmerobotics.roadrunner.trajectory.TemporalMarker;
import com.acmerobotics.roadrunner.trajectory.Trajectory;
import com.acmerobotics.roadrunner.trajectory.TrajectoryGenerator;
import com.acmerobotics.roadrunner.util.Angle;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B3\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\b\b\u0002\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tB1\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\b\b\u0002\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\fB1\b\u0016\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\b\b\u0002\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0010BO\b\u0002\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0013J:\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00182\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0018H\u0014R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/acmerobotics/roadrunner/trajectory/SimpleTrajectoryBuilder;", "Lcom/acmerobotics/roadrunner/trajectory/BaseTrajectoryBuilder;", "startPose", "Lcom/acmerobotics/roadrunner/geometry/Pose2d;", "startTangent", "", "maxProfileVel", "maxProfileAccel", "maxProfileJerk", "(Lcom/acmerobotics/roadrunner/geometry/Pose2d;DDDD)V", "reversed", "", "(Lcom/acmerobotics/roadrunner/geometry/Pose2d;ZDDD)V", "trajectory", "Lcom/acmerobotics/roadrunner/trajectory/Trajectory;", "t", "(Lcom/acmerobotics/roadrunner/trajectory/Trajectory;DDDD)V", "start", "Lcom/acmerobotics/roadrunner/profile/MotionState;", "(Lcom/acmerobotics/roadrunner/geometry/Pose2d;Ljava/lang/Double;Lcom/acmerobotics/roadrunner/trajectory/Trajectory;Ljava/lang/Double;DDDLcom/acmerobotics/roadrunner/profile/MotionState;)V", "buildTrajectory", "path", "Lcom/acmerobotics/roadrunner/path/Path;", "temporalMarkers", "", "Lcom/acmerobotics/roadrunner/trajectory/TemporalMarker;", "displacementMarkers", "Lcom/acmerobotics/roadrunner/trajectory/DisplacementMarker;", "spatialMarkers", "Lcom/acmerobotics/roadrunner/trajectory/SpatialMarker;", "core"})
public final class SimpleTrajectoryBuilder
extends BaseTrajectoryBuilder<SimpleTrajectoryBuilder> {
    private final double maxProfileVel;
    private final double maxProfileAccel;
    private final double maxProfileJerk;
    private final MotionState start;

    @Override
    @NotNull
    protected Trajectory buildTrajectory(@NotNull Path path, @NotNull List<TemporalMarker> temporalMarkers, @NotNull List<DisplacementMarker> displacementMarkers, @NotNull List<SpatialMarker> spatialMarkers) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(temporalMarkers, (String)"temporalMarkers");
        Intrinsics.checkNotNullParameter(displacementMarkers, (String)"displacementMarkers");
        Intrinsics.checkNotNullParameter(spatialMarkers, (String)"spatialMarkers");
        MotionState goal = new MotionState(path.length(), 0.0, 0.0, 0.0, 8, null);
        return TrajectoryGenerator.INSTANCE.generateSimpleTrajectory(path, this.maxProfileVel, this.maxProfileAccel, this.maxProfileJerk, this.start, goal, temporalMarkers, displacementMarkers, spatialMarkers);
    }

    private SimpleTrajectoryBuilder(Pose2d startPose, Double startTangent, Trajectory trajectory, Double t, double maxProfileVel, double maxProfileAccel, double maxProfileJerk, MotionState start) {
        super(startPose, startTangent, trajectory, t);
        this.maxProfileVel = maxProfileVel;
        this.maxProfileAccel = maxProfileAccel;
        this.maxProfileJerk = maxProfileJerk;
        this.start = start;
    }

    @JvmOverloads
    public SimpleTrajectoryBuilder(@NotNull Pose2d startPose, double startTangent, double maxProfileVel, double maxProfileAccel, double maxProfileJerk) {
        Intrinsics.checkNotNullParameter((Object)startPose, (String)"startPose");
        this(startPose, startTangent, null, null, maxProfileVel, maxProfileAccel, maxProfileJerk, new MotionState(0.0, 0.0, 0.0, 0.0, 8, null));
    }

    public /* synthetic */ SimpleTrajectoryBuilder(Pose2d pose2d, double d, double d2, double d3, double d4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            d = pose2d.getHeading();
        }
        if ((n & 0x10) != 0) {
            d4 = 0.0;
        }
        this(pose2d, d, d2, d3, d4);
    }

    @JvmOverloads
    public SimpleTrajectoryBuilder(@NotNull Pose2d startPose, double startTangent, double maxProfileVel, double maxProfileAccel) {
        this(startPose, startTangent, maxProfileVel, maxProfileAccel, 0.0, 16, null);
    }

    @JvmOverloads
    public SimpleTrajectoryBuilder(@NotNull Pose2d startPose, double maxProfileVel, double maxProfileAccel) {
        this(startPose, 0.0, maxProfileVel, maxProfileAccel, 0.0, 18, null);
    }

    public SimpleTrajectoryBuilder(@NotNull Pose2d startPose, boolean reversed, double maxProfileVel, double maxProfileAccel, double maxProfileJerk) {
        Intrinsics.checkNotNullParameter((Object)startPose, (String)"startPose");
        this(startPose, Angle.norm(startPose.getHeading() + (reversed ? Math.PI : 0.0)), maxProfileVel, maxProfileAccel, maxProfileJerk);
    }

    public /* synthetic */ SimpleTrajectoryBuilder(Pose2d pose2d, boolean bl, double d, double d2, double d3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            d3 = 0.0;
        }
        this(pose2d, bl, d, d2, d3);
    }

    public SimpleTrajectoryBuilder(@NotNull Trajectory trajectory, double t, double maxProfileVel, double maxProfileAccel, double maxProfileJerk) {
        Intrinsics.checkNotNullParameter((Object)trajectory, (String)"trajectory");
        this(null, null, trajectory, t, maxProfileVel, maxProfileAccel, maxProfileJerk, SimpleTrajectoryBuilderKt.access$zeroPosition(trajectory.getProfile().get(t)));
    }

    public /* synthetic */ SimpleTrajectoryBuilder(Trajectory trajectory, double d, double d2, double d3, double d4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            d4 = 0.0;
        }
        this(trajectory, d, d2, d3, d4);
    }
}

