/*
 * Decompiled with CFR 0.152.
 */
package com.acmerobotics.roadrunner.profile;

import com.acmerobotics.roadrunner.profile.AccelerationConstraint;
import com.acmerobotics.roadrunner.profile.EvaluatedConstraint;
import com.acmerobotics.roadrunner.profile.MotionProfile;
import com.acmerobotics.roadrunner.profile.MotionProfileBuilder;
import com.acmerobotics.roadrunner.profile.MotionSegment;
import com.acmerobotics.roadrunner.profile.MotionState;
import com.acmerobotics.roadrunner.profile.VelocityConstraint;
import com.acmerobotics.roadrunner.util.DoubleProgression;
import com.acmerobotics.roadrunner.util.MathUtil;
import com.acmerobotics.roadrunner.util.MathUtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J8\u0010\b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\n0\t2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\tH\u0002J*\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00072\b\b\u0002\u0010\u0014\u001a\u00020\u0007H\u0002J2\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\b\b\u0002\u0010\u001b\u001a\u00020\u0007H\u0007J<\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00072\b\b\u0002\u0010\u0014\u001a\u00020\u00072\b\b\u0002\u0010\u001d\u001a\u00020\u001eH\u0007J\u0018\u0010\u001f\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u00042\u0006\u0010!\u001a\u00020\u0004H\u0002\u00a8\u0006\""}, d2={"Lcom/acmerobotics/roadrunner/profile/MotionProfileGenerator;", "", "()V", "afterDisplacement", "Lcom/acmerobotics/roadrunner/profile/MotionState;", "state", "dx", "", "forwardPass", "", "Lkotlin/Pair;", "start", "displacements", "Lcom/acmerobotics/roadrunner/util/DoubleProgression;", "constraints", "Lcom/acmerobotics/roadrunner/profile/EvaluatedConstraint;", "generateAccelProfile", "Lcom/acmerobotics/roadrunner/profile/MotionProfile;", "maxVel", "maxAccel", "maxJerk", "generateMotionProfile", "goal", "velocityConstraint", "Lcom/acmerobotics/roadrunner/profile/VelocityConstraint;", "accelerationConstraint", "Lcom/acmerobotics/roadrunner/profile/AccelerationConstraint;", "resolution", "generateSimpleMotionProfile", "overshoot", "", "intersection", "state1", "state2", "core"})
public final class MotionProfileGenerator {
    public static final MotionProfileGenerator INSTANCE;

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final MotionProfile generateSimpleMotionProfile(@NotNull MotionState start, @NotNull MotionState goal, double maxVel, double maxAccel, double maxJerk, boolean overshoot) {
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)goal, (String)"goal");
        if (goal.getX() < start.getX()) {
            return MotionProfileGenerator.generateSimpleMotionProfile$default(start.flipped(), goal.flipped(), maxVel, maxAccel, maxJerk, false, 32, null).flipped();
        }
        if (MathUtilKt.epsilonEquals(maxJerk, 0.0)) {
            double requiredAccel = (goal.getV() * goal.getV() - start.getV() * start.getV()) / ((double)2 * (goal.getX() - start.getX()));
            MotionProfile accelProfile = MotionProfileGenerator.generateAccelProfile$default(INSTANCE, start, maxVel, maxAccel, 0.0, 8, null);
            MotionProfile decelProfile = INSTANCE.generateAccelProfile(new MotionState(goal.getX(), goal.getV(), -goal.getA(), goal.getJ()), maxVel, maxAccel, maxJerk).reversed();
            MotionProfile noCoastProfile = accelProfile.plus(decelProfile);
            double remainingDistance = goal.getX() - noCoastProfile.end().getX();
            if (remainingDistance >= 0.0) {
                double deltaT2 = remainingDistance / maxVel;
                return new MotionProfileBuilder(start).appendProfile(accelProfile).appendAccelerationControl(0.0, deltaT2).appendProfile(decelProfile).build();
            }
            boolean deltaT2 = false;
            if (Math.abs(requiredAccel) > maxAccel) {
                MotionProfile motionProfile;
                if (overshoot) {
                    motionProfile = noCoastProfile.plus(MotionProfileGenerator.generateSimpleMotionProfile$default(noCoastProfile.end(), goal, maxVel, maxAccel, 0.0, true, 16, null));
                } else {
                    double dt = (goal.getV() - start.getV()) / requiredAccel;
                    motionProfile = new MotionProfileBuilder(start).appendAccelerationControl(requiredAccel, dt).build();
                }
                return motionProfile;
            }
            if (start.getV() > maxVel && goal.getV() > maxVel) {
                void $this$filterTo$iv$iv2;
                List<Double> roots = MathUtil.solveQuadratic(-maxAccel, (double)2 * start.getV(), (goal.getV() * goal.getV() - start.getV() * start.getV()) / ((double)2 * maxAccel) - goal.getX() + start.getX());
                Iterable $this$filter$iv = roots;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                    double it = ((Number)element$iv$iv).doubleValue();
                    boolean bl = false;
                    if (!(it >= 0.0)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Double d = CollectionsKt.minOrNull((Iterable)((List)destination$iv$iv));
                Intrinsics.checkNotNull((Object)d);
                double deltaT1 = d;
                double $this$filterTo$iv$iv2 = start.getV() - goal.getV();
                $i$f$filterTo = false;
                double deltaT3 = Math.abs($this$filterTo$iv$iv2) / maxAccel + deltaT1;
                return new MotionProfileBuilder(start).appendAccelerationControl(-maxAccel, deltaT1).appendAccelerationControl(maxAccel, deltaT3).build();
            }
            List<Double> roots = MathUtil.solveQuadratic(maxAccel, (double)2 * start.getV(), (start.getV() * start.getV() - goal.getV() * goal.getV()) / ((double)2 * maxAccel) - goal.getX() + start.getX());
            Iterable $this$filter$iv = roots;
            boolean $i$f$filter = false;
            Iterable $this$filterTo$iv$iv2 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                double it = ((Number)element$iv$iv).doubleValue();
                boolean bl = false;
                if (!(it >= 0.0)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Double d = CollectionsKt.minOrNull((Iterable)((List)destination$iv$iv));
            Intrinsics.checkNotNull((Object)d);
            double deltaT1 = d;
            double $this$filterTo$iv$iv22 = start.getV() - goal.getV();
            $i$f$filterTo = false;
            double deltaT3 = Math.abs($this$filterTo$iv$iv22) / maxAccel + deltaT1;
            return new MotionProfileBuilder(start).appendAccelerationControl(maxAccel, deltaT1).appendAccelerationControl(-maxAccel, deltaT3).build();
        }
        MotionProfile accelerationProfile = INSTANCE.generateAccelProfile(start, maxVel, maxAccel, maxJerk);
        MotionProfile decelerationProfile = INSTANCE.generateAccelProfile(new MotionState(goal.getX(), goal.getV(), -goal.getA(), goal.getJ()), maxVel, maxAccel, maxJerk).reversed();
        MotionProfile noCoastProfile = accelerationProfile.plus(decelerationProfile);
        double remainingDistance = goal.getX() - noCoastProfile.end().getX();
        if (remainingDistance >= 0.0) {
            double deltaT4 = remainingDistance / maxVel;
            return new MotionProfileBuilder(start).appendProfile(accelerationProfile).appendJerkControl(0.0, deltaT4).appendProfile(decelerationProfile).build();
        }
        double upperBound = maxVel;
        double lowerBound = 0.0;
        for (int iterations = 0; iterations < 1000; ++iterations) {
            double peakVel = (upperBound + lowerBound) / (double)2;
            MotionProfile searchAccelProfile = INSTANCE.generateAccelProfile(start, peakVel, maxAccel, maxJerk);
            MotionProfile searchDecelProfile = INSTANCE.generateAccelProfile(goal, peakVel, maxAccel, maxJerk).reversed();
            MotionProfile searchProfile = searchAccelProfile.plus(searchDecelProfile);
            double error = goal.getX() - searchProfile.end().getX();
            if (MathUtilKt.epsilonEquals(error, 0.0)) {
                return searchProfile;
            }
            if (error > 0.0) {
                lowerBound = peakVel;
                continue;
            }
            upperBound = peakVel;
        }
        return overshoot ? noCoastProfile.plus(MotionProfileGenerator.generateSimpleMotionProfile(noCoastProfile.end(), goal, maxVel, maxAccel, maxJerk, true)) : MotionProfileGenerator.generateSimpleMotionProfile$default(start, goal, maxVel, maxAccel, 0.0, false, 16, null);
    }

    public static /* synthetic */ MotionProfile generateSimpleMotionProfile$default(MotionState motionState, MotionState motionState2, double d, double d2, double d3, boolean bl, int n, Object object) {
        if ((n & 0x10) != 0) {
            d3 = 0.0;
        }
        if ((n & 0x20) != 0) {
            bl = false;
        }
        return MotionProfileGenerator.generateSimpleMotionProfile(motionState, motionState2, d, d2, d3, bl);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final MotionProfile generateSimpleMotionProfile(@NotNull MotionState start, @NotNull MotionState goal, double maxVel, double maxAccel, double maxJerk) {
        return MotionProfileGenerator.generateSimpleMotionProfile$default(start, goal, maxVel, maxAccel, maxJerk, false, 32, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final MotionProfile generateSimpleMotionProfile(@NotNull MotionState start, @NotNull MotionState goal, double maxVel, double maxAccel) {
        return MotionProfileGenerator.generateSimpleMotionProfile$default(start, goal, maxVel, maxAccel, 0.0, false, 48, null);
    }

    /*
     * WARNING - void declaration
     */
    private final MotionProfile generateAccelProfile(MotionState start, double maxVel, double maxAccel, double maxJerk) {
        MotionProfile motionProfile;
        if (MathUtilKt.epsilonEquals(maxJerk, 0.0)) {
            double d = start.getV() - maxVel;
            boolean bl = false;
            double deltaT12 = Math.abs(d) / maxAccel;
            MotionProfileBuilder builder = new MotionProfileBuilder(start);
            if (start.getV() > maxVel) {
                builder.appendAccelerationControl(-maxAccel, deltaT12);
            } else {
                builder.appendAccelerationControl(maxAccel, deltaT12);
            }
            motionProfile = builder.build();
        } else {
            Pair pair;
            double deltaV1;
            double deltaT1;
            if (start.getA() > maxAccel) {
                deltaT1 = (start.getA() - maxAccel) / maxJerk;
                deltaV1 = start.getA() * deltaT1 - 0.5 * maxJerk * deltaT1 * deltaT1;
                pair = new Pair((Object)deltaT1, (Object)deltaV1);
            } else {
                deltaT1 = (maxAccel - start.getA()) / maxJerk;
                deltaV1 = start.getA() * deltaT1 + 0.5 * maxJerk * deltaT1 * deltaT1;
                pair = new Pair((Object)deltaT1, (Object)deltaV1);
            }
            Pair pair2 = pair;
            double deltaT12 = ((Number)pair2.component1()).doubleValue();
            double deltaV12 = ((Number)pair2.component2()).doubleValue();
            double deltaT3 = maxAccel / maxJerk;
            double deltaV3 = maxAccel * deltaT3 - 0.5 * maxJerk * deltaT3 * deltaT3;
            double deltaV2 = maxVel - start.getV() - deltaV12 - deltaV3;
            if (deltaV2 < 0.0) {
                if (start.getA() > maxAccel || start.getV() - maxVel > start.getA() * start.getA() / ((double)2 * maxJerk)) {
                    double newDeltaT1 = (start.getA() + maxAccel) / maxJerk;
                    double newDeltaV1 = start.getA() * newDeltaT1 - 0.5 * maxJerk * newDeltaT1 * newDeltaT1;
                    double newDeltaV2 = maxVel - start.getV() - newDeltaV1 + deltaV3;
                    if (newDeltaV2 > 0.0) {
                        void $this$filterTo$iv$iv;
                        List<Double> roots = MathUtil.solveQuadratic(-maxJerk, (double)2 * start.getA(), start.getV() - maxVel - start.getA() * start.getA() / ((double)2 * maxJerk));
                        Iterable $this$filter$iv = roots;
                        boolean $i$f$filter = false;
                        Iterable iterable = $this$filter$iv;
                        Collection destination$iv$iv = new ArrayList();
                        boolean $i$f$filterTo = false;
                        for (Object element$iv$iv : $this$filterTo$iv$iv) {
                            double it = ((Number)element$iv$iv).doubleValue();
                            boolean bl = false;
                            if (!(it >= 0.0)) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        Double d = CollectionsKt.minOrNull((Iterable)((List)destination$iv$iv));
                        Intrinsics.checkNotNull((Object)d);
                        double finalDeltaT1 = d;
                        double finalDeltaT3 = finalDeltaT1 - start.getA() / maxJerk;
                        motionProfile = new MotionProfileBuilder(start).appendJerkControl(-maxJerk, finalDeltaT1).appendJerkControl(maxJerk, finalDeltaT3).build();
                    } else {
                        double newDeltaT2 = newDeltaV2 / -maxAccel;
                        motionProfile = new MotionProfileBuilder(start).appendJerkControl(-maxJerk, newDeltaT1).appendJerkControl(0.0, newDeltaT2).appendJerkControl(maxJerk, deltaT3).build();
                    }
                } else {
                    void $this$filterTo$iv$iv;
                    List<Double> roots = MathUtil.solveQuadratic(maxJerk, (double)2 * start.getA(), start.getV() - maxVel + start.getA() * start.getA() / ((double)2 * maxJerk));
                    Iterable $this$filter$iv = roots;
                    boolean $i$f$filter = false;
                    Iterable iterable = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        double it = ((Number)element$iv$iv).doubleValue();
                        boolean bl = false;
                        if (!(it >= 0.0)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    Double d = CollectionsKt.minOrNull((Iterable)((List)destination$iv$iv));
                    Intrinsics.checkNotNull((Object)d);
                    double newDeltaT1 = d;
                    double newDeltaT3 = newDeltaT1 + start.getA() / maxJerk;
                    motionProfile = new MotionProfileBuilder(start).appendJerkControl(maxJerk, newDeltaT1).appendJerkControl(-maxJerk, newDeltaT3).build();
                }
            } else {
                double deltaT2 = deltaV2 / maxAccel;
                MotionProfileBuilder builder = new MotionProfileBuilder(start);
                if (start.getA() > maxAccel) {
                    builder.appendJerkControl(-maxJerk, deltaT12);
                } else {
                    builder.appendJerkControl(maxJerk, deltaT12);
                }
                motionProfile = builder.appendJerkControl(0.0, deltaT2).appendJerkControl(-maxJerk, deltaT3).build();
            }
        }
        return motionProfile;
    }

    static /* synthetic */ MotionProfile generateAccelProfile$default(MotionProfileGenerator motionProfileGenerator, MotionState motionState, double d, double d2, double d3, int n, Object object) {
        if ((n & 8) != 0) {
            d3 = 0.0;
        }
        return motionProfileGenerator.generateAccelProfile(motionState, d, d2, d3);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final MotionProfile generateMotionProfile(@NotNull MotionState start, @NotNull MotionState goal, @NotNull VelocityConstraint velocityConstraint, @NotNull AccelerationConstraint accelerationConstraint, double resolution) {
        MotionState backwardStartState;
        double dx;
        Object item$iv$iv;
        Object $this$mapTo$iv$iv;
        void $this$mapTo$iv$iv2;
        EvaluatedConstraint evaluatedConstraint;
        Collection collection;
        void $this$mapTo$iv$iv3;
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)goal, (String)"goal");
        Intrinsics.checkNotNullParameter((Object)velocityConstraint, (String)"velocityConstraint");
        Intrinsics.checkNotNullParameter((Object)accelerationConstraint, (String)"accelerationConstraint");
        if (goal.getX() < start.getX()) {
            return MotionProfileGenerator.generateMotionProfile(start.flipped(), goal.flipped(), new VelocityConstraint(velocityConstraint){
                final /* synthetic */ VelocityConstraint $velocityConstraint;

                public final double get(double it) {
                    return this.$velocityConstraint.get(-it);
                }
                {
                    this.$velocityConstraint = velocityConstraint;
                }
            }, new AccelerationConstraint(accelerationConstraint){
                final /* synthetic */ AccelerationConstraint $accelerationConstraint;

                public final double get(double it) {
                    return this.$accelerationConstraint.get(-it);
                }
                {
                    this.$accelerationConstraint = accelerationConstraint;
                }
            }, resolution).flipped();
        }
        double length = goal.getX() - start.getX();
        double d = length / resolution;
        boolean bl = false;
        int samples = (int)Math.ceil(d);
        DoubleProgression s = DoubleProgression.Companion.fromClosedInterval(0.0, length, samples);
        Iterable $this$map$iv = s.plus(start.getX());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv3) {
            void it;
            double d2 = ((Number)item$iv$iv2).doubleValue();
            collection = destination$iv$iv;
            boolean bl2 = false;
            evaluatedConstraint = new EvaluatedConstraint(velocityConstraint.get((double)it), accelerationConstraint.get((double)it));
            collection.add(evaluatedConstraint);
        }
        List constraintsList = (List)destination$iv$iv;
        Iterable $this$map$iv2 = INSTANCE.forwardPass(new MotionState(0.0, start.getV(), start.getA(), 0.0, 8, null), s, constraintsList);
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Iterable destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv3 : $this$mapTo$iv$iv2) {
            void motionState;
            void $dstr$motionState$dx;
            Pair pair = (Pair)item$iv$iv3;
            collection = destination$iv$iv2;
            boolean bl3 = false;
            MotionState motionState2 = (MotionState)$dstr$motionState$dx.component1();
            double dx2 = ((Number)$dstr$motionState$dx.component2()).doubleValue();
            evaluatedConstraint = new Pair((Object)new MotionState(motionState.getX() + start.getX(), motionState.getV(), motionState.getA(), 0.0, 8, null), (Object)dx2);
            collection.add(evaluatedConstraint);
        }
        List forwardStates = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv2));
        Iterable $this$map$iv3 = INSTANCE.forwardPass(new MotionState(0.0, goal.getV(), goal.getA(), 0.0, 8, null), s, CollectionsKt.reversed((Iterable)constraintsList));
        boolean $i$f$map3 = false;
        destination$iv$iv2 = $this$map$iv3;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
        boolean $i$f$mapTo3 = false;
        Object item$iv$iv3 = $this$mapTo$iv$iv.iterator();
        while (item$iv$iv3.hasNext()) {
            void motionState;
            void $dstr$motionState$dx;
            item$iv$iv = item$iv$iv3.next();
            Pair bl3 = (Pair)item$iv$iv;
            collection = destination$iv$iv3;
            boolean bl4 = false;
            MotionState dx2 = (MotionState)$dstr$motionState$dx.component1();
            dx = ((Number)$dstr$motionState$dx.component2()).doubleValue();
            evaluatedConstraint = new Pair((Object)INSTANCE.afterDisplacement((MotionState)motionState, dx), (Object)dx);
            collection.add(evaluatedConstraint);
        }
        $this$map$iv3 = (List)destination$iv$iv3;
        $i$f$map3 = false;
        $this$mapTo$iv$iv = $this$map$iv3;
        destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
        $i$f$mapTo3 = false;
        item$iv$iv3 = $this$mapTo$iv$iv.iterator();
        while (item$iv$iv3.hasNext()) {
            item$iv$iv = item$iv$iv3.next();
            Pair $dstr$motionState$dx = (Pair)item$iv$iv;
            collection = destination$iv$iv3;
            boolean bl5 = false;
            MotionState motionState = (MotionState)$dstr$motionState$dx.component1();
            dx = ((Number)$dstr$motionState$dx.component2()).doubleValue();
            evaluatedConstraint = new Pair((Object)new MotionState(goal.getX() - motionState.getX(), motionState.getV(), -motionState.getA(), 0.0, 8, null), (Object)dx);
            collection.add(evaluatedConstraint);
        }
        List backwardStates = CollectionsKt.toMutableList((Collection)CollectionsKt.reversed((Iterable)((List)destination$iv$iv3)));
        $i$f$map3 = false;
        List finalStates = new ArrayList();
        for (int i = 0; i < forwardStates.size() && i < backwardStates.size(); ++i) {
            double intersection;
            void forwardStartState;
            item$iv$iv3 = (Pair)forwardStates.get(i);
            $this$mapTo$iv$iv = (MotionState)item$iv$iv3.component1();
            double forwardDx = ((Number)item$iv$iv3.component2()).doubleValue();
            Pair bl5 = (Pair)backwardStates.get(i);
            item$iv$iv3 = (MotionState)bl5.component1();
            double backwardDx = ((Number)bl5.component2()).doubleValue();
            if (!MathUtilKt.epsilonEquals(forwardDx, backwardDx)) {
                if (forwardDx > backwardDx) {
                    forwardStates.add(i + 1, new Pair((Object)INSTANCE.afterDisplacement((MotionState)forwardStartState, backwardDx), (Object)(forwardDx - backwardDx)));
                    forwardDx = backwardDx;
                } else {
                    backwardStates.add(i + 1, new Pair((Object)INSTANCE.afterDisplacement(backwardStartState, forwardDx), (Object)(backwardDx - forwardDx)));
                    backwardDx = forwardDx;
                }
            }
            MotionState forwardEndState = INSTANCE.afterDisplacement((MotionState)forwardStartState, forwardDx);
            MotionState backwardEndState = INSTANCE.afterDisplacement(backwardStartState, backwardDx);
            if (forwardStartState.getV() <= backwardStartState.getV()) {
                if (forwardEndState.getV() <= backwardEndState.getV()) {
                    finalStates.add(new Pair((Object)forwardStartState, (Object)forwardDx));
                    continue;
                }
                intersection = INSTANCE.intersection((MotionState)forwardStartState, backwardStartState);
                finalStates.add(new Pair((Object)forwardStartState, (Object)intersection));
                finalStates.add(new Pair((Object)INSTANCE.afterDisplacement(backwardStartState, intersection), (Object)(backwardDx - intersection)));
                continue;
            }
            if (forwardEndState.getV() >= backwardEndState.getV()) {
                finalStates.add(new Pair((Object)backwardStartState, (Object)backwardDx));
                continue;
            }
            intersection = INSTANCE.intersection((MotionState)forwardStartState, backwardStartState);
            finalStates.add(new Pair((Object)backwardStartState, (Object)intersection));
            finalStates.add(new Pair((Object)INSTANCE.afterDisplacement((MotionState)forwardStartState, intersection), (Object)(forwardDx - intersection)));
        }
        boolean bl6 = false;
        List motionSegments = new ArrayList();
        for (Pair pair : finalStates) {
            double d3;
            void state;
            backwardStartState = (MotionState)pair.component1();
            double stateDx = ((Number)pair.component2()).doubleValue();
            if (MathUtilKt.epsilonEquals(state.getA(), 0.0)) {
                d3 = stateDx / state.getV();
            } else {
                double discriminant = state.getV() * state.getV() + (double)2 * state.getA() * stateDx;
                if (MathUtilKt.epsilonEquals(discriminant, 0.0)) {
                    d3 = -state.getV() / state.getA();
                } else {
                    boolean bl7 = false;
                    d3 = (Math.sqrt(discriminant) - state.getV()) / state.getA();
                }
            }
            double dt = d3;
            motionSegments.add(new MotionSegment((MotionState)state, dt));
        }
        return new MotionProfile(motionSegments);
    }

    public static /* synthetic */ MotionProfile generateMotionProfile$default(MotionState motionState, MotionState motionState2, VelocityConstraint velocityConstraint, AccelerationConstraint accelerationConstraint, double d, int n, Object object) {
        if ((n & 0x10) != 0) {
            d = 0.25;
        }
        return MotionProfileGenerator.generateMotionProfile(motionState, motionState2, velocityConstraint, accelerationConstraint, d);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final MotionProfile generateMotionProfile(@NotNull MotionState start, @NotNull MotionState goal, @NotNull VelocityConstraint velocityConstraint, @NotNull AccelerationConstraint accelerationConstraint) {
        return MotionProfileGenerator.generateMotionProfile$default(start, goal, velocityConstraint, accelerationConstraint, 0.0, 16, null);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Pair<MotionState, Double>> forwardPass(MotionState start, DoubleProgression displacements, List<EvaluatedConstraint> constraints) {
        boolean bl = false;
        List forwardStates = new ArrayList();
        double dx = displacements.getStep();
        MotionState lastState = start;
        Iterable $this$forEach$iv = CollectionsKt.dropLast((List)CollectionsKt.zip((Iterable)displacements, (Iterable)constraints), (int)1);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MotionState motionState;
            void displacement;
            Pair $dstr$displacement$constraint = (Pair)element$iv;
            boolean bl2 = false;
            double d = ((Number)$dstr$displacement$constraint.component1()).doubleValue();
            EvaluatedConstraint constraint = (EvaluatedConstraint)$dstr$displacement$constraint.component2();
            double maxVel = constraint.getMaxVel();
            double maxAccel = constraint.getMaxAccel();
            if (lastState.getV() >= maxVel) {
                MotionState state = new MotionState((double)displacement, maxVel, 0.0, 0.0, 8, null);
                forwardStates.add(new Pair((Object)state, (Object)dx));
                motionState = INSTANCE.afterDisplacement(state, dx);
            } else {
                double d2 = lastState.getV() * lastState.getV() + (double)2 * maxAccel * dx;
                boolean bl3 = false;
                double finalVel = Math.sqrt(d2);
                if (finalVel <= maxVel) {
                    MotionState state = new MotionState((double)displacement, lastState.getV(), maxAccel, 0.0, 8, null);
                    forwardStates.add(new Pair((Object)state, (Object)dx));
                    motionState = INSTANCE.afterDisplacement(state, dx);
                } else {
                    double accelDx = (maxVel * maxVel - lastState.getV() * lastState.getV()) / ((double)2 * maxAccel);
                    MotionState accelState = new MotionState((double)displacement, lastState.getV(), maxAccel, 0.0, 8, null);
                    MotionState coastState = new MotionState((double)(displacement + accelDx), maxVel, 0.0, 0.0, 8, null);
                    forwardStates.add(new Pair((Object)accelState, (Object)accelDx));
                    forwardStates.add(new Pair((Object)coastState, (Object)(dx - accelDx)));
                    motionState = INSTANCE.afterDisplacement(coastState, dx - accelDx);
                }
            }
            lastState = motionState;
        }
        return forwardStates;
    }

    private final MotionState afterDisplacement(MotionState state, double dx) {
        MotionState motionState;
        double discriminant = state.getV() * state.getV() + (double)2 * state.getA() * dx;
        if (MathUtilKt.epsilonEquals(discriminant, 0.0)) {
            motionState = new MotionState(state.getX() + dx, 0.0, state.getA(), 0.0, 8, null);
        } else {
            boolean bl = false;
            motionState = new MotionState(state.getX() + dx, Math.sqrt(discriminant), state.getA(), 0.0, 8, null);
        }
        return motionState;
    }

    private final double intersection(MotionState state1, MotionState state2) {
        return (state1.getV() * state1.getV() - state2.getV() * state2.getV()) / ((double)2 * state2.getA() - (double)2 * state1.getA());
    }

    private MotionProfileGenerator() {
    }

    static {
        MotionProfileGenerator motionProfileGenerator;
        INSTANCE = motionProfileGenerator = new MotionProfileGenerator();
    }
}

