/*
 * Decompiled with CFR 0.152.
 */
package com.acmerobotics.roadrunner.profile;

import com.acmerobotics.roadrunner.profile.MotionProfile;
import com.acmerobotics.roadrunner.profile.MotionSegment;
import com.acmerobotics.roadrunner.profile.MotionState;
import com.acmerobotics.roadrunner.util.MathUtilKt;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\t\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bJ\u0016\u0010\r\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bJ\u000e\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0012\u001a\u00020\u0011R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/acmerobotics/roadrunner/profile/MotionProfileBuilder;", "", "start", "Lcom/acmerobotics/roadrunner/profile/MotionState;", "(Lcom/acmerobotics/roadrunner/profile/MotionState;)V", "currentState", "segments", "", "Lcom/acmerobotics/roadrunner/profile/MotionSegment;", "appendAccelerationControl", "accel", "", "dt", "appendJerkControl", "jerk", "appendProfile", "profile", "Lcom/acmerobotics/roadrunner/profile/MotionProfile;", "build", "core"})
public final class MotionProfileBuilder {
    private MotionState currentState;
    private final List<MotionSegment> segments;

    @NotNull
    public final MotionProfileBuilder appendJerkControl(double jerk, double dt) {
        MotionSegment segment = new MotionSegment(new MotionState(this.currentState.getX(), this.currentState.getV(), this.currentState.getA(), jerk), dt);
        this.segments.add(segment);
        this.currentState = segment.end();
        return this;
    }

    @NotNull
    public final MotionProfileBuilder appendAccelerationControl(double accel, double dt) {
        MotionSegment segment = new MotionSegment(new MotionState(this.currentState.getX(), this.currentState.getV(), accel, 0.0, 8, null), dt);
        this.segments.add(segment);
        this.currentState = segment.end();
        return this;
    }

    @NotNull
    public final MotionProfileBuilder appendProfile(@NotNull MotionProfile profile) {
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        for (MotionSegment segment : profile.getSegments$core()) {
            if (MathUtilKt.epsilonEquals(segment.getStart().getJ(), 0.0)) {
                this.appendAccelerationControl(segment.getStart().getA(), segment.getDt());
                continue;
            }
            this.appendJerkControl(segment.getStart().getJ(), segment.getDt());
        }
        return this;
    }

    @NotNull
    public final MotionProfile build() {
        return new MotionProfile(this.segments);
    }

    public MotionProfileBuilder(@NotNull MotionState start) {
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        this.currentState = start;
        boolean bl = false;
        this.segments = new ArrayList();
    }
}

