/*
 * Decompiled with CFR 0.152.
 */
package com.acmerobotics.roadrunner.path.heading;

import com.acmerobotics.roadrunner.path.ParametricCurve;
import com.acmerobotics.roadrunner.path.QuinticPolynomial;
import com.acmerobotics.roadrunner.path.heading.HeadingInterpolator;
import com.acmerobotics.roadrunner.path.heading.TangentInterpolator;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u001d\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0003H\u0010\u00a2\u0006\u0002\b\u0012J\u001d\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0003H\u0010\u00a2\u0006\u0002\b\u0014J\u001d\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0003H\u0010\u00a2\u0006\u0002\b\u0016J\u0010\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0003H\u0002J\u0010\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0003H\u0002J\u0010\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/acmerobotics/roadrunner/path/heading/WiggleInterpolator;", "Lcom/acmerobotics/roadrunner/path/heading/HeadingInterpolator;", "amplitude", "", "desiredPeriod", "baseInterpolator", "(DDLcom/acmerobotics/roadrunner/path/heading/HeadingInterpolator;)V", "beginSpline", "Lcom/acmerobotics/roadrunner/path/QuinticPolynomial;", "endSpline", "period", "init", "", "curve", "Lcom/acmerobotics/roadrunner/path/ParametricCurve;", "internalDeriv", "s", "t", "internalDeriv$core", "internalGet", "internalGet$core", "internalSecondDeriv", "internalSecondDeriv$core", "waveDeriv", "waveGet", "waveSecondDeriv", "core"})
public final class WiggleInterpolator
extends HeadingInterpolator {
    private double period;
    private QuinticPolynomial beginSpline;
    private QuinticPolynomial endSpline;
    private final double amplitude;
    private final double desiredPeriod;
    private final HeadingInterpolator baseInterpolator;

    @Override
    public void init(@NotNull ParametricCurve curve) {
        Intrinsics.checkNotNullParameter((Object)curve, (String)"curve");
        super.init(curve);
        this.baseInterpolator.init(curve);
        int n = (int)(curve.length() / this.desiredPeriod);
        this.period = 1.0 / (double)n;
        double t1 = 0.5 * this.period;
        double t2 = 1.0 - t1;
        this.beginSpline = new QuinticPolynomial(0.0, 0.0, 0.0, this.waveGet(t1), this.waveDeriv(t1) * (0.5 * this.period), this.waveSecondDeriv(t1) * (0.25 * this.period * this.period));
        this.endSpline = new QuinticPolynomial(this.waveGet(t2), this.waveDeriv(t2) * (1.0 - 0.5 * this.period), this.waveSecondDeriv(t2) * ((1.0 - 0.5 * this.period) * (1.0 - 0.5 * this.period)), 0.0, 0.0, 0.0);
    }

    private final double waveGet(double t) {
        double d = Math.PI * 2 * t / this.period;
        boolean bl = false;
        return this.amplitude * Math.sin(d);
    }

    private final double waveDeriv(double t) {
        double d = Math.PI * 2 * t / this.period;
        boolean bl = false;
        return Math.PI * 2 * this.amplitude / this.period * Math.cos(d);
    }

    private final double waveSecondDeriv(double t) {
        double d = Math.PI * 2 * t / this.period;
        boolean bl = false;
        return 39.47841760435743 * this.amplitude / (this.period * this.period) * Math.sin(d);
    }

    @Override
    public double internalGet$core(double s, double t) {
        double d;
        if (t < 0.5 * this.period) {
            QuinticPolynomial quinticPolynomial = this.beginSpline;
            if (quinticPolynomial == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"beginSpline");
            }
            d = quinticPolynomial.get(t / (0.5 * this.period));
        } else if (t > 1.0 - 0.5 * this.period) {
            QuinticPolynomial quinticPolynomial = this.endSpline;
            if (quinticPolynomial == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"endSpline");
            }
            d = quinticPolynomial.get(t / (1.0 - 0.5 * this.period) - 1.0);
        } else {
            d = this.waveGet(t);
        }
        double heading = d;
        return heading + this.baseInterpolator.get(s, t);
    }

    @Override
    public double internalDeriv$core(double s, double t) {
        double d;
        if (t < 0.5 * this.period) {
            QuinticPolynomial quinticPolynomial = this.beginSpline;
            if (quinticPolynomial == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"beginSpline");
            }
            d = quinticPolynomial.deriv(t / (0.5 * this.period)) / (0.5 * this.period);
        } else if (t > 1.0 - 0.5 * this.period) {
            QuinticPolynomial quinticPolynomial = this.endSpline;
            if (quinticPolynomial == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"endSpline");
            }
            d = quinticPolynomial.deriv(t / (1.0 - 0.5 * this.period) - 1.0) / (1.0 - 0.5 * this.period);
        } else {
            d = this.waveDeriv(t);
        }
        double headingDeriv = d;
        return headingDeriv * this.getCurve().paramDeriv$core(t) + this.baseInterpolator.deriv(s, t);
    }

    @Override
    public double internalSecondDeriv$core(double s, double t) {
        double d;
        double d2;
        if (t < 0.5 * this.period) {
            QuinticPolynomial quinticPolynomial = this.beginSpline;
            if (quinticPolynomial == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"beginSpline");
            }
            d2 = quinticPolynomial.deriv(t / (0.5 * this.period)) / (0.5 * this.period);
        } else if (t > 1.0 - 0.5 * this.period) {
            QuinticPolynomial quinticPolynomial = this.endSpline;
            if (quinticPolynomial == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"endSpline");
            }
            d2 = quinticPolynomial.deriv(t / (1.0 - 0.5 * this.period) - 1.0) / (1.0 - 0.5 * this.period);
        } else {
            d2 = this.waveDeriv(t);
        }
        double headingDeriv = d2;
        if (t < 0.5 * this.period) {
            QuinticPolynomial quinticPolynomial = this.beginSpline;
            if (quinticPolynomial == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"beginSpline");
            }
            d = quinticPolynomial.secondDeriv(t / (0.5 * this.period)) / (0.25 * this.period * this.period);
        } else if (t > 1.0 - 0.5 * this.period) {
            QuinticPolynomial quinticPolynomial = this.endSpline;
            if (quinticPolynomial == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"endSpline");
            }
            d = quinticPolynomial.secondDeriv(t / (1.0 - 0.5 * this.period) - 1.0) / ((1.0 - 0.5 * this.period) * (1.0 - 0.5 * this.period));
        } else {
            d = this.waveSecondDeriv(t);
        }
        double headingSecondDeriv = d;
        return headingSecondDeriv * this.getCurve().paramDeriv$core(t) * this.getCurve().paramDeriv$core(t) + headingDeriv * this.getCurve().paramSecondDeriv$core(t) + this.baseInterpolator.secondDeriv(s, t);
    }

    public WiggleInterpolator(double amplitude, double desiredPeriod, @NotNull HeadingInterpolator baseInterpolator) {
        Intrinsics.checkNotNullParameter((Object)baseInterpolator, (String)"baseInterpolator");
        this.amplitude = amplitude;
        this.desiredPeriod = desiredPeriod;
        this.baseInterpolator = baseInterpolator;
    }

    public /* synthetic */ WiggleInterpolator(double d, double d2, HeadingInterpolator headingInterpolator, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            headingInterpolator = new TangentInterpolator(0.0, 1, null);
        }
        this(d, d2, headingInterpolator);
    }
}

