/*
 * Decompiled with CFR 0.152.
 */
package com.acmerobotics.roadrunner.path.heading;

import com.acmerobotics.roadrunner.path.ParametricCurve;
import com.acmerobotics.roadrunner.path.QuinticPolynomial;
import com.acmerobotics.roadrunner.path.heading.HeadingInterpolator;
import com.acmerobotics.roadrunner.path.heading.TangentInterpolator;
import com.acmerobotics.roadrunner.util.Angle;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001BG\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u001d\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0003H\u0010\u00a2\u0006\u0002\b\u0016J\u001d\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0003H\u0010\u00a2\u0006\u0002\b\u0018J\u001d\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0003H\u0010\u00a2\u0006\u0002\b\u001aR\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u0012\u0010\b\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/acmerobotics/roadrunner/path/heading/SplineInterpolator;", "Lcom/acmerobotics/roadrunner/path/heading/HeadingInterpolator;", "startHeading", "", "endHeading", "startHeadingDeriv", "startHeadingSecondDeriv", "endHeadingDeriv", "endHeadingSecondDeriv", "(DDLjava/lang/Double;Ljava/lang/Double;Ljava/lang/Double;Ljava/lang/Double;)V", "Ljava/lang/Double;", "headingSpline", "Lcom/acmerobotics/roadrunner/path/QuinticPolynomial;", "tangentInterpolator", "Lcom/acmerobotics/roadrunner/path/heading/TangentInterpolator;", "init", "", "curve", "Lcom/acmerobotics/roadrunner/path/ParametricCurve;", "internalDeriv", "s", "t", "internalDeriv$core", "internalGet", "internalGet$core", "internalSecondDeriv", "internalSecondDeriv$core", "core"})
public final class SplineInterpolator
extends HeadingInterpolator {
    private final TangentInterpolator tangentInterpolator;
    private QuinticPolynomial headingSpline;
    private final double startHeading;
    private final double endHeading;
    private final Double startHeadingDeriv;
    private final Double startHeadingSecondDeriv;
    private final Double endHeadingDeriv;
    private final Double endHeadingSecondDeriv;

    @Override
    public void init(@NotNull ParametricCurve curve) {
        Intrinsics.checkNotNullParameter((Object)curve, (String)"curve");
        super.init(curve);
        this.tangentInterpolator.init(this.getCurve());
        double len = curve.length();
        double headingDelta = Angle.normDelta(this.endHeading - this.startHeading);
        Double d = this.startHeadingDeriv;
        Double d2 = this.startHeadingSecondDeriv;
        Double d3 = this.endHeadingDeriv;
        Double d4 = this.endHeadingSecondDeriv;
        this.headingSpline = new QuinticPolynomial(0.0, (d != null ? d.doubleValue() : curve.tangentAngleDeriv(0.0, 0.0)) * len, (d2 != null ? d2.doubleValue() : curve.tangentAngleSecondDeriv(0.0, 0.0)) * len * len, headingDelta, (d3 != null ? d3.doubleValue() : curve.tangentAngleDeriv(len, 1.0)) * len, (d4 != null ? d4.doubleValue() : curve.tangentAngleSecondDeriv(len, 1.0)) * len * len);
    }

    @Override
    public double internalGet$core(double s, double t) {
        QuinticPolynomial quinticPolynomial = this.headingSpline;
        if (quinticPolynomial == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"headingSpline");
        }
        return Angle.norm(this.startHeading + quinticPolynomial.get(s / this.getCurve().length()));
    }

    @Override
    public double internalDeriv$core(double s, double t) {
        double len = this.getCurve().length();
        QuinticPolynomial quinticPolynomial = this.headingSpline;
        if (quinticPolynomial == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"headingSpline");
        }
        return quinticPolynomial.deriv(s / len) / len;
    }

    @Override
    public double internalSecondDeriv$core(double s, double t) {
        double len = this.getCurve().length();
        QuinticPolynomial quinticPolynomial = this.headingSpline;
        if (quinticPolynomial == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"headingSpline");
        }
        return quinticPolynomial.secondDeriv(s / len) / (len * len);
    }

    @JvmOverloads
    public SplineInterpolator(double startHeading, double endHeading, @Nullable Double startHeadingDeriv, @Nullable Double startHeadingSecondDeriv, @Nullable Double endHeadingDeriv, @Nullable Double endHeadingSecondDeriv) {
        this.startHeading = startHeading;
        this.endHeading = endHeading;
        this.startHeadingDeriv = startHeadingDeriv;
        this.startHeadingSecondDeriv = startHeadingSecondDeriv;
        this.endHeadingDeriv = endHeadingDeriv;
        this.endHeadingSecondDeriv = endHeadingSecondDeriv;
        this.tangentInterpolator = new TangentInterpolator(0.0, 1, null);
    }

    public /* synthetic */ SplineInterpolator(double d, double d2, Double d3, Double d4, Double d5, Double d6, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            d3 = null;
        }
        if ((n & 8) != 0) {
            d4 = null;
        }
        if ((n & 0x10) != 0) {
            d5 = null;
        }
        if ((n & 0x20) != 0) {
            d6 = null;
        }
        this(d, d2, d3, d4, d5, d6);
    }

    @JvmOverloads
    public SplineInterpolator(double startHeading, double endHeading, @Nullable Double startHeadingDeriv, @Nullable Double startHeadingSecondDeriv, @Nullable Double endHeadingDeriv) {
        this(startHeading, endHeading, startHeadingDeriv, startHeadingSecondDeriv, endHeadingDeriv, null, 32, null);
    }

    @JvmOverloads
    public SplineInterpolator(double startHeading, double endHeading, @Nullable Double startHeadingDeriv, @Nullable Double startHeadingSecondDeriv) {
        this(startHeading, endHeading, startHeadingDeriv, startHeadingSecondDeriv, null, null, 48, null);
    }

    @JvmOverloads
    public SplineInterpolator(double startHeading, double endHeading, @Nullable Double startHeadingDeriv) {
        this(startHeading, endHeading, startHeadingDeriv, null, null, null, 56, null);
    }

    @JvmOverloads
    public SplineInterpolator(double startHeading, double endHeading) {
        this(startHeading, endHeading, null, null, null, null, 60, null);
    }
}

