/*
 * Decompiled with CFR 0.152.
 */
package com.acmerobotics.roadrunner.path;

import com.acmerobotics.roadrunner.geometry.Vector2d;
import com.acmerobotics.roadrunner.path.ParametricCurve;
import com.acmerobotics.roadrunner.path.QuinticPolynomial;
import com.acmerobotics.roadrunner.util.MathUtilKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0019\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u00019B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ \u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u0017H\u0002J\u0010\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u0006H\u0002J\u0015\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u0006H\u0010\u00a2\u0006\u0002\b\u001dJ\u0015\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u0006H\u0010\u00a2\u0006\u0002\b\u001fJ\u0015\u0010 \u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u0006H\u0010\u00a2\u0006\u0002\b!J\u0015\u0010\"\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u0006H\u0010\u00a2\u0006\u0002\b#J0\u0010$\u001a\u00020\u00062\u0006\u0010%\u001a\u00020\u00062\u0006\u0010&\u001a\u00020\u00062\u0006\u0010'\u001a\u00020\u00062\u0006\u0010(\u001a\u00020\u00062\u0006\u0010)\u001a\u00020\u0006H\u0002J\b\u0010\u000b\u001a\u00020\u0006H\u0016J\u0015\u0010*\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u0006H\u0010\u00a2\u0006\u0002\b+J\u0015\u0010,\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u0006H\u0010\u00a2\u0006\u0002\b-J\u0015\u0010.\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u0006H\u0010\u00a2\u0006\u0002\b/J6\u00100\u001a\u0002012\u0006\u0010(\u001a\u00020\u00062\u0006\u0010)\u001a\u00020\u00062\b\b\u0002\u00102\u001a\u00020\u00172\b\b\u0002\u00103\u001a\u00020\u00172\b\b\u0002\u00104\u001a\u00020\tH\u0002J\u0015\u00105\u001a\u00020\u00062\u0006\u0010%\u001a\u00020\u0006H\u0010\u00a2\u0006\u0002\b6J\b\u00107\u001a\u000208H\u0016R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012\u00a8\u0006:"}, d2={"Lcom/acmerobotics/roadrunner/path/QuinticSpline;", "Lcom/acmerobotics/roadrunner/path/ParametricCurve;", "start", "Lcom/acmerobotics/roadrunner/path/QuinticSpline$Knot;", "end", "maxDeltaK", "", "maxSegmentLength", "maxDepth", "", "(Lcom/acmerobotics/roadrunner/path/QuinticSpline$Knot;Lcom/acmerobotics/roadrunner/path/QuinticSpline$Knot;DDI)V", "length", "sSamples", "", "tSamples", "x", "Lcom/acmerobotics/roadrunner/path/QuinticPolynomial;", "getX", "()Lcom/acmerobotics/roadrunner/path/QuinticPolynomial;", "y", "getY", "approxLength", "v1", "Lcom/acmerobotics/roadrunner/geometry/Vector2d;", "v2", "v3", "internalCurvature", "t", "internalDeriv", "internalDeriv$core", "internalGet", "internalGet$core", "internalSecondDeriv", "internalSecondDeriv$core", "internalThirdDeriv", "internalThirdDeriv$core", "interp", "s", "sLo", "sHi", "tLo", "tHi", "paramDeriv", "paramDeriv$core", "paramSecondDeriv", "paramSecondDeriv$core", "paramThirdDeriv", "paramThirdDeriv$core", "parameterize", "", "vLo", "vHi", "depth", "reparam", "reparam$core", "toString", "", "Knot", "core"})
public final class QuinticSpline
extends ParametricCurve {
    @NotNull
    private final QuinticPolynomial x;
    @NotNull
    private final QuinticPolynomial y;
    private double length;
    private final List<Double> sSamples;
    private final List<Double> tSamples;
    private final double maxDeltaK;
    private final double maxSegmentLength;
    private final int maxDepth;

    @NotNull
    public final QuinticPolynomial getX() {
        return this.x;
    }

    @NotNull
    public final QuinticPolynomial getY() {
        return this.y;
    }

    private final double approxLength(Vector2d v1, Vector2d v2, Vector2d v3) {
        double d;
        Vector2d w1 = v2.minus(v1).times(2.0);
        Vector2d w2 = v2.minus(v3).times(2.0);
        double det = w1.getX() * w2.getY() - w2.getX() * w1.getY();
        double chord = v1.distTo(v3);
        if (MathUtilKt.epsilonEquals(det, 0.0)) {
            d = chord;
        } else {
            double x1 = v1.getX() * v1.getX() + v1.getY() * v1.getY();
            double x2 = v2.getX() * v2.getX() + v2.getY() * v2.getY();
            double x3 = v3.getX() * v3.getX() + v3.getY() * v3.getY();
            double y1 = x2 - x1;
            double y2 = x2 - x3;
            Vector2d origin = new Vector2d(y1 * w2.getY() - y2 * w1.getY(), y2 * w1.getX() - y1 * w2.getX()).div(det);
            double radius = origin.distTo(v1);
            double d2 = chord / (2.0 * radius);
            boolean bl = false;
            d = 2.0 * radius * Math.asin(d2);
        }
        return d;
    }

    private final double internalCurvature(double t) {
        Vector2d deriv = this.internalDeriv$core(t);
        double derivNorm = deriv.norm();
        Vector2d secondDeriv = this.internalSecondDeriv$core(t);
        double d = secondDeriv.getX() * deriv.getY() - deriv.getX() * secondDeriv.getY();
        boolean bl = false;
        return Math.abs(d) / (derivNorm * derivNorm * derivNorm);
    }

    private final void parameterize(double tLo, double tHi, Vector2d vLo, Vector2d vHi, int depth) {
        if (depth >= this.maxDepth) {
            return;
        }
        double tMid = 0.5 * (tLo + tHi);
        Vector2d vMid = this.internalGet$core(tMid);
        double d = this.internalCurvature(tLo) - this.internalCurvature(tHi);
        boolean bl = false;
        double deltaK = Math.abs(d);
        double segmentLength = this.approxLength(vLo, vMid, vHi);
        if (deltaK > this.maxDeltaK || segmentLength > this.maxSegmentLength) {
            this.parameterize(tLo, tMid, vLo, vMid, depth + 1);
            this.parameterize(tMid, tHi, vMid, vHi, depth + 1);
        } else {
            this.length += segmentLength;
            this.sSamples.add(this.length);
            this.tSamples.add(tHi);
        }
    }

    static /* synthetic */ void parameterize$default(QuinticSpline quinticSpline, double d, double d2, Vector2d vector2d, Vector2d vector2d2, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            vector2d = quinticSpline.internalGet$core(d);
        }
        if ((n2 & 8) != 0) {
            vector2d2 = quinticSpline.internalGet$core(d2);
        }
        if ((n2 & 0x10) != 0) {
            n = 0;
        }
        quinticSpline.parameterize(d, d2, vector2d, vector2d2, n);
    }

    @Override
    @NotNull
    public Vector2d internalGet$core(double t) {
        return new Vector2d(this.x.get(t), this.y.get(t));
    }

    @Override
    @NotNull
    public Vector2d internalDeriv$core(double t) {
        return new Vector2d(this.x.deriv(t), this.y.deriv(t));
    }

    @Override
    @NotNull
    public Vector2d internalSecondDeriv$core(double t) {
        return new Vector2d(this.x.secondDeriv(t), this.y.secondDeriv(t));
    }

    @Override
    @NotNull
    public Vector2d internalThirdDeriv$core(double t) {
        return new Vector2d(this.x.thirdDeriv(t), this.y.thirdDeriv(t));
    }

    private final double interp(double s, double sLo, double sHi, double tLo, double tHi) {
        return tLo + (s - sLo) * (tHi - tLo) / (sHi - sLo);
    }

    @Override
    public double reparam$core(double s) {
        if (s <= 0.0) {
            return 0.0;
        }
        if (s >= this.length) {
            return 1.0;
        }
        int lo = 0;
        int hi = this.sSamples.size();
        while (lo <= hi) {
            int mid = (hi + lo) / 2;
            if (s < ((Number)this.sSamples.get(mid)).doubleValue()) {
                hi = mid - 1;
                continue;
            }
            if (s > ((Number)this.sSamples.get(mid)).doubleValue()) {
                lo = mid + 1;
                continue;
            }
            return ((Number)this.tSamples.get(mid)).doubleValue();
        }
        return this.interp(s, ((Number)this.sSamples.get(lo)).doubleValue(), ((Number)this.sSamples.get(hi)).doubleValue(), ((Number)this.tSamples.get(lo)).doubleValue(), ((Number)this.tSamples.get(hi)).doubleValue());
    }

    @Override
    public double paramDeriv$core(double t) {
        Vector2d deriv = this.internalDeriv$core(t);
        double d = deriv.getX() * deriv.getX() + deriv.getY() * deriv.getY();
        boolean bl = false;
        return 1.0 / Math.sqrt(d);
    }

    @Override
    public double paramSecondDeriv$core(double t) {
        Vector2d deriv = this.internalDeriv$core(t);
        Vector2d secondDeriv = this.internalSecondDeriv$core(t);
        double numerator = -(deriv.getX() * secondDeriv.getX() + deriv.getY() * secondDeriv.getY());
        double denominator = deriv.getX() * deriv.getX() + deriv.getY() * deriv.getY();
        return numerator / (denominator * denominator);
    }

    @Override
    public double paramThirdDeriv$core(double t) {
        Vector2d deriv = this.internalDeriv$core(t);
        Vector2d secondDeriv = this.internalSecondDeriv$core(t);
        Vector2d thirdDeriv = this.internalThirdDeriv$core(t);
        double firstNumerator = -(deriv.getX() * secondDeriv.getX() + deriv.getY() * secondDeriv.getY());
        double secondNumeratorFirstTerm = secondDeriv.getX() * secondDeriv.getX() + secondDeriv.getY() * secondDeriv.getY() + deriv.getX() * thirdDeriv.getX() + deriv.getY() * thirdDeriv.getY();
        double secondNumeratorSecondTerm = -4.0 * firstNumerator;
        double denominator = deriv.getX() * deriv.getX() + deriv.getY() * deriv.getY();
        return secondNumeratorFirstTerm / Math.pow(denominator, 2.5) + secondNumeratorSecondTerm / Math.pow(denominator, 3.5);
    }

    @Override
    public double length() {
        return this.length;
    }

    @NotNull
    public String toString() {
        return "" + '(' + this.x + ',' + this.y + ')';
    }

    public QuinticSpline(@NotNull Knot start, @NotNull Knot end, double maxDeltaK, double maxSegmentLength, int maxDepth) {
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        this.maxDeltaK = maxDeltaK;
        this.maxSegmentLength = maxSegmentLength;
        this.maxDepth = maxDepth;
        this.x = new QuinticPolynomial(start.getX(), start.getDx(), start.getD2x(), end.getX(), end.getDx(), end.getD2x());
        this.y = new QuinticPolynomial(start.getY(), start.getDy(), start.getD2y(), end.getY(), end.getDy(), end.getD2y());
        this.sSamples = CollectionsKt.mutableListOf((Object[])new Double[]{0.0});
        this.tSamples = CollectionsKt.mutableListOf((Object[])new Double[]{0.0});
        QuinticSpline.parameterize$default(this, 0.0, 1.0, null, null, 0, 28, null);
    }

    public /* synthetic */ QuinticSpline(Knot knot, Knot knot2, double d, double d2, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            d = 0.01;
        }
        if ((n2 & 8) != 0) {
            d2 = 0.25;
        }
        if ((n2 & 0x10) != 0) {
            n = 30;
        }
        this(knot, knot2, d, d2, n);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u000e\u0018\u00002\u00020\u0001B#\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006B?\b\u0007\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\b\b\u0002\u0010\n\u001a\u00020\b\u0012\b\b\u0002\u0010\u000b\u001a\u00020\b\u0012\b\b\u0002\u0010\f\u001a\u00020\b\u0012\b\b\u0002\u0010\r\u001a\u00020\b\u00a2\u0006\u0002\u0010\u000eJ\u0006\u0010\u0004\u001a\u00020\u0003J\u0006\u0010\u0002\u001a\u00020\u0003J\u0006\u0010\u0005\u001a\u00020\u0003R\u0011\u0010\f\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\r\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0011\u0010\n\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u0011\u0010\u000b\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0010R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0010R\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0010\u00a8\u0006\u0016"}, d2={"Lcom/acmerobotics/roadrunner/path/QuinticSpline$Knot;", "", "pos", "Lcom/acmerobotics/roadrunner/geometry/Vector2d;", "deriv", "secondDeriv", "(Lcom/acmerobotics/roadrunner/geometry/Vector2d;Lcom/acmerobotics/roadrunner/geometry/Vector2d;Lcom/acmerobotics/roadrunner/geometry/Vector2d;)V", "x", "", "y", "dx", "dy", "d2x", "d2y", "(DDDDDD)V", "getD2x", "()D", "getD2y", "getDx", "getDy", "getX", "getY", "core"})
    public static final class Knot {
        private final double x;
        private final double y;
        private final double dx;
        private final double dy;
        private final double d2x;
        private final double d2y;

        @NotNull
        public final Vector2d pos() {
            return new Vector2d(this.x, this.y);
        }

        @NotNull
        public final Vector2d deriv() {
            return new Vector2d(this.dx, this.dy);
        }

        @NotNull
        public final Vector2d secondDeriv() {
            return new Vector2d(this.d2x, this.d2y);
        }

        public final double getX() {
            return this.x;
        }

        public final double getY() {
            return this.y;
        }

        public final double getDx() {
            return this.dx;
        }

        public final double getDy() {
            return this.dy;
        }

        public final double getD2x() {
            return this.d2x;
        }

        public final double getD2y() {
            return this.d2y;
        }

        @JvmOverloads
        public Knot(double x, double y, double dx, double dy, double d2x, double d2y) {
            this.x = x;
            this.y = y;
            this.dx = dx;
            this.dy = dy;
            this.d2x = d2x;
            this.d2y = d2y;
        }

        public /* synthetic */ Knot(double d, double d2, double d3, double d4, double d5, double d6, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                d3 = 0.0;
            }
            if ((n & 8) != 0) {
                d4 = 0.0;
            }
            if ((n & 0x10) != 0) {
                d5 = 0.0;
            }
            if ((n & 0x20) != 0) {
                d6 = 0.0;
            }
            this(d, d2, d3, d4, d5, d6);
        }

        @JvmOverloads
        public Knot(double x, double y, double dx, double dy, double d2x) {
            this(x, y, dx, dy, d2x, 0.0, 32, null);
        }

        @JvmOverloads
        public Knot(double x, double y, double dx, double dy) {
            this(x, y, dx, dy, 0.0, 0.0, 48, null);
        }

        @JvmOverloads
        public Knot(double x, double y, double dx) {
            this(x, y, dx, 0.0, 0.0, 0.0, 56, null);
        }

        @JvmOverloads
        public Knot(double x, double y) {
            this(x, y, 0.0, 0.0, 0.0, 0.0, 60, null);
        }

        @JvmOverloads
        public Knot(@NotNull Vector2d pos, @NotNull Vector2d deriv, @NotNull Vector2d secondDeriv) {
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)deriv, (String)"deriv");
            Intrinsics.checkNotNullParameter((Object)secondDeriv, (String)"secondDeriv");
            this(pos.getX(), pos.getY(), deriv.getX(), deriv.getY(), secondDeriv.getX(), secondDeriv.getY());
        }

        public /* synthetic */ Knot(Vector2d vector2d, Vector2d vector2d2, Vector2d vector2d3, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                vector2d2 = new Vector2d(0.0, 0.0, 3, null);
            }
            if ((n & 4) != 0) {
                vector2d3 = new Vector2d(0.0, 0.0, 3, null);
            }
            this(vector2d, vector2d2, vector2d3);
        }

        @JvmOverloads
        public Knot(@NotNull Vector2d pos, @NotNull Vector2d deriv) {
            this(pos, deriv, null, 4, null);
        }

        @JvmOverloads
        public Knot(@NotNull Vector2d pos) {
            this(pos, null, null, 6, null);
        }
    }
}

