/*
 * Decompiled with CFR 0.152.
 */
package com.acmerobotics.roadrunner.path;

import com.acmerobotics.roadrunner.path.QuinticPolynomialKt;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.apache.commons.math3.linear.DecompositionSolver;
import org.apache.commons.math3.linear.LUDecomposition;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.RealMatrix;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0019\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0003J\u0011\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0003H\u0086\u0002J\u000e\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0003J\u000e\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0003J\b\u0010\u001c\u001a\u00020\u001dH\u0016R\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u000f\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\fR\u0011\u0010\u0011\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\fR\u0011\u0010\u0013\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\fR\u0011\u0010\u0015\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\f\u00a8\u0006\u001e"}, d2={"Lcom/acmerobotics/roadrunner/path/QuinticPolynomial;", "", "start", "", "startDeriv", "startSecondDeriv", "end", "endDeriv", "endSecondDeriv", "(DDDDDD)V", "a", "getA", "()D", "b", "getB", "c", "getC", "d", "getD", "e", "getE", "f", "getF", "deriv", "t", "get", "secondDeriv", "thirdDeriv", "toString", "", "core"})
public final class QuinticPolynomial {
    private final double a;
    private final double b;
    private final double c;
    private final double d;
    private final double e;
    private final double f;

    public final double getA() {
        return this.a;
    }

    public final double getB() {
        return this.b;
    }

    public final double getC() {
        return this.c;
    }

    public final double getD() {
        return this.d;
    }

    public final double getE() {
        return this.e;
    }

    public final double getF() {
        return this.f;
    }

    public final double get(double t) {
        return (this.a * t + this.b) * (t * t * t * t) + this.c * (t * t * t) + this.d * (t * t) + this.e * t + this.f;
    }

    public final double deriv(double t) {
        return ((double)5 * this.a * t + (double)4 * this.b) * (t * t * t) + ((double)3 * this.c * t + (double)2 * this.d) * t + this.e;
    }

    public final double secondDeriv(double t) {
        return ((double)20 * this.a * t + (double)12 * this.b) * (t * t) + (double)6 * this.c * t + (double)2 * this.d;
    }

    public final double thirdDeriv(double t) {
        return ((double)60 * this.a * t + (double)24 * this.b) * t + (double)6 * this.c;
    }

    @NotNull
    public String toString() {
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = "%.5f*t^5+%.5f*t^4+%.5f*t^3+%.5f*t^2+%.5f*t+%.5f";
        Object[] objectArray = new Object[]{this.a, this.b, this.c, this.d, this.e, this.f};
        boolean bl = false;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
        return string2;
    }

    public QuinticPolynomial(double start, double startDeriv, double startSecondDeriv, double end, double endDeriv, double endSecondDeriv) {
        RealMatrix target = MatrixUtils.createRealMatrix((double[][])new double[][]{{start, startDeriv, startSecondDeriv, end, endDeriv, endSecondDeriv}}).transpose();
        DecompositionSolver solver = new LUDecomposition(QuinticPolynomialKt.access$getCOEFF_MATRIX$p()).getSolver();
        RealMatrix coeff = solver.solve(target);
        this.a = coeff.getEntry(0, 0);
        this.b = coeff.getEntry(1, 0);
        this.c = coeff.getEntry(2, 0);
        this.d = coeff.getEntry(3, 0);
        this.e = coeff.getEntry(4, 0);
        this.f = coeff.getEntry(5, 0);
    }
}

